<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class RegistrationNo extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'number', 'status','name','phone_number','email','cnic','is_deleted'
    ];

    //status

    const open = 1;
    const reserved = 2;
    const sold = 3;
    const cancel = 4;
    const temp_hold = 5;

    public function registration() {
        return $this->hasOne('\App\CustomerRegistration','registration_id','id')->with('customer');
    }
}
