<?php
namespace App;

use Illuminate\Database\Eloquent\Model;
use Zizaco\Entrust\EntrustRole;
use App\Permission;

class Role extends EntrustRole
{

    
    
    protected $fillable = [
        'name',
        'display_name',
        'description'
    ];

    public function userRole()
    {
        return $this->hasMany(Role::class, 'user_id', 'id');
    }

    public function permissions()
    {
        return $this->belongsToMany(Permission::class, 'permission_role', 'role_id', 'permission_id');
    }

    public function user() {
        return $this->belongsToMany('App\User');
    }

    public function projects()
    {
        return $this->belongsToMany(MultiProject::class, 'multiproject_role', 'role_id', 'multi_project_id');
    }
}
