<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;
use Maatwebsite\Excel\Facades\Excel;

class ExcelMapFileRule implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        try {
            // dd($attribute,$value);
            $data = Excel::toArray([], $value)[0];
            //
            $words = ['Sr No', 'Plot No', 'Category(Area)', 'Feature', 'Exact/Odd', 'Sector', 'Road Category', 'Type', 'Street No'];


            if ($data[0][0] == $words[0] && $data[0][1] == $words[1] && $data[0][2] == $words[2] && $data[0][3] == $words[3] && $data[0][4] == $words[4] && $data[0][5] == $words[5] && $data[0][6] == $words[6] && $data[0][7] == $words[7] && $data[0][8] == $words[8]) {
                return true;
            } else {
                return false;
            }
        } catch (\Exception $e) {
            return false;
        }
        
//         $commonWords = [];

// foreach ($words as $word) {
//     if (in_array($word, $data[0])) {
//         $commonWords[] = $word;
//     }
// }
//         if (sizeof($commonWords) == 7) {
//             return true;
//         }
//         else{
//             return false;
//         }
 
        
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'There is some issue in your file format.';
    }
}
