<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Input;
use Carbon\Carbon;
use DB;
use App\Mail\InstallmentConfirmation;
use Illuminate\Support\Facades\Mail;
use App\Http\Controllers\SmsController;

class SurchargeReceipt extends Model
{
       protected $table = 'surcharge_receipts';


         protected $fillable = [
        'customer_id', 
        'customer_property_id', 
        'payment_head',
        'payment_mode',
        'bank_name',
        'cheque_number',
        'cheque_title',
        'drawn_date',
        'amount',
        'total_surcharge',
        'receipt_no',
        'receipt_date',
        'reference_no',
        'receipt_id',
        'company_account',
        'adjustment_type',
        'adjustment_detail',
        'inventory_id',
        'is_deleted',
        'is_approved',
        'payment_method',
        'dealer_adjustment_unit_id',
        'vendor_purchase_order_id',
        'notes',
        'is_book',
        'tax_paid_by',
        'tax_payment_received',
        'tax_amount',
    ];



        public function customer() {
        return $this->belongsTo('\App\Customer');
    }

    public function property() {
        return $this->belongsTo('App\CustomerProperty','customer_property_id')->with('inventory');
    }

    public function statement() {
        return $this->hasOne('App\CustomerStatement');
    }

     public function documents() {
        return $this->hasMany('App\Receiptdocument' , 'receipt_id');
    }

    public function DepositorBank(){
        return $this->belongsTo('App\DepositorBank','bank_name');
    }

    public function companyAccount() {
        return $this->belongsTo('\App\CompanyBank','company_account');
    }

    public function inventory() {
        return $this->belongsTo('\App\inventory','inventory_id');
    }

    public function paymentMode() {
        return $this->belongsTo('\App\ChartOfAccount','payment_mode');
    }


      public function insertReceipt($request) {
       

       $total_surcharge =   CustomerStatement::where([['customer_property_id',$request->customer_property_id]])->sum('surcharge');

          $received =   SurchargeReceipt::where([['customer_property_id',$request->customer_property_id]])->sum('total_surcharge');

          $remaining = ( $total_surcharge - $received );

        $request->merge([
            'total_surcharge' => $remaining,
        ]);

       
        DB::beginTransaction();
        try 
        {
            $input=$request->all();
            $receipt = SurchargeReceipt::create($input);
            DB::commit();
            return $receipt;
        }
        catch (\Exception $e) 
        {
            //dd($e);
            DB::rollback();
            return false;
        }

    }



      public function updateTable($filters,$ids=null) {

        $query = SurchargeReceipt::where('is_deleted',false)
        
        ->when($ids[0] !== 'all', function ($query) use ($ids) {
            $query->whereIn('multi_project_id', $ids);
        });

        foreach($filters as $key => $val) {
            if($key == 'receipt_no')
                $query = $query->where('id',$val);
            elseif($key == 'payment_head')
                $query = $query->where('payment_head',$val);
            elseif($key == 'payment_mode' && $val != 'all')
                $query = $query->where('payment_method',$val);
            elseif($key == 'unit')
                $query = $query->whereHas('property',function($query) use($val){
                    $query->whereHas('inventory',function($query) use($val){
                        $query->where('id',$val);
                    });
                    });
            elseif($key == 'customer')
                $query = $query->whereHas('customer',function($query) use($val){
                    $query->where('id',$val);
                });
            elseif($key == 'dealer')
                $query = $query->whereHas('property',function($query) use($val){
                    $query->whereHas('dealer',function($query) use($val){
                        $query->where('id',$val);
                      });
                    });
        }
        $query->with('property');
        $data['receipts'] = $query->get();

        return $data;
    }



}
