<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Task extends Model
{
       protected $appends = ["open"];
 
    public function getOpenAttribute(){
        return true;
    }

    public function scopeWithAndWhereHas($query, $relation, $constraint){
    return $query->whereHas($relation, $constraint)
    ->with([$relation => $constraint]);
    }


       //each category might have one parent
  public function parent() {
    return $this->belongsTo(static::class, 'parent');
  }

  //each category might have multiple children
  public function children() {
    return $this->hasMany(static::class, 'parent')->orderBy('text', 'asc');
  }

  public function childs() {
        return $this->hasMany('App\Task','parent','id') ;
    }

    //each category might have one parent
  public function boq() {
    return $this->hasMany('App\billOfQuantity','task_id');
  }



}
