<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class TaxReceipt extends Model
{

     //payment mode
    const cash = 1;
    const bank = 2;
    const cheque = 3;


    protected $fillable = [
       'multi_project_id','tax_id', 'receipt_no', 'receipt_date', 'receipt_amount',  'payment_method','depositer_bank_id','company_bank_id','drawn_date','instrument_no','note','payment_head','inst_no','is_book'];


       public function customerPropertyTax() {
        return $this->belongsTo('App\CustomerPropertyTax' , 'tax_id')->with('statement');
    }

       public function DepositorBank(){
        return $this->belongsTo('App\DepositorBank','depositer_bank_id');
    }

    public function companyAccount() {
        return $this->belongsTo('\App\CompanyBank','company_bank_id');
    }
    

}
