<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class TokenReceipt extends Model
{
    protected $table ='token_receipt';
 
    protected $fillable = [
       
        'unit_id','payment_head','token_amount','payment_method','bank_name','company_account','drawn_date','instrument_no','adjustment_type','vendor_purchase_order_id','adjustment_detail','dealer_adjustment_unit_id','receipt_number','receipt_date','notes','is_approved','multi_project_id'
        
    ];
    
    public function inventory() {
        return $this->belongsTo('App\inventory','unit_id');
    }
    
    public function updateTable($filters,$ids=null) {

        $query = TokenReceipt::where('is_approved' , true)
        ->when($ids[0] !== 'all', function ($query) use ($ids) {
            $query->whereIn('multi_project_id', $ids);
                            })
        ;

        foreach($filters as $key => $val) {
            if($key == 'receipt_no')
                $query = $query->where('id',$val);
                
            elseif($key == 'payment_mode' && $val != 'all')
                $query = $query->where('payment_method',$val);
          
         
        $query->with('inventory');
        
        $data['receipts'] = $query->get();

        return $data;
    }
}
}
