<?php

namespace App\Traits;

use App\MultiProject;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;

trait MultiProjectCookie
{
    public function getCookieInfoAndMultiPro($request=null){
        
        
        $data =  array();
        try{ 
               
           if($request == null){
            $request = app(Request::class);
           }

                    if($request->has('multipro_id')){
                
                if($request->multipro_id == 'all'){
                    $data['multipro_id'] =$request->multipro_id;
                }else if(!empty($request->multipro_id)){
                $data['multipro_id'] =  decrypt($request->multipro_id);
                }
            }
            
            
            $project_id = request()->cookie('current_project_id');
           
            $user = Auth::user();
            $data['multi_projects'] = [];
            if (!empty($project_id)) {
               
                $p_id = decrypt($project_id);
                
                $multi = MultiProject::where('id', $p_id)->first();
                $multiProjectId = $multi->id;
              
                if ($multi->name == "Super Admin") {
                   
                    $roles = $user
                        ->roles()
                        ->where('name', 'like', 'admin')
                        ->whereHas('projects', function ($query) use ($multiProjectId) {
                            $query->where('multi_project_id', $multiProjectId);
                        })
                        ->first();
                       
                    if (!empty($roles)) {
                        $data['multi_projects']  = MultiProject::where('name', 'NOT like', 'Super Admin')->get();
                        $data['project'] = $multi->name;
                        $data['role'] = 'admin';
                        $data['project_ids'] =  'all';
                        $data['project_names'] = MultiProject::where('name', 'NOT like', 'Super Admin')->get()->pluck('name')->toArray();
                        if(isset( $data['multipro_id'])){
                            $data['project_ids'] = $data['multipro_id'];
                            if( $data['project_ids'] != 'all'){
                                $data['project_names'] = MultiProject::where('id',$data['project_ids'])->first('name')->toArray();
                           
                              
                            }
                            // 
                        }
                        $data['status'] = 'success';
                        return  $data;
                        
    
                    } 
                    else {
                        // $request = app(Request::class);
               
                    $permission=decrypt($request->permission);
                    // dd($permission);
                    
                    $project_ids=       $user->roles()
                    // ->where('name', 'NOT like', 'admin')
                   ->whereHas('projects', function ($query)   {
                   $query->where('name', 'NOT like', 'Super Admin');
                   })
                   ->get()
                   ->filter(function ($r) use ($permission) {
                   return $r->hasPermission($permission);
                   })
                   ->pluck('projects.*.id') // Pluck the 'id' column from the remaining 'projects' models
                   ->flatten() // Flatten the collection of IDs into a single array
                   ->unique()
                   ->toArray()
                   ;

                //    dd( $project_ids);
                   if(sizeof($project_ids) == 0)
                   {
                       $data['status'] = 'error';
                       return  $data; 
                   }
                         
                        $data['multi_projects'] = MultiProject::whereIn('id',  $project_ids)->where('name', 'NOT like', 'Super Admin')->get();
                        $data['project'] = $multi->name;
                        $data['role'] = 'other';
                        $data['project_ids'] =  $project_ids;
                        $data['project_names'] = MultiProject::whereIn('id',  $project_ids)->where('name', 'NOT like', 'Super Admin')->get()->pluck('name')->toArray();
                        if(isset( $data['multipro_id'])){
                            if($data['multipro_id'] != 'all'){
                            $data['project_ids'] = $data['multipro_id'];
                                $data['project_names'] = MultiProject::where('id',$data['project_ids'])->first('name')->toArray();
                        
                            }
                         
                        }
                        $data['status'] = 'success';
                        return $data;
                    }
                }
                else{
                   
                    $roles = $user
                        ->roles()
                        
                        ->whereHas('projects', function ($query) use ($multiProjectId) {
                            $query->where('multi_project_id', $multiProjectId);
                        })
                        ->first(); 
                   
                        if (!empty($roles)) {
                            $data['multi_projects']  = [];
                            $data['project'] = $multi->name;
                            $data['role'] = 'other';
                            $data['project_ids'] =  $multi->id ;
                            $data['project_names'] = MultiProject::where('id',$data['project_ids'])->first('name')->toArray();
                           
                              
                            if(isset( $data['multipro_id'])){
                                if($data['multipro_id'] != 'all'){
                                    $data['project_ids'] = $data['multipro_id'];
                                    }
                            }
                            $data['status'] = 'success';
                            return  $data;
                            
        
                        }
                }
            }
            else
            {
                $data['status'] = 'error';
                return  $data; 
            }
        }
        catch(\Exception $e){
            $data['status'] = 'error';
            return  $data;
    
        }
    }
    
    
    public function getProjectIds(){
        $data =  array();
        try{ 
            if (Auth::check()){
          
            
            
            $project_id = request()->cookie('current_project_id');
           
            $user = Auth::user();
            $data['multi_projects'] = [];
            if (!empty($project_id)) {
                $p_id = decrypt($project_id);
               
                $multi = MultiProject::where('id', $p_id)->first();
                $multiProjectId = $multi->id;
            
                if ($multi->name == "Super Admin") {
                   
                    $roles = $user
                        ->roles()
                        ->where('name', 'like', 'admin')
                        ->whereHas('projects', function ($query) use ($multiProjectId) {
                            $query->where('multi_project_id', $multiProjectId);
                        })
                        ->first();
                       
                    if (!empty($roles)) {
                         
                        $data['project_ids'] =  'all';
                        
                       
                        $data['status'] = 'success';
                        return  $data;
                        
    
                    } 
                    else {
                        // $request = app(Request::class);
                    $project_ids=       $user->roles()
                    // ->where('name', 'NOT like', 'admin')
                   ->whereHas('projects', function ($query)   {
                   $query->where('name', 'NOT like', 'Super Admin');
                   })
                   ->get()                 
                   ->pluck('projects.*.id') // Pluck the 'id' column from the remaining 'projects' models
                   ->flatten() // Flatten the collection of IDs into a single array
                   ->unique()
                   ->toArray()
                   ;

                //    dd( $project_ids);
                   if(sizeof($project_ids) == 0)
                   {
                       $data['status'] = 'error';
                       return  $data; 
                   }
                         
                         
                        $data['project_ids'] =  $project_ids;
                       
                        $data['status'] = 'success';
                        return $data;
                    }
                }
                else{
                   
                    $roles = $user
                        ->roles()
                        
                        ->whereHas('projects', function ($query) use ($multiProjectId) {
                            $query->where('multi_project_id', $multiProjectId);
                        })
                        ->first(); 
                   
                        if (!empty($roles)) {
                         
                            $data['project_ids'] =  $multi->id ;
                            
                           
                            $data['status'] = 'success';
                            return  $data;
                            
        
                        }
                }
            }
            else
            {
                $data['status'] = 'error';
                return  $data; 
            }
        }
        else{
            $data['status'] = 'error';
            return  $data;   
        }
            
        }
        catch(\Exception $e){
            $data['status'] = 'error';
            return  $data;
    
        }
    }
}
