<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class UnitFloor extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name','is_deleted','unit_block_id'
    ];

    public function unitFloors() {
        return $this->hasMany('\App\UnitFloorSize')->with('size','type');
    }

     public function inventory() {
        return $this->hasMany('\App\Inventory');
    }

    public function unitBlock() {
        return $this->belongsTo('\App\UnitBlock');
    }

    //create a new floor
    public function insertUnitFloor($request) {

        $floor = UnitFloor::create(['name'=>$request->name,'unit_block_id'=>$request->unit_block_id]);

        if($request->type) {
            for($i =0 ;$i<count($request->type) ;$i++) {
                UnitFloorSize::create(['unit_floor_id'=>$floor->id,'unit_type_id'=>$request->type[$i]]);
            }
        }
    }

    //update the floor
    public function updateUnitFloor($request) {

        $floor = UnitFloor::where('id',$request->id)->update(['name'=>$request->name,'unit_block_id'=>$request->unit_block_id]);

        //maintan the old rates

        $oldRates = UnitFloorSize::where('unit_floor_id',$request->id)->get();

        foreach ($oldRates as $value) {
            UnitOldRates::create(['unit_floor_id'=>$value->unit_floor_id,'unit_type_id'=>$value->unit_type_id,'created_at'=>$value->created_at]);
        }

        //

        UnitFloorSize::where('unit_floor_id',$request->id)->delete();

        if($request->type) {
            for($i = 0 ;$i<count($request->type) ;$i++) {
                UnitFloorSize::create(['unit_floor_id'=>$request->id,'unit_type_id'=>$request->type[$i]]);
                // $inventories = Inventory::where([['status',Inventory::open],['unit_floor_id',$request->id],['unit_type_id',$request->type[$i]]])->with('categories')->get();
                // foreach($inventories as $inv) {
                //     $per = 0;
                //     $extra_amount = 0;
                //     foreach($inv->categories as $c) {
                //         if($c->category->is_percent) {
                //             $per = (int)$c->category->percent;
                //             $extra_amount += (int)($request->rate[$i] * (float)$inv->size->name) * $per / 100;
                //         }
                //         else {
                //             $per = (int)$c->category->percent;
                //             $extra_amount += $per;
                //         }

                //     }
                    
                //     Inventory::where('id',$inv->id)->update(['total_price'=>(int)($request->rate[$i] * (float)$inv->size->name) + $extra_amount,'extra_amount' => $extra_amount]);
                // }

            }
        }
    }
}
