<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class UnitFloorSize extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'unit_floor_id','unit_size_id','unit_type_id','rate'
    ];

    public function floor() {
        return $this->belongsTo('\App\UnitFloor');
    }

    public function size() {
        return $this->belongsTo('\App\UnitSize','unit_size_id');
    }

    public function type() {
        return $this->belongsTo('\App\UnitType','unit_type_id');
    }
}
