<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class UnitRefundHistory extends Model
{
    //

    const REFUND_DEDUCTUION_IN_PERCENTAGE = 1;
    const REFUND_DEDUCTUION_IN_PKR = 0;

    const REFUND_DECISION_APPROVED = 1;

    const REFUND_DECISION_DECLINE= 2;
    const REFUND_DECISION_PENDING = 0;

    public function  customer()
    {
        return $this->belongsTo('\App\Customer', 'customer_id');
    }
    public function  customerProperty()
    {
        return $this->belongsTo('\App\CustomerProperty', 'customer_property_id');
    }

    public function  refundhistory()
    {
        return $this->hasMany('\App\StatementHistory', 'unit_refund_history_id');
        
    }
    public function  cancelProperty()
    {
        return $this->belongsTo('\App\CancelProperty', 'cancel_property_id');
    }
   






}