<?php

namespace App;

 
use Illuminate\Notifications\Notifiable;
use Zizaco\Entrust\Traits\EntrustUserTrait;
use Illuminate\Cache\TaggableStore;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Config;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use Notifiable , EntrustUserTrait;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password','role','session_id','phone_number'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    public function otp() {
        return $this->hasOne('App\Otp','phone_number','phone_number')->latest();
    }

    public function roles() {
        return $this->belongsToMany('App\Role');
    }

    public function role() {
        return $this->hasOne('App\RoleUser');
    }

    public function userRole()
    {
        return $this->hasMany(RoleUser::class, 'user_id', 'id');
    }

    public function canForProject($permissionName, $requireAll = false)
    {
        $projectId = request()->cookie('current_project_id');
           
            if (is_null($projectId)) {
                
                return false;
            }
            $projectId= decrypt( $projectId);
            $roles = $this->roles()->whereHas('projects', function ($query) use ($projectId) {
                $query->where('multi_project_id', $projectId);
            })
          ->get();
    
        // $roles = $this->roles()->where('project_id', $projectId)->get();
        // $permissions = $project->permissions()->whereIn('name', (array)$permissionName)->get();
    
        foreach ($roles as $role) {
            foreach ($permissions as $permission) {
                if ($role->hasPermission($permission->name, $requireAll)) {
                    return true;
                }
            }
        }
    
        return false;
    }
//     public function cachedPermissions()
// {
//     $userPrimaryKey = $this->primaryKey;
//     $cacheKey = 'entrust_permissions_for_user_' . $this->$userPrimaryKey;
//     if (Cache::getStore() instanceof TaggableStore) {
//         return Cache::tags(Config::get('entrust.permission_user_table'))->remember($cacheKey, Config::get('cache.ttl', 60), function () {
//             return $this->roles()->with('permissions')->get()->pluck('permissions')->flatten()->unique('id');
//         });
//     } else {
//         return $this->roles()->with('permissions')->get()->pluck('permissions')->flatten()->unique('id');
//     }
// }
public function cachedPermissions($projectId = null)
{
    $userPrimaryKey = $this->primaryKey;
    $cacheKey = 'entrust_permissions_for_user_' . $this->$userPrimaryKey . '_project_' . $projectId;

    if (Cache::getStore() instanceof TaggableStore) {
        return Cache::tags(Config::get('entrust.permission_user_table'))->remember($cacheKey, Config::get('cache.ttl', 60), function () use ($projectId) {
            $permissions = collect([]);

            foreach ($this->roles as $role) {
                $permissions = $permissions->merge($role->cachedPermissions($projectId));
            }

            return $permissions->unique('id')->values();
        });
    } else {
        $permissions = collect([]);

        foreach ($this->roles as $role) {
            $permissions = $permissions->merge($role->cachedPermissions($projectId));
        }

        return $permissions->unique('id')->values();
    }
}


    public function canInProject($permissionName, $projectId, $roleName)
{
    
    $role = Role::where('name', $roleName)->whereHas('projects', function ($query) use ($projectId) {
        $query->where('multi_project_id', $projectId);
    })->firstOrFail();

    $permissions = $role->permissions()->whereIn('name', (array)$permissionName)->get();

    if ($permissions->isEmpty()) {
        return false;
    }

    $cachedPermissions = $this->cachedPermissions($projectId);

    foreach ($permissions as $permission) {
        if ($cachedPermissions->contains('id', $permission->id)) {
            return true;
        }
    }

    return false;
}

    



    const admin = 1;
    const staff = 2;
    const dealer = 3;
    const accountant = 4;
}