<?php

if(!function_exists('to_currency'))
{
    function to_currency($number)
    {
        return to_decimals($number, 'currency_decimals', \NumberFormatter::CURRENCY);
    }
}

if(!function_exists('to_decimals'))
{
    function to_decimals($number, $decimals, $type=\NumberFormatter::DECIMAL)
{
    // ignore empty strings and return
    // NOTE: do not change it to empty otherwise tables will show a 0 with no decimal nor currency symbol
    if(!isset($number))
    {
        return $number;
    }

    $fmt = new \NumberFormatter('PKR', $type);

    if (empty($config->item('thousands_separator')))
    {
        $fmt->setAttribute(\NumberFormatter::GROUPING_SEPARATOR_SYMBOL, '');
    }
    $fmt->setSymbol(\NumberFormatter::CURRENCY_SYMBOL, 'Rs ');
    return $fmt->format($number);
}
}