<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCustomersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customers', function (Blueprint $table) {
            $table->increments('id');
           
            $table->text('name');
            $table->text('father_name');
            $table->text('cnic')->nullable();
            $table->text('email')->nullable();
            $table->text('phone_number')->nullable();
            $table->text('address')->nullable();
            $table->double('total_paid_amount')->default(0);
            $table->boolean('status')->default(1);
            $table->text('img_url')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
      //  Schema::dropIfExists('customers');
    }
}
