<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCustomerStatementsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customer_statements', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('customer_id')->unsigned()->nullable();;
            $table->foreign('customer_id')->references('id')->on('customers')->onDelete('set null');
            $table->integer('customer_property_id')->unsigned()->nullable();;
            $table->foreign('customer_property_id')->references('id')->on('customer_properties')->onDelete('set null');
            
            $table->integer('payment_head')->default(1);
            $table->integer('inst_no')->default(1);
            $table->date('due_date')->nullable();
            $table->double('due')->nullable();
            $table->double('received')->nullable();
            $table->double('balance')->nullable();
            $table->text('rcpt_no')->nullable();
            $table->text('ref_no')->nullable();
            $table->date('rcpt_date')->nullable();
            $table->double('rcpt_amount')->nullable();
            $table->integer('late_days')->nullable();
            $table->double('surcharge')->nullable();
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
      //  Schema::dropIfExists('customer_statements');
    }
}
