<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePurchasesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('purchases', function (Blueprint $table) {
            $table->increments('id');
            $table->date('date')->nullable();
            $table->string('product')->nullable();
            $table->string('supplier')->nullable();
            $table->double('rate')->nullable();
            $table->integer('qty')->nulllable();
            $table->double('total')->nullable();
            $table->double('tax')->nullable();
            $table->double('net')->nullable();
            $table->boolean('status')->default('1');
            $table->boolean('payment_mode')->default(1);
           $table->string('bank_name')->nullable();
           $table->string('bill_no')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
      //  Schema::dropIfExists('purchases');
    }
}
