<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEmployeesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('employees', function (Blueprint $table) {
            $table->increments('id');
            
            $table->double('basic_salary')->default(0);
            $table->string('employee_id')->nullable();
            $table->integer('manager_id')->unsigned()->nullable();
            $table->foreign('manager_id')->references('id')->on('employees')->onDelete('set null');
            $table->integer('department_id')->unsigned()->nullable();
            $table->integer('designation_id')->unsigned()->nullable();
            $table->date('start_date')->nullable();
            
            $table->boolean('status')->default(1);
            $table->integer('employee_type')->default(1);
            $table->integer('working_hours')->deafult(8);
            $table->integer('working_days')->default(5);
            
            $table->string('bank_name')->nullable();
            $table->string('account_name')->nullable();
            $table->string('account_number')->nullable();
            
            $table->string('name')->nullable();
            $table->string('email')->nullable();
            $table->string('phone_number')->nullable();
            $table->string('address')->nullable();
            $table->boolean('gender')->default(1);
            $table->date('dob')->nullable();
            
            $table->string('emer_person')->nullable();
            $table->string('emer_relation')->nullable();
            $table->string('emer_phone_number')->nullable();
            $table->string('emer_email')->nullable();
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employees');
    }
}
