<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateReceiptsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('receipts', function (Blueprint $table) {
            $table->increments('id');
            
            $table->integer('customer_id')->unsigned()->nullable();
            $table->foreign('customer_id')->references('id')->on('customers')->onDelete('set null');
            
            $table->integer('customer_property_id')->unsigned()->nullable();
            $table->foreign('customer_property_id')->references('id')->on('customer_properties')->onDelete('set null');
            
            $table->integer('payment_head');
            $table->integer('payment_mode')->default(1);
            $table->text('bank_name')->nullable();
            $table->string('cheque_number')->nullable();
            $table->string('cheque_title')->nullable();
            
            $table->double('amount');
            
            $table->string('receipt_no')->nullable();
            $table->string('reference_no')->nullable();
            $table->date('receipt_date');
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
      //  Schema::dropIfExists('receipts');
    }
}
