<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class UpdateInstallmmentPlansNew extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
       //   Schema::dropIfExists('installment_plans');
      
          Schema::create('installment_plans', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('plot_type')->unsigned();
            $table->foreign('plot_type')->references('id')->on('product_types')->onDelete('cascade');
            $table->integer('plot_size')->unsigned();
            $table->foreign('plot_size')->references('id')->on('product_sizes')->onDelete('cascade');
            $table->double('cost_amount');
            $table->double('down_payment');
            $table->double('confirmation_fee');
            $table->double('plot_belting_fee')->nullable();
            $table->double('possession_fee');
            $table->double('installment');
            $table->integer('total_months');
           
            $table->boolean('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('installment_plans', function (Blueprint $table) {
            //
        });
    }
}
