<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTransferPropertiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::dropIfExists('transfer_properties');
        
        Schema::create('transfer_properties', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('property_id')->unsigned();
            $table->foreign('property_id')->references('id')->on('customer_properties')->onDelete('cascade');
            $table->integer('owner_id')->unsigned();
            $table->foreign('owner_id')->references('id')->on('customers')->onDelete('cascade');
            $table->integer('transfer_customer_id')->unsigned();
            $table->foreign('transfer_customer_id')->references('id')->on('customers')->onDelete('cascade');
            $table->date('transfer_date');
            $table->text('transfer_note')->nullable();
            $table->double('amount_paid');
            $table->double('surcharge')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transfer_properties');
    }
}
