<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInventoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('inventories', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('unit_category_id')->unsigned();
            $table->foreign('unit_category_id')->references('id')->on('unit_categories')->onDelete('cascade');
            $table->integer('unit_size_id')->unsigned();
            $table->foreign('unit_size_id')->references('id')->on('unit_sizes')->onDelete('cascade');
            $table->string('unit_number');
            $table->double('rate_sqft');
            $table->double('total_price');
            $table->boolean('status');
            $table->text('floor');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('inventories');
    }
}
