<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCustomerPropertyBuyBacksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customer_property_buy_backs', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('customer_property_id')->unsigned();
            $table->foreign('customer_property_id')->references('id')->on('customer_properties')->onDelete('cascade');
            $table->double('total_amount')->nullable();
            $table->double('total_tenure')->nullable();
            $table->double('rebate_percentage')->nullable();
            $table->double('return_tenure')->nullable();
            $table->double('rebate_amount_per_tenure')->nullable();
            $table->double('deduction_amount')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customer_property_buy_backs');
    }
}
