<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProjectAccountFilesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('project_account_files', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('project_account_id')->unsigned();
            $table->foreign('project_account_id')->references('id')->on('project_accounts')->onDelete('cascade');
            $table->text('file_url');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('project_account_files');
    }
}
