<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class UpdateProjectAccount extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('project_accounts', function (Blueprint $table) {
            $table->string('pay_order_title')->nullable();
            $table->string('pay_order_date')->nullable();
            $table->integer('pay_order_bank_id')->unsigned()->nullable();
            $table->foreign('pay_order_bank_id')->references('id')->on('depositor_banks')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('project_accounts', function (Blueprint $table) {
            //
        });
    }
}
