<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUnitFloorCategoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('unit_floor_categories', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('unit_floor_id')->unsigned();
            $table->foreign('unit_floor_id')->references('id')->on('unit_floors')->onDelete('cascade');
            $table->integer('unit_category_id')->unsigned();
            $table->foreign('unit_category_id')->references('id')->on('unit_categories')->onDelete('cascade');
            $table->double('rate');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('unit_floor_categories');
    }
}
