<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDealerReceivedAmountsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('dealer_received_amounts', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('dealer_id')->unsigned();
            $table->index('dealer_id');
            $table->foreign('dealer_id')->references('id')->on('dealers')->onDelete('cascade');
            $table->integer('customer_property_id')->unsigned();
            $table->index('customer_property_id');
            $table->foreign('customer_property_id')->references('id')->on('customer_properties')->onDelete('cascade');
            $table->integer('payment_mode')->default(1);
            $table->text('bank_name')->nullable();
            $table->string('cheque_number')->nullable();
            $table->string('cheque_title')->nullable();
            
            $table->double('amount');
            $table->date('date');

            $table->text('note');
            $table->integer('adjacement_type')->nullable();
            $table->text('adjacement_detail')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('dealer_received_amounts');
    }
}
