<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGeneralJournalEntriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('general_journal_entries', function (Blueprint $table) {
            $table->increments('id');
            $table->date('date');
            $table->integer('entry_no');
            $table->boolean('adjusting_entry')->default(0);
            $table->integer('account_id')->unsigned();
            $table->foreign('account_id')->references('id')->on('chart_of_accounts')->onDelete('cascade');
            $table->double('amount');
            $table->text('memo')->nullable();
            $table->string('name')->nullable();
            $table->boolean('name_type');
            $table->string('type')->nullable();
            $table->integer('class_id')->unsigned();
            $table->foregin('class_id')->references('id')->on('account_classes')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('general_journal_entries');
    }
}
