<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNocTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('noc', function (Blueprint $table) {
        $table->increments('id');
        $table->string('noc_no');
        $table->integer('customer_id');
        $table->bigInteger('unit_number_id');
        $table->date('noc_date');
        $table->tinyInteger('status')->default(0)->comment('0 = Pending, 1 = Approve, 2 = Expiry, 3 = Transfer');
        $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('noc', function (Blueprint $table) {
            //
        });
    }
}
