<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStatementHistoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('statement_histories', function (Blueprint $table) {
            $table->increments('id');
            $table->bigInteger('unit_refund_history_id')->nullable();
            $table->integer('payment_head')->default(1);
            $table->integer('inst_no')->default(1);
            $table->tinyInteger('inst_track')->default(0);
            $table->date('due_date')->nullable();
            $table->double('due')->nullable();
            $table->double('received')->nullable();
            $table->double('balance')->nullable();
            $table->text('rcpt_no')->nullable();
            $table->text('ref_no')->nullable();
            $table->date('rcpt_date')->nullable();
            $table->double('rcpt_amount')->nullable();
            $table->integer('late_days')->nullable();
            $table->double('surcharge')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('statement_histories');
    }
}
