<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCancelOpenFilesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cancel_open_files', function (Blueprint $table) {
            $table->increments('id');
            $table->bigInteger('openfile_dealer_info_id');
            $table->tinyInteger('status')->default(0)->comment('0 pending , 1 approved');
            $table->enum('after_cancellation_status', ['refund-pending', 'adjust-pending','swap-pending', 'pending','refunded','adjusted','decline','swaped'])->default('pending');
            $table->double('fee')->nullable();
            $table->boolean('voucher_generated')->default(0)->comment('0=> not generated, 1=> generated ');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cancel_open_files');
    }
}
