<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOpenFileRefundHistoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('open_file_refund_histories', function (Blueprint $table) {
            $table->increments('id');
            $table->bigInteger('dealer_id');
            $table->bigInteger('inventory_id');
            $table->bigInteger('cancel_openfile_id')->nullable();  
            $table->double('total_amount')->nullable();
            $table->double('total_refund')->nullable();
            $table->double('total_deduct')->nullable();
            $table->double('total_deduct_percentage')->nullable();
            $table->text('openfile_detail')->default(null);  
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('open_file_refund_histories');
    }
}
