<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDevelopmentChargesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('development_charges', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('customer_id')->unsigned()->nullable();
            $table->integer('customer_property_id')->unsigned()->nullable();
            // $table->integer('payment_head')->default(1);
            // $table->integer('inst_no')->default(1);
            // $table->date('due_date')->nullable();
            // $table->double('due')->nullable();
            // $table->double('received')->nullable();
            // $table->double('balance')->nullable();
            $table->text('charges_detail')->nullable();
            $table->integer('is_approved')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('development_charges');
    }
}
