<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBallotingMapDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('balloting_map_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('balloting_map_file_id');
            $table->bigInteger('sr_no')->nullable();
            $table->bigInteger('plot_no');
            $table->double('area')->nullable();
            $table->string('feature')->nullable();
            $table->string('exact_odd')->nullable();
            $table->string('sector')->nullable();
            $table->string('road_category')->nullable();
            $table->bigInteger('customer_property_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('balloting_map_details');
    }
}
