<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmailSmsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('email_sms', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('email_sms_type_id');
            $table->tinyInteger('content_type')->comment('0 => email 1 => sms');
            $table->text('content')->nullable();
            $table->tinyInteger('status')->comment('0 => off 1 => on');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('email_sms');
    }
}
