<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDirectBallotingMapDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('direct_balloting_map_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('direct_balloting_map_file_id');
            $table->bigInteger('sr_no')->nullable();
            $table->bigInteger('plot_no');
            $table->double('area')->nullable();
            $table->string('feature')->nullable();
            $table->string('exact_odd')->nullable();
            $table->string('sector')->nullable();
            $table->string('road_category')->nullable();
            $table->bigInteger('customer_property_id')->nullable();
            $table->bigInteger('unit_size_id')->nullable();
            $table->bigInteger('unit_type_id')->nullable();
            $table->bigInteger('unit_block_id')->nullable();
            $table->bigInteger('unit_floor_id')->nullable();
            $table->string('unit_category_ids')->nullable();
            $table->bigInteger('inventory_id')->nullable();
            $table->tinyInteger('balloting_status')->default(0);
            $table->string('street')->nullable();
            $table->string('type')->nullable();
            $table->string('cnic')->nullable();
            $table->string('membershipno')->nullable();
           
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('direct_balloting_map_details');
    }
}
