<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCustomerRefundUnitReceiptsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customer_refund_unit_receipts', function (Blueprint $table) {
            $table->increments('id');            
            $table->integer('customer_id')->unsigned()->nullable();            
            $table->integer('customer_property_id')->unsigned()->nullable();             
            $table->integer('payment_head');
            $table->integer('payment_mode')->default(1);
            $table->text('bank_name')->nullable();
            $table->string('cheque_number')->nullable();
            $table->string('cheque_title')->nullable();             
            $table->date('drawn_date')->nullable();
            $table->double('amount');            
            $table->string('receipt_no')->nullable();
            $table->string('reference_no')->nullable();
            $table->date('receipt_date');
            $table->integer('company_account')->nullable();
            $table->integer('adjustment_type')->nullable();
            $table->text('adjustment_detail')->nullable();
            $table->tinyInteger('is_deleted')->default(0);
            $table->tinyInteger('is_approved')->nullable();
            $table->integer('download_count')->nullable();
            $table->integer('print_count')->nullable();             
            $table->tinyInteger('reconciled')->nullable();
            $table->integer('payment_method')->nullable();
            $table->integer('dealer_adjustment_unit_id')->nullable();
            $table->integer('vendor_purchase_order_id')->nullable();
            $table->tinyInteger('is_book')->default(0); 
            $table->text('notes')->nullable();
            $table->tinyInteger('tax_paid_by')->nullable();
            $table->tinyInteger('tax_payment_received')->nullable();
            $table->double('tax_amount')->nullable();
            $table->bigInteger('multi_project_id')->nullable();
               
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customer_refund_unit_receipts');
    }
}
