<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCancelReceiptDocumentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cancel_receipt_documents', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('cancel_receipt_id');
            $table->string('document_path', 255)->collation('latin1_swedish_ci');
            $table->tinyInteger('close_unit')->default(0);
            $table->tinyInteger('openfile')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cancel_receipt_documents');
    }
}
