DROP TABLE IF EXISTS account_classes;

CREATE TABLE `account_classes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS account_transfers;

CREATE TABLE `account_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `from_account` int(11) NOT NULL,
  `to_account` int(11) NOT NULL,
  `date` date NOT NULL,
  `amount` double NOT NULL,
  `memo` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS account_types;

CREATE TABLE `account_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4;

INSERT INTO account_types VALUES("1","Income","<p style=\"text-align: center;\"><strong>Income Account</strong><strong></strong></p>\n\n<p style=\"text-align: left;\">Categorizes money earned from normal business operations, such as:</p>\n\n<ul>\n\n<li style=\"text-align: left;\">Product sales</li>\n\n<li style=\"text-align: left;\">Service sales</li>\n\n<li style=\"text-align: left;\">Discounts to customers</li>\n\n</ul>"),
("2","Expense","<p style=\"text-align: center;\"><strong>Expense Account</strong><strong></strong></p>\n\n<p style=\"text-align: left;\">Categorizes money spent in the course of normal business operations, such as:</p>\n\n<ul>\n\n<li style=\"text-align: left;\">Advertising and promotion</li>\n\n<li style=\"text-align: left;\">Office supplies</li>\n\n<li style=\"text-align: left;\">Insurance</li>\n\n<li style=\"text-align: left;\">Legal fees</li>\n\n<li style=\"text-align: left;\">Charitable contributions</li>\n\n<li style=\"text-align: left;\">Rent</li>\n\n</ul>"),
("3","Non-Current Asset","<p style=\"text-align: center;\"><strong>Fixed Asset Account</strong><strong></strong></p>\n\n<p style=\"text-align: left;\">Tracks the value of significant items that have a useful life of more than one year, such as:</p>\n\n<ul>\n\n<li style=\"text-align: left;\">Buildings</li>\n\n<li style=\"text-align: left;\">Land</li>\n\n<li style=\"text-align: left;\">Machinery and equipment</li>\n\n<li style=\"text-align: left;\">Vehicles</li>\n\n</ul>"),
("4","Bank","<p style=\"text-align: center;\"><strong>Bank Account</strong><strong></strong></p>\n\n<p style=\"text-align: left;\">Create one for each cash account, such as:</p>\n\n<ul>\n\n<li style=\"text-align: left;\">Petty Cash</li>\n\n<li style=\"text-align: left;\">Checking</li>\n\n<li style=\"text-align: left;\">Savings</li>\n\n<li style=\"text-align: left;\">Money market</li>\n\n</ul>"),
("7","Equity","<p style=\"text-align: center;\"><strong>Equity Account</strong><strong></strong></p>\n\n<p style=\"text-align: left;\">Tracks money invested in. or money is taken out of, the business by owners or shareholders. Payroll and reimbursable expenses should not be included.</p>"),
("8","Accounts Receivable","<p style=\"text-align: center;\"><strong>Accounts Receivable (A/R)</strong><strong></strong></p>\n\n<p style=\"text-align: left;\">Tracks money your customers owe you on unpaid invoices.</p>"),
("9","Other CurrentAsset","<p style=\"text-align: center;\"><strong>Other Current Asset Account</strong><strong></strong></p>\n\n<p style=\"text-align: left;\">Tracks the value of things that can be converted to cash or used up within one year, such as:</p>\n\n<ul>\n\n<li style=\"text-align: left;\">Prepaid expenses</li>\n\n<li style=\"text-align: left;\">Employee cash advances</li>\n\n<li style=\"text-align: left;\">Inventory</li>\n\n<li style=\"text-align: left;\">Loans from your business</li>\n\n</ul>"),
("10","Other Asset","<p style=\"text-align: center;\"><strong>Other&nbsp; Asset Account</strong><strong></strong></p>\n\n<p style=\"text-align: left;\">Tracks the value of things that are neither Fixed Assets nor Other Current Assets, such as:</p>\n\n<ul>\n\n<li style=\"text-align: left;\">Goodwill</li>\n\n<li style=\"text-align: left;\">Long-term&nbsp; notes receivable</li>\n\n<li style=\"text-align: left;\">Security deposits paid</li>\n\n</ul>"),
("11","Accounts Payable","<p style=\"text-align: center;\"><strong>Accounts Payable (A/P)</strong><strong></strong></p>\n\n<p style=\"text-align: left;\">Tracks money you owe to vendors for purchases made on credit.</p>"),
("12","Other Current Liability","<p style=\"text-align: center;\"><strong>Other Current Liability Account</strong><strong></strong></p>\n\n<p style=\"text-align: left;\">Tracks money your business owes and expects to pay within one year, such as:</p>\n\n<ul>\n\n<li style=\"text-align: left;\">Sales tax</li>\n\n<li style=\"text-align: left;\">Payroll tax</li>\n\n<li style=\"text-align: left;\">Security deposits/retainers from customers</li>\n\n</ul>"),
("13","Long Term Liability","<p style=\"text-align: center;\"><strong>Long Term Liability Account</strong><strong></strong></p>\n\n<p style=\"text-align: left;\">Tracks money your business owes and expects to pay back over more than one year, such as:</p>\n\n<ul>\n\n<li style=\"text-align: left;\">Mortgages</li>\n\n<li style=\"text-align: left;\">Long-term loans</li>\n\n<li style=\"text-align: left;\">Notes payable</li>\n\n</ul>"),
("15","Direct Cost","<p style=\"text-align: center;\"><strong>Cost of Goods Sold Account</strong><strong></strong></p>\n\n<p style=\"text-align: left;\">Tracks the direct costs to produce the items that your business sells, such as:</p>\n\n<ul>\n\n<li style=\"text-align: left;\">Cost of materials</li>\n\n<li style=\"text-align: left;\">Cost of labor</li>\n\n<li style=\"text-align: left;\">Shipping, freight, and delivery</li>\n\n<li style=\"text-align: left;\">Subcontractors</li>\n\n</ul>");



DROP TABLE IF EXISTS activity_log;

CREATE TABLE `activity_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `subject_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `causer_id` int(11) DEFAULT NULL,
  `causer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `properties` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activity_log_log_name_index` (`log_name`)
) ENGINE=InnoDB AUTO_INCREMENT=107 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO activity_log VALUES("1","View","Customer list.","","","22","App\\User","[]","2022-12-22 20:31:31","2022-12-22 20:31:31"),
("2","View","dashboard","","","22","App\\User","[]","2022-12-22 20:31:36","2022-12-22 20:31:36"),
("3","View","dashboard","","","22","App\\User","[]","2022-12-23 00:07:40","2022-12-23 00:07:40"),
("4","View","dashboard","","","22","App\\User","[]","2022-12-23 00:25:10","2022-12-23 00:25:10"),
("5","View","dashboard","","","22","App\\User","[]","2022-12-23 00:37:53","2022-12-23 00:37:53"),
("6","View","Unit Categories List.","","","22","App\\User","[]","2022-12-23 00:48:17","2022-12-23 00:48:17"),
("7","View","Unit Type List.","","","22","App\\User","[]","2022-12-23 00:48:36","2022-12-23 00:48:36"),
("8","Create","New Type added Shop","","","22","App\\User","[]","2022-12-23 00:48:57","2022-12-23 00:48:57"),
("9","View","Unit Type List.","","","22","App\\User","[]","2022-12-23 00:48:58","2022-12-23 00:48:58"),
("10","View","Unit Size List.","","","22","App\\User","[]","2022-12-23 00:49:11","2022-12-23 00:49:11"),
("11","View","Unit Block List.","","","22","App\\User","[]","2022-12-23 00:49:16","2022-12-23 00:49:16"),
("12","Create","New Block added General","","","22","App\\User","[]","2022-12-23 00:49:30","2022-12-23 00:49:30"),
("13","View","Unit Block List.","","","22","App\\User","[]","2022-12-23 00:49:31","2022-12-23 00:49:31"),
("14","View","Unit Floor List.","","","22","App\\User","[]","2022-12-23 00:49:40","2022-12-23 00:49:40"),
("15","Create","New Floor added Lower Ground 1","","","22","App\\User","[]","2022-12-23 00:50:17","2022-12-23 00:50:17"),
("16","View","Unit Floor List.","","","22","App\\User","[]","2022-12-23 00:50:17","2022-12-23 00:50:17"),
("17","View","Unit Size List.","","","22","App\\User","[]","2022-12-23 00:54:39","2022-12-23 00:54:39"),
("18","Create","New Size added 405","","","22","App\\User","[]","2022-12-23 00:54:50","2022-12-23 00:54:50"),
("19","View","Unit Size List.","","","22","App\\User","[]","2022-12-23 00:54:51","2022-12-23 00:54:51"),
("20","Create","New inventory added LG-01","","","22","App\\User","[]","2022-12-23 00:55:37","2022-12-23 00:55:37"),
("21","View","See the inventory Detail LG-01","","","22","App\\User","[]","2022-12-23 00:55:37","2022-12-23 00:55:37"),
("22","View","Inventory list.","","","22","App\\User","[]","2022-12-23 00:55:43","2022-12-23 00:55:43"),
("23","Create","customer Ali shahzaib","","","22","App\\User","[]","2022-12-23 00:59:29","2022-12-23 00:59:29"),
("24","View","See the customer Detail Ali shahzaib","","","22","App\\User","[]","2022-12-23 00:59:29","2022-12-23 00:59:29"),
("25","Create","New Dealer Added Masood","","","22","App\\User","[]","2022-12-23 01:06:03","2022-12-23 01:06:03"),
("26","View","Dealer detail Masood","","","22","App\\User","[]","2022-12-23 01:06:04","2022-12-23 01:06:04"),
("27","Create","New Property Added  LG-01","","","22","App\\User","[]","2022-12-23 01:09:35","2022-12-23 01:09:35"),
("28","View","View the property info LG-01Ali shahzaib","","","22","App\\User","[]","2022-12-23 01:09:35","2022-12-23 01:09:35"),
("29","Update","Assign client id.","","","22","App\\User","[]","2022-12-23 01:10:53","2022-12-23 01:10:53"),
("30","View","View the property info LG-01Ali shahzaib","","","22","App\\User","[]","2022-12-23 01:10:54","2022-12-23 01:10:54"),
("31","Create","New Receipt Added 50000","","","22","App\\User","[]","2022-12-23 01:15:34","2022-12-23 01:15:34"),
("32","View","Pending Receipt List","","","22","App\\User","[]","2022-12-23 01:15:45","2022-12-23 01:15:45"),
("33","View","Property list.","","","22","App\\User","[]","2022-12-23 01:15:58","2022-12-23 01:15:58"),
("34","View","View Receipt record 50000","","","22","App\\User","[]","2022-12-23 01:16:15","2022-12-23 01:16:15"),
("35","Approved","Receipt Approved 50000","","","22","App\\User","[]","2022-12-23 01:16:54","2022-12-23 01:16:54"),
("36","View","View the property info LG-01Ali shahzaib","","","22","App\\User","[]","2022-12-23 01:16:54","2022-12-23 01:16:54"),
("37","View","View the property info LG-01Ali shahzaib","","","22","App\\User","[]","2022-12-23 01:19:26","2022-12-23 01:19:26"),
("38","View","Customer list.","","","22","App\\User","[]","2022-12-23 01:25:51","2022-12-23 01:25:51"),
("39","View","See the customer Detail Ali shahzaib","","","22","App\\User","[]","2022-12-23 01:25:58","2022-12-23 01:25:58"),
("40","View","Dealer List.","","","22","App\\User","[]","2022-12-23 01:26:38","2022-12-23 01:26:38"),
("41","View","Dealer detail Masood","","","22","App\\User","[]","2022-12-23 01:26:48","2022-12-23 01:26:48"),
("42","View","Dealer Rebate List.","","","22","App\\User","[]","2022-12-23 01:27:17","2022-12-23 01:27:17"),
("43","Create","Dealer Rebate Paid Masood","","","22","App\\User","[]","2022-12-23 01:27:49","2022-12-23 01:27:49"),
("44","View","Dealer List.","","","22","App\\User","[]","2022-12-23 01:28:02","2022-12-23 01:28:02"),
("45","View","Dealer detail Masood","","","22","App\\User","[]","2022-12-23 01:28:09","2022-12-23 01:28:09"),
("46","View","Dealer List.","","","22","App\\User","[]","2022-12-23 01:28:50","2022-12-23 01:28:50"),
("47","View","Dealer Rebate List.","","","22","App\\User","[]","2022-12-23 01:28:57","2022-12-23 01:28:57"),
("48","View","Roles List.","","","22","App\\User","[]","2022-12-23 01:35:12","2022-12-23 01:35:12"),
("49","View","dashboard","","","22","App\\User","[]","2022-12-23 01:36:21","2022-12-23 01:36:21"),
("50","View","Customer list.","","","22","App\\User","[]","2022-12-23 01:37:32","2022-12-23 01:37:32"),
("51","View","See the customer Detail Ali shahzaib","","","22","App\\User","[]","2022-12-23 01:37:40","2022-12-23 01:37:40"),
("52","List","List Taxcition","","","22","App\\User","[]","2022-12-23 01:53:09","2022-12-23 01:53:09"),
("53","Add","Add Taxcition","","","22","App\\User","[]","2022-12-23 01:53:13","2022-12-23 01:53:13"),
("54","Hrm Dashbord","View Hrm Dashbord","","","22","App\\User","[]","2022-12-23 01:53:32","2022-12-23 01:53:32"),
("55","Create","Create Employee","","","22","App\\User","[]","2022-12-23 01:53:38","2022-12-23 01:53:38"),
("56","View","admin profile","","","22","App\\User","[]","2022-12-23 01:55:02","2022-12-23 01:55:02"),
("57","Edit","admin profile","","","22","App\\User","[]","2022-12-23 01:55:06","2022-12-23 01:55:06"),
("58","View","dashboard","","","22","App\\User","[]","2022-12-23 01:55:17","2022-12-23 01:55:17"),
("59","View","dashboard","","","22","App\\User","[]","2022-12-23 01:55:37","2022-12-23 01:55:37"),
("60","View","dashboard","","","22","App\\User","[]","2022-12-23 02:02:46","2022-12-23 02:02:46"),
("61","View","dashboard","","","22","App\\User","[]","2022-12-23 03:40:18","2022-12-23 03:40:18"),
("62","View","Property list.","","","22","App\\User","[]","2022-12-23 13:00:07","2022-12-23 13:00:07"),
("63","View","View the property info LG-01Ali shahzaib","","","22","App\\User","[]","2022-12-23 13:00:10","2022-12-23 13:00:10"),
("64","View","View the property info LG-01Ali shahzaib","","","22","App\\User","[]","2022-12-23 13:00:24","2022-12-23 13:00:24"),
("65","View","Property list.","","","22","App\\User","[]","2022-12-23 13:01:06","2022-12-23 13:01:06"),
("66","View","dashboard","","","22","App\\User","[]","2022-12-23 15:26:59","2022-12-23 15:26:59"),
("67","View","View the property info LG-01Ali shahzaib","","","22","App\\User","[]","2022-12-23 15:30:35","2022-12-23 15:30:35"),
("68","View","View the property info LG-01Ali shahzaib","","","22","App\\User","[]","2022-12-23 15:31:08","2022-12-23 15:31:08"),
("69","View","View the property info LG-01Ali shahzaib","","","22","App\\User","[]","2022-12-23 15:32:42","2022-12-23 15:32:42"),
("70","View","View the property info LG-01Ali shahzaib","","","22","App\\User","[]","2022-12-23 15:32:58","2022-12-23 15:32:58"),
("71","View","dashboard","","","22","App\\User","[]","2022-12-23 18:02:07","2022-12-23 18:02:07"),
("72","View","Property list.","","","22","App\\User","[]","2022-12-23 18:03:12","2022-12-23 18:03:12"),
("73","View","View the property info LG-01Ali shahzaib","","","22","App\\User","[]","2022-12-23 18:03:17","2022-12-23 18:03:17"),
("74","View","Property list.","","","22","App\\User","[]","2022-12-23 18:53:54","2022-12-23 18:53:54"),
("75","View","Property list.","","","22","App\\User","[]","2022-12-23 18:56:08","2022-12-23 18:56:08"),
("76","View","Property list.","","","22","App\\User","[]","2022-12-23 18:56:57","2022-12-23 18:56:57"),
("77","View","Property list.","","","22","App\\User","[]","2022-12-23 18:57:21","2022-12-23 18:57:21"),
("78","View","Property list.","","","22","App\\User","[]","2022-12-23 18:57:45","2022-12-23 18:57:45"),
("79","View","Property list.","","","22","App\\User","[]","2022-12-23 18:58:15","2022-12-23 18:58:15"),
("80","View","Property list.","","","22","App\\User","[]","2022-12-23 19:02:16","2022-12-23 19:02:16"),
("81","View","Property list.","","","22","App\\User","[]","2022-12-23 19:02:33","2022-12-23 19:02:33"),
("82","View","Property list.","","","22","App\\User","[]","2022-12-23 19:05:27","2022-12-23 19:05:27"),
("83","View","Property list.","","","22","App\\User","[]","2022-12-23 19:05:39","2022-12-23 19:05:39"),
("84","View","Property list.","","","22","App\\User","[]","2022-12-23 19:10:53","2022-12-23 19:10:53"),
("85","View","Property list.","","","22","App\\User","[]","2022-12-23 19:11:46","2022-12-23 19:11:46"),
("86","View","Property list.","","","22","App\\User","[]","2022-12-23 19:11:59","2022-12-23 19:11:59"),
("87","View","Property list.","","","22","App\\User","[]","2022-12-23 19:12:41","2022-12-23 19:12:41"),
("88","View","Property list.","","","22","App\\User","[]","2022-12-23 19:13:07","2022-12-23 19:13:07"),
("89","View","Property list.","","","22","App\\User","[]","2022-12-23 19:13:31","2022-12-23 19:13:31"),
("90","View","Property list.","","","22","App\\User","[]","2022-12-23 19:14:17","2022-12-23 19:14:17"),
("91","View","Property list.","","","22","App\\User","[]","2022-12-23 19:14:45","2022-12-23 19:14:45"),
("92","View","Property list.","","","22","App\\User","[]","2022-12-23 19:15:20","2022-12-23 19:15:20"),
("93","View","dashboard","","","22","App\\User","[]","2022-12-26 00:26:34","2022-12-26 00:26:34"),
("94","View","Property list.","","","22","App\\User","[]","2022-12-26 00:36:34","2022-12-26 00:36:34"),
("95","View","View the property info LG-01Ali shahzaib","","","22","App\\User","[]","2022-12-26 00:36:40","2022-12-26 00:36:40"),
("96","View","Property list.","","","22","App\\User","[]","2022-12-26 00:38:55","2022-12-26 00:38:55"),
("97","View","Property list.","","","22","App\\User","[]","2022-12-26 00:39:13","2022-12-26 00:39:13"),
("98","View","Property list.","","","22","App\\User","[]","2022-12-26 00:43:59","2022-12-26 00:43:59"),
("99","View","Property list.","","","22","App\\User","[]","2022-12-26 00:44:12","2022-12-26 00:44:12"),
("100","View","dashboard","","","22","App\\User","[]","2022-12-28 16:49:17","2022-12-28 16:49:17"),
("101","View","Cancel Statements list.","","","22","App\\User","[]","2022-12-28 16:49:30","2022-12-28 16:49:30"),
("102","View","Unit Type List.","","","22","App\\User","[]","2022-12-28 17:54:33","2022-12-28 17:54:33"),
("103","View","Unit Type List.","","","22","App\\User","[]","2022-12-28 17:55:19","2022-12-28 17:55:19"),
("104","View","Unit Type List.","","","22","App\\User","[]","2022-12-28 17:57:48","2022-12-28 17:57:48"),
("105","View","dashboard","","","22","App\\User","[]","2022-12-29 10:10:22","2022-12-29 10:10:22"),
("106","View","dashboard","","","22","App\\User","[]","2022-12-29 11:25:11","2022-12-29 11:25:11");



DROP TABLE IF EXISTS approvel_roles;

CREATE TABLE `approvel_roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS approvel_status_comparative_statement;

CREATE TABLE `approvel_status_comparative_statement` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_id` int(11) NOT NULL DEFAULT 0,
  `purchase_request_id` int(11) NOT NULL DEFAULT 0,
  `purchase_order_id` int(11) NOT NULL DEFAULT 0,
  `approvel_status` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS approvel_status_purchase_request;

CREATE TABLE `approvel_status_purchase_request` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(11) NOT NULL DEFAULT 0,
  `purchase_request_id` int(11) NOT NULL DEFAULT 0,
  `approvel_status` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `approvel_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS asset_location;

CREATE TABLE `asset_location` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS asset_maintainances;

CREATE TABLE `asset_maintainances` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) NOT NULL,
  `type` varchar(100) DEFAULT NULL,
  `cost` double DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS asset_releases;

CREATE TABLE `asset_releases` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` int(11) NOT NULL,
  `assign_date` date DEFAULT NULL,
  `till_date` date DEFAULT NULL,
  `asset_id` int(11) NOT NULL,
  `assign_status` int(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS bill_of_quantities;

CREATE TABLE `bill_of_quantities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `task_id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL,
  `quantity` bigint(20) NOT NULL,
  `rate_per_unit` double(8,2) NOT NULL,
  `total_cost` double(8,2) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS buy_back;

CREATE TABLE `buy_back` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref_no` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date` date DEFAULT NULL,
  `party_code` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inventory_id` int(11) DEFAULT NULL,
  `total_amount_invested` double NOT NULL DEFAULT 0,
  `total_amount_received` double NOT NULL DEFAULT 0,
  `if_merging_then_value_of_merging` double NOT NULL DEFAULT 0,
  `buy_back_option` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `roi_terms` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `sales_agents` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_mode` int(11) NOT NULL,
  `merging_sold` enum('yes','no') COLLATE utf8_unicode_ci NOT NULL,
  `bank_name` int(11) DEFAULT NULL,
  `company_account` int(11) DEFAULT NULL,
  `drawn_date` date DEFAULT NULL,
  `cheque_number` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_approve` tinyint(1) NOT NULL DEFAULT 0,
  `buy_back_value_requested_by_client` double NOT NULL DEFAULT 0,
  `merging_receipts` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `rental_discount_paid_to_customer_for_unit` double NOT NULL DEFAULT 0,
  `loss_or_profit_on_merging` double NOT NULL DEFAULT 0,
  `total_rebate_payable` double NOT NULL DEFAULT 0,
  `rebate_paid` double NOT NULL DEFAULT 0,
  `merging_selling_expenses` double NOT NULL DEFAULT 0,
  `rebate_on_buy_back` double NOT NULL DEFAULT 0,
  `value_of_appreciation_in_pkr` double NOT NULL DEFAULT 0,
  `roi_as_per_customer` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `roi_as_per_company` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `total_amount` double NOT NULL DEFAULT 0,
  `payee_name` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `payee_cnic` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payee_address` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `term_and_conditions` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;




DROP TABLE IF EXISTS cancel_properties;

CREATE TABLE `cancel_properties` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_property_id` bigint(20) NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 0 COMMENT '0 pending , 1 approved',
  `fee` double DEFAULT NULL,
  `after_cancellation_status` enum('refund-pending','adjust-pending','pending','refunded','adjusted','decline') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `unit_refund_history_id` bigint(20) NOT NULL DEFAULT 0,
  `voucher_generated` tinyint(1) NOT NULL DEFAULT 0 COMMENT '0=> not generated, 1=> generated ',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS categories;

CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `categories_category_name_unique` (`category_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS chart_of_accounts;

CREATE TABLE `chart_of_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `number` text NOT NULL,
  `account_type_id` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `opening_balance` double DEFAULT NULL,
  `sub_account_id` int(11) DEFAULT NULL,
  `closing_balance` double(8,2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=830 DEFAULT CHARSET=utf8mb4;

INSERT INTO chart_of_accounts VALUES("3","    TANGIBLE FIXED ASSETS AT COST-OWNED","11-01","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("4","FIXED ASSETS-OFFICE","11-01-01","3","","0000-00-00 00:00:00","2021-11-13 03:02:19","0","3","0.00"),
("5","        LAND","11-01-01-0001","3","","0000-00-00 00:00:00","2022-10-07 15:44:50","0","4","452830.00"),
("6","        BUILDING","11-01-01-0002","3","","0000-00-00 00:00:00","2021-12-28 15:44:57","0","4","22500.00"),
("7","        PLANT & MACHINERY","11-01-01-0003","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","4","0.00"),
("8","        FURNITURE & FIXTURES","11-01-01-0004","3","","0000-00-00 00:00:00","2021-12-14 14:29:29","0","4","30000.00"),
("9","        OFFICE EQUIPMENTS","11-01-01-0005","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","4","0.00"),
("10","        ELECTRICAL EQUIPMENTS","11-01-01-0006","3","","0000-00-00 00:00:00","2021-12-14 14:26:38","0","4","1200.00"),
("11","        TOOLS & EQUIPMENTS","11-01-01-0007","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","4","0.00"),
("12","VEHICLES","11-01-01-0008","3","","0000-00-00 00:00:00","2022-02-01 15:50:33","0","4","-50000.00"),
("13","        GENERATORS","11-01-01-0009","3","","0000-00-00 00:00:00","2021-12-14 14:26:38","0","4","800.00"),
("14","      FIXED ASSETS- SITE","11-01-02","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","3","0.00"),
("15","        LAND","11-01-02-0001","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","14","0.00"),
("16","        BUILDING","11-01-02-0002","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","14","0.00"),
("17","        PLANT & MACHINERY","11-01-02-0003","3","","0000-00-00 00:00:00","2021-12-14 14:04:32","0","14","100000.00"),
("18","        FURNITURE & FIXTURES","11-01-02-0004","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","14","0.00"),
("19","        OFFICE EQUIPMENTS","11-01-02-0005","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","14","0.00"),
("20","        ELECTRICAL EQUIPMENTS","11-01-02-0006","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","14","0.00"),
("21","        TOOLS & EQUIPMENTS","11-01-02-0007","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","14","0.00"),
("22","        VEHICLES","11-01-02-0008","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","14","0.00"),
("23","        GENERATORS","11-01-02-0009","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","14","0.00"),
("24","        CONATINERS","11-01-02-0010","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","14","0.00"),
("25","    TANGIBLE FIXED ASSETS AT COST-LEASED","11-02","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("26","      FIXED ASSETS-OFFICE ","11-02-01","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","25","0.00"),
("27","        LAND","11-02-01-0001","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","26","0.00"),
("28","        BUILDING","11-02-01-0002","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","26","0.00"),
("29","        PLANT & MACHINERY","11-02-01-0003","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","26","0.00"),
("30","        FURNITURE & FIXTURES","11-02-01-0004","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","26","0.00"),
("31","        OFFICE EQUIPMENTS","11-02-01-0005","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","26","0.00"),
("32","        ELECTRICAL EQUIPMENTS","11-02-01-0006","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","26","0.00"),
("33","        TOOLS & EQUIPMENTS","11-02-01-0007","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","26","0.00"),
("34","        VEHICLES","11-02-01-0008","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","26","0.00"),
("35","        GENERATORS","11-02-01-0009","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","26","0.00"),
("36","      FIXED ASSETS- SITE","11-02-02","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","25","0.00"),
("37","        LAND","11-02-02-0001","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","36","0.00"),
("38","        BUILDING","11-02-02-0002","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","36","0.00"),
("39","        PLANT & MACHINERY","11-02-02-0003","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","36","0.00"),
("40","        FURNITURE & FIXTURES","11-02-02-0004","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","36","0.00"),
("41","        OFFICE EQUIPMENTS","11-02-02-0005","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","36","0.00"),
("42","        ELECTRICAL EQUIPMENTS","11-02-02-0006","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","36","0.00"),
("43","        TOOLS & EQUIPMENTS","11-02-02-0007","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","36","0.00"),
("44","        VEHICLES","11-02-02-0008","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","36","0.00"),
("45","        GENERATORS","11-02-02-0009","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","36","0.00"),
("46","        CONATINERS","11-02-02-0010","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","36","0.00"),
("47","    INVESTMENTS","11-05","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("48","      INVESTMENT IN PROPERTY","11-05-02","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","47","0.00"),
("49","        PROPERTY","11-05-02-0001","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","48","0.00"),
("50","    LONG TERM LOANS, DEPOSITS, PREPAYMENTS & OTHER REC","11-06","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("51","      LONG TERM SECURITY DEPOSITS","11-06-02","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","50","0.00"),
("52","        IESCO","11-06-02-0001","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","51","0.00"),
("53"," LONG TERM LOANS","11-06-02-0002","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","51","0.00"),
("54"," LONG TERM LOANS","11-06-02-0003","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","51","0.00"),
("55"," LONG TERM LOANS","11-06-02-0004","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","51","0.00"),
("56"," LONG TERM LOANS","11-06-02-0005","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","51","0.00"),
("57"," LONG TERM LOANS","11-06-02-0006","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","51","0.00"),
("58"," LONG TERM LOANS","11-06-02-0007","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","51","0.00"),
("59","      LEASE SECURITY DEPOSITS","11-06-03","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","50","0.00"),
("60","        MEEZAN BANK LTD-LEASE SECURITY DEPOSIT","11-06-03-0001","3","","0000-00-00 00:00:00","2021-12-24 20:53:43","0","59","-200.00"),
("61","  LEASE SECURITY DEPOSITS","11-06-03-0002","3","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","59","0.00"),
("63","    STORES & SPARES","12-01","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("64","      STORES","12-01-01","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","63","0.00"),
("65","        FGI-STORE","12-01-01-0001","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","64","0.00"),
("66","    RAW MATERIAL","12-02","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("67","      CONSTRUCTION MATERIAL","12-02-01","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","66","0.00"),
("68","        BRICKS","12-02-01-0001","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","67","0.00"),
("69","        CEMENT","12-02-01-0002","9","","0000-00-00 00:00:00","2021-12-13 20:46:06","0","67","0.00"),
("70","        CRUSH","12-02-01-0003","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","67","0.00"),
("71","        SAND","12-02-01-0004","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","67","0.00"),
("72","        STEEL","12-02-01-0005","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","67","0.00"),
("73","    PLUMBING MATERIALS","12-03","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("74","      PLUMBING MATERIALS","12-03-01","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","73","0.00"),
("75","    ELECTRIC MATERIALS","12-04","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("76","      ELECTRIC MATERIALS","12-04-01","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","75","0.00"),
("77","    FINISHING MATERIALS","12-05","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("78","      FINISHING MATERIAL","12-05-01","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","77","0.00"),
("79","TILES","12-03-01-0001","9","","0000-00-00 00:00:00","2021-12-15 15:33:46","0","74","0.00"),
("80","        TILES","12-03-01-0002","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","78","0.00"),
("81","        TILES","12-03-01-0003","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","78","0.00"),
("82","        TILES","12-03-01-0004","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","78","0.00"),
("83","        TILES","12-03-01-0005","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","78","0.00"),
("84","        TILES","12-03-01-0006","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","78","0.00"),
("85","        TILES","12-03-01-0007","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","78","0.00"),
("86","        TILES","12-03-01-0008","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","78","0.00"),
("87","        TILES","12-03-01-0009","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","78","0.00"),
("88","        TILES","12-03-01-0010","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","78","0.00"),
("89","    TRADE DEBTS / RCEIVABLES","12-06","8","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("90","      RECEIVABLE FROM / PAYABLE TO ASSOCIATED CONCERNS","12-06-01","8","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","89","0.00"),
("91","  RECEIVABLE FROM ","12-06-01-0001","8","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","90","0.00"),
("92","  RECEIVABLE FROM ","12-06-01-0003","8","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","90","0.00"),
("93","  RECEIVABLE FROM ","12-06-01-0004","8","","0000-00-00 00:00:00","2021-12-13 20:19:57","0","90","0.00"),
("94","      SUNDRY DEBTORS","12-06-02","8","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","89","0.00"),
("95","SUNDRY DEBTORS","12-06-02-0001","8","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","94","0.00"),
("96","    ADVANCES","12-07","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("97","      ADVANCE TO EMPLOYEES AGAINST SALARY","12-07-01","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("98","          Faheem Ullah Ag. Salary","12-07-01-0001","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","97","0.00"),
("99","          Umair Yousaf Ag. Salary","12-07-01-0002","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","97","0.00"),
("100","          Zulfiqar Ag. Salary","12-07-01-0003","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","97","0.00"),
("101","          Raees Khan Ag. Salary","12-07-01-0004","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","97","0.00"),
("102","          Muhammad Irfan Ag. Salary","12-07-01-0005","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","97","0.00"),
("103","          Ikhlaq Hussain Ag. Salary","12-07-01-0006","9","","0000-00-00 00:00:00","2021-12-13 19:31:45","0","97","0.00"),
("104","          Ikram Zaib Khan Ag. Salary","12-07-01-0007","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","97","0.00"),
("105","          M yousaf Ag. Salary","12-07-01-0009","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","97","0.00"),
("106","          Irfan Masih Ag. Salary","12-07-01-0010","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","97","0.00"),
("107","          Zill-e-Hussnain Sheikh Ag. Salary","12-07-01-0011","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","97","0.00"),
("108","          Ali Ahmed Manzoor Ag. Salary","12-07-01-0012","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","97","0.00"),
("109","          Osama Bin Nadir Ag. Salary","12-07-01-0013","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","97","0.00"),
("110","      ADVANCE TO EMPLOYEES AG. EXPENSES","12-07-02","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","96","0.00"),
("111","          Faheem Ullah Ag. Expenses","12-07-02-0001","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","110","0.00"),
("112","          Umair Yousaf Ag. Expenses","12-07-02-0002","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","110","0.00"),
("113","          Zulfiqar Ag. Expenses","12-07-02-0003","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","110","0.00"),
("114","          Raees Khan Ag. Expenses","12-07-02-0004","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","110","0.00"),
("115","          Muhammad Irfan Ag. Expenses","12-07-02-0005","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","110","0.00"),
("116","          Ikhlaq Hussain Ag. Expenses","12-07-02-0006","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","110","0.00"),
("117","          Ikram Zaib Khan Ag. Expenses","12-07-02-0007","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","110","0.00"),
("118","          M yousaf Ag. Expenses","12-07-02-0008","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","110","0.00"),
("119","          Irfan Masih Ag. Expenses","12-07-02-0009","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","110","0.00"),
("120","          Zill-e-Hussnain Sheikh Ag. Expenses","12-07-02-0010","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","110","0.00"),
("121","          Ali Ahmed Manzoor Ag. Expenses","12-07-02-0011","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","110","0.00"),
("122","          Osama Bin Nadir Ag. Expenses","12-07-02-0012","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","110","0.00"),
("123","      MOBILIZATION ADVANCE TO CONTRACTORS - CW","12-07-03","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","96","0.00"),
("124","MOBILIZATION ADVANCE TO CONTRACTORS","12-07-03-0001","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","123","0.00"),
("125","MOBILIZATION ADVANCE TO CONTRACTORS","12-07-03-0002","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","123","0.00"),
("126","MOBILIZATION ADVANCE TO CONTRACTORS","12-07-03-0003","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","123","0.00"),
("127","      ADVANCE TO OTHER / SUB CONTRACTORS","12-07-07","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","96","0.00"),
("128","   ADVANCE TO OTHER ","12-07-07-0001","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","127","0.00"),
("129","   ADVANCE TO OTHER ","12-07-07-0002","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","127","0.00"),
("130","   ADVANCE TO OTHER ","12-07-07-0003","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","127","0.00"),
("131","   ADVANCE TO OTHER ","12-07-07-0004","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","127","0.00"),
("132","   ADVANCE TO OTHER ","12-07-07-0005","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","127","0.00"),
("133","   ADVANCE TO OTHER ","12-07-07-0006","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","127","0.00"),
("134","   ADVANCE TO OTHER ","12-07-07-0008","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","127","0.00"),
("135","   ADVANCE TO OTHER ","12-07-07-0009","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","127","0.00"),
("136","      ADVANCES TO SUPPLIERS","12-07-08","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","96","0.00"),
("137","        HAYAT NEON SIGN","12-07-08-0001","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","136","0.00"),
("138","      ADVANCE INCOME TAX","12-07-11","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","96","0.00"),
("139","        ADVANCE INCOME TAX - QUARTERLY","12-07-11-0001","9","","0000-00-00 00:00:00","2022-10-07 15:44:50","0","138","-2000.00"),
("140","        ADVANCE TAX ON PHONE BILLS","12-07-11-0003","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","138","0.00"),
("141","        ADVANCE TAX ON MOBILE PHONE BILLS","12-07-11-0004","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","138","0.00"),
("142","        ADVANCE TAX ON ELECTRICITY BILL","12-07-11-0005","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","138","0.00"),
("143","        ADVANCE TAX ON BANK PROFIT","12-07-11-0006","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","138","0.00"),
("144","        TAX CHALLAN RECEIVABLE","12-07-11-0007","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","138","0.00"),
("145","        ADVANCE TAX ON CASH WITHDRAWAL","12-07-11-0008","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","138","0.00"),
("146","        ADVANCE TAX ON VEHICLES","12-07-11-0010","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","138","0.00"),
("147","        ADVANCE TAX ON INTEREST TO ASSOCIATED COMPANIES","12-07-11-0012","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","138","0.00"),
("148","        ADVANCE TAX ON LOCAL AIR TRAVEL","12-07-11-0013","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","138","0.00"),
("149","        ADVANCE TAX ON SERVICES","12-07-11-0014","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","138","0.00"),
("150","        SURCHARGE ON WITH HOLDING TAX","12-07-11-0020","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","138","0.00"),
("151","        ADVANCE TAX ON FUNCTIONS/GATHERINGS","12-07-11-0021","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","138","0.00"),
("152","        ADVANCE TAX ON LAND","12-07-11-0022","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","138","0.00"),
("153","      OTHER ADVANCES","12-07-12","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","96","0.00"),
("154","OTHER ADVANCES","12-07-12-0001","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","153","0.00"),
("155","      ADVANCES FOR LAND","12-07-13","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","96","0.00"),
("156","   ADVANCES FOR LAND","12-07-13-0001","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","155","0.00"),
("157","   ADVANCES FOR LAND","12-07-13-0002","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","155","0.00"),
("158","   ADVANCES FOR LAND","12-07-13-0003","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","155","0.00"),
("159","    DEPOSITS","12-08","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("160","      DEPOSITS","12-08-01","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","159","0.00"),
("161","   DEPOSITS","12-08-01-0001","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","160","0.00"),
("162","   DEPOSITS","12-08-01-0002","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","160","0.00"),
("163","   DEPOSITS","12-08-01-0003","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","160","0.00"),
("164","   DEPOSITS","12-08-01-0004","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","160","0.00"),
("165","   DEPOSITS","12-08-01-0005","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","160","0.00"),
("166","   DEPOSITS","12-08-01-0006","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","160","0.00"),
("167","   DEPOSITS","12-08-01-0007","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","160","0.00"),
("168","   DEPOSITS","12-08-01-0008","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","160","0.00"),
("169","   DEPOSITS","12-08-01-0009","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","160","0.00"),
("170","   DEPOSITS","12-08-01-0010","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","160","0.00"),
("171","   DEPOSITS","12-08-01-0011","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","160","0.00"),
("172","   DEPOSITS","12-08-01-0012","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","160","0.00"),
("173","    PREPAYMENTS","12-09","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("174","      PREPAID RENT","12-09-01","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","173","0.00"),
("175","   PREPAID RENT","12-09-01-0001","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","174","0.00"),
("176","   PREPAID RENT","12-09-01-0002","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","174","0.00"),
("177","   PREPAID RENT","12-09-01-0003","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","174","0.00"),
("178","   PREPAID RENT","12-09-01-0004","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","174","0.00"),
("179","   PREPAID RENT","12-09-01-0005","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","174","0.00"),
("180","   PREPAID RENT","12-09-01-0006","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","174","0.00"),
("181","   PREPAID RENT","12-09-01-0007","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","174","0.00"),
("182","   PREPAID RENT","12-09-01-0008","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","174","0.00"),
("183","   PREPAID RENT","12-09-01-0009","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","174","0.00"),
("184","   PREPAID RENT","12-09-01-0010","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","174","0.00"),
("185","      PREPAID INSURANCE","12-09-02","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","173","0.00"),
("186","      PREPAID INSURANCE","12-09-02-0001","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","185","0.00"),
("187","        BUILDING","12-09-02-0002","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","185","0.00"),
("188","        PLANT & MACHINERY","12-09-02-0003","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","185","0.00"),
("189","        FURNITURE & FIXTURES","12-09-02-0004","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","185","0.00"),
("190","        OFFICE EQUIPMENTS","12-09-02-0005","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","185","0.00"),
("191","        ELECTRICAL EQUIPMENTS","12-09-02-0006","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","185","0.00"),
("192","        TOOLS & EQUIPMENTS","12-09-02-0007","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","185","0.00"),
("193","        VEHICLES","12-09-02-0008","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","185","0.00"),
("194","        GENERATORS","12-09-02-0009","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","185","0.00"),
("195","        CONATINERS","12-09-02-0010","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","185","0.00"),
("196","      PREPAID FEES, REGISTRATION & SUBSCRIPTION","12-09-03","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","173","0.00"),
("197"," PREPAID FEES, REGISTRATION & SUBSCRIPTION","12-09-03-0001","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","196","0.00"),
("198","      OTHER PREPAYMENTS","12-09-04","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","173","0.00"),
("199","        INTERNET","12-09-04-0001","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","198","0.00"),
("200","    OTHER RECEIVABLES","12-10","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("201","      OTHER RECEIVABLES","12-10-01","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","200","0.00"),
("202","        INTEREST RECEIVABLE","12-10-01-0001","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","201","0.00"),
("203","        INTEREST RECEIVABLE","12-10-01-0002","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","201","0.00"),
("204","        INTEREST RECEIVABLE","12-10-01-0003","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","201","0.00"),
("205","        INTEREST RECEIVABLE","12-10-01-0004","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","201","0.00"),
("206","      RECEIVABLES FROM CONTRACTORS AG. MATERIALS","12-10-02","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","200","0.00"),
("207","RECEIVABLES FROM CONTRACTORS","12-10-02-0002","9","","0000-00-00 00:00:00","2021-12-14 14:22:39","0","206","600.00"),
("208","RECEIVABLES FROM CONTRACTORS","12-10-02-0003","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","206","0.00"),
("209","RECEIVABLES FROM CONTRACTORS","12-10-02-0004","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","206","0.00"),
("210","RECEIVABLES FROM CONTRACTORS","12-10-02-0008","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","206","0.00"),
("211","RECEIVABLES FROM CONTRACTORS","12-10-02-0010","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","206","0.00"),
("212","RECEIVABLES FROM CONTRACTORS","12-10-02-0011","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","206","0.00"),
("213","RECEIVABLES FROM CONTRACTORS","12-10-02-0012","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","206","0.00"),
("214","RECEIVABLES FROM CONTRACTORS","12-10-02-0013","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","206","0.00"),
("215","RECEIVABLES FROM CONTRACTORS","12-10-02-0014","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","206","0.00"),
("216","RECEIVABLES FROM CONTRACTORS","12-10-02-0015","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","206","0.00"),
("217","    LETTERS OF CREDIT","12-11","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("218","      LETTERS OF CREDIT","12-11-01","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","217","0.00"),
("219","        LC BANK CHARGES","12-11-01-0001","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","218","0.00"),
("220","        LC INSURANCE","12-11-01-0002","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","218","0.00"),
("221","        LC COST OF PRODUCT (INVOICE VALUE)","12-11-01-0003","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","218","0.00"),
("222","        LC CUSTOM DUTY","12-11-01-0004","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","218","0.00"),
("223","        LC CLEARING EXPENSES","12-11-01-0005","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","218","0.00"),
("224","        LC OTHER EXPENSES","12-11-01-0007","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","218","0.00"),
("225","    CASH & BANK BALANCES","12-15","4","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("226","      CASH BALANCES","12-15-01","4","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","225","0.00"),
("227","        CASH IN HAND - ACCOUNTS DEPT","12-15-01-0001","4","","0000-00-00 00:00:00","2021-12-30 20:03:43","0","226","7950.00"),
("228","        CASH IN HAND - IKRAM ZAIB KHAN","12-15-01-0002","4","","0000-00-00 00:00:00","2021-12-30 16:37:03","0","226","-19500.00"),
("229","        CASH IN HAND - CONTINGENCY S.E.","12-15-01-0003","4","","0000-00-00 00:00:00","2021-12-25 16:39:52","0","226","10000.00"),
("230","        CHEQUES IN HAND","12-15-01-0011","4","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","226","0.00"),
("231","      BANK BALANCES","12-15-02","4","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","225","0.00"),
("232","        MEEZAN BANK LTD. SAVING A/C 0302-0104750095","12-15-02-0001","4","","0000-00-00 00:00:00","2022-03-30 11:48:32","0","231","994499.99"),
("233","        HABIB METROPOLITAN BANK LTD. CD A/C 20301-714-144661","12-15-02-0002","4","","0000-00-00 00:00:00","2021-12-25 17:09:19","0","231","-50000.00"),
("234","      TERM DEPOSIT RECEIPTS","12-15-03","4","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","225","0.00"),
("235","        TDR -","12-15-03-0001","4","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","234","0.00"),
("236","        TDR -","12-15-03-0002","4","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","234","0.00"),
("237","    SHORT TERM LOANS","12-16","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("238","      SHORT TERM LOANS","12-16-01","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","237","0.00"),
("239","  SHORT TERM LOANS","12-16-01-0001","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","238","0.00"),
("240","  SHORT TERM LOANS","12-16-01-0002","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","238","0.00"),
("241","  CAPITAL WORK IN PROGRESS","13","9","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("244","    LONG TERM FINANCES","21-01","13","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("245","LONG TERM FINANCES","21-01-01","13","","0000-00-00 00:00:00","2021-12-15 14:09:55","0","244","0.00"),
("246","MUSHARAKAH FINANCE - MEEZAN BANK","21-01-01-0001","13","","0000-00-00 00:00:00","2021-12-15 14:39:55","0","245","-276000.00"),
("247","LONG TERM FINANCE","21-01-01-0002","13","","0000-00-00 00:00:00","2021-12-15 15:16:03","0","245","343700.00"),
("248","LONG TERM FINANCE","21-01-01-0003","13","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","245","0.00"),
("249","LONG TERM FINANCE","21-01-01-0004","13","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","245","0.00"),
("250","      OBLIGATIONS UNDER FINANCE LEASE","21-01-02","13","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","244","0.00"),
("251","        MEEZAN BANK LTD-FINANCE LEASE","21-01-02-0001","13","","0000-00-00 00:00:00","2021-12-14 14:03:36","0","250","-150000.00"),
("252","OBLIGATIONS UNDER FINANCE LEASE","21-01-02-0002","13","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","250","0.00"),
("253","    OTHER LONG TERM LIABILITIES","21-02","13","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("254","      EMPLOYEES BENEFITS","21-02-01","13","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","253","0.00"),
("255","        PROVISION FOR GRATUITY","21-02-01-0001","13","","0000-00-00 00:00:00","2021-12-14 14:02:50","0","254","224450.00"),
("256","      DEFERRED TAXATION","21-02-02","13","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","253","0.00"),
("257","        DEFERRED TAXATION","21-02-02-0001","13","","0000-00-00 00:00:00","2021-12-15 14:56:33","0","256","-3000.00"),
("258","      LONG TERM SECURITY DEPOSITS","21-02-06","13","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","253","0.00"),
("259","        AZ CONTRACTOR","21-02-06-0002","13","","0000-00-00 00:00:00","2021-12-14 14:03:36","0","258","-250000.00"),
("261","    SHORT TERM FINANCES","22-01","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("262","      SHORT TERM FINANCES","22-01-01","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","261","0.00"),
("263","        MUSHARAKAH FINANCE - MEEZAN BANK","22-01-01-0001","12","","0000-00-00 00:00:00","2021-12-14 14:03:36","0","262","-450000.00"),
("264","SHORT TERM FINANCES","22-01-01-0002","12","","0000-00-00 00:00:00","2021-12-14 14:02:50","0","262","126700.00"),
("265","SHORT TERM FINANCES","22-01-01-0003","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","262","0.00"),
("266","CREDITORS, ACCRUED & OTHER OBLIGATIES","22-02","11","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("267","      PAYABLE TO CONTRACTORS","22-02-01","11","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","266","0.00"),
("268","        AZ CONTRACTOR","22-02-01-0001","11","","0000-00-00 00:00:00","2021-12-14 14:29:29","0","267","-105800.00"),
("269","      PAYABLE TO CONTRACTORS","22-02-01-0002","11","","0000-00-00 00:00:00","2021-12-14 14:29:02","0","267","-95000.00"),
("270","      PAYABLE TO CONTRACTORS","22-02-01-0003","11","","0000-00-00 00:00:00","2021-12-14 14:23:30","0","267","5000.00"),
("271","      RETENTION MONEY PAYABLE","22-02-02","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","266","0.00"),
("272","      RETENTION MONEY PAYABLE","22-02-02-0001","12","","0000-00-00 00:00:00","2021-12-14 14:03:36","0","271","-125450.00"),
("273","      RETENTION MONEY PAYABLE","22-02-02-0002","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","271","0.00"),
("274","      RETENTION MONEY PAYABLE","22-02-02-0003","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","271","0.00"),
("275","      PROJECT CREDITORS","22-02-03","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","266","0.00"),
("276","        ITTEHAD STEEL INDUSTRIES","22-02-03-0001","12","","0000-00-00 00:00:00","2021-12-14 14:03:36","0","275","-50000.00"),
("277","PROJECT CREDITORS","22-02-03-0002","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","275","0.00"),
("278","PROJECT CREDITORS","22-02-03-0003","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","275","0.00"),
("279","      OTHER CREDITORS","22-02-04","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","266","0.00"),
("280","        TCS (PVT.) LTD.","22-02-04-0001","12","","0000-00-00 00:00:00","2021-12-14 14:03:36","0","279","-45500.00"),
("281","OTHER CREDITORS","22-02-04-0002","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","279","0.00"),
("282","OTHER CREDITORS","22-02-04-0011","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","279","0.00"),
("283","      THE GARDEN APARTMENT DEPOSITS A/C","22-02-05","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","266","0.00"),
("284","        APARTMENT DEPOSITS A/C","22-02-05-0001","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","283","0.00"),
("285","        APARTMENT DEPOSITS REFUND A/C","22-02-05-0002","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","283","0.00"),
("286","        APARTMENT DEPOSITS SUSPENSE A/C","22-02-05-0003","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","283","0.00"),
("287","      PERFORMANCE SECURITY","22-02-06","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","266","0.00"),
("288","        AB CONTRACTOR-PERFORMANCE SECURITY","22-02-06-0001","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","287","0.00"),
("289","        AZ CONTRACTOR-PERFORMANCE SECURITY","22-02-06-0002","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","287","0.00"),
("290","      PERFORMANCE SECURITY","22-02-06-0003","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","287","0.00"),
("291","      OTHER DEPOSITS","22-02-07","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","266","0.00"),
("292","   OTHER DEPOSITS","22-02-07-0005","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","291","0.00"),
("293","      ACCRUED EXPENSES","22-02-08","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","266","0.00"),
("294","        ACCRUED EXPENSES - PROJECT","22-02-08-0001","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","293","0.00"),
("295","        ACCRUED EXPENSES - ADMIN","22-02-08-0002","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","293","0.00"),
("296","        ACCRUED EXPENSES - MARKETING","22-02-08-0003","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","293","0.00"),
("297","      WITHOLDING TAX PAYABLE-SUPPLIER","22-02-09","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","266","0.00"),
("298","        WITHOLDING TAX ON SUPPLIES","22-02-09-0001","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","297","0.00"),
("299","        WITHOLDING TAX ON SERVICES","22-02-09-0002","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","297","0.00"),
("300","        WITHOLDING TAX ON CONTRACTS","22-02-09-0003","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","297","0.00"),
("301","        SURCHARGE ON WITH HOLDING TAX","22-02-09-0004","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","297","0.00"),
("302","        WITHOLDING TAX ON RENT","22-02-09-0005","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","297","0.00"),
("303","      WITHOLDING TAX PAYABLE-EMPLOYEES","22-02-10","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","266","0.00"),
("304","        WITHOLDING TAX PAYABLE-SALARY","22-02-10-0001","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","303","0.00"),
("305","        SURCHARGE ON WITH HOLDING TAX - SALARY","22-02-10-0002","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","303","0.00"),
("306","      SALES TAX PAYABLE","22-02-11","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","266","0.00"),
("307","        WITHOLDING SALES TAX ON PURCHASES","22-02-11-0001","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","306","0.00"),
("308","        PRA SALES TAX- LAND DEVELOPMENT","22-02-11-0002","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","306","0.00"),
("309","        PRA SALES TAX-BUILDING CONSTRUCTION","22-02-11-0003","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","306","0.00"),
("310","        PRA SALES TAX-CONTRACTOR","22-02-11-0004","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","306","0.00"),
("311","        PRA SALES TAX-SERVICES","22-02-11-0005","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","306","0.00"),
("312","        WITHOLDING SALES TAX ON SERVICES","22-02-11-0006","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","306","0.00"),
("313","        PRA SALES TAX-CONSULTANCY INC","22-02-11-0007","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","306","0.00"),
("314","        SRB SALES TAX-SERVICES","22-02-11-0008","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","306","0.00"),
("315","      MARKUP PAYABLE-BANK LOANS","22-02-12","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","266","0.00"),
("316","        MARK UP PAYABLE - MEEZAN BANK","22-02-12-0001","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","315","0.00"),
("317","MARKUP PAYABLE-BANK LOANS","22-02-12-0002","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","315","0.00"),
("318","      OTHER PAYABLES","22-02-14","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","266","0.00"),
("319","        EOBI PAYABLE","22-02-14-0001","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","318","0.00"),
("320","        SALARIES PAYABLE","22-02-14-0002","12","","0000-00-00 00:00:00","2021-12-13 19:46:55","0","318","0.00"),
("321","      PROVISION FOR TAXATION","22-02-15","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","266","0.00"),
("322","        PROVISION FOR TAXATION","22-02-15-0001","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","321","0.00"),
("323","      OTHER LIABILITIES","22-02-16","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","266","0.00"),
("324","        ADVANCE AGAINST EQUITY-OPENING BALANCE","22-02-16-0001","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","323","0.00"),
("325","      ADVANCES FROM CUSTOMERS - MAINTENANCE","22-02-18","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","266","0.00"),
("326","        ADVANCES FROM CUSTOMERS-MAINTENANCE INCOME","22-02-18-0002","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","325","0.00"),
("327","      EMPLOYEES BENEVOLENT FUND","22-02-19","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","266","0.00"),
("328","        EMPLOYEES B.F. CONTRIBUTION","22-02-19-0001","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","327","0.00"),
("329","        EMPLOYERS B.F. CONTRIBUTION","22-02-19-0002","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","327","0.00"),
("330","    UNEARNED REVENUE","22-03","12","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("331","UNEARNED REVENUE - THE GARDEN","22-03-01","12","","0000-00-00 00:00:00","2021-12-15 14:15:01","0","330","0.00"),
("332","       APARTMENTS - UNEARNED REVENUE","22-03-01-0001","12","","0000-00-00 00:00:00","2021-12-14 14:03:36","0","331","-3250.00"),
("335","    PARTNERS\' CAPITAL","31-01","7","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("336","CAPITAL INJECTION","31-01-01","7","","0000-00-00 00:00:00","2021-12-15 14:38:33","0","335","0.00"),
("337","        AHMAD NAEEM QAMAR CHAUDHRY","31-01-01-0001","7","","0000-00-00 00:00:00","2021-12-13 19:55:47","0","336","0.00"),
("338","        AHMAD NAVEED QAMAR","31-01-01-0002","7","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","336","0.00"),
("339","        KHALIL AHMED NOON","31-01-01-0003","7","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","336","0.00"),
("340","        CH. RASHID ALI NOON","31-01-01-0004","7","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","336","0.00"),
("341","        CH. LIAQAT ALI NOON","31-01-01-0005","7","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","336","0.00"),
("342","        MUHAMMAD AHMAD","31-01-01-0006","7","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","336","0.00"),
("343","        JAMAL JAN","31-01-01-0007","7","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","336","0.00"),
("344","        ADEEL ELLAHI","31-01-01-0008","7","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","336","0.00"),
("345","        MUHAMMAD HAROON MAHMOOD","31-01-01-0009","7","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","336","0.00"),
("348","PROJECT SALES REVENUE","41-01","1","","0000-00-00 00:00:00","2021-12-14 20:18:22","0","0","0.00"),
("349","PEARL CITY MULTAN","41-01-01","1","","0000-00-00 00:00:00","2021-12-14 20:18:24","0","348","0.00"),
("350","SALE OF APARTMENTS","41-01-01-0001","1","","0000-00-00 00:00:00","2021-12-14 20:18:49","0","349","-998999.99"),
("353","OTHER INCOME","42-01","1","","0000-00-00 00:00:00","2021-12-14 19:45:30","0","0","0.00"),
("354","RETURN ON BANK DEPOSITS","42-01-01-0001","1","","0000-00-00 00:00:00","2021-12-14 19:47:19","0","824","0.00"),
("355","TRANSFER FEE","42-01-01-0002","1","","0000-00-00 00:00:00","2021-12-14 19:48:02","0","824","0.00"),
("356","LATE PAYMENT SURCHARGE","42-01-01-0003","1","","0000-00-00 00:00:00","2021-12-14 19:49:23","0","824","0.00"),
("357","PROCESSING FEE","42-01-01-0005","1","","0000-00-00 00:00:00","2021-12-14 19:49:54","0","824","-25500.00"),
("358","MAINTENANCE INCOME","42-01-01-0006","1","","0000-00-00 00:00:00","2021-12-14 19:50:35","0","824","-300.00"),
("359","REGISTRY FEE","42-01-01-0007","1","","0000-00-00 00:00:00","2021-12-14 19:51:15","0","824","0.00"),
("360","SCRAP SALES","42-01-01-0008","1","","0000-00-00 00:00:00","2021-12-14 19:51:46","0","824","-450.00"),
("361","EXCHANGE GAIN / LOSS","42-01-01-0009","1","","0000-00-00 00:00:00","2021-12-14 19:52:30","0","824","0.00"),
("362","PROFIT / (LOSS) ON SALE OF FIXED ASSETS","42-01-01-0010","1","","0000-00-00 00:00:00","2021-12-14 19:53:20","0","824","0.00"),
("363","MARK-UP","42-01-01-0011","1","","0000-00-00 00:00:00","2021-12-14 19:54:55","0","824","0.00"),
("364","RENTAL INCOME","42-01-01-0012","1","","0000-00-00 00:00:00","2021-12-14 19:55:25","0","824","-600.00"),
("365","MISCELLANEOUS INCOME","42-01-01-0013","1","","0000-00-00 00:00:00","2021-12-14 19:55:58","0","824","0.00"),
("366","      TENDER FEES","42-01-02","1","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","351","0.00"),
("367","TENDER FEES","42-01-02-0001","1","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","366","0.00"),
("368","TENDER FEES","42-01-02-0002","1","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","366","0.00"),
("369","      CONSULTANCY FEE","42-01-03","1","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","351","0.00"),
("370","CONSULTANCY FEE","42-01-03-0001","1","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","369","0.00"),
("371","CONSULTANCY FEE","42-01-03-0002","1","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","369","0.00"),
("372","      MARKUP INCOME FROM ASSOCIATED CONCERNS","42-01-04","1","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","351","0.00"),
("373","   MARKUP INCOME FROM ASSOCIATED CONCERNS","42-01-04-0001","1","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","372","0.00"),
("374","   MARKUP INCOME FROM ASSOCIATED CONCERNS","42-01-04-0002","1","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","372","0.00"),
("375","   MARKUP INCOME FROM ASSOCIATED CONCERNS","42-01-04-0003","1","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","372","0.00"),
("376","      BACK CHARGE INCOME","42-01-05","1","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","351","0.00"),
("377"," BACK CHARGE INCOME","42-01-05-0001","1","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","376","0.00"),
("378"," BACK CHARGE INCOME","42-01-05-0002","1","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","376","0.00"),
("381","    DIRECT COST","52-01","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("382","      CONSULTANTS & DEPARTMENTAL FEE","52-01-01","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","381","0.00"),
("383","       ARCHITECTURAL DESIGN FEE","52-01-01-0001","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","382","0.00"),
("384","       DRAWING APPROVAL FEE","52-01-01-0002","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","382","0.00"),
("385","       D.W.C","52-01-01-0003","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","382","0.00"),
("386","       M.F (Partial)","52-01-01-0004","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","382","0.00"),
("387","       STRUCTURE ENGINEER CONSULTANCY","52-01-01-0005","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","382","0.00"),
("388","       STRUCTURE VETTING CONSULTANCY","52-01-01-0006","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","382","0.00"),
("389","       HVAC CONSULTANCY","52-01-01-0007","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","382","0.00"),
("390","       PLUMBING & PUBLIC HEALTH CONSULTANCY","52-01-01-0008","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","382","0.00"),
("391","       ELECTRICAL CONSULTANCY ","52-01-01-0009","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","382","0.00"),
("392","       FIRE FIGHTING CONSULTANCY ","52-01-01-0010","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","382","0.00"),
("393","Civil Work","52-01-02","15","","0000-00-00 00:00:00","2021-12-14 20:21:42","0","381","0.00"),
("394","        LAND COST","52-01-02-0001","15","","0000-00-00 00:00:00","2021-12-14 16:16:27","0","393","10000.00"),
("395","        BOUNDARY WALL / FENCING","52-01-02-0002","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","393","0.00"),
("396","        BASIC SITE DEVELOPMENT","52-01-02-0003","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","393","0.00"),
("397","        TEMPORARY SITE OFFICE","52-01-02-0004","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","393","0.00"),
("398","        ELECTRIFICATION","52-01-02-0005","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","393","0.00"),
("399","        LABOR WAGES-CIVIL WORKS","52-01-02-0006","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","393","0.00"),
("400","        CONSTRUCTION MATERIAL","52-01-02-0007","15","","0000-00-00 00:00:00","2021-12-14 16:16:27","0","393","10000.00"),
("401","        BLOCKS & BRICKS","52-01-02-0008","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","393","0.00"),
("402","        CEMENT","52-01-02-0009","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","393","0.00"),
("403","        CRUSH","52-01-02-0010","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","393","0.00"),
("404","        SAND","52-01-02-0011","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","393","0.00"),
("405","        STEEL & BINDING WIRE","52-01-02-0012","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","393","0.00"),
("406","        CONST CHEMICALS & ALLIED MATERIALS","52-01-02-0013","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","393","0.00"),
("407","        READY MIX CONCRETE","52-01-02-0016","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","393","0.00"),
("408","        FORM WORK & HARDWARE","52-01-02-0017","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","393","0.00"),
("409","        PAVERS","52-01-02-0018","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","393","0.00"),
("410","        RENT-MACHINERY","52-01-02-0019","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","393","0.00"),
("411","        LANDSCAPING","52-01-02-0020","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","393","0.00"),
("412","        FREIGHT & TRANSPORTATION","52-01-02-0021","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","393","0.00"),
("413","        SUI GAS NETWORK","52-01-02-0022","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","393","0.00"),
("414","        WATER DISTRIBUTION SYSTEM","52-01-02-0023","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","393","0.00"),
("415","        SEWERAGE SYSYTEM","52-01-02-0024","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","393","0.00"),
("416","        TELECOMMUNICATION NETWORK","52-01-02-0025","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","393","0.00"),
("417","        TOOLS & EQUIPMENTS","52-01-02-0026","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","393","0.00"),
("418","        ELEVATORS","52-01-02-0027","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","393","0.00"),
("419","      Civil Work - CONTRACTORS","52-01-03","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("420","      Civil Work - SUB CONTRACTORS","52-01-04","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("421","PLUMBING & SANITARY Work","52-01-05","15","","0000-00-00 00:00:00","2021-12-15 13:32:21","0","381","0.00"),
("422","        LABOR WAGES-PLUMBING","52-01-05-0006","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","421","0.00"),
("423","        PLUMBING MATERIALS","52-01-05-0007","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","421","0.00"),
("424","        SANITARY WARE","52-01-05-0008","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","421","0.00"),
("425","        SANITARY FITTINGS","52-01-05-0009","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","421","0.00"),
("426","ELECTRICAL WORK","52-01-06","15","","0000-00-00 00:00:00","2021-12-15 13:37:19","0","381","0.00"),
("427","        LABOR WAGES-ELECTRICAL","52-01-06-0006","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","426","0.00"),
("428","        ELECTRICAL MATERIALS","52-01-06-0007","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","426","0.00"),
("429","TILE WORK","52-01-07","15","","0000-00-00 00:00:00","2021-12-15 13:38:17","0","381","0.00"),
("430","        LABOR WAGES-TILE WORK","52-01-07-0006","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","429","0.00"),
("431","        TILES","52-01-07-0007","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","429","0.00"),
("432","MARBLE WORK","52-01-08","15","","0000-00-00 00:00:00","2021-12-15 13:39:40","0","381","0.00"),
("433","        LABOR WAGES-MARBLE WORK","52-01-08-0006","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","432","0.00"),
("434","        MARBLE","52-01-08-0007","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","432","0.00"),
("435","WOOD WORK","52-01-09","15","","0000-00-00 00:00:00","2021-12-15 13:45:44","0","381","0.00"),
("436","        LABOR WAGES-WOOD WORK","52-01-09-0006","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","435","0.00"),
("437","        MARBLE","52-01-09-0007","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","435","0.00"),
("438","      ALUMINIUM WORK","52-01-10","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("439","LABOR WAGES-ALUMINIUM WORK","52-01-10-0006","15","","0000-00-00 00:00:00","2021-12-15 13:43:20","0","381","0.00"),
("440","        ALUMINIUM","52-01-10-0007","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","439","0.00"),
("441","GLASS WORK","52-01-11","15","","0000-00-00 00:00:00","2021-12-15 13:41:22","0","381","0.00"),
("442","        LABOR WAGES-GLASS WORK","52-01-11-0006","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","441","0.00"),
("443","        GLASS","52-01-11-0007","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","441","0.00"),
("444","PAINT WORK","52-01-12","15","","0000-00-00 00:00:00","2021-12-15 13:46:40","0","381","0.00"),
("445","        LABOR WAGES-PAINT WORK","52-01-12-0006","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","444","0.00"),
("446","        PAINTS","52-01-12-0007","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","444","0.00"),
("447","SECURITY SYSTEM","52-01-13","15","","0000-00-00 00:00:00","2021-12-15 13:46:59","0","381","0.00"),
("448","        LABOR WAGES-SECURITY SYSTEM","52-01-13-0006","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","447","0.00"),
("449","        SECURITY CAMERAS","52-01-13-0007","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","447","0.00"),
("450","HVAC SYSTEM","52-01-14","15","","0000-00-00 00:00:00","2021-12-15 13:47:35","0","381","0.00"),
("451","        LABOR WAGES-HVAC","52-01-14-0006","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","450","0.00"),
("452","        Heating & Cooling Network","52-01-14-0007","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","450","0.00"),
("453","MISCELLANEOUS FINISHES","52-01-15","15","","0000-00-00 00:00:00","2021-12-15 13:48:06","0","381","0.00"),
("454","        ROOF TREATMENT","52-01-15-0001","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","453","0.00"),
("455","        FALSE CEILING","52-01-15-0007","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","453","0.00"),
("456","Z A/C","52-01-20","15","","0000-00-00 00:00:00","2021-12-15 13:48:22","0","381","0.00"),
("457","        LABOR MEAL","52-01-20-0001","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","456","0.00"),
("458","        LABOR WELFARE","52-01-20-0002","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","456","0.00"),
("459","        LABOR MEDICAL","52-01-20-0003","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","456","0.00"),
("461","SALARIES, WAGES & BENEFITS","52-02-01","15","","0000-00-00 00:00:00","2021-12-14 20:23:51","0","381","0.00"),
("462","        SALARIES","52-02-01-0001","15","","0000-00-00 00:00:00","2021-12-14 14:23:30","0","461","10000.00"),
("463","        OVERTIME","52-02-01-0003","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","461","0.00"),
("464","        MEDICAL","52-02-01-0007","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","461","0.00"),
("465","        UNIFORMS","52-02-01-0008","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","461","0.00"),
("466","        EOBI","52-02-01-0009","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","461","0.00"),
("467","        EMPLOYEE TRAINING-LOCAL","52-02-01-0012","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","461","0.00"),
("468","        HONORARIUM/EX-GRATIA","52-02-01-0014","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","461","0.00"),
("469","        LEAVE ENCASHMENT","52-02-01-0015","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","461","0.00"),
("470","        GRATUITY","52-02-01-0016","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","461","0.00"),
("471","        UTILITY & MOBILE ALLOWANCES","52-02-01-0018","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","461","0.00"),
("472","        CONVEYANCE ALLOWANCE","52-02-01-0020","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","461","0.00"),
("473","        STAFF MEAL","52-02-01-0021","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","461","0.00"),
("474","        EXECUTIVE MEAL","52-02-01-0022","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","461","0.00"),
("475","        HOUSE RENT ALLOWANCE","52-02-01-0023","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","461","0.00"),
("476","TRAVELLING & CONVEYANCE","52-02-02","15","","0000-00-00 00:00:00","2021-12-15 13:50:17","0","381","0.00"),
("477","        TRAVELLING-LOCAL","52-02-02-0001","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","476","0.00"),
("478","        TRAVELLING-FOREIGN","52-02-02-0002","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","476","0.00"),
("479","        ACCOMODATION-LOCAL","52-02-02-0003","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","476","0.00"),
("480","        ACCOMODATION-FOREIGN","52-02-02-0004","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","476","0.00"),
("481","        DAILY ALLOWANCE-LOCAL","52-02-02-0005","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","476","0.00"),
("482","        DAILY ALLOWANCE-FOREIGN","52-02-02-0006","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","476","0.00"),
("483","        CONVEYANCE LOCAL","52-02-02-0007","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","476","0.00"),
("484","VEHICLE RUNNING EXPENSES","52-02-03","15","","0000-00-00 00:00:00","2021-12-15 13:50:35","0","381","0.00"),
("485","        VEHICLE FUEL","52-02-03-0001","15","","0000-00-00 00:00:00","2021-12-15 14:56:33","0","484","1000.00"),
("486","        VEHICLE REPAIR & MAINTENANCE","52-02-03-0002","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","484","0.00"),
("487","        VEHICLE OTHER EXPENSES (REG. & TOKEN, TRAKKER ETC)","52-02-03-0003","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","484","0.00"),
("488","UTILITIES","52-02-04","15","","0000-00-00 00:00:00","2021-12-15 13:52:07","0","381","0.00"),
("489","        TELEPHONE","52-02-04-0001","15","","0000-00-00 00:00:00","2021-12-15 14:56:33","0","488","1000.00"),
("490","        MOBILE","52-02-04-0002","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","488","0.00"),
("491","        ELECTRICITY","52-02-04-0004","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","488","0.00"),
("492","        WATER & SANITATION CHARGES","52-02-04-0005","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","488","0.00"),
("493","        SUI GAS","52-02-04-0006","15","","0000-00-00 00:00:00","2021-12-13 20:12:45","0","488","0.00"),
("494","        GENERATOR FUEL","52-02-04-0007","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","488","0.00"),
("495","        INTERNET CHARGES","52-02-04-0008","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","488","0.00"),
("496","        TELEPHONE-STAFF ACCOMODATION","52-02-04-0009","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","488","0.00"),
("497","        ELECTRICITY-STAFF ACCOMODATION","52-02-04-0012","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","488","0.00"),
("498","        WATER & SANITATION-STAFF ACCOMODATION","52-02-04-0013","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","488","0.00"),
("499","        SUI GAS-STAFF ACCOMODATION","52-02-04-0014","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","488","0.00"),
("500","REPAIR & MAINTENANCE","52-02-05","15","","0000-00-00 00:00:00","2021-12-15 13:53:05","0","381","0.00"),
("501","        BUILDING","52-02-05-0002","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","500","0.00"),
("502","        FURNITURE & FIXTURE","52-02-05-0004","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","500","0.00"),
("503","        OFFICE EQUIPMENT","52-02-05-0005","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","500","0.00"),
("504","        ELECTRICAL OFFICE EQUIPMENT","52-02-05-0006","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","500","0.00"),
("505","        TOOLS & EQUIPMENT","52-02-05-0007","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","500","0.00"),
("506","        GENERATORS","52-02-05-0009","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","500","0.00"),
("507","        PHOTOCOPIER","52-02-05-0012","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","500","0.00"),
("508","        HOUSE KEEPING","52-02-05-0013","15","","0000-00-00 00:00:00","2021-12-15 14:56:33","0","500","1000.00"),
("509","        HOUSE KEEPING-STAFF ACCOMODATION","52-02-05-0016","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","500","0.00"),
("510","INSURANCE","52-02-06","15","","0000-00-00 00:00:00","2021-12-15 13:56:16","0","381","0.00"),
("511","        BUILDING","52-02-06-0002","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","510","0.00"),
("512","        FURNITURE & FIXTURE","52-02-06-0004","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","510","0.00"),
("513","        OFFICE EQUIPMENT","52-02-06-0005","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","510","0.00"),
("514","        ELECTRICAL OFFICE EQUIPMENT","52-02-06-0006","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","510","0.00"),
("515","        TOOLS & EQUIPMENT","52-02-06-0007","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","510","0.00"),
("516","        VEHICLES","52-02-06-0008","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","510","0.00"),
("517","        GENERATORS","52-02-06-0009","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","510","0.00"),
("518","PRINTING & STATIONERY","52-02-07","15","","0000-00-00 00:00:00","2021-12-15 14:00:25","0","381","0.00"),
("519","        PRINTING & STATIONERY","52-02-07-0001","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","518","0.00"),
("520","        NEWSPAPERS, BOOKS & PERIODICALS","52-02-07-0002","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","518","0.00"),
("521","        PHOTOCOPY EXPENSES","52-02-07-0003","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","518","0.00"),
("522","POSTAGE & COURIER","52-02-08","15","","0000-00-00 00:00:00","2021-12-15 13:56:21","0","381","0.00"),
("523","        LOCAL POSTAGE & COURIER","52-02-08-0001","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","522","0.00"),
("524","        OVERSEAS POSTAGE & COURIER","52-02-08-0002","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","522","0.00"),
("525","RENT,FEES & TAXES","52-02-09","15","","0000-00-00 00:00:00","2021-12-15 14:01:16","0","381","0.00"),
("526","        RENT-PROJECT DEPARTMENT","52-02-09-0001","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","525","0.00"),
("527","        PROFESSIONAL TAX","52-02-09-0003","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","525","0.00"),
("528","        FEES , SUBCRIPTION & REGISTRATION","52-02-09-0006","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","525","0.00"),
("529","        RENT","52-02-09-0009","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","525","0.00"),
("530","        RENT-STAFF ACCOMODATION","52-02-09-0012","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","525","0.00"),
("531","      MEALS & ENTERTAINMENT","52-02-10","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("532","        BUSINESS ENTERTAINMENT-LOCAL","52-02-10-0001","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","531","0.00"),
("533","        BUSINESS ENTERTAINMENT-FOREIGN","52-02-10-0002","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","531","0.00"),
("534","        REFRESHMENTS","52-02-10-0003","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","531","0.00"),
("535","        STAFF RECREATION","52-02-10-0004","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","531","0.00"),
("536","        BOARD MEETING EXPENSE","52-02-10-0005","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","531","0.00"),
("537","LEGAL & PROFESSIONAL EXPENSES","52-02-11","15","","0000-00-00 00:00:00","2021-12-15 14:01:54","0","381","0.00"),
("538","        LEGAL EXPENSES","52-02-11-0001","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","537","0.00"),
("539","        OTHER CONSULTANCY SERVICES","52-02-11-0003","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","537","0.00"),
("540","        PROFESSIONAL CHARGES","52-02-11-0005","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","537","0.00"),
("541","MISCELLANEOUS EXPENSES","52-02-14","15","","0000-00-00 00:00:00","2021-12-15 14:02:10","0","381","0.00"),
("542","        SECURITY SERVICES","52-02-14-0001","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","541","0.00"),
("543","        SOFTWARE MAINTENANCE","52-02-14-0003","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","541","0.00"),
("544","        TRANSPORTATION, FREIGHT & FORWARDING","52-02-14-0004","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","541","0.00"),
("545","        ADVERTISING","52-02-14-0005","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","541","0.00"),
("546","        OTHERS","52-02-14-0006","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","541","0.00"),
("547","DEPRECIATION-OWNED ASSETS","52-02-15","15","","0000-00-00 00:00:00","2021-12-15 14:02:58","0","381","0.00"),
("548","        BUILDING","52-02-15-0002","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","547","0.00"),
("549","        PLANT & MACHINERY","52-02-15-0003","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","547","0.00"),
("550","        FURNITURE & FIXTURES","52-02-15-0004","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","547","0.00"),
("551","        OFFICE EQUIPMENTS","52-02-15-0005","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","547","0.00"),
("552","        ELECTRICAL EQUIPMENTS","52-02-15-0006","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","547","0.00"),
("553","        TOOLS & EQUIPMENTS","52-02-15-0007","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","547","0.00"),
("554","        VEHICLES","52-02-15-0008","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","547","0.00"),
("555","        GENERATORS","52-02-15-0009","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","547","0.00"),
("556","        CONATINERS","52-02-15-0010","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","547","0.00"),
("557","DEPRECIATION-OWNED ASSETS","52-02-16","15","","0000-00-00 00:00:00","2021-12-15 14:03:05","0","381","0.00"),
("558","        BUILDING","52-02-16-0002","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","557","0.00"),
("559","        PLANT & MACHINERY","52-02-16-0003","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","557","0.00"),
("560","        FURNITURE & FIXTURES","52-02-16-0004","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","557","0.00"),
("561","        OFFICE EQUIPMENTS","52-02-16-0005","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","557","0.00"),
("562","        ELECTRICAL EQUIPMENTS","52-02-16-0006","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","557","0.00"),
("563","        TOOLS & EQUIPMENTS","52-02-16-0007","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","557","0.00"),
("564","        VEHICLES","52-02-16-0008","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","557","0.00"),
("565","        GENERATORS","52-02-16-0009","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","557","0.00"),
("566","        CONATINERS","52-02-16-0010","15","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","557","0.00"),
("568","ADMINISTRATIVE & GENERAL EXPENSES","53-01","2","","0000-00-00 00:00:00","2021-12-15 14:19:09","0","0","0.00"),
("569","SALARIES, WAGES & BENEFITS","53-01-01","2","","0000-00-00 00:00:00","2021-12-15 14:18:57","0","568","0.00"),
("570","SALARIES","53-01-01-0001","2","","0000-00-00 00:00:00","2021-12-14 20:05:36","0","569","0.00"),
("571","        WAGES/CONTRACTUAL EMPLOYEES","53-01-01-0002","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","569","0.00"),
("572","        OVERTIME","53-01-01-0003","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","569","0.00"),
("573","        PROVIDENT FUND","53-01-01-0004","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","569","0.00"),
("574","BONUS","53-01-01-0005","2","","0000-00-00 00:00:00","2021-12-16 14:46:49","0","569","5000.00"),
("575","        INCENTIVES/REWARDS","53-01-01-0006","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","569","0.00"),
("576","        MEDICAL","53-01-01-0007","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","569","0.00"),
("577","        UNIFORMS","53-01-01-0008","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","569","0.00"),
("578","        EOBI","53-01-01-0009","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","569","0.00"),
("579","        SESSI","53-01-01-0010","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","569","0.00"),
("580","        EMPLOYEE TRAINING-LOCAL","53-01-01-0012","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","569","0.00"),
("581","        HONORARIUM/EX-GRATIA","53-01-01-0014","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","569","0.00"),
("582","        LEAVE ENCASHMENT","53-01-01-0015","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","569","0.00"),
("583","        GRATUITY","53-01-01-0016","2","","0000-00-00 00:00:00","2021-12-14 16:16:27","0","569","2000.00"),
("584","        CONVEYANCE ALLOWANCE","53-01-01-0018","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","569","0.00"),
("585","        STAFF MEAL","53-01-01-0021","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","569","0.00"),
("586","        HOUSE RENT ALLOWANCE","53-01-01-0023","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","569","0.00"),
("587","TRAVELLING & CONVEYANCE","53-01-02","2","","0000-00-00 00:00:00","2021-12-15 13:32:04","0","568","0.00"),
("588","        TRAVELLING-LOCAL","53-01-02-0001","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","587","0.00"),
("589","        TRAVELLING-FOREIGN","53-01-02-0002","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","587","0.00"),
("590","        ACCOMODATION-LOCAL","53-01-02-0003","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","587","0.00"),
("591","        ACCOMODATION-FOREIGN","53-01-02-0004","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","587","0.00"),
("592","        DAILY ALLOWANCE-LOCAL","53-01-02-0005","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","587","0.00"),
("593","        DAILY ALLOWANCE-FOREIGN","53-01-02-0006","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","587","0.00"),
("594","        CONVEYANCE LOCAL","53-01-02-0007","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","587","0.00"),
("595","VEHICLE RUNNING EXPENSES","53-01-03","2","","0000-00-00 00:00:00","2021-12-15 13:32:10","0","568","0.00"),
("596","        VEHICLE FUEL","53-01-03-0001","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","595","0.00"),
("597","        VEHICLE REPAIR & MAINTENANCE","53-01-03-0002","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","595","0.00"),
("598","        VEHICLE OTHER EXPENSES (REG. & TOKEN, TRACKER ETC.","53-01-03-0003","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","595","0.00"),
("599","UTILITIES","53-01-04","2","","0000-00-00 00:00:00","2021-12-15 13:32:17","0","568","0.00"),
("600","        TELEPHONE","53-01-04-0001","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","599","0.00"),
("601","        MOBILE","53-01-04-0002","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","599","0.00"),
("602","        ELECTRICITY","53-01-04-0004","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","599","0.00"),
("603","        WATER & SANITATION CHARGES","53-01-04-0005","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","599","0.00"),
("604","        SUI GAS","53-01-04-0006","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","599","0.00"),
("605","        GENERATOR FUEL","53-01-04-0007","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","599","0.00"),
("606","        INTERNET CHARGES","53-01-04-0008","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","599","0.00"),
("607","REPAIR & MAINTENANCE","53-01-05","2","","0000-00-00 00:00:00","2021-12-15 13:37:46","0","568","0.00"),
("608","        BUILDING / PREMISES","53-01-05-0002","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","607","0.00"),
("609","        FURNITURE & FIXTURES","53-01-05-0004","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","607","0.00"),
("610","        OFFICE EQUIPMENT","53-01-05-0005","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","607","0.00"),
("611","        ELECTRICAL OFFICE EQUIPMENT","53-01-05-0006","2","","0000-00-00 00:00:00","2021-12-15 15:16:03","0","607","500.00"),
("612","        GENERATORS","53-01-05-0009","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","607","0.00"),
("613","        PHOTOCOPIER","53-01-05-0012","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","607","0.00"),
("614","        HOUSE KEEPING","53-01-05-0013","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","607","0.00"),
("615","INSURANCE","53-01-06","2","","0000-00-00 00:00:00","2021-12-15 13:32:27","0","568","0.00"),
("616","        BUILDING","53-01-06-0002","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","615","0.00"),
("617","        FURNITURE & FIXTURES","53-01-06-0004","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","615","0.00"),
("618","        OFFICE EQUIPMENT","53-01-06-0005","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","615","0.00"),
("619","        ELECTRICAL OFFICE EQUIPMENT","53-01-06-0006","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","615","0.00"),
("620","        VEHICLES","53-01-06-0008","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","615","0.00"),
("621","        GENERATORS","53-01-06-0009","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","615","0.00"),
("622","PRINTING & STATIONERY","53-01-07","2","","0000-00-00 00:00:00","2021-12-15 13:32:31","0","568","0.00"),
("623","        PRINTING & STATIONERY","53-01-07-0001","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","622","0.00"),
("624","        NEWSPAPERS, BOOKS & PERIODICALS","53-01-07-0002","2","","0000-00-00 00:00:00","2021-12-15 15:16:03","0","622","400.00"),
("625","        PHOTOCOPY EXPENSES","53-01-07-0003","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","622","0.00"),
("626","POSTAGE & COURIER","53-01-08","2","","0000-00-00 00:00:00","2021-12-15 13:32:40","0","568","0.00"),
("627","        LOCAL POSTAGE & COURIER","53-01-08-0001","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","626","0.00"),
("628","        OVERSEAS POSTAGE & COURIER","53-01-08-0002","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","626","0.00"),
("629","RENT, FEES & TAXES","53-01-09","2","","0000-00-00 00:00:00","2021-12-15 13:32:52","0","568","0.00"),
("630","        RENT-FINANCE DEPARTMENT","53-01-09-0001","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","629","0.00"),
("631","        PROFESSIONAL TAX","53-01-09-0003","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","629","0.00"),
("632","        FEES, SUBSCRIPTION & REGISTRATION","53-01-09-0006","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","629","0.00"),
("633","MEALS & ENTERTAINMENT","53-01-10","2","","0000-00-00 00:00:00","2021-12-15 13:32:53","0","568","0.00"),
("634","        BUSINESS ENTERTAINMENT-LOCAL","53-01-10-0001","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","633","0.00"),
("635","        REFRESHMENTS","53-01-10-0003","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","633","0.00"),
("636","        STAFF RECREATION","53-01-10-0004","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","633","0.00"),
("637","        BOARD MEETING","53-01-10-0005","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","633","0.00"),
("638","LEGAL & PROFESSIONAL CHARGES","53-01-11","2","","0000-00-00 00:00:00","2021-12-15 13:32:54","0","568","0.00"),
("639","        LEGAL EXPENSES","53-01-11-0001","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","638","0.00"),
("640","        TAX CONSULTANCY","53-01-11-0002","2","","0000-00-00 00:00:00","2021-12-15 15:16:03","0","638","100.00"),
("641","        PROFESSIONAL CHARGES","53-01-11-0005","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","638","0.00"),
("642","AUDITORS REMUNERATION","53-01-12","2","","0000-00-00 00:00:00","2021-12-15 13:32:59","0","568","0.00"),
("643","        AUDIT FEE","53-01-12-0001","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","642","0.00"),
("644","        OUT OF POCKET EXPENSES","53-01-12-0002","2","","0000-00-00 00:00:00","2021-12-15 15:16:03","0","642","300.00"),
("645","MISCELLANEOUS EXPENSES","53-01-14","2","","0000-00-00 00:00:00","2021-12-15 13:33:04","0","568","0.00"),
("646","        SECURITY SERVICES","53-01-14-0001","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","645","0.00"),
("647","        CHARITY / DONATIONS","53-01-14-0002","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","645","0.00"),
("648","        SOFTWARE MAINTENANCE","53-01-14-0003","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","645","0.00"),
("649","        TRANSPORTATION , FREIGHT & FORWARDING","53-01-14-0004","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","645","0.00"),
("650","        ADVERTISING","53-01-14-0005","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","645","0.00"),
("651","        OTHERS","53-01-14-0006","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","645","0.00"),
("652","DEPRECIATION - OWNED ASSETS","53-01-15","2","","0000-00-00 00:00:00","2021-12-15 13:33:13","0","568","0.00"),
("653","        BUILDING","53-01-15-0002","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","652","0.00"),
("654","        PLANT & MACHINERY","53-01-15-0003","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","652","0.00"),
("655","        FURNITURE & FIXTURES","53-01-15-0004","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","652","0.00"),
("656","        OFFICE EQUIPMENTS","53-01-15-0005","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","652","0.00"),
("657","        ELECTRICAL EQUIPMENTS","53-01-15-0006","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","652","0.00"),
("658","        TOOLS & EQUIPMENTS","53-01-15-0007","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","652","0.00"),
("659","        VEHICLES","53-01-15-0008","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","652","0.00"),
("660","        GENERATORS","53-01-15-0009","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","652","0.00"),
("661","DEPRECIATION - LEASED ASSETS","53-01-16","2","","0000-00-00 00:00:00","2021-12-15 13:33:32","0","568","0.00"),
("662","        BUILDING","53-01-16-0002","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","661","0.00"),
("663","        PLANT & MACHINERY","53-01-16-0003","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","661","0.00"),
("664","        FURNITURE & FIXTURES","53-01-16-0004","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","661","0.00"),
("665","        OFFICE EQUIPMENTS","53-01-16-0005","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","661","0.00"),
("666","        ELECTRICAL EQUIPMENTS","53-01-16-0006","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","661","0.00"),
("667","        TOOLS & EQUIPMENTS","53-01-16-0007","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","661","0.00"),
("668","        VEHICLES","53-01-16-0008","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","661","0.00"),
("669","        GENERATORS","53-01-16-0009","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","661","0.00"),
("670","    SELLING & MARKETING EXPENSES","53-02","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("671","SALARIES, WAGES & BENEFITS","53-02-01","2","","0000-00-00 00:00:00","2021-12-15 13:42:22","0","670","0.00"),
("672","        SALARIES","53-02-01-0001","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","671","0.00"),
("673","        OVERTIME","53-02-01-0003","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","671","0.00"),
("674","        PROVIDENT FUND","53-02-01-0004","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","671","0.00"),
("675","        INCENTIVES/REWARDS","53-02-01-0006","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","671","0.00"),
("676","        MEDICAL","53-02-01-0007","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","671","0.00"),
("677","        UNIFORMS","53-02-01-0008","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","671","0.00"),
("678","        EOBI","53-02-01-0009","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","671","0.00"),
("679","        HONORARIUM/EXGRATIA","53-02-01-0014","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","671","0.00"),
("680","        LEAVE ENCASHMENT","53-02-01-0015","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","671","0.00"),
("681","        GRATUITY","53-02-01-0016","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","671","0.00"),
("682","        VEHICLE RUNNING & MAINTENANCE ALLOWANCE","53-02-01-0017","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","671","0.00"),
("683","        CONVEYANCE ALLOWANCE","53-02-01-0018","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","671","0.00"),
("684","        HOUSE RENT ALLOWANCE","53-02-01-0019","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","671","0.00"),
("685","        GROUP INSURANCE","53-02-01-0020","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","671","0.00"),
("686","        STAFF MEAL","53-02-01-0021","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","671","0.00"),
("687","        EXECUTIVE MEAL","53-02-01-0022","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","671","0.00"),
("688","TRAVELLING & CONVEYANCE","53-02-02","2","","0000-00-00 00:00:00","2021-12-15 13:46:06","0","670","0.00"),
("689","TRAVELLING-LOCAL","53-02-02-0001","2","","0000-00-00 00:00:00","2021-12-15 13:48:41","0","688","0.00"),
("690","TRAVELLING-FOREIGN","53-02-02-0002","2","","0000-00-00 00:00:00","2021-12-15 13:48:27","0","688","0.00"),
("691","ACCOMODATION-LOCAL","53-02-02-0003","2","","0000-00-00 00:00:00","2021-12-15 13:48:14","0","688","0.00"),
("692","CONVEYANCE LOCAL","53-02-02-0007","2","","0000-00-00 00:00:00","2021-12-15 13:48:00","0","688","0.00"),
("693","VEHICLE RUNNING EXPENSES","53-02-03","2","","0000-00-00 00:00:00","2021-12-15 13:49:20","0","670","0.00"),
("694","VEHICLE FUEL","53-02-03-0001","2","","0000-00-00 00:00:00","2021-12-15 13:51:21","0","693","0.00"),
("695","VEHICLE REPAIR & MAINTENANCE","53-02-03-0002","2","","0000-00-00 00:00:00","2021-12-15 13:51:36","0","693","0.00"),
("696","VEHICLE OTHER EXPENSES (REG. & TOKEN)","53-02-03-0003","2","","0000-00-00 00:00:00","2021-12-15 13:51:52","0","693","0.00"),
("697","UTILITIES","53-02-04","2","","0000-00-00 00:00:00","2021-12-15 13:52:29","0","670","0.00"),
("698","        TELEPHONE","53-02-04-0001","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","697","0.00"),
("699","        MOBILE","53-02-04-0002","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","697","0.00"),
("700","        FAX","53-02-04-0003","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","697","0.00"),
("701","        ELECTRICITY","53-02-04-0004","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","697","0.00"),
("702","        WATER & SANITATION CHARGES","53-02-04-0005","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","697","0.00"),
("703","        SUI GAS","53-02-04-0006","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","697","0.00"),
("704","        GENERATOR FUEL - RESIDENCE MULTAN","53-02-04-0007","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","697","0.00"),
("705","        INTERNET CHARGES","53-02-04-0008","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","697","0.00"),
("706","        GENERATOR FUEL - MARKETING OFFICE MULTAN","53-02-04-0009","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","697","0.00"),
("707","REPAIR & MAINTENANCE","53-02-05","2","","0000-00-00 00:00:00","2021-12-15 13:53:47","0","670","0.00"),
("708","        BUILDING","53-02-05-0002","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","707","0.00"),
("709","        FURNITURE & FIXTURES","53-02-05-0004","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","707","0.00"),
("710","        OFFICE EQUIPMENT","53-02-05-0005","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","707","0.00"),
("711","        ELECTRICAL OFFICE EQUIPMENT","53-02-05-0006","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","707","0.00"),
("712","        GENERATORS","53-02-05-0009","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","707","0.00"),
("713","        PHOTOCOPIER","53-02-05-0012","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","707","0.00"),
("714","        HOUSE KEEPING","53-02-05-0013","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","707","0.00"),
("715","INSURANCE","53-02-06","2","","0000-00-00 00:00:00","2021-12-15 13:54:30","0","670","0.00"),
("716","        FURNITURE & FIXTURES","53-02-06-0004","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","715","0.00"),
("717","        OFFICE EQUIPMENT","53-02-06-0005","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","715","0.00"),
("718","        ELECTRICAL OFFICE EQUIPMENT","53-02-06-0006","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","715","0.00"),
("719","        VEHICLES","53-02-06-0008","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","715","0.00"),
("720","        GENERATORS","53-02-06-0009","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","715","0.00"),
("721","PRINTING & STATIONERY","53-02-07","2","","0000-00-00 00:00:00","2021-12-15 13:55:05","0","670","0.00"),
("722","        PRINTING & STATIONERY","53-02-07-0001","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","721","0.00"),
("723","        NEWSPAPERS, BOOKS & PERIODICALS","53-02-07-0002","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","721","0.00"),
("724","        PHOTOCOPY EXPENSES","53-02-07-0003","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","721","0.00"),
("725","POSTAGE & COURIER","53-02-08","2","","0000-00-00 00:00:00","2021-12-15 13:55:39","0","670","0.00"),
("726","        LOCAL POSTAGE & COURIER","53-02-08-0001","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","725","0.00"),
("727","        OVERSEAS POSTAGE & COURIER","53-02-08-0002","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","725","0.00"),
("728","RENT, FEES & TAXES","53-02-09","2","","0000-00-00 00:00:00","2021-12-15 13:56:20","0","670","0.00"),
("729","        RENT-MARKETING DEPARTMENT","53-02-09-0001","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","728","0.00"),
("730","        PROFESSIONAL TAX","53-02-09-0003","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","728","0.00"),
("731","        FEES , SUBSCRIPTION & REGISTRATION","53-02-09-0006","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","728","0.00"),
("732","        RATES & TAXES","53-02-09-0007","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","728","0.00"),
("733","        RENT-SALES OFFICE MULTAN","53-02-09-0012","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","728","0.00"),
("734","        RENT - GENERATOR (MARKETING OFFICE)","53-02-09-0013","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","728","0.00"),
("735","MEALS & ENTERTAINEMENT","53-02-10","2","","0000-00-00 00:00:00","2021-12-15 13:56:52","0","670","0.00"),
("736","        BUSINESS ENTERTAINMENT-LOCAL","53-02-10-0001","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","735","0.00"),
("737","        REFRESHMENTS","53-02-10-0003","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","735","0.00"),
("738","        STAFF RECREATION","53-02-10-0004","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","735","0.00"),
("739","        BOARD MEETING","53-02-10-0005","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","735","0.00"),
("740","LEGAL & PROFESSIONAL CHARGES","53-02-11","2","","0000-00-00 00:00:00","2021-12-15 13:57:28","0","670","0.00"),
("741","        LEGAL EXPENSES","53-02-11-0001","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","740","0.00"),
("742","        PROFESSIONAL CHARGES","53-02-11-0005","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","740","0.00"),
("743","MISCELLANEOUS EXPENSES","53-02-14","2","","0000-00-00 00:00:00","2021-12-15 13:58:04","0","670","0.00"),
("744","        SECURITY SERVICES","53-02-14-0001","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","743","0.00"),
("745","        CHARITY / DONATION","53-02-14-0002","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","743","0.00"),
("746","        SOFTWARE MAINTENANCE","53-02-14-0003","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","743","0.00"),
("747","        TRANSPORTATION , FREIGHT & FORWARDING","53-02-14-0004","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","743","0.00"),
("748","        ADVERTISING","53-02-14-0005","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","743","0.00"),
("749","        OTHERS","53-02-14-0006","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","743","0.00"),
("750","DEPRECIATION - OWNED ASSETS","53-02-15","2","","0000-00-00 00:00:00","2021-12-15 13:58:41","0","670","0.00"),
("751","        BUILDING","53-02-15-0002","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","750","0.00"),
("752","        PLANT & MACHINERY","53-02-15-0003","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","750","0.00"),
("753","        FURNITURE & FIXTURES","53-02-15-0004","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","750","0.00"),
("754","        OFFICE EQUIPMENTS","53-02-15-0005","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","750","0.00"),
("755","        ELECTRICAL EQUIPMENTS","53-02-15-0006","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","750","0.00"),
("756","        TOOLS & EQUIPMENTS","53-02-15-0007","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","750","0.00"),
("757","        VEHICLES","53-02-15-0008","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","750","0.00"),
("758","        GENERATORS","53-02-15-0009","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","750","0.00"),
("759","DEPRECIATION - LEASED ASSETS","53-02-16","2","","0000-00-00 00:00:00","2021-12-15 13:59:20","0","670","0.00"),
("760","        BUILDING","53-02-16-0001","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","759","0.00"),
("761","        PLANT & MACHINERY","53-02-16-0002","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","759","0.00"),
("762","        FURNITURE & FIXTURES","53-02-16-0003","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","759","0.00"),
("763","        OFFICE EQUIPMENTS","53-02-16-0004","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","759","0.00"),
("764","        ELECTRICAL EQUIPMENTS","53-02-16-0005","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","759","0.00"),
("765","        TOOLS & EQUIPMENTS","53-02-16-0006","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","759","0.00"),
("766","        VEHICLES","53-02-16-0007","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","759","0.00"),
("767","        GENERATORS","53-02-16-0008","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","759","0.00"),
("768","SALES PROMOTION EXPENSE","53-02-17","2","","0000-00-00 00:00:00","2021-12-15 13:59:57","0","670","0.00"),
("769","        ADVERTISING - PRINT MEDIA","53-02-17-0001","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","768","0.00"),
("770","        ADVERTISING - ELECTRONIC MEDIA","53-02-17-0002","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","768","0.00"),
("771","        ADVERTISING - HOARDINGS, SIGN BOARDS, ETC.","53-02-17-0003","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","768","0.00"),
("772","        MODEL EXPENSE","53-02-17-0004","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","768","0.00"),
("773","        SALE LITERATURE & BROCHURE","53-02-17-0005","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","768","0.00"),
("774","        GIFTS & GIVEAWAYS","53-02-17-0006","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","768","0.00"),
("775","        BUSINESS PROMOTION","53-02-17-0007","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","768","0.00"),
("776","        AGENTS\' COMMISSION","53-02-17-0008","2","","0000-00-00 00:00:00","2021-12-09 17:50:24","0","768","0.00"),
("777","        SALES STAFF INCENTIVES","53-02-17-0009","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","768","0.00"),
("778","        WEBSITE CHARGES","53-02-17-0010","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","768","0.00"),
("779","LAUNCHING MARKETING EXPENSES","53-02-19","2","","0000-00-00 00:00:00","2021-12-15 14:00:54","0","670","0.00"),
("780","        EVENTS MANAGEMENT","53-02-19-0001","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","779","0.00"),
("781","        TRAVELLING - LOCAL","53-02-19-0002","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","779","0.00"),
("782","        ACCOMODATION - LOCAL","53-02-19-0003","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","779","0.00"),
("783","        VEHICLE FUEL","53-02-19-0004","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","779","0.00"),
("784","        VEHICLE REPAIR & MAINTENANCE","53-02-19-0005","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","779","0.00"),
("785","        VEHICLE OTHER EXPENSES (REG. & TOKEN)","53-02-19-0006","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","779","0.00"),
("786","        HOUSE KEEPING","53-02-19-0007","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","779","0.00"),
("787","        PRINTING & STATIONERY","53-02-19-0008","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","779","0.00"),
("788","        NEWSPAPER, BOOKS & PERIODICALS","53-02-19-0009","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","779","0.00"),
("789","        PHOTOCOPY EXPENSES","53-02-19-0010","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","779","0.00"),
("790","        LOCAL POSTAGE & COURIER","53-02-19-0011","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","779","0.00"),
("791","        FEES, SUBSCRIPTION & REGISTRATION","53-02-19-0013","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","779","0.00"),
("792","        BUSINESS ENTERTAINMENT - LOCAL","53-02-19-0014","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","779","0.00"),
("793","        TRANSPORTATION, FREIGHT & FORWARDING","53-02-19-0015","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","779","0.00"),
("794","        OTHERS","53-02-19-0016","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","779","0.00"),
("795","        ADVERTISING - HOARDINGS, SIGN BOARDS, BANNERS ETC","53-02-19-0017","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","779","0.00"),
("796","        BUSINESS PROMOTION","53-02-19-0018","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","779","0.00"),
("797","        CONVEYANCE LOCAL","53-02-19-0019","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","779","0.00"),
("798","        GENERATOR FUEL","53-02-19-0020","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","779","0.00"),
("799","        GIFTS & GIVEAWAYS","53-02-19-0021","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","779","0.00"),
("801","    FINANCIAL CHARGES","54-01","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("802","BANK FINANCIAL CHARGES","54-01-01","2","","0000-00-00 00:00:00","2021-12-15 13:36:04","0","801","0.00"),
("803","        BANK CHARGES","54-01-01-0001","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","802","0.00"),
("804","BANK GUARANTEE CHARGES","54-01-01-0002","2","","0000-00-00 00:00:00","2021-12-15 14:02:36","0","802","0.00"),
("805","        INSURANCE GUARANTEE CHARGES","54-01-01-0003","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","802","0.00"),
("806","        BANK COMMISSION","54-01-01-0004","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","802","0.00"),
("807","        DOCUMENTATION CHARGES","54-01-01-0005","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","802","0.00"),
("808","LEASE FINANCIAL CHARGES","54-01-02","2","","0000-00-00 00:00:00","2021-12-15 14:01:51","0","801","0.00"),
("809","        MARK UP- CAR","54-01-02-0001","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","808","0.00"),
("811","    TAXATION","55-01","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","0.00"),
("812","TAXATION","55-01-01","2","","0000-00-00 00:00:00","2021-12-15 13:38:23","0","811","0.00"),
("813","        CURRENT YEAR","55-01-01-0001","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","812","0.00"),
("814","        PRIOR YEARS","55-01-01-0002","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","812","0.00"),
("815","        DEFERRED","55-01-01-0003","2","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","812","0.00"),
("824","OTHER INCOME","42-01-01","1","","2021-12-14 19:46:33","2021-12-14 19:46:33","0","353","0.00"),
("825","land hamid","11-01-01-00010","3","","2021-12-14 21:08:34","2022-03-03 13:25:18","0","4","256000.00"),
("826","hamid equity","31-01-01-0000","7","","2021-12-14 21:10:54","2021-12-24 19:22:03","0","336","-153000.00"),
("827","SALARIES, WAGES & BENEFITS","53-01-011","2","","2021-12-15 14:57:13","2021-12-15 14:57:13","0","568","0.00"),
("828","civil work - contractor","52-01-03-0001","15","","2021-12-16 15:08:21","2021-12-16 15:08:58","0","419","0.00"),
("829","civil work - sub contractor","52-01-04-0001","15","","2021-12-16 15:10:30","2021-12-16 15:10:30","0","420","0.00");



DROP TABLE IF EXISTS cities;

CREATE TABLE `cities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cities_country_id_foreign` (`country_id`)
) ENGINE=InnoDB AUTO_INCREMENT=191 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO cities VALUES("1","rawalpindi","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("2","other","166","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("64","Karachi","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("65","Lahore","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("66","Faisalabad","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("67","Serai","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("68","Rawalpindi","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("69","Multan","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("70","Gujranwala","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("71","Hyderabad City","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("72","Peshawar","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("73","Abbottabad","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("74","Islamabad","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("75","Quetta","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("76","Bannu","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("77","Bahawalpur","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("78","Sargodha","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("79","Sialkot City","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("80","Sukkur","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("81","Larkana","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("82","Sheikhupura","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("83","Marpur Khas","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("84","Rahaimyar Khan","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("85","Kohat","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("86","Jhang Sadr","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("87","Gujrat","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("88","Bardar","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("89","Kasor","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("90","Dera Ghazi Khan","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("91","Masawala","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("92","Nawabshah","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("93","Okara","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("94","Gilgit","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("95","Chiniot","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("96","Sadiqabad","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("97","Turbat","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("98","Dera Ismaail Khan","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("99","Chaman","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("100","Zhob","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("101","Mehra","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("102","Parachinar","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("103","Gwadar","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("104","Kundian","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("105","Shahdad Kot","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("106","Haraipur","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("107","Matiari","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("108","Dera Allahyar","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("109","Lodhran","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("110","Batgram","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("111","Thatta","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("112","Bagh","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("113","Badain","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("114","Mansehra","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("116","Muzaffargarh","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("117","Tando Allahyar","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("118","Dera Murad Jamali","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("119","Karak","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("120","Mardan","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("121","Uthal","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("122","Nankana Sahib","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("123","Barkhan","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("124","Hafizabad","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("125","Kotli","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("126","Loralai","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("127","Dera Bugti","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("128","Jhang City","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("129","Sahaiwal","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("130","Sanghar","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("131","Pakpattan","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("132","Chakwal","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("133","Khushab","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("134","Ghotki","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("135","Kohlu","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("136","Khuzdar","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("137","Awaran","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("138","Nowshera","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("139","Charsadda","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("140","Qila Abdullah","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("141","Bahawalnagar","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("142","Dadu","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("143","Alaiabad","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("144","Lakki Marwat","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("145","Chilas","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("146","Pishin","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("147","Tank","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("148","Chitral","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("149","Qila Saifullah","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("150","Shikarpur","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("151","Panjgaer","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("153","Kalat","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("154","Gandava","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("155","Khanewal","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("156","Narowal","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("157","Khairpur","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("158","Malakand","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("159","Vihari","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("160","Saidu Sharif","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("161","Jhelum","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("162","Mandi Bahauddin","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("163","Bhakkar","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("164","Toba Tek Singh","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("165","Jamshoro","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("166","Kharan","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("167","Umarkot","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("168","Hangu","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("169","Timargara","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("170","Gakuch","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("171","Jacobabad","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("173","Mianwali","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("175","Naushahro Faroz","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("176","New Marpur","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("177","Daggar","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("178","Eidgah","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("179","Sibi","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("180","Dalbandan","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("181","Rajanpur","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("182","Leiah","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("183","Upper Dir","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("184","Tando Muhammad Khan","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("185","Attock City","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("186","Rawala Kot","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("187","Swabi","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("188","Kandhkot","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("189","Dasu","165","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("190","Athmuqam","165","0000-00-00 00:00:00","0000-00-00 00:00:00");



DROP TABLE IF EXISTS company_bank_transactions;

CREATE TABLE `company_bank_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `receipt_id` int(10) unsigned NOT NULL,
  `company_account` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_bank_transactions_receipt_id_foreign` (`receipt_id`),
  KEY `company_bank_transactions_company_account_foreign` (`company_account`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS company_banks;

CREATE TABLE `company_banks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_number` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `opening_balance` double NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` tinyint(1) DEFAULT 1,
  `amount` double DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS comparative_statement_documents;

CREATE TABLE `comparative_statement_documents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pr_id` int(11) DEFAULT NULL,
  `vendor_id` int(11) DEFAULT NULL,
  `document_name` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS comparative_statements;

CREATE TABLE `comparative_statements` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `purchase_request_id` int(11) NOT NULL DEFAULT 0,
  `item_id` int(11) NOT NULL DEFAULT 0,
  `vendor_id` int(11) NOT NULL DEFAULT 0,
  `price` double(8,2) NOT NULL DEFAULT 0.00,
  `message` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS control_accounts;

CREATE TABLE `control_accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `rep_name` varchar(100) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `type` int(11) DEFAULT NULL,
  `vendor_type` int(11) DEFAULT NULL,
  `file` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS countries;

CREATE TABLE `countries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=167 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO countries VALUES("165","Pakistan","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("166","Other","0000-00-00 00:00:00","0000-00-00 00:00:00");



DROP TABLE IF EXISTS customer_adjustments;

CREATE TABLE `customer_adjustments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `receipt_id` int(10) unsigned NOT NULL,
  `type` int(11) DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `merge_amount` double DEFAULT NULL,
  `sold_amount` double DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_adjustments_receipt_id_foreign` (`receipt_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS customer_amounts;

CREATE TABLE `customer_amounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` enum('buy_back','roll_over') NOT NULL,
  `total_amount` double NOT NULL,
  `customer_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS customer_documents;

CREATE TABLE `customer_documents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int(10) unsigned NOT NULL,
  `url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_documents_customer_id_foreign` (`customer_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO customer_documents VALUES("1","1","1-Untitled.png","2022-12-23 00:59:29","2022-12-23 00:59:29");



DROP TABLE IF EXISTS customer_nominees;

CREATE TABLE `customer_nominees` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int(10) unsigned NOT NULL,
  `nominee_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nominee_so_do_wo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nominee_cnic` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nominee_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nominee_relation` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nominee_contact_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nominee_passport_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nominee_phone_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nominee_res_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nominee_mobile_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `nominee_cnic_flag` tinyint(4) DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `customer_nominees_customer_id_foreign` (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS customer_properties;

CREATE TABLE `customer_properties` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `cost` double NOT NULL,
  `booking_date` date NOT NULL,
  `original_boooking_date` date DEFAULT NULL,
  `discount` double DEFAULT 0,
  `discount_type` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `down_payment` double NOT NULL DEFAULT 15,
  `possession_fee` double DEFAULT 10,
  `installment` double NOT NULL DEFAULT 50,
  `installment_plan` int(11) NOT NULL DEFAULT 4,
  `application_form_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `plot_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `plot_category` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dealer_id` int(10) unsigned DEFAULT NULL,
  `net_pay` double DEFAULT NULL,
  `membership_no` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `plot_type` int(10) unsigned DEFAULT NULL,
  `plot_belting` double DEFAULT NULL,
  `schedule_start_date` date DEFAULT NULL,
  `six_installment` double DEFAULT NULL,
  `inventory_id` int(10) unsigned DEFAULT NULL,
  `booking_type` tinyint(1) DEFAULT NULL,
  `schedular_type` int(11) NOT NULL DEFAULT 1,
  `status` tinyint(1) DEFAULT NULL,
  `invoice_number` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `down_payment_note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `sms_alert` tinyint(1) DEFAULT NULL,
  `email_alert` tinyint(1) DEFAULT NULL,
  `down_payment_rebate` float NOT NULL DEFAULT 50,
  `installment_rebate` float NOT NULL DEFAULT 50,
  `paid_installment_rebate` int(11) NOT NULL DEFAULT 8,
  `reminder_text` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reminder_date` date DEFAULT NULL,
  `print_count_m` int(11) NOT NULL DEFAULT 0,
  `print_count_c` int(11) NOT NULL DEFAULT 0,
  `is_book` tinyint(1) NOT NULL DEFAULT 0,
  `sale_by` int(11) DEFAULT NULL,
  `allotment_date` date DEFAULT NULL,
  `confirmation_date` date DEFAULT NULL,
  `development_date` date DEFAULT NULL,
  `file_processing_date` date DEFAULT NULL,
  `registration_date` date DEFAULT NULL,
  `allotment_fee` double NOT NULL DEFAULT 0,
  `confirmation_fee` double NOT NULL DEFAULT 0,
  `booking_fee` double NOT NULL DEFAULT 0,
  `development_fee` double NOT NULL DEFAULT 0,
  `file_processing_fee` double NOT NULL DEFAULT 0,
  `registration_fee` double NOT NULL DEFAULT 0,
  `access_amount` double DEFAULT 0,
  `cancel_date` date DEFAULT NULL,
  `block_date` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_properties_customer_id_foreign` (`customer_id`),
  KEY `customer_properties_dealer_id_foreign` (`dealer_id`),
  KEY `customer_properties_product_type_foreign` (`plot_type`),
  KEY `customer_properties_inventory_id_foreign` (`inventory_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO customer_properties VALUES("1","1","10935000","2022-12-25","2022-12-22","0","1","2022-12-23 01:09:35","2022-12-23 01:21:45","2733750","1640250","6561000","8","","","","1","10935000","45876487","","","2023-01-01","","1","1","3","2","50000","","0","","","50","50","8","","","1","0","0","22","2022-12-22","2022-12-22","2022-12-22","2022-12-22","2022-12-22","0","0","0","0","0","0","","","");



DROP TABLE IF EXISTS customer_property_full_payment_statements;

CREATE TABLE `customer_property_full_payment_statements` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int(10) unsigned NOT NULL,
  `property_id` int(10) unsigned NOT NULL,
  `due_date` date NOT NULL,
  `due` double NOT NULL,
  `received` double DEFAULT 0,
  `balance` double DEFAULT NULL,
  `receipt_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `payment_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_property_full_payment_statements_customer_id_foreign` (`customer_id`),
  KEY `customer_property_full_payment_statements_property_id_foreign` (`property_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS customer_property_full_payments;

CREATE TABLE `customer_property_full_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_property_id` int(10) unsigned NOT NULL,
  `total_amount` double DEFAULT NULL,
  `total_tenure` double DEFAULT NULL,
  `discount_percentage` double DEFAULT NULL,
  `return_tenure` double DEFAULT NULL,
  `discount_amount` double DEFAULT NULL,
  `deduction_amount` double DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_property_full_payments_customer_property_id_foreign` (`customer_property_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS customer_property_partners;

CREATE TABLE `customer_property_partners` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `property_id` int(10) unsigned NOT NULL,
  `customer_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_property_partners_property_id_foreign` (`property_id`),
  KEY `customer_property_partners_customer_id_foreign` (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS customer_property_taxes;

CREATE TABLE `customer_property_taxes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
  `property_id` int(11) NOT NULL,
  `installment_id` int(11) NOT NULL,
  `tax` int(11) DEFAULT 0,
  `status` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `tax_pay_by` tinyint(1) DEFAULT NULL,
  `tax_payment_received` tinyint(1) DEFAULT NULL,
  `reference` varchar(100) DEFAULT NULL,
  `cpr` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

INSERT INTO customer_property_taxes VALUES("1","1","1","1","20000","1","2022-12-23 01:16:53","2022-12-23 01:19:26","1","0","03146150723600","1-Untitled.png");



DROP TABLE IF EXISTS customer_requests;

CREATE TABLE `customer_requests` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int(10) unsigned NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `floor` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approx_bugdet` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_requests_customer_id_foreign` (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS customer_statements;

CREATE TABLE `customer_statements` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `customer_property_id` int(10) unsigned DEFAULT NULL,
  `payment_head` int(11) NOT NULL DEFAULT 1,
  `inst_no` varchar(11) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `inst_track` tinyint(4) NOT NULL DEFAULT 0,
  `due_date` date DEFAULT NULL,
  `due` double DEFAULT NULL,
  `received` double DEFAULT 0,
  `balance` double DEFAULT 0,
  `rcpt_no` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ref_no` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rcpt_date` date DEFAULT NULL,
  `rcpt_amount` double DEFAULT 0,
  `late_days` int(11) DEFAULT NULL,
  `surcharge` double DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `customer_statements_customer_id_foreign` (`customer_id`),
  KEY `customer_statements_customer_property_id_foreign` (`customer_property_id`),
  KEY `customer_statements_receipt_id_foreign` (`receipt_id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO customer_statements VALUES("1","1","1","1","2-a","0","2022-12-25","2000000","2000000","0","50000","RC1","2022-12-22","2000000","","0","2022-12-23 01:09:35","2022-12-23 01:16:53","1","0"),
("2","1","1","3","1","0","2023-01-01","820125","0","820125","","","","0","","0","2022-12-23 01:09:35","2022-12-23 01:09:35","","0"),
("3","1","1","3","2","0","2023-04-01","820125","0","820125","","","","0","","0","2022-12-23 01:09:35","2022-12-23 01:09:35","","0"),
("4","1","1","3","3","0","2023-07-01","820125","0","820125","","","","0","","0","2022-12-23 01:09:35","2022-12-23 01:09:35","","0"),
("5","1","1","3","4","0","2023-10-01","820125","0","820125","","","","0","","0","2022-12-23 01:09:35","2022-12-23 01:09:35","","0"),
("6","1","1","3","5","0","2024-01-01","820125","0","820125","","","","0","","0","2022-12-23 01:09:35","2022-12-23 01:09:35","","0"),
("7","1","1","3","6","0","2024-04-01","820125","0","820125","","","","0","","0","2022-12-23 01:09:35","2022-12-23 01:09:35","","0"),
("8","1","1","3","7","0","2024-07-01","820125","0","820125","","","","0","","0","2022-12-23 01:09:35","2022-12-23 01:09:35","","0"),
("9","1","1","3","8","0","2024-10-01","820125","0","820125","","","","0","","0","2022-12-23 01:09:35","2022-12-23 01:09:35","","0"),
("10","1","1","2","2","0","2024-12-01","1640250","0","1640250","","","","0","","0","2022-12-23 01:09:35","2022-12-23 01:09:35","","0"),
("11","1","1","8","1","0","2022-12-22","0","0","0","","","","0","","0","2022-12-23 01:09:35","2022-12-23 01:09:35","","0"),
("12","1","1","9","1","0","2022-12-22","0","0","0","","","","0","","0","2022-12-23 01:09:35","2022-12-23 01:09:35","","0"),
("13","1","1","10","1","0","2022-12-25","0","0","0","","","","0","","0","2022-12-23 01:09:35","2022-12-23 01:09:35","","0"),
("14","1","1","11","1","0","2022-12-22","0","0","0","","","","0","","0","2022-12-23 01:09:35","2022-12-23 01:09:35","","0"),
("15","1","1","12","1","0","2022-12-22","0","0","0","","","","0","","0","2022-12-23 01:09:35","2022-12-23 01:09:35","","0"),
("16","1","1","13","1","0","2022-12-22","0","0","0","","","","0","","0","2022-12-23 01:09:35","2022-12-23 01:09:35","","0"),
("17","1","1","1","2-b","0","2022-12-25","733750","0","733750","","","","0","","0","2022-12-23 01:16:53","2022-12-23 01:16:53","","0");



DROP TABLE IF EXISTS customers;

CREATE TABLE `customers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `membership_no` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `father_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `cnic` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone_number` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_paid_amount` double NOT NULL DEFAULT 0,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `img_url` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `nominee_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nominee_so_do_wo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nominee_cnic` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nominee_relation` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nominee_phone_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `passport_no` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nominee_passport_no` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `res_number` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile_number` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nominee_res_number` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nominee_mobile_number` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `occupation` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mailing_address` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `permanent_address` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nominee_email` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `father_type` int(11) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `cnic_flag` tinyint(4) DEFAULT 1,
  `nominee_cnic_flag` tinyint(4) DEFAULT 1,
  `nominee_father_type` tinyint(4) DEFAULT NULL,
  `password` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_filer` tinyint(1) NOT NULL DEFAULT 0,
  `ntn_number` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` int(11) DEFAULT NULL,
  `nominee_address` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_title` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `iban_number` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_owner` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `second_owner` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_owner_father` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `second_owner_father` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_owner_cnic` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `second_owner_cnic` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_method` int(11) NOT NULL DEFAULT 0,
  `buy_back_total` double NOT NULL DEFAULT 0,
  `roll_over_total` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO customers VALUES("1","","Ali shahzaib","naseem Abbasi","3810481580747","","","2000000","1","1-Untitled.png","2022-12-23 00:59:29","2022-12-23 01:16:53","imran khan","Haq nawaz","7546756865876","brother","","","","","03311334445","","","","","rwp","rwp","","1","0","1","","1","$2y$10$xmI9Y9FIvHtnalXtI8FYlOVQkRR6Px5cDvySRzGyY.8W8Jt4Apfjy","","1","","0","rwp","","","","","","","","","","0","0","0");



DROP TABLE IF EXISTS customers_fingerprints;

CREATE TABLE `customers_fingerprints` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
  `image` blob NOT NULL,
  `template` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `encodeWEQ` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO customers_fingerprints VALUES("1","0","","Rk1SACAyMAAAAADkAAABLAGQAMUAxQEAAABZIYCsACBsAIDwADLjAIDjAE1hAICjAGdxAED1AGnbAIDsAJFbAEBiAJQNAEC9AJ1kAIEXAJ1UAEA/AJ2lAEBgAKKkAEBqAKugAIBWALMlAEBKALuuAIB+AMvjAIEOANfQAECZANvRAIB/AOHHAEC9AOlRAEEGAPPZAEBIAQvGAICLAQtNAECVARpYAECBARzeAEBMASBKAECPASteAEDAAStVAICtATVfAEB9AT9oAEC2AVNsAECcAVjxAEC3AWNxAECnAWtxAAAA","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","2022-12-23 19:11:45","2022-12-23 19:11:45"),
("2","0","","Rk1SACAyMAAAAADYAAABLAGQAMUAxQEAAABcH4CrAAx1AIDyAB7lAIBTAC2JAIDjADdfAED2AFDbAICjAFFyAEA2AHGbAIDwAHxaAEBkAH4KAEDAAIdlAEA/AIykAEBgAI+hAEBsAJWgAECDALjWAECdAMTRAEAjAMW1AEENAMrZAICCAMrKAEDBANBVAEEIAODUAICOAPNNAEBJAPnHAECYAQNYAEBOAQ5KAEDDARRVAICvAR5dAECBASpoAEC1AT5pAECdAUXsAEC1AVBxAECnAVtxAAAA","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","2022-12-23 19:11:58","2022-12-23 19:11:58"),
("3","0","","Rk1SACAyMAAAAAEmAAABLAGQAMUAxQEAAAA9LICiACdyAEC6ACzsAICAADN5AECMAEt9AECSAEv1AIClAFgGAIBbAFuEAIDEAGHjAIBcAGSMAEA0AG4aAIBdAG+UAICcAHLoAEAxAIAbAEBnAIKaAEDMAIbaAEAyAIukAECSAKJvAEBBAKasAED0ALTZAIB2ALazAEDfALjRAECFALjRAIAbAL02AECCAL3GAEAxAMC4AEBYAMA1AEBhAMXDAEDCAMfGAIC1AMnAAECTANJAAECPANNKAIDkANbJAICOAN9iAICoAN+zAEBXAOHHAEDaAOPGAID+AOTMAEDKAO29AEB0APBUAIAhAQDFAICZAQCWAEBBASJhAECJASeAAEB0AS1zAAAA","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","2022-12-23 19:12:40","2022-12-23 19:12:40"),
("4","0","","Rk1SACAyMAAAAADqAAABLAGQAMUAxQEAAABcIoDBACp1AIBoAE+HAID9AFRlAEEMAGvgAIC+AHNyAEBQAJCdAIEJAJtdAEB9AJ8KAEDZAKlkAEBZAKukAEB5AK+sAECFALaeAIBxAL4lAEBkAMeuAECaANrUAEA8AOO1AEC0AOjRAIAuAOy1AICZAO3HAEDYAPRUAICkARdNAEBfARjGAECuASZYAECaASfeAEBjAStHAECnATVeAEDYAThRAIDEAUBeAECVAUpnAEBuAVVkAEDKAV5sAECxAWPsAEDOAXFsAEC9AXhxAAAA","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","2022-12-23 19:13:06","2022-12-23 19:13:06"),
("5","0","","Rk1SACAyMAAAAAEmAAABLAGQAMUAxQEAAAA8LEB+ADV9AECRAEqAAEBcAE8HAECgAGSDAIBgAG6RAIBuAHqUAIDUAH/rAEBRAIAVAIByAIyUAEC3AJHnAEBIAJ0bAICIAJ2RAIDfAKDhAEBEAK6nAICzALtrAEBYAMKuAIEGAMnbAED5ANDUAICNANG7AECdANLWAECcANbDAEBKAN61AIByAN8zAEB5AODDAEDcAODGAIDPAOLDAECtAOpDAECpAOxNAID+AO7NAECmAPRVAIBzAPfFAEDzAPvHAED5AP1KAEDFAP2xAED7AQHHAECNAQtRAEDeAQ+1AIC0ARmWAECSASFlAEA/ASPGAECSATD+AICxAT6TAIBjAT9nAECPAUd1AAAA","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","2022-12-23 19:13:30","2022-12-23 19:13:30"),
("6","0","","Rk1SACAyMAAAAAFiAAABLAGQAMUAxQEAAAA1NkCDAFpuAICgAHVfAECXAHtnAIB6AH51AIDnAIFiAEDXAIFnAECCAIfqAIC5AJDlAECEAJVxAECYAJ9kAECsAJ9fAIAgAKApAIC7AKzUAEBBAK+hAED0ALJdAICvALTRAEClALVdAECCAL3dAIBkAMGHAICkAMjRAIA8AMmsAICFAMxiAIAkANQwAEBlANeoAEBrANi4AEBhAOezAIApAOc2AEDeAOvjAEB4AOzNAIClAOzJAIA/APE5AEBuAPTDAICFAPfMAEAjAPm7AEBqAP7DAIAvAQPCAIDhAQ3XAEBfARDNAICnARLGAEB5AR09AEBuAR1HAEDfASNaAICUASa2AIDMASjNAEBvAShUAIDaASnjAIB5ASxAAEC1AT3DAICoAUq5AICeAUyzAEBSAVXjAIDPAVbFAICEAVmdAIChAYImAAAA","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","2022-12-23 19:14:16","2022-12-23 19:14:16"),
("7","0","","Rk1SACAyMAAAAAEOAAABLAGQAMUAxQEAAABZKECKABJzAIDiADNoAED+AEHgAICcAFR1AEBHAGObAECOAGv0AEDmAG9iAECuAHFuAEB2AHuNAEDWAIPdAEB3AIgDAEBYAI4fAECpAI9pAIB5AI+OAEBqAJoYAEDsAJtfAEBNAJ+zAECYAKZzAICCALgLAECLAMDbAECHAMDNAEBqAME4AECXAMPZAEC6AMNaAECEAMXDAEBeAMfGAEEFAMnaAEBGANJDAEBGAOnGAECBAPTNAEDnAQRUAEBoARbQAEBcARnHAIDyASZlAIDuATJrAEDjATdzAEB6AT5UAECcAULjAICyAURuAEDYAUx9AAAA","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","2022-12-23 19:14:45","2022-12-23 19:14:45"),
("8","0","","Rk1SACAyMAAAAAEIAAABLAGQAMUAxQEAAABZJ0BVADH4AIDZADhlAICIAElsAEAkAF6UAEBAAGT+AEBAAGuGAEDPAGtlAEDyAH3eAIAWAH8RAICOAIhuAEA8AIiRAEB9AJ3sAECeAKpnAEBmAKqDAEDWAK5bAEBDALcXAEBiALf+AEDCAL/aAEBiAMKNAECUAMZiAEA0AMisAEBRAMgQAEDWANhdAEB/ANpsAIBpAOf/AEBNAO4zAEBBAO+9AIB6APDXAEBuAPHWAEBnAPG7AEAmAPM6AEBsAPbHAECeAPxVAEDqAQbWAEAjAQq7AEBcASDHAEAwATzGAEA+ATzHAIDCAUJTAAAA","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","2022-12-23 19:15:18","2022-12-23 19:15:18"),
("9","0","","Rk1SACAyMAAAAACcAAABLAGQAMUAxQEAAABEFYBXABksAIBXADkuAICqAEQGAEB2AEkkAEBfAFczAECjAFsKAEC5AGfxAECJAHsoAECjAIH+AICnAIqiAECrAJLQAEBJAJK7AEDaAJTUAECpAJvAAEDGALfDAECBAL5AAED1AMDHAEDNAMi4AECqAM1AAIDJANc8AIDhANy9AAAA","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","2022-12-26 00:38:54","2022-12-26 00:38:54"),
("10","0","","Rk1SACAyMAAAAAC6AAABLAGQAMUAxQEAAABYGoBCABY2AIBiACsvAIBkAEwuAIC4AFMKAICHAGEuAEBuAGkzAEC0AGkHAEDLAHbxAECaAIwpAEC2AJH+AIAlAJi1AEC3AKC4AEDrAKDZAEC9AKLRAEBcAKe7AEC7AKrGAEDbAMbDAEEKAMvKAIDkAM7HAECUAM9AAEC+ANxDAIDgAOVCAID3AOrAAIDrAQc5AECDARM9AECeASQzAAAA","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","2022-12-26 00:39:12","2022-12-26 00:39:12"),
("11","0","","Rk1SACAyMAAAAAC0AAABLAGQAMUAxQEAAAA3GUBZACMmAECnAEYNAIB6AGkcAEBmAHMiAECWAIYTAECkAJ0GAIC5AK/4AEC9AMLxAECRANMNAEB0ANUaAICOAOgGAECtAOjuAIBDAPAvAEAjAPKzAICIAQMHAIC4AQPbAICeAQneAIBcAQ+4AECQARLAAECKARmxAICaAR7CAECvASjDAIC8ASvCAICoAS27AICyATxCAAAA","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","2022-12-26 00:43:58","2022-12-26 00:43:58"),
("12","0","","Rk1SACAyMAAAAAEaAAABLAGQAMUAxQEAAABDKoCCAB8XAEBpACshAECZAEAKAEClAFkAAIC3AG31AEC8AIDqAEDaAIJoAEB2AIsVAECSAIsHAICMAKEDAECqAKPqAEAgAKisAIDmALrRAICFALoBAEAUALwpAIC2AL/UAECgAMDWAECPAMLTAIBZAMS1AICGAMbHAIAvANC5AEA2ANLDAIBIANc6AICXANm9AEDVAN/HAICjAOe7AEAjAOu9AIC3AOzCAIAcAO21AEDuAPPGAIAYARTCAEC8ARizAEAyARrUAIA+AR3ZAICeASGrAIDIASY4AEBYASxuAEB9ATiRAECYAT0oAEDgAUOxAIDDAUarAICbAU6iAAAA","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","2022-12-26 00:44:12","2022-12-26 00:44:12");



DROP TABLE IF EXISTS dealer_paid_rebates;

CREATE TABLE `dealer_paid_rebates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `dealer_id` int(10) unsigned DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `property_id` int(11) DEFAULT NULL,
  `is_deleted` tinyint(4) NOT NULL DEFAULT 0,
  `account_id` int(11) DEFAULT NULL,
  `payment_method` int(11) DEFAULT NULL,
  `bank_name` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_account` int(10) unsigned DEFAULT NULL,
  `drawn_date` date DEFAULT NULL,
  `cheque_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_book` tinyint(1) NOT NULL DEFAULT 0,
  `tax_amount` double(8,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`),
  KEY `dealer_paid_rebates_dealer_id_foreign` (`dealer_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO dealer_paid_rebates VALUES("1","1","546750","2022-12-22","2022-12-23 01:27:49","2022-12-23 01:27:49","1","0","","1","","","","","","0","65610.00");



DROP TABLE IF EXISTS dealer_received_amounts;

CREATE TABLE `dealer_received_amounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `dealer_id` int(10) unsigned NOT NULL,
  `customer_property_id` int(10) unsigned NOT NULL,
  `payment_mode` int(11) NOT NULL DEFAULT 1,
  `bank_name` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cheque_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cheque_title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` double NOT NULL,
  `date` date NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjacement_type` int(11) DEFAULT NULL,
  `adjacement_detail` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dealer_received_amounts_dealer_id_index` (`dealer_id`),
  KEY `dealer_received_amounts_customer_property_id_index` (`customer_property_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS dealer_transactions;

CREATE TABLE `dealer_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned NOT NULL,
  `dealer_id` int(10) unsigned DEFAULT NULL,
  `amount` double NOT NULL DEFAULT 0,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `is_book` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `dealer_transactions_dealer_id_foreign` (`dealer_id`),
  KEY `dealer_transactions_product_id_foreign` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO dealer_transactions VALUES("1","1","1","546750","0","2022-12-23 01:09:35","2022-12-23 01:09:35","0");



DROP TABLE IF EXISTS dealer_types;

CREATE TABLE `dealer_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO dealer_types VALUES("1","EXPO SEVEN","1","2022-12-23 01:03:06","2022-12-23 01:03:06"),
("2","Dealer","1","2022-12-23 01:03:26","2022-12-23 01:03:26");



DROP TABLE IF EXISTS dealers;

CREATE TABLE `dealers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cnic` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_sale` double NOT NULL DEFAULT 0,
  `total_rebate` double NOT NULL DEFAULT 0,
  `total_paid_amount` double NOT NULL DEFAULT 0,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `percentage` double(8,2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `city_id` int(10) unsigned DEFAULT NULL,
  `dealer_type_id` int(10) unsigned DEFAULT NULL,
  `parent_dealer` int(10) unsigned DEFAULT NULL,
  `parent_dealer_percentage` double(8,2) DEFAULT NULL,
  `code` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `down_payment_rebate` float NOT NULL DEFAULT 50,
  `installment_rebate` float NOT NULL DEFAULT 50,
  `paid_installment_rebate` int(11) NOT NULL DEFAULT 8,
  `password` varchar(110) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(110) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rebate_in_percent` tinyint(4) DEFAULT 1,
  `is_filer` tinyint(1) DEFAULT 0,
  `ntn_number` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dealers_city_id_foreign` (`city_id`),
  KEY `dealers_dealer_type_id_foreign` (`dealer_type_id`),
  KEY `dealers_parent_dealer_foreign` (`parent_dealer`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO dealers VALUES("1","Masood","23463-4564564-5","","","0331-1333444","10935000","546750","546750","1","5.00","2022-12-23 01:06:03","2022-12-23 01:27:49","1","1","","","d-364","0","50","50","8","$2y$10$JTa2F9glrmyaIuGc6zpTRuv./qHRJQ8S1Z4PBuz51IOiUry9/9PKy","","1","1","");



DROP TABLE IF EXISTS departments;

CREATE TABLE `departments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `department_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `deleted_at` int(11) DEFAULT NULL,
  `role_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS depositor_banks;

CREATE TABLE `depositor_banks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO depositor_banks VALUES("1","HBL","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("2","UBL","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("3","National Bank of Pakistan","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("5","The Bank of Khyber","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("6","The Bank of Punjab","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("9","Sindh Bank Limited","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("10","Zarai Tarqiati Bank Limited","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("11","MCB Bank Limited","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("16","JS Bank Limited","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("21","SILKBANK Limited","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("23","Meezan Bank Limited","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("24","Al-Baraka Bank (Pakistan) Limited","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("26","MCB Islamic Bank Limited","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("32","Allied Bank limited","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("33","Bank Al-Falah Limited","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("34","Bank Al-Habib Limited","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("35","Habib Metropolitan Bank Limited","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("37","Faysal Bank Limited","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("38","Askari Bank Limited","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("39","Standard Chartered Bank","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("40","Soneri Bank Limited","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("42","Summit Bank Limited","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("45","Bank Islami Pakistan Limited","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("47","Dubai Islamic Bank Pakistan","0000-00-00 00:00:00","0000-00-00 00:00:00");



DROP TABLE IF EXISTS designations;

CREATE TABLE `designations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS dnfbp;

CREATE TABLE `dnfbp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `fname` varchar(50) NOT NULL,
  `cnic` varchar(50) NOT NULL,
  `district` varchar(50) NOT NULL,
  `province` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3173 DEFAULT CHARSET=utf8mb4;

INSERT INTO dnfbp VALUES("2","  Zain Haider","Ahmad Nawaz","3810481580749","Punjab","BHAKKAR"),
("3"," Abdul Ghafoor","Muhammad Nazir ","8210350884027","AJ&K","HAVELI"),
("4","Aamir Bilal alias Babu Jhangvee ","Muhammad Bilal ","3640177467701","Punjab","PAKPATTAN"),
("5","Abbas","Mohammad Ali. ","5440044885249","Balochistan","QUETTA"),
("6","Abdar Rehman ","Muhammad Yousaf","3720139466545","Punjab","CHAKWAL"),
("7","Abdul Ahad","Muhammad Hussain","1620223292179","KP","SWABI"),
("8","Abdul Aleem","Habib-ur-Rehman","3230405368119","Punjab","Muzaffargarh"),
("9","Abdul Asghar Aziz ","Muhammad Azam Khan ","3830260632903","Punjab","MIANWALI"),
("10","Abdul Azeem","Habib Mulla","1530293896815","KP","LOWER DIR (AT TEMERGARA)"),
("11","Abdul Aziz","Deen Muhammad ","3310060613503","Punjab","FAISALABAD"),
("12","Abdul Aziz ","Abdul Rasheed ","3810236348825","Punjab","BHAKKAR"),
("13","Abdul Aziz Faisal","Muhammad Suleman","3710303276027","Punjab","ATTOCK"),
("14","Abdul Badi","Abdul Hayi","4540226369835","Punjab","BAHAWALNAGAR"),
("15","Abdul basit ","Allah bakhash","3320353463967","Punjab","Jhang"),
("16","Abdul Basit","Ghulam Hussain","3230391070849","Punjab","Muzaffargarh"),
("17","Abdul Basit ","Ain Ullah ","4240165931273","Sindh","Karachi"),
("18","Abdul Basit Nizami","Abdul Wahid","3110416529505","Punjab","BAHAWALNAGAR"),
("19","Abdul Ghaffar ","Ali Muhammad ","3630275529953","Punjab","MULTAN"),
("20","Abdul Ghaffar ","Jameel Ahmad ","3410185992463","Punjab","GUJRANWALA"),
("21","Abdul Ghaffar","Ghullam Sarwer","3320247438725","Punjab","Jhang"),
("22","Abdul Ghaffar ","Ilam Din ","3410143162069","Punjab","GUJRANWALA"),
("23","Abdul Ghaffar ","Muhammad Urus ","4340203958225","Sindh","KAMBAR SHAHDADKOT"),
("24","Abdul Ghaffar  ","Muhammad Mukhtiar","3120434228149","Punjab","BAHAWALPUR"),
("25","Abdul Ghaffar alias Ghaffri ","Sher Shah ","3310094453975","Punjab","CHAKWAL"),
("26","Abdul Ghafoor","Sheikh Noor Muhammad","3320248734053","Punjab","Jhang"),
("27","Abdul Ghafoor Abid","Ali Muhammad","3220216810765","Punjab","LAYYAH"),
("28","Abdul Ghafoor Haqani","Ghulam Shabbir","3810106878767","Punjab","BHAKKAR"),
("29","Abdul Ghafoor Shah","Sahib Shah","3230166745113","Punjab","Muzaffargarh"),
("30","Abdul Ghafoor Tabani ","Muhammad Nazir  ","8120269022711","AJ&K","KOTLI"),
("31","Abdul Hafeez","Mian Alam","3420103737425","Punjab","GUJRAT"),
("32","Abdul Hafeez","Abdul Aziz","3830187839633","Punjab","Mianwali"),
("33","Abdul Hafeez","Muhammad Ibrahim","3540416062129","Punjab","Sheikhupura"),
("34","Abdul Hafeez Raza ","Abdul Rasheed Gujjar ","3110311500407","Punjab","BAHAWALNAGAR"),
("35","Abdul Hakeem ","Ahmed Caste Nasar Zahri Caste Zakri","5650348384365","Balochistan","ZHOB"),
("36","Abdul Haleem","Ilam Din","3540148953461","Punjab","Sheikhupura"),
("37","Abdul Haleem @ Saifullah ","Muhammad Razzaq (Haleem)","4240184637399","Sindh","Karachi"),
("38","Abdul Hameed ","Janan Kashmiri","","Sindh",""),
("39","Abdul Hameed","Muhammad Yousaf","3320308396977","Punjab","Jhang"),
("40","Abdul Hameed","Bagh Ali","3630246141029","Punjab","MULTAN"),
("41","Abdul Hameed","Muhammad Nawaz","4250114449559","Punjab","RAJANPUR"),
("42","Abdul Hameed","Haji Tilan ","3240462832361","Punjab","RAJANPUR"),
("43","Abdul Hameed","Hameed Gul","1430143617655","KP","KOHAT"),
("44","Abdul Hameed ","Abdul Ghafoor ","5160211409965","Balochistan","QUETTA"),
("45","Abdul Hameed alias Abu Dajana","ABDUL MAJEED ","3220390658069","Punjab","LAYYAH"),
("46","Abdul Hameed Bugti","Ali Murad Bugti","0000000000005","Sindh","KARACHI SOUTH"),
("47","Abdul Hameed Khalid","Khalil","3810247160353","Punjab","BHAKKAR"),
("48","Abdul Hameed Khan","Rahim Bakhsh ","3120102813963","Punjab","BAHAWALPUR"),
("49","Abdul Hanan ","Muhammad Sardar","3660128812233","Punjab","VEHARI"),
("50","Abdul Hanan alias Sheikh Hanan","Abdul Waheed ","3230443831503","Punjab","BAHAWALPUR"),
("51","Abdul Hanan Farooqi ","Salabit Ali ","3330394233387","Punjab","TOBA TEK SINGH"),
("52","Abdul Haq","Taj Muhammad/Haji","1730119767069","KP","PESHAWAR"),
("53","Abdul Islam","Akhtar Ali","3110416954291","Punjab","BAHAWALNAGAR"),
("54","Abdul Jabbar","Muhammad yousaf","3460284918843","Punjab","Sialkot"),
("55","Abdul Jabbar ","Ahmad Ali ","3310028671433","Punjab","FAISALABAD"),
("56","Abdul Jabbar","Abdul Khaliq","3610297550021","Punjab","KHANEWAL"),
("57","ABDUL JABBAR","MIAN MUHAMMAD HUSSAIN","3420233630033","Punjab","GUJRAT"),
("58","Abdul Jabbar","Hakim Ali Mallah","4530471615359","Sindh","N-Feroze"),
("59","Abdul Jabbar ","Sher Shah ","3310038471557","Punjab","CHAKWAL"),
("60","Abdul Jabbar","Abdul Ghafoor","3240341783017","Punjab","RAJANPUR"),
("61","Abdul Jalil","Kechi Khan","5440012024887","Balochistan","QUETTA"),
("62","Abdul kabeer","Ghullam Shabir","3320274623087","Punjab","Jhang"),
("63","Abdul Karam ","Gul","1111111111110","KP","PESHAWAR"),
("64","ABDUL KAREEM","KHUDA BAKHSH","3220280631795","Punjab","Layyah"),
("65","Abdul Kareem alias Asad (Chohan)","Muhammad Hafeez","3650169802817","Punjab","SAHIWAL"),
("66","Abdul Kareem alias Bagu ","Malik Muhammad Musa ","3120103552155","Punjab","BAHAWALPUR"),
("67","Abdul karim ","Abdul Sattar (late) ","3240214531357","Punjab","RAJANPUR"),
("68","Abdul Khaliq ","Ahmed Khan ","3310502911799","Punjab","FAISALABAD"),
("69","Abdul Khaliq","Mian Muhammad","6110142161485","Punjab","ATTOCK"),
("70","Abdul Khaliq "," Abdul Ur Rehman","8230107943359","AJ&K","Kot Kuian Abbaspur, Poonch"),
("71","Abdul lateef","Chauhdary Muhammad Sidique","3320268796295","Punjab","Jhang"),
("72","Abdul Lateef Lashari","Piyara Khan Lashari","5340333762323","Balochistan","JAFFARABAD"),
("73","Abdul Latif ","Muhammad ","3110185982115","Punjab","BAHAWALNAGAR"),
("74","Abdul Latif alias Abdul Latif  ","Nizam Ul Din","3630293288803","Punjab","MULTAN"),
("75","Abdul Latif Tariq ","Muhammad Din ","3730122469713","Punjab","JHELUM"),
("76","Abdul Majeed ","Lal Khan","3210209199605","Punjab","DERA GHAZI KHAN"),
("77","ABDUL MAJEED","ABDUL RASHEED","3220209649867","Punjab","LAYYAH"),
("78","Abdul Majeed ","Muhammad Yusuf","1310164241659","Punjab","Gujrat"),
("79","Abdul Majeed ","Abdul Salam","5621038467033","Balochistan","KILLA SAIFULLAH"),
("80","Abdul Majeed ","Muhammad Yousaf","1310164244659","Punjab","GUJRAT"),
("81","Abdul Majeed","Allah Ditta","3810261319559","Punjab","BHAKKAR"),
("82","Abdul Majeed @ Javed ","Abdul Malik Brohi","4330490512693","Sindh","Shikarpur"),
("83","Abdul Majeed Sajid","Ghulam Haider","3320199491083","Punjab","CHINIOT"),
("84","Abdul Majid ","Muhammad Hanif Anwar ","3410352991651","Punjab","GUJRANWALA"),
("85","Abdul Majid alias Saad Ullah","Jan Muhammad","3530232262661","Punjab","OKARA"),
("86","Abdul Manan","Muhammad Afzal","3520247249315","Punjab","LAHORE"),
("87","Abdul Manan","Abdul Aziz","3630269320369","Punjab","MULTAN"),
("88","Abdul Mateen ","Abdul Hameed Khan ","3210227021661","Punjab","DERA GHAZI KHAN"),
("89","Abdul Mateen","Gul","1570444343623","KP","UPPER DIR (AT DIR)"),
("90","Abdul Matin ","Abdul Raheem ","3450247197315","Punjab","Narowal"),
("91","Abdul Maula","Syed Sharif","1540289118247","KP","MALAKAND P.A."),
("92","Abdul Qadeer ","Abdul Rehman ","4130374333995","Sindh","Hyderabad"),
("93","Abdul Qadeer alias Sheikh ","Sheikh Abdullah","3740579843871","Punjab","RAWALPINDI"),
("94","Abdul Qadeer Khalti ","Sher Muhammad","3240391285837","Punjab","RAJANPUR"),
("95","Abdul Qadoos Nadeem "," Ahsan-ul-Haq","3320313589105","Punjab","JHANG"),
("96","Abdul Qadus","Abdul Wahid","5170103396819","Balochistan","WASHUK"),
("97","Abdul Qayoom","Sher jan","1710103992313","Sindh","KAMBAR SHAHDADKOT"),
("98","Abdul Qayoum ","Abdul Haq","NIL","Sindh","Hyderabad"),
("99","Abdul Qayum","Gul Zada","1530586034943","KP","LOWER DIR (AT TEMERGARA)"),
("100","Abdul Qayyum","Muhammad Siddique","3720360483793","Punjab","CHAKWAL"),
("101","Abdul Qayyum","Muhammad Inayat","3710407572473","Punjab","Attock    "),
("102","Abdul Qayyum Chohan ","Manzoor Ahmed ","3460297394857","Punjab","SIALKOT"),
("103","Abdul Qayyum Usmani ","Imam Bakhsh ","3810271630553","Punjab","BHAKKAR"),
("104","Abdul Raheem ","Abdul Qadir","3660213853745","Punjab","VEHARI"),
("105","Abdul Rahim","Nawaz Mir Wali","1410191045365","KP","Hangu"),
("106","Abdul Rasheed ","Ch. Abdul Latif ","3410249729783","Punjab","GUJRANWALA"),
("107","Abdul Rasheed alias Kutian Wala ","Abdul Rehman ","3530227979275","Punjab","OKARA"),
("108","Abdul Rasheed alias Peer Jee ","Dost Muhammad ","3130161104227","Punjab","RAHIM YAR KHAN"),
("109","Abdul Rasheed Shah ","Abdullah Shah Bukhari","4550436797357","Sindh","Sukkur"),
("110","ABDUL RAUF","MUHAMMAD ALI","3630266591243","Punjab","Multan"),
("111","Abdul Rauf alias Doctor ","Allah Ditta Khan ","3240368996787","Punjab","RAJANPUR"),
("112","Abdul Rauf alias Rofi ","Gull Ahmad Shah ","3120195572519","Punjab","BAHAWALPUR"),
("113","Abdul Rauf Asghar ","Allah Bakhsh Sabir ","3120267899419","Punjab","BAHAWALPUR"),
("114","Abdul Rauf Nizami ","Muhammad Abdullah Nizami","8220309539299","AJ&K","MUZAFFARABAD"),
("115","Abdul Razaq","Abdul Ghafoor","1540225329295","KP","MALAKAND P.A."),
("116","Abdul Raziq","Abdul Jabbar","1210111140677","KP","DERA ISMAIL KHAN"),
("117","Abdul Raziq","Sikandar Shah","1610111582481","KP","MARDAN"),
("118","Abdul razzaq","Muhammad Hussain","3320314285209","Punjab","Jhang"),
("119","Abdul Razzaq ","Muhammad Ismail Panhwar","4540135201729","Sindh",""),
("120","Abdul Razzaq ","Mukhtar Ahmed","4210115098729","Sindh","Karachi"),
("121","Abdul Razzaq","Muhammad Khan","1540257041987","KP","MALAKAND P.A."),
("122","Abdul Razzaq ","Abdul Rehman ","3810160651693","Punjab","BHAKKAR"),
("123","Abdul Rehman","Wazir Ahmed Tahir","3840320506127","Punjab","SARGODHA"),
("124","Abdul Rehman ","Abdul Hameed ","3240271987885","Punjab","RAJANPUR"),
("125","Abdul Rehman ","Patay Ullah Khan ","3840177568133","Punjab","CHAKWAL"),
("126","Abdul Rehman","Rorai","1530713681769","KP","LOWER DIR (AT TEMERGARA)"),
("127","Abdul Rehman","Badshah Rehman","1530476050609","KP","Dir Lower"),
("128","Abdul Rehman","Bakht Zaib Bacha","1530787564025","KP","LOWER DIR (AT TEMERGARA)"),
("129","Abdul Rehman","Amir Khan","1620193952989","KP","SWABI"),
("130","Abdul Rehman ","Gul Nawaz","2170556512019","Sindh","Karachi"),
("131","Abdul Rehman ","Rasheed Ahmad ","3320371645081","Punjab","FAISALABAD"),
("132","Abdul Rehman ","Abdul Shakoor ","3310280324005","Punjab","FAISALABAD"),
("133","Abdul Rehman ","Muhammad Ramzan ","3320267483611","Punjab","RAWALPINDI"),
("134","Abdul Rehman ","Abdul Hameed ","3120102903865","Punjab","BAHAWALPUR"),
("135","Abdul Rehman","Noor Muhammad","3540116384153","Punjab","Sheikhupura"),
("136","Abdul Rehman @ Ibrahim ","Habib ur Rehman ","NIL","Sindh","Karachi"),
("137","Abdul Rehman Abid","Muhammad Shareef","3330120782383","Punjab","Sheikhupura"),
("138","Abdul Rehman alias Manna ","Khushi Muhammad","3120570621759","Punjab","BAHAWALPUR"),
("139","Abdul Rehman alias Rehmani","ABDUL SHAKOOR","3220274638329","Punjab","LAYYAH"),
("140","Abdul Rehman Nasir Caste Raja","Raja Nasir Nawaz","3730156181161","Punjab","JHELUM"),
("141","Abdul Saboor Shakir ","Muhammad Aziz ","3310627363805","Punjab","TOBA TEK SINGH"),
("142","Abdul Saeed","Dost Muhammad","1530585643919","KP","LOWER DIR (AT TEMERGARA)"),
("143","Abdul Salaam","Muhib Ullah (Ghareeb Ullah)","1570174089677","KP","Dir Upper"),
("144","Abdul Salam","Muhammad Bakhsh","3620209196933","Punjab","LODHRAN"),
("145","Abdul Salam","Muhammad Yousaf","3460229127191","Punjab","Sialkot"),
("146","Abdul Salam ","Hafiz Muhammad Abu Al-Qasim","3530183876747","Punjab","SHEIKHUPURA"),
("147","Abdul Salik (alias Abdul Malik)","Abdul Hakeem Khan","8240155815169","AJ&K","SUDHNOTI"),
("148","Abdul Samad","Muhammad Amin","3540453357213","Punjab","Sheikhupura"),
("149","Abdul Samad","Abdul Salam","1330249184593","KP","HARIPUR"),
("150","Abdul Samad alias Abdul Qahar ","Mouj Ali","3420214046047","Punjab","RAJANPUR"),
("151","Abdul Sami","Mian Allah Bakhsh","3230433351699","Punjab","MUZAFFARGARH"),
("152","Abdul Sami @ Abdul Samad ","Samiullah","2170584649159","Sindh","Karachi"),
("153","Abdul Sami Yasir alias Ubaid Caste Thaheem","Abdul Rehman","3120267326787","Punjab","BAHAWALPUR"),
("154","Abdul Sattar","Haji Yar Muhammad","3210380441065","Punjab","DERA GHAZI KHAN"),
("155","Abdul Sattar ","Sufi Allah Ditta ","3460233094959","Punjab","SIALKOT"),
("156","Abdul Sattar","Muhammad Ali","3540416369739","Punjab","Sheikhupura"),
("157","Abdul Sattar","Ghullam Rasool","3320314041115","Punjab","JHANG"),
("158","Abdul Sattar","hafiz Ahmed Din","3320403397933","Punjab","Jhang"),
("159","Abdul Sattar ","Muhammad Hussain ","3210343848541","Punjab","DERA GHAZI KHAN"),
("160","Abdul Sattar alias Pammi","Abdul Khaliq","3610257636161","Punjab","KHANEWAL"),
("161","Abdul Shakoor","Muhammad Yousaf","3610227241803","Punjab","Khanewal"),
("162","Abdul Shakoor ","Bashir Ahmed alias Abdul Rehman Malik","4530172820607","Sindh","N-Feroze"),
("163","Abdul Wahab","Muhammad Rahim Khan","8230301359869","AJ&K","Khirk Rawalakot"),
("164","Abdul Wahab","Muhammad Iqbal","1540297990043","KP","MALAKAND P.A."),
("165","Abdul Wahab","Habib Gul","","KP","Peshawar"),
("166","ABDUL WAHAB","ABDUL JABBAR","3640189189903","Punjab","Pakpattan"),
("167","Abdul Wahab","Akhtar Ali","3110437468935","Punjab","BAHAWALNAGAR"),
("168","Abdul Wahab","Aziz Ullah Khan","3840392400121","Punjab","SARGODHA"),
("169","Abdul Wahab Alias Sani","Haji Ghulam Yasin","1210148070905","KP","DERA ISMAIL KHAN"),
("170","Abdul Waheed","Dost Muhammad","3320295237309","Punjab","Jhang"),
("171","Abdul Waheed","Abdul Aziz ","3710410063167","Punjab","ATTOCK"),
("172","Abdul Wahid @  Lala Gudu ","Ghulam far","4210172145165","Sindh","Karachi"),
("173","Abdul Wajid Abbasi ","Ghulam Mustafa Abbasi ","3740505649697","Punjab","RAWALPINDI"),
("174","Abdul Wajid Farooqi","Ahmad Nawaz","3710144535183","Punjab","ATTOCK"),
("175","Abdul Wakeel ","Qari Abdul Baqi","1530385841935","KP","LOWER DIR (AT TEMERGARA)"),
("176","Abdul Wali @ Umer Khurasani @ Umer Khalid @ Doctor","Hafiz Mohammad Hayat","2140619730919","KP","MOHMAND (AT GHALLANAY)"),
("177","Abdull Munaf","Muhammad Khurshid","3620166630221","Punjab","LODHRAN"),
("178","Abdullah","Muhammad Ishaq","1510165056449","KP","BUNER"),
("179","Abdullah","Ghulam Rasool. ","5130158091429","Balochistan","KHARAN"),
("180","Abdullah","Hazrat Khan","1530596804711","KP","LOWER DIR (AT TEMERGARA)"),
("181","Abdullah","Abdul Ghani","1570161433997","KP","UPPER DIR (AT DIR)"),
("182","Abdullah","Muhammad Akbar","1530606618893","KP","Dir Lower"),
("183","Abdullah","Nimat Ullah","1530626590421","KP","LOWER DIR (AT TEMERGARA)"),
("184","Abdullah","Molana Sufi Muhammad","1530547480719","KP","LOWER DIR (AT TEMERGARA)"),
("185","Abdullah","Fateh Muhammad","5440021648967","Balochistan","QUETTA"),
("186","Abdullah @ Nangial","Rehmatullah","2260166939911","KP","S.WAZIRISTAN (AT WANA)"),
("187","Abdullah Farooqi ","Wali Mohammad","5120196872547","Balochistan","KALAT"),
("188","Abdullah Jan ","Bhai Khan","5650318423001","Balochistan","ZHOB"),
("189","Abdullah Langove","Haji Rasool Bakhsh","5120135170049","Balochistan","SOHBATPUR"),
("190","Abdullah Noorzai","Yaroo Noorzai ","5160297883601","Balochistan","LASBELA (AT UTHAL)"),
("191","Abdur Rahman","Mulana Sufi Muhammad","1530501509487","KP","LOWER DIR (AT TEMERGARA)"),
("192","Abdur Rehman","Ghulam Rasool","3740102128091","Punjab","SARGODHA"),
("193","Abid Ali","Muhammad Amin","1610101452025","KP","MARDAN"),
("194","Abid Ali","Mehr Ameer","3320245271539","Punjab","Jhang"),
("195","Abid Ali","Ali Ahmed","3460193057529","Punjab","Sialkot"),
("196","Abid Hussain","Muhammad Hussain","3220231230187","Punjab","LAYYAH"),
("197","Abid Hussain alias Farooqi (Wattoo)","Muhammad Warsi","3660290274583","Punjab","VEHARI"),
("198","Abid Hussain alias Moulana Abid Usmani ","Mehboob Ahmad Khan ","3630141685907","Punjab","BAHAWALPUR"),
("199","Abid Hussain Memon","Alim Hyder ","4330405554195","Sindh","SHIKARPUR"),
("200","Abid Mahmood ","Abdul Shakoor ","3120317279125","Punjab","BAHAWALPUR"),
("201","Abid Majeed ","Abdul Majeed","3520122270025","Punjab","LAHORE"),
("202","Abid Mehmood ","Noor Deen","4150404003973","Punjab","CHAKWAL"),
("203","Abid Rasheed Nayyar ","Abdul Rasheed ","3810266585129","Punjab","BHAKKAR"),
("204","Abid Ur Rahman","Abdur Rahman","1720124592465","KP","NOWSHERA"),
("205","Abid-ur-Rehman Asad ","Anwar Hussain ","3840125359841","Punjab","SARGODHA"),
("206","Abu Bakar ","Shareef-u-Deen ","3810106697559","Punjab","BHAKKAR"),
("207","Abu Bakkar","Abdul Majeed","3320211865547","Punjab","Jhang"),
("208","Abu Bakkar","Asghar hussain","3320255369985","Punjab","Jhang"),
("209","Abu Hafza Umaruddin ","Muhammad Hanif Malik","NIL","Sindh","Sukkur"),
("210","Abu Zar alias Sabir","Muhammad Akbar","3510273314311","Punjab","KASUR"),
("211","Abu Zar Hussain"," GHULAM NABI","3220339748931","Punjab","LAYYAH"),
("212","Abubakar","Mian Gul","","KP","Dir Upper"),
("213","Abuzar Hussnain ","Mukhtar Hussain ","3320404927389","Punjab","JHANG"),
("214","Adam Badshah","Abdul Wahid","1530722939941","KP","LOWER DIR (AT TEMERGARA)"),
("215","Adeel Ashiq ","Ashiq Hussain ","3410431749011","Punjab","GUJRANWALA"),
("216","Adeel Raza Kazmi ","Shabeer Shah ","3240412625527","Punjab","RAJANPUR"),
("217","Adil Sher ","Muhammad Khalid","3310493216643","Punjab","HAFIZABAD"),
("218","Adnan Ali Khan","Malik Shamroz Khan","3710342205645","Punjab","ATTOCK"),
("219","Adnan Rasheed","Malik Sher","1620107227227","KP","SWABI"),
("220","Afsar Abbas Alias Moon Shah","Jaffar Abbas","3320117555353","Punjab","CHINIOT"),
("221","Afsar Ali","Muhammad Ali","1110176810783","KP","BANNU"),
("222","Aftab Ahmad ","Muhammad Sadiq ","3630206205607","Punjab","MULTAN"),
("223","Aftab Ahmad ","Mashooq Ali ","3450157955995","Punjab","NAROWAL"),
("224","Aftab Ahmad ","Jan Muhammad ","3320278962823","Punjab","JHANG"),
("225","Aftab Ahmad Saddique ","Tariq Ahmad Saddique ","3630204066803","Punjab","MULTAN"),
("226","Aftab Asghar ","Asghar Ali ","3120375418909","Punjab","BAHAWALPUR"),
("227","Aftab Shafi "," M. Shafi","8230389224517","AJ&K","Chak Dhamni,District Poonch"),
("228","Afzaal Ahmed Jaffery","Piran Ditta","3420317163019","Punjab","GUJRAT"),
("229","Agha Syed Ali Rizvi ","Syed Muhammad Ali Shah","7110371773065","Gilgit-Baltistan","BALTISTAN (AT SKARDU)"),
("230","Agha Yasir Raza","Agha Ali Raza","3810135498515","Punjab","BHAKKAR"),
("231","Ahmad Bakhsh ","Rabnawaz","3810208723177","Punjab","BHAKKAR"),
("232","Ahmad Ghani","Shah Jan","1560205022561","KP","SWAT (AT MINGORA)"),
("233","Ahmad Hassan ","Muhammad Amin ","3130342341941","Punjab","RAHIM YAR KHAN"),
("234","Ahmad Hussain","Qari Muhammad Zarib","1560256586579","KP","SWAT (AT MINGORA)"),
("235","Ahmad Hussain @ Ayeen","Akbar Khan","1510199111729","KP","BUNER"),
("236","Ahmad Hussain @ Ghat Haji","Abbas Kheil Meshood","2170500000000","KP","DERA ISMAIL KHAN"),
("237","Ahmad Idrees alias Butt Sub","Muhammad Idrees Butt","3420107132125","Punjab","GUJRAT"),
("238","Ahmad Khan","Tati","1570481395753","KP","UPPER DIR (AT DIR)"),
("239","Ahmad Noor .","Shamim Ahmed","4240188051059","KP","LOWER DIR (AT TEMERGARA)"),
("240","Ahmad Raza alias Inam Khan ","Laiq Raza ","3420179890337","Punjab","GUJRAT"),
("241","Ahmad Riaz","Amin Gul","1560267702701","KP","SWAT (AT MINGORA)"),
("242","Ahmad Said @ Osama","Akbar Khan","1510125151681","KP","BUNER"),
("243","Ahmad Saood Khan","Ameer Ali Khan","3330120879109","Punjab","Jhang"),
("244","Ahmad Ullah","Sher Ahmed","1530315329475","KP","LOWER DIR (AT TEMERGARA)"),
("245","Ahmad Zada","Mohammad Raziq","1570172473493","KP","UPPER DIR (AT DIR)"),
("246","Ahmed ","","4210114146311","Sindh","Karachi"),
("247","Ahmed Saeed ","Dil Pazeer ","3710521783535","Punjab","ATTOCK"),
("248","Ahmed Ullah @ Muhammad Ullah","Abdul Qayyum","2170252272275","Sindh","Karachi"),
("249","Ahmed Umair Saeed Shaik @ Chaoudry Bashir","Saeed Ahmed Shaikh","0000000000001","Sindh","KARACHI SOUTH"),
("250","Ahsan Abbas ","Khadam Hussain ","3610247077201","Punjab","KHANEWAL"),
("251","Ahsan Ishfaq alias Sunny ","Muhammad Ishfaq Khalid","3810189766667","Punjab","BHAKKAR"),
("252","Ahsan Nawaz","Muhammad nawaz","3320404983599","Punjab","Jhang"),
("253","Ahsan Ullah","Aman Ullah","3810233914099","Punjab","BHAKKAR"),
("254","Ahsan Ullah ","Malik Saif Ullah ","3810239286097","Punjab","BHAKKAR"),
("255","Ahsan Ullah ","Aman Ullah ","3810176456113","Punjab","BHAKKAR"),
("256","Ahsan ullah Zia","Muahammad Zia ud Din Zia","3540468920245","Punjab","Sheikhupura"),
("257","Ajab Noor","Noor Muhammad ","5630212379907","Balochistan","QUETTA"),
("258","Ajmal","Kamal Caste Mamuzai","2160479143263","KP","KOHAT"),
("259","Ajmal","Gul Shali Khan","4250120599323","KP","BAJAUR (AT KHAR BAJAUR)"),
("260","Ajmal Abbas ","S/o Ghulam Abbas ","3810106340407","Punjab","BHAKKAR"),
("261","Ajmal Hassan ","Abdul Majeed ","3310007466359","Punjab","FAISALABAD"),
("262","Ajmal Khan ","Afsar Khan","1310181051085","Sindh","Karachi"),
("263","Ajmal Khan","Badshah Zaman","1530702954669","KP","LOWER DIR (AT TEMERGARA)"),
("264","Ajoy Mistry","b","1111111111117","KP","PESHAWAR"),
("265","Akbar @ Haq Dad @ Akoo ","Palay Khan.","5310390719457","Balochistan","KACHHI (BOLAN) (AT DHADAR)"),
("266","Akbar Ali @ Ghulam Akbar ","Mehmood Indher","4550118299895","Sindh","Sukkur"),
("267","Akhtar","Bakht Sultan","1560203445307","KP","SWAT (AT MINGORA)"),
("268","Akhtar Abbas","Muhammad Nawaz","3320362821755","Punjab","Jhang"),
("269","Akhtar Abbas ","Haji Muhammad ","3240294807593","Punjab","RAJANPUR"),
("270","Akhtar Abbas Alias Haidri","Mehram Khan","3320397659969","Punjab","JHANG"),
("271","Akhtar Ali","Muhammad Jahangir","3340104091011","Punjab","CHINIOT"),
("272","Akhtar Ali","Mahi Muhammad","1570108853925","KP","UPPER DIR (AT DIR)"),
("273","Akhtar Ali","Muhammad Ali","1560243412999","KP","SWAT (AT MINGORA)"),
("274","Akhtar Hussain","Manzoor Hussain Bhatti ","3310437048443","Punjab","FAISALABAD"),
("275","Akhtar Hussain","Palwan ","3320313726587","Punjab","JHANG"),
("276","Akhtar Hussain @ Asadullah","Khoro Khan Soomro ","4330448004179","Sindh","THATTA"),
("277","Akhtar Hussain Rajput ","Shafi Muhammad","4530401696277","Sindh","N-Feroze"),
("278","Akhtar Mehmood ","Abdul Rehman Khan","3740175911243","Punjab","RAWALPINDI"),
("279","Akhtar Muhammad Khalil","Gul Roz","1111111111166","KP","BANNU"),
("280","Akhtar Nawaz","Muhammad Kamal","1730157946715","KP","Peshawar"),
("281","Akram ","Murtaza Caste Adozai","5410208203163","Balochistan","KILLA ABDULLAH"),
("282","Alaf Deen","Ghulam Mohiuddin","3710409896487","Punjab","Attock    "),
("283","Alam","Amanat Khan","1530238616821","KP","LOWER DIR (AT TEMERGARA)"),
("284","Alam","Aslam","1120189456693","KP","LAKKI MARWAT"),
("285","Alam Khan","Gojar Khan","4240118048425","KP","MALAKAND P.A."),
("286","Alam Khan","Anat Khan","1530746231403","KP","LOWER DIR (AT TEMERGARA)"),
("287","Alam Zaib","Bahadar","1570123278203","KP","UPPER DIR (AT DIR)"),
("288","Alamdar Hussain","Muhammad Ali","3840253407905","Punjab","SARGODHA"),
("289","Alamdar Hussain ","Manzoor Hussain ","3630213494405","Punjab","MUZAFFARGARH"),
("290","Aleem Khan ","Danya Khan ","2170709216235","Punjab","CHAKWAL"),
("291","Aleem-ur-Rehman","Mubeen Ahmad Khan","3510377731195","Punjab","KASUR"),
("292","Ali Abbas ","Muhammad Siddique ","3320267668461","Punjab","JHANG"),
("293","Ali Abbas Askari","Sajjad Haider","3520275298239","Punjab","LAHORE"),
("294","Ali Abbas Jafery","Ghulam Murtaza Jafery","1330204725015","KP","HARIPUR"),
("295","Ali Akbar","Ali Haidar Jango","1530798142373","KP","LOWER DIR (AT TEMERGARA)"),
("296","Ali Asghar alias Kala ","Muhammad Ali ","3330140457787","Punjab","TOBA TEK SINGH"),
("297","Ali farhan mehdi","Mukhtar Ahmed khan","3320277545465","Punjab","Jhang"),
("298","Ali haider","Anwar ul haq","3320403843173","Punjab","Jhang"),
("299","Ali Haider ","Muhammad Rafique","3320220897691","Punjab","JHANG"),
("300","Ali Hashir ","Muhammad Iqbal ","3320225440983","Punjab","JHANG"),
("301","Ali Hassan","Muhammad Arshad","3340105649207","Punjab","CHINIOT"),
("302","Ali Hassan MIr","Malik Maaz Ullah","1730143719949","KP","PESHAWAR"),
("303","Ali Javaid ","Javaid Zaman","3410168665457","Punjab","GUJRANWALA"),
("304","Ali Khan alias chota Ali","Wali khan","3650234008823","Punjab","SAHIWAL"),
("305","Ali Muhammad ","Nazar Muhammad ","3650226297459","Punjab","SAHIWAL"),
("306","Ali Muhammad Abu Turab","Noor Muhammad ","5440004591153","Balochistan","QUETTA"),
("307","Ali Muhammad Karimi  ","Ali ","7110254021039","Gilgit-Baltistan","SHIGAR"),
("308","Ali Muhammad Shahzad alias Abu Talha Khawaj (Arain","Shah Muhammad ","3650205829019","Punjab","SAHIWAL"),
("309","Ali raza","Muhammad Ameer Abbas","3320403698615","Punjab","Jhang"),
("310","Ali Raza ","Muhammad Shafi ","3320148071297","Punjab","CHINIOT"),
("311","Allah Bachaya ","Muhammad Abdullah ","3120117718427","Punjab","BAHAWALPUR"),
("312","Allah Bakhsh ","Abdul Rehman ","3240216058007","Punjab","RAJANPUR"),
("313","Allah Dad","Ghulam Farid","1210155445769","KP","DERA ISMAIL KHAN"),
("314","Allah dino","Loung Sheedi","4410121654937","Sindh","Mirpurkhas"),
("315","Allah Dino Bhutto ","Muhammad Ali Bhutto","4320596930267","Sindh","Larkana"),
("316","Allah Ditta","Muhammad Ali","3530368588839","Punjab","Okara"),
("317","Allah Ditta","Ghulam Fareed","3540415832313","Punjab","Sheikhupura"),
("318","Allah Ditta","Muhammad Ali","3320213288535","Punjab","Jhang"),
("319","Allah Ditta Farooqi ","Haji Qadir Bakhsh ","3210233461749","Punjab","DERA GHAZI KHAN"),
("320","Allah Ditta Nadeem","Qasim Ali","3320248746839","Punjab","Jhang"),
("321","Allah Mehar alias Fani ","Shafi Muhammad ","3530204431051","Punjab","OKARA"),
("322","Allah Rakha ","Allah Yar","3660284987167","Punjab","VEHARI"),
("323","ALLAH RAKHA ","MUHAMMAD YASIN ","3640248361679","Punjab","Pakpattan"),
("324","Allah Wasaya ","Budha Khan ","3210224817425","Punjab","DERA GHAZI KHAN"),
("325","Allama Sabtain Sherazi","Syed Muhammad Hussain Sherazi","6110119226849","ICT","ISLAMABAD\n\n"),
("326","Altaf Ahmed Shaikh @ Abu Bilal","Sagheer Ahmed Shaikh","4130427463747","Sindh","Hyderabad"),
("327","Altaf Hussain","Ameer Shah","3320363672497","Punjab","Jhang"),
("328","Aman Ullah","Rehman Ullah","1510180625279","KP","BUNER"),
("329","Aman Ullah","Hassan Khan","1530661268781","KP","LOWER DIR (AT TEMERGARA)"),
("330","Aman Ullah alias Muhammad Asif ","Muhammad Qasim ","3120298607481","Punjab","BAHAWALPUR"),
("331","Amanullah Maheri ","Muhammad Ramzan Maheri ","4110210122367","Sindh"," Badin "),
("332","Ameer Hamza","Ghulam Hassan","3810261534751","Punjab","BHAKKAR"),
("333","Ameer Hamza","Muhammad Munir","3460340324413","Punjab","SIALKOT"),
("334","Ameer hamza Bhatti Aajiz","Abdull Ali","3320142080461","Punjab","Jhang"),
("335","Ameer Umar Alvi","Ali Muhammad Alvi","3810287063097","Punjab","BHAKKAR"),
("336","Amin Khan","Ayub Khan","1720128473711","KP","NOWSHERA"),
("337","Amin Khan","Khan Sahib","1620247488649","KP","HARIPUR"),
("338","Amin Zada","Amin ul Haq","1530632452905","KP","LOWER DIR (AT TEMERGARA)"),
("339","Amir","Said Ghafoor","1620297556809","KP","SWABI"),
("340","Amir ","Sher Muhammad ","3340103463037","Punjab","CHINIOT"),
("341","Amir Abdullah","Purdul Khan","1510103318287","KP","BUNER"),
("342","Amir Afzal","Sabir Khan","1510185515245","KP","BUNER"),
("343","Amir Alam","Muhammad Rahim","1550117115775","KP","SHANGLA (AT ALPURI)"),
("344","Amir Ali @ Chanda.","Ameer Jan","5440014383039","Balochistan","QUETTA"),
("345","Amir Hatam","Bakht Biland","4240116703549","KP","SWAT (AT MINGORA)"),
("346","Amir Khan","Khuni Jan","1530504191429","KP","LOWER DIR (AT TEMERGARA)"),
("347","Amir Nawab","Fazal Khaliq","1530209612699","KP","LOWER DIR (AT TEMERGARA)"),
("348","Amir Nawab","Ziarat Gul","1540237413415","KP","MALAKAND P.A."),
("349","Amir Rasheed","Abdul Rasheed","3420104993935","Punjab","GUJRAT"),
("350","Amir Rehman","Jawdar","1530503894475","KP","LOWER DIR (AT TEMERGARA)"),
("351","Amir Sadiq","Muhammad Sadiq","1310103106557","KP","ABBOTTABAD"),
("352","Amir Shah","Ghulam Rasool","1570112316231","KP","Dir Upper"),
("353","Amir Shehzad","Shrafat Ali","3720136252477","Punjab","CHAKWAL"),
("354","Amir Zaib","Muhammad Zaib ","1530209090389","KP","LOWER DIR (AT TEMERGARA)"),
("355","Amjad","Jan Said","1530190778619","KP","LOWER DIR (AT TEMERGARA)"),
("356","Amjad","Sadiqu Akhunzada","1530182384037","KP","LOWER DIR (AT TEMERGARA)"),
("357","Amjad Abbas ","Ghulam Abbas ","3810106268201","Punjab","BHAKKAR"),
("358","Amjad Abbas","Khaliq Dad Khan","3310556561329","Punjab","FAISALABAD"),
("359","Amjad Ali","Munawar Khan (Mansoor)","4240102485641","KP","ABBOTTABAD"),
("360","Amjad Ali alias Rana Sahab ","Manzoor Hussain","3630270548553","Punjab","MULTAN"),
("361","Amjad Iqbal Abbasi ","Khaliqdad Khan ","3740444348381","Punjab","RAWALPINDI"),
("362","Amjad Madni ","Dost Muhamamd Madni","4540209577021","Sindh","Shaeed Benizrabad"),
("363","Amjad Nawaz","Nawaz Khan","1120178731929","KP","LAKKI MARWAT"),
("364","Amjid Ali","Nizam-ud-Din","3810107483009","Punjab","BHAKKAR"),
("365","Amjid Hussain","Saeed Gul","1540226744145","KP","MALAKAND P.A."),
("366","Anayat Abbas ","Talib Hussain ","3310425711181","Punjab","FAISALABAD"),
("367","Anees Ahmed","Muhammad Yousaf","3320403746801","Punjab","Jhang"),
("368","Anees ur Rehman ","Muhammad Asif ","NIL","Sindh","Karachi"),
("369","Anees-ur-Rehman ","Fateh Muhammad","3460140556597","Punjab","SIALKOT"),
("370","Angara Appaji","c","1111111111118","KP","PESHAWAR"),
("371","Ansar","Mir Azam","Gx11038176371","KP","Dir Lower"),
("372","Ansar Abbas","Dost Muhammad Khan ","3240367775393","Punjab","RAJANPUR"),
("373","Ansar Abbas Caste Baloch","Rajab Ali","3330239078627","Punjab","TOBA TEK SINGH"),
("374","Ansar Ali ","Mandost","5320308783967","Balochistan","SOHBATPUR"),
("375","Ansar Altaf ","M. Altaf","8210137454477","AJ&K","Rawli Dhokan, Hari Gehl Bagh"),
("376","Ansar Manzoor ","Ch. Manzoor Akhtar ","3740588497693","Punjab","RAWALPINDI"),
("377","Ansir","Muhammad Sadiq","","KP","Haripur"),
("378","Anwaar Haider ","Ghulam Haider ","3201322619067","Punjab","DERA GHAZI KHAN"),
("379","Anwar","Said ul Zaman","1560212806411","KP","SWAT (AT MINGORA)"),
("380","Anwar","Fateh Muhammad","1530511905561","KP","LOWER DIR (AT TEMERGARA)"),
("381","Anwar Ali Shah","Bakht Shahzada","1530605105979","KP","LOWER DIR (AT TEMERGARA)"),
("382","Anwar Bahadar","Sher Malik","1620303635569","KP","SWABI"),
("383","Anwar Khan","Khair Ullah","1530526980147","KP","LOWER DIR (AT TEMERGARA)"),
("384","Anwar Said","Muhammad Said","1560203474515","KP","SWAT (AT MINGORA)"),
("385","Anwar Zamin","Shah Tamaz Khan","1530651006617","KP","LOWER DIR (AT TEMERGARA)"),
("386","Anwar Zeb","Badesh","1510126697083","KP","BUNER"),
("387","Anyat Ullah ","Allah Yar","3210347594491","Punjab","DERA GHAZI KHAN"),
("388","Aoun Ali Shahbaz ","Shahbaz Ahmad ","3230329274927","Punjab","MUZAFFARGARH"),
("389","Aqeel Ahmad","Raees Ahmad","3840181114869","Punjab","SARGODHA"),
("390","Aqeel Raza ","Mukhtiar Ahmad ","3230381333737","Punjab","MUZAFFARGARH"),
("391","Arib Hussain Umrani"," Din Mohammad","5340407951215","Balochistan","JAFFARABAD"),
("392","Arif Hussain","Khadim Hussain","3810240280197","Punjab","BHAKKAR"),
("393","Arif Saeed ","Khan Muhammad ","3630242864813","Punjab","MULTAN"),
("394","Arman Waseem Dar (Daar)","Shahzad Waseem Dar","3730158197451","Punjab","JHELUM"),
("395","Arshad @ Megay","Ali Bakhash","1730154475917","KP","PESHAWAR"),
("396","Arshad Ali","Alamgir","1560289874745","KP","SWAT (AT MINGORA)"),
("397","Arshad Ali Ansari ","Ghulam Nabi ","3630263129055","Punjab","MULTAN"),
("398","Arshad Hussain Shah","Asghar Ali Shah","3420111493837","Punjab","GUJRAT"),
("399","Arshad Mehmood Qadri","Noor Ahmad Awan","3710181081809","Punjab","Attock    "),
("400","Arslan Saeed ","Malik Mohsin Saeed","3510129693037","Sindh","Karachi"),
("401","Asad Aftab","Aftab Ahmad","3520285902911","Punjab","LAHORE"),
("402","Asad Ali","Muhammad Din Chishti","3330109759423","Punjab","T.T.Singh"),
("403","Asad Ali @ Bhai jan @ Kaleem @ Rafiullah","Usman Zada ","4220165489197","Sindh","Karachi"),
("404","Asad Ali Naqvi ","Syed Asghar Ali Naqvi ","4410304971639","Sindh","Mirpurkhas"),
("405","Asad Iqbal ","Shah Muhammad","3720357352773","Punjab","CHAKWAL"),
("406","Asad Rehman ","Habib Ur Rehman ","3520229953613","Punjab","LAHORE"),
("407","Asad ul Zaman ","Muzahir Ali","4250107663255","Sindh","Karachi"),
("408","Asad Ullah","Abdul Razaq","1530298536945","KP","LOWER DIR (AT TEMERGARA)"),
("409","Asad Zia","Fawad Khan","1620109773719","KP","NOWSHERA"),
("410","Asghar","Anwar Khan","1620232549879","KP","SWABI"),
("411","Asghar Ali","Abdul Qasim","1560240159739","KP","SWAT (AT MINGORA)"),
("412","Asghar Ali ","Mirza ","3430212314921","Punjab","HAFIZABAD"),
("413","Asghar Ali alias Rana  ","BABU","3310389971127","Punjab","FAISALABAD"),
("414","Asghar Ali Anwar ","Shafi Muhammad ","3410324922635","Punjab","GUJRANWALA"),
("415","Asghar Ali Farooqi","Haji Khan ","5440023344523","Balochistan","KACHHI (BOLAN) (AT DHADAR)"),
("416","Asghar Nadeem ","Muhammad Ashraf ","3830309887809","Punjab","MIANWALI"),
("417","Ashfaq Ahmad ","Masood Ahmad ","3630272738047","Punjab","MULTAN"),
("418","Ashfaq Ahmad","Nazeer Ahmad","3610225668081","Punjab","KHANEWAL"),
("419","Ashraf @ Khan","Said Karim","1760206461915","KP","SWAT (AT MINGORA)"),
("420","Ashraf Ali","Adam Khan","1220140997151","KP","TANK"),
("421","Ashraf Ali","Muhammad Abas","1560281152751","KP","SWAT (AT MINGORA)"),
("422","Ashraf Ali ","Khadim Hussain ","3240413955069","Punjab","RAJANPUR"),
("423","Asif @ Kashi @ Muhavia","Abdul Khaliq","1350365301455","KP","MANSEHRA"),
("424","Asif Ameer ","Muhammad Ameer","3530172921413","Punjab","OKARA"),
("425","Asif Iqbal ","Sibghat ullah","3820212868699","Punjab","KHUSHAB"),
("426","Asif Kamal","Muhammad Shafi (Late)","3720232574743","Punjab","CHAKWAL"),
("427","Asif Masood ","Mazhar Hussain","3720120856801","Punjab","CHAKWAL"),
("428","Asif Mehmood","Ghulam Muhammad","3710428305905","Punjab","Attock    "),
("429","Asif Mehmood","Muhammad Akbar","3810209164813","Punjab","BHAKKAR"),
("430","Asif Naseer alias Asif Raza Alvi ","Naseer Ahmed Alvi ","3310009725171","Punjab","FAISALABAD"),
("431","Asif Rasheed Alias Dumba ","Haroon Rasheed","4240144145585","Sindh","Karachi"),
("432","Asif Raza","Muhammad Hussain","3320403470925","Punjab","Jhang"),
("433","Asif Ullah","Ghulam Muhammad","1730115516979","KP","PESHAWAR"),
("434","Asif Zaheer ","Zaheer uddin ","4220104149639","Sindh","Karachi"),
("435","Asim Ali","Muhammad Afzal","3320183969497","Punjab","CHINIOT"),
("436","Asim Irfan ","Muhammad Sharif ","3630250378733","Punjab","MULTAN"),
("437","Askar Yaqoob","Muhammad Yaqoob","1720122467297","KP","NOWSHERA"),
("438","Aslam","Muhammad Hanif Shaikh","NIL","Sindh","Hyderabad"),
("439","Aslam Aziz","Mian Gul","1530574005701","KP","LOWER DIR (AT TEMERGARA)"),
("440","Asmat Ali","Bunair Gul","1560253062881","KP","SWAT (AT MINGORA)"),
("441","Asmat Ullah","Muhammad Darwaish","1530538235703","KP","LOWER DIR (AT TEMERGARA)"),
("442","Asmat Ullah ","Muhammad Tufail ","3120576204987","Punjab","BAHAWALPUR"),
("443","Asmat Ullah Mauvia ","Buta Khan","Resident of Pakistan","Punjab","Mian Channu Lahore"),
("444","Asmatullah","Rasool Muhammad ","2170575217405","Sindh","Karachi"),
("445","Ateeq-ur-Rehman @ Attique Ahme Mavia","Sher Mohammad ","5150371467909","Balochistan","LASBELA (AT UTHAL)"),
("446","Atiq ur Rehman Chohan","Ghulam Rasool","1730174908381","KP","Haripur"),
("447","Atiq-ur-Rehman","Molvi Abdul Manan.","5630210140695","Balochistan","LORALAI"),
("448","Atta Ullah","Jani Khan.","5310279083799","Balochistan","KACHHI (BOLAN) (AT DHADAR)"),
("449","Atta Ullah","Muhammad Jan","1530569495197","KP","LOWER DIR (AT TEMERGARA)"),
("450","Atta Ullah","Ajab Khan","1730182370993","KP","PESHAWAR"),
("451","Atta Ullah @ Shakir ","Maulana Anwar Ullah ","3330377211755","Punjab","TOBA TEK SINGH"),
("452","Atta Ullah Khan ","Ghulam Rasool ","3210209767755","Punjab","DERA GHAZI KHAN"),
("453","Atta-ul-Mohsin Sial ","Khurshed Ahmad Sial ","3530119399601","Punjab","OKARA"),
("454","Atta-ur-Rehman  ","Faqeer Muhammad","502089745974","Sindh","Karachi"),
("455","Attaullah Miraji Mengal ","Ghulam Rasool.","5140311955911","Balochistan","KHUZDAR"),
("456","Attique-ur-Rehman ","Muhammad Adil ","3520261780013","Punjab","FAISALABAD"),
("457","Attique-ur-Rehman ","Ali Muhammad","3660389010509","Punjab","VEHARI"),
("458","Attique-ur-Rehman ","Ghulam Ali","3410250740943","Punjab","GUJRANWALA"),
("459","Au Zain Ghumma","Muhammad Akram","3840365129869","Punjab","SARGODHA"),
("460","Aurangzaib Khan","Zarq Khan","3320266743811","Punjab","JHANG"),
("461","Aurangzeb ","Noor-ul-Deen Zangi ","3240487430423","Punjab","RAJANPUR"),
("462","Aurangzeb","Zakha","1111111111135","KP","PESHAWAR"),
("463","Aurangzeb ","Muhammad Haleem ","3440348268749","Punjab","MANDI BAHAUDDIN"),
("464","Aurangzeb ","Mohd.Aslam","5650318468639","Balochistan","ZHOB"),
("465","Awais Akram ","Muhammad Akram","3320131884127","Punjab","CHINIOT"),
("466","Awais Latif ","Muhammad Latif Khokhar ","3410425172835","Punjab","GUJRANWALA"),
("467","Awais Mustafa ","Muhammad Younas Aasi ","3650245795535","Punjab","SAHIWAL"),
("468","Ayaz Akhtar ","Muhammad Akhtar Bhatti ","3420148381773","Punjab","GUJRAT"),
("469","Ayaz Ali ","Wadal Khan ","4150604072717","Sindh","JAMSHORO"),
("470","Ayaz Khan Jadoon","Muhammad Akram Khan Jadoon","1310110055521","KP","ABBOTTABAD"),
("471","Ayaz Rasool Aslam ","Rasool Bakhsh Khan ","3230146791155","Punjab","RAJANPUR"),
("472","Ayub","Sher Mohammad","1570150039913","KP","UPPER DIR (AT DIR)"),
("473","Ayub Siyal ","Sagheer Ahmad","3630418967929","Punjab","MULTAN"),
("474","Azam Ali ","Anayat Ali Cheema ","3460155155493","Punjab","SIALKOT"),
("475","Azeem-ul-Shan Haider","Muhammad Basit Taqi","3520201002433","Punjab","LAHORE"),
("476","Azhar Abbas","Khuda bakhash","3320371007991","Punjab","JHANG"),
("477","Azhar Ali ","Muhammad Suleman ","3310463546405","Punjab","FAISALABAD"),
("478","Azhar Hussain ","Manzoor-ul-Hassan ","3310217719021","Punjab","FAISALABAD"),
("479","Azhar Hussain ","Noshad Hussain ","4210184835425","Sindh","Karachi"),
("480","Azhar Iqbal"," Sardar Khan ","3440216985677","Punjab","MANDI BAHAUDDIN"),
("481","Azhar IQbal ","Jaam Allah Diwayia ","3620216688633","Punjab","LODHRAN"),
("482","Aziz Khan","Yar Muhammad","3410481307105","Punjab","Mianwali"),
("483","Aziz Muhammad","Abdul Qahar","1530136318559","KP","LOWER DIR (AT TEMERGARA)"),
("484","Aziz Muhammad","Abdul Qahar","1530209269703","KP","Dir Lower"),
("485","Aziz ul Hamid","Noor Hamid","1510194004035","KP","BUNER"),
("486","Aziz Ullah","Soran","1120130116515","KP","LAKKI MARWAT"),
("487","Aziz Ullah","Fazal Khaliq","1560703582133","KP","SWAT (AT MINGORA)"),
("488","Aziz Ullah","Malik Peer Rehman","2170627693479","KP","S.WAZIRISTAN (AT WANA)"),
("489","Aziz Ullah ","Behrul Wahab","1320123475291","KP","BATAGRAM (AT BANA)"),
("490","Aziz Ullah","Imam Bux Bhutto","4320385664149","Sindh","LARKANA"),
("491","Aziz ur Rehman","Nasib Dad","1550451459241","KP","SHANGLA (AT ALPURI)"),
("492","Aziz ur Rehman","Ismail Darwesh","1730154717511","KP","PESHAWAR"),
("493","Aziz ur Rehman","Ghulam Muhammad","3720391090051","Punjab","CHAKWAL"),
("494","Aziz-ul-Haq alias Asad","Ghulam Fareed","3710189685061","Punjab","ATTOCK"),
("495","Aziz-ur-Rehman ","Abdul Rasheed","3410113988863","Sindh","Karachi"),
("496","Azizur Rahman","Kachkol Muhammad","2110320410683","KP","BAJAUR (AT KHAR BAJAUR)"),
("497","Azmat","Mian Gul","1570147583333","KP","UPPER DIR (AT DIR)"),
("498","Azmat Ali Abid","Haji Manzoor","3520014256365","Punjab","Vehari"),
("499","Azmat Ali Khan","Mehboob Ali Khan","3710484595891","Punjab","Attock    "),
("500","Azmat Khan  "," Hurmat Khan ","7150138209291","Gilgit-Baltistan","GILGIT"),
("501","Baa Khan","Gul Wazir","1111111111112","KP","PESHAWAR"),
("502","Babar Abbas Naqvi","Syed Irshad Hussain Naqvi","3540416219889","Punjab","Sheikhupura"),
("503","Babar Haider Malhi ","Azmat Javed Malhi ","3450119869289","Punjab","NAROWAL"),
("504","Babar Shehzad ","Abdul Sattar ","3320503409985","Punjab","JHANG"),
("505","Bacha Hussain","Zarin Engar","1570175378823","KP","UPPER DIR (AT DIR)"),
("506","Bacha Islam","Jabar","1530160497777","KP","LOWER DIR (AT TEMERGARA)"),
("507","Bacha Said","Muhammad Hakim","1570157595421","KP","UPPER DIR (AT DIR)"),
("508","Bacha Sardar Khan","Abdul Rehman","1530605221311","KP","Dir Lower"),
("509","Bacha Sher","Mulla Jan","1530552729957","KP","LOWER DIR (AT TEMERGARA)"),
("510","BAdar ul Islam","Mubashar Hussain","3520291021387","Punjab","Lahore"),
("511","Badshah Gul","Amin Gul","1530281248123","KP","LOWER DIR (AT TEMERGARA)"),
("512","Bahadar Ali Shah ","Sadiq Hussain Shah ","3440239470395","Punjab","MANDI BAHAUDDIN"),
("513","Bahadar Khan","Shah Murad","1530571265269","KP","LOWER DIR (AT TEMERGARA)"),
("514","Bahadar Khan","Fazal Ghafoor","1530571265263","KP","LOWER DIR (AT TEMERGARA)"),
("515","Bahadar Khan","Toghan Shah","1530232829065","KP","LOWER DIR (AT TEMERGARA)"),
("516","Bakhsh Ali ","Shahi ","3240460504987","Punjab","RAJANPUR"),
("517","Bakht Alam","Muhammad Ali","1720196738227","KP","NOWSHERA"),
("518","Bakht Munir","Abdul  Sadiq","1530516750605","KP","LOWER DIR (AT TEMERGARA)"),
("519","Bakht Rawan","Abdul Jalal @ Muhammad Jamal","1560279839173","KP","Toorghar"),
("520","Bakht Roz","Khan Roz","1570224957141","KP","Dir Upper"),
("521","Bakht Shah Zaib","Bahadar Khan","1530542410561","KP","LOWER DIR (AT TEMERGARA)"),
("522","Bakht Ullah ","Gulab Khan","2170598779473","KP","S.WAZIRISTAN (AT WANA)"),
("523","Bakht Zada","Muhammad Sadeeq","1510165723675","KP","BUNER"),
("524","Bakht Zamin","Muhib Ullah","1560109908375","KP","SWAT (AT MINGORA)"),
("525","Bakht Zamin @ Bakht","Abdul Matin / Abdul Mat Khan","1530604514935","KP","LOWER DIR (AT TEMERGARA)"),
("526","Bakht Zarin","Faiz Talab","1530119323935","KP","LOWER DIR (AT TEMERGARA)"),
("527","Bakht zeb","Khan Zeb","1530749935305","KP","LOWER DIR (AT TEMERGARA)"),
("528","Bakht Zubair @ Zubair","Niamat Ullah","1530209885367","KP","LOWER DIR (AT TEMERGARA)"),
("529","Bakhtaji Gul ","Ahmad Gul ","1510149759947","KP","BUNER"),
("530","Bakhti Rahman","Aziz-ur-Rehman","1510170241559","KP","BUNER"),
("531","Bakhzar Jan","Fateh Muhammad","1530209691765","KP","LOWER DIR (AT TEMERGARA)"),
("532","Balach Khan alias Balash ","Nabi Bakhsh ","3240498707885","Punjab","RAJANPUR"),
("533","Baloch Khan Ramdanzai Mengal","Mohammad Ibrahim.","5140368396841","Balochistan","KHUZDAR"),
("534","Baqir Ali","Ahmed Bakhash","3320392008553","Punjab","Jhang"),
("535","Baqir Raza","Fazal Khan ","3720115483095","Punjab","CHAKWAL"),
("536","Barkat Ullah ","Sher Bahadur Khan ","4250102654929","Sindh","Karachi"),
("537","Basharat Khan ","Jumma Khan ","3320220946855","Punjab","JHANG"),
("538","Bashir","Rahman Ghani","1570142885995","KP","UPPER DIR (AT DIR)"),
("539","Bashir Ahmad","Kashmir Khan","1560205336831","KP","SWAT (AT MINGORA)"),
("540","Bashir Ahmad ","Peer Bakhsh ","3210259156469","Punjab","DERA GHAZI KHAN"),
("541","Bashir Ahmad ","Ameer Nawaz ","1610177969819","KP","MOHMAND (AT GHALLANAY)"),
("542","Bashir Ahmed ","Gul Muhammad Caste Mengal","5410254828875","Balochistan","NUSHKI"),
("543","Bashir Ahmed","Niaz Ahmad","3230415852241","Punjab","Muzaffargarh"),
("544","Bashir Ahmed","Shahamand","3320282763927","Punjab","Jhang"),
("545","Behram Shah","Yaqoob Shah","1510151614917","KP","BUNER"),
("546","Behram Zai","Dawlat Zai","1510146902801","KP","BUNER"),
("547","Behroz Khan","Umar Daraz Khan","1530209397715","KP","LOWER DIR (AT TEMERGARA)"),
("548","Bilal","Gul Taj","1730182282709","KP","PESHAWAR"),
("549","Bilal","Haji Ashraf","1310149989869","KP","MANSEHRA"),
("550","Bilal Ahmad alias Abdullah ","Muhammad Ismail ","3210212847827","Punjab","DERA GHAZI KHAN"),
("551","Bilal Ahmad Bhatti ","Mian Abdul Rahim Bhatti ","3120317329555","Punjab","BAHAWALPUR"),
("552","Bilal Ahmed","Khuda Bakhash","3320214039653","Punjab","Jhang"),
("553","Bilal Akbar","Sana Ullah","3540456621859","Punjab","Sheikhupura"),
("554","Bilal Alias Bilawal","zz","1111111111129","KP","PESHAWAR"),
("555","Bilal Hussain","Nazar Hussain","3840315130095","Punjab","LAYYAH"),
("556","Bilal Riaz ","Muhammad Riaz ","3420310898269","Punjab","DERA GHAZI KHAN"),
("557","Bisham Khan","Abdul Qadir Caste Rind","5440182594347","Balochistan","QUETTA"),
("558","Burhan","Jumat Khan","1510114045883","KP","BUNER"),
("559","Burhan Ullah","Ibrar Ullah","1510103935211","KP","BUNER"),
("560","Captain Murad Ali. ","Barkat Ali","5440042242371","Balochistan","QUETTA"),
("561","Ch. Babar Hussain Gujjar ","Ch. Ghulam Rasool Gujjar ","3410126757933","Punjab","GUJRANWALA"),
("562","Ch. Mudassar","Muhammad Nazar","6110166838979","ICT","ISLAMABAD\n\n"),
("563","Ch. Muhammad Ejaz Ahmad ","Ch. Muhammad Aslam ","3220247826311","Punjab","LAYYAH"),
("564","Ch. Razzaq Ahmad ","Ch. Mushtaq Ahmad ","3410216060509","Punjab","GUJRANWALA"),
("565","Chauhdary Muhammad Aslam","Chauhdary Imam Din","3320265353189","Punjab","Jhang"),
("566","Col (Rtd) Nadir ","Hassan Khan","6110125684243","Gilgit-Baltistan","GILGIT"),
("567","Danial Ali","Agha Hussain","3810152935345","Punjab","BHAKKAR"),
("568","Daud","Mehmood","1510146070497","KP","BUNER"),
("569","Dawod Nazir Alias Shoukat Sufi Asad","Nazir Ahmed ","3430129195915","Punjab","HAFIZABAD"),
("570","Deen Muhammad","Hazrat Muhammad","1730115243617","KP","Charsada"),
("571","Didar Ali "," Mehar Ali (Ex-MLA)","7150185121501","Gilgit-Baltistan","GILGIT"),
("572","Dilawar","Mian Khan","1350355305507","KP","MANSEHRA"),
("573","Dilshad Khan","Muhammad Tufail ","3410358463385","Punjab","GUJRANWALA"),
("574","Doctor Gul Alam","Abdul Latif","2150158730831","KP","BANNU"),
("575","Dost Muhammad","Muhammad Akbar","1550124862277","KP","SHANGLA (AT ALPURI)"),
("576","Dost Muhammad","Unknown","1530521720035","KP","LOWER DIR (AT TEMERGARA)"),
("577","Dr. Habib ur Rehman ","Ghulam Muhammad","3720181812097","Punjab","CHAKWAL"),
("578","Dr. Iftikhar Ahmed alias Dr. Wajid ","Muhammad Din ","3520122232701","Punjab","LAHORE"),
("579","Dr. Inam Ullah","Muhammad Khursheed","3710156091261","Punjab","ATTOCK"),
("580","Dr. M. Rasool","Muhammad Jan","1530209278477","KP","LOWER DIR (AT TEMERGARA)"),
("581","Dr. Muhammad Ismail Shaikh ","Ahmed Ismail Shaikh ","4220171929847","Sindh","Karachi"),
("582","Dur Muhammad ","Muhammad Panah Rind","4310224585901","Sindh","Jacobabad"),
("583","Ehsan Ullah ","Muhammad Yaqoob ","3410199954205","Punjab","GUJRANWALA"),
("584","Ehsan Ullah Khan ","Haji Atta Ullah Khan ","3830203624573","Punjab","MIANWALI"),
("585","Ehsan-ul-Haq Shad","Pehelwan Khan","3420206433815","Punjab","GUJRAT"),
("586","Ehtesham Ali alias Shani","Muhammad Aslam ","3720138428497","Punjab","CHAKWAL"),
("587","Ejaz  Ahmad Dar","Muhammad Khan","3730122623861","Punjab","JHELUM"),
("588","Enzar Gul","Noor Ahmad Shah","1620211012471","KP","SWABI"),
("589","Essa","Muhammad Sidique","1310182213209","KP","Abbotabad"),
("590","Fahad Mehmood","Aurangzeb","1310111802363","KP","ABBOTTABAD"),
("591","Fahad Munir","Munir Ahmad","3840484680627","Punjab","SARGODHA"),
("592","Fahad Naseem","Syed Naseem Ahmed","4220103244499","Sindh","KARACHI EAST"),
("593","Fahim Nawaz","Muhammad Nawaz","3660238604351","Punjab","Vehari"),
("594","Faiq Ahmed Memon ","Saadullah Memon","4520347439039","Sindh","Khairpur"),
("595","Faisal ","Muhammad Akram ","3820115859827","Punjab","KHUSHAB"),
("596","Faisal Ahmad Khan","Sher Ahmad Khan","3840342656657","Punjab","BHAKKAR"),
("597","Faisal Baber Hussain","Iftikhar Ahmed","3420171494633","Punjab","GUJRAT"),
("598","Faisal Riaz ","Noor Muhammad ","3710502827363","Punjab","Attock    "),
("599","Faiz","Gul Faraz Khan","1570195807975","KP","UPPER DIR (AT DIR)"),
("600","Faiz Rasool","BASHIR AHMED","3420104012705","Punjab","GUJRAT"),
("601","Faiz ul Wahid","Molana Abdul Wahid","1540232203325","KP","MALAKAND P.A."),
("602","Faiz Ullah","Hamza Khan","1570290083489","KP","UPPER DIR (AT DIR)"),
("603","faiz Ullah Khan sial","Nawab Aziz ullah khan","3320242061135","Punjab","Jhang"),
("604","Faiz ur Rehman @ Abdul Rehman ","Aziz ur Rehman ","4240112749335","Sindh","Karachi"),
("605","Faizan Ul Haq "," Javid Iqbal ","7150159727273","Gilgit-Baltistan","GILGIT"),
("606","Fakhar Abbas ","Mohammad Ashraf ","3430266237369","Punjab","HAFIZABAD"),
("607","Fakhre Alam","Fazal Raheem","1620212284295","KP","SWABI"),
("608","Falak Niaz","Waris Khan","1730104109115","KP","PESHAWAR"),
("609","Falak Sher ","Muhammad Inayat ","3420131134533","Punjab","GUJRAT"),
("610","Faqeer Hussain ","Abdul Hameed ","3410324721375","Punjab","GUJRANWALA"),
("611","Faqir Mohammad @ Faqira","Shah Gul","5610123696367","Balochistan","BARKHAN"),
("612","Faqir Muhammad @ Ganjaey","Shah Rahman","1620296568463","KP","SWABI"),
("613","Faramosh","Feroz","1560204147715","KP","SWAT (AT MINGORA)"),
("614","Faraz Sultan alias Abdullah","Muhammad Nawaz","3840159344977","Punjab","SARGODHA"),
("615","Farhan Siddique ","Muhammad Yameen Siddique ","3410165822589","Punjab","GUJRANWALA"),
("616","Farhat","Fazal Wazir","1530585554389","KP","LOWER DIR (AT TEMERGARA)"),
("617","Farman","Bacha Hussain","3520268010863","KP","UPPER DIR (AT DIR)"),
("618","Farman @ Nawaly","Sikandar","1560267796427","KP","TORGHAR (AT OGHI)"),
("619","Farman Ullah","Safeer Gul","1430163746661","KP","KOHAT"),
("620","Farman Ullah Khan","Habib ul Hassan","1530555094295","KP","LOWER DIR (AT TEMERGARA)"),
("621","Farooq","Aala Gul (Afghan National)","1530211394809","KP","Dir Lower"),
("622","Farooq","Shehbaz","1570170469863","KP","UPPER DIR (AT DIR)"),
("623","Farooq","Hassan Akbar","1620303449497","KP","SWABI"),
("624","Farooq","Khadim","1560403465681","KP","SWAT (AT MINGORA)"),
("625","Farooq /Farooq Haider","Sufi Farid","1310156198729","KP","ABBOTTABAD"),
("626","Farooq Ahmad Kha","Gulaya Khan","3810336154049","Punjab","BHAKKAR"),
("627","Farooq Azam Bhatti @ Talib ","Abdul Rasheed ","4230142523581","Sindh","Karachi"),
("628","Farooq Haider","Ghulam Rabani","3840343494055","Punjab","SARGODHA"),
("629","Farrukh Abbas ","Muhammad Bashir Jaffari ","3110475998761","Punjab","BAHAWALNAGAR"),
("630","Fateh Mohammad s/o  caste Khetran","Sahiban","5610122314867","Balochistan","BARKHAN"),
("631","Fateh Muhammad caste Nasar","Jalat Khan","5420334497405","Balochistan","KILLA ABDULLAH"),
("632","Fawad Habib Ullah","Maqsood Alam Sawati ","3520224601703","Punjab","LAHORE"),
("633","Fawad Khan","Sher Khan","1510131284683","KP","BUNER"),
("634","Fayyaz Elahi ","Nabi Bakhsh ","3210381305135","Punjab","MANDI BAHAUDDIN"),
("635","Fayyaz Hussain","Abdal Ghafoor","3720315029465","Punjab","CHAKWAL"),
("636","Fayyaz Hussain ","Muhammad Nawaz","1220177495949","Punjab","BHAKKAR"),
("637","Fazal Ahad","Muhammad Hussain","1620205485861","KP","SWABI"),
("638","Fazal Akbar","Malik Said Akbar","1520105845663","KP","CHITRAL"),
("639","Fazal Amin","Noor ul Qamar","1620251843667","KP","SWABI"),
("640","Fazal Azim","Gul Azeem","1570122638049","KP","BATAGRAM (AT BANA)"),
("641","Fazal Elahi ab r/o Moh: Malakpora Swabi","Fazal Wahab","","KP","Swabi"),
("642","Fazal Ghafoor","Abdul Sattar","1530627759291","KP","LOWER DIR (AT TEMERGARA)"),
("643","Fazal Ghafur","Juma Khan","1610159463673","KP","MARDAN"),
("644","Fazal Hakim","Gul Azim","1530427203009","KP","LOWER DIR (AT TEMERGARA)"),
("645","Fazal Hameed","Shah Tamas","1530209222871","KP","LOWER DIR (AT TEMERGARA)"),
("646","Fazal Hayat","Umar Zada","1570179947331","KP","UPPER DIR (AT DIR)"),
("647","Fazal Hussain Shah","Nazar Hussain Shah","1330281224573","KP","HARIPUR"),
("648","Fazal Karim","Abdur Rahim","1510148849237","KP","BUNER"),
("649","Fazal Nawab","Haji Nawab","4140116039379","KP","MALAKAND P.A."),
("650","Fazal Qadir","Gulbar Said","1530536044925","KP","LOWER DIR (AT TEMERGARA)"),
("651","Fazal Qadir","Inayat Ellahi ","3710109428067","Punjab","ATTOCK"),
("652","Fazal Qayum @ Qayyum","Abdul Rehman","1530323244151","KP","LOWER DIR (AT TEMERGARA)"),
("653","Fazal Raheem","Said Ahmad","1620223597417","KP","SWABI"),
("654","Fazal Rehman","Fazal Manan","1530649884249","KP","LOWER DIR (AT TEMERGARA)"),
("655","Fazal Subhan","Shah Zaman","1570111738333","KP","UPPER DIR (AT DIR)"),
("656","Fazal ur Rehman ","Gul Janan ","NIL","Sindh","Karachi"),
("657","Fazal Wahab","Gul Mehmood","1510104041867","KP","BUNER"),
("658","Fazal Wahid","Shan Mohammad","1570191667271","KP","UPPER DIR (AT DIR)"),
("659","Fazal-e-Raziq","Abdul Waheed","1550366981369","KP","CHARSADDA"),
("660","Fazal-ul-Allah alias Khalid ","Mehmood Asad ","3130366224053","Punjab","RAHIM YAR KHAN"),
("661","Fazal-ur-Rehman","Azeem Khan","2104032137369","KP","MOHMAND (AT GHALLANAY)"),
("662","Fazal-Ur-Rehman","Azeem Khan","2140321373699","KP","MOHMAND (AT GHALLANAY)"),
("663","Fazal-ur-Rehman ","Muhammad Yousaf   ","3120597002619","Punjab","BAHAWALPUR"),
("664","Fazal-ur-Rehman ","Abdul Rehman ","3830174336111","Punjab","MIANWALI"),
("665","Fazal-ur-Rehman.","Gul Baran","5440039771865","Balochistan","QUETTA"),
("666","Ferhat Kavakli","","P00033721","ICT","Islamabad"),
("667","Fiaz Ahmad","Muhammad Khursheed","3640277903213","Punjab","PAKPATTAN"),
("668","Fiaz Ahmad ","Rehmat Ullah ","3310476932543","Punjab","FAISALABAD"),
("669","Fiaz Hussain Shah alias Riaz ","Syed Maqsood Hussain Shah ","3460323187649","Punjab","SIALKOT"),
("670","Fida Hussain","Ishaq Ali. ","5440023875115","Balochistan","QUETTA"),
("671","Fida Hussain","Fazal Rahman","1570180500479","KP","UPPER DIR (AT DIR)"),
("672","Fida Hussain @ Baccho ","Zafar Ali","5440005093579","Balochistan","QUETTA"),
("673","Fida Shah","Syed Abdul Ghaffar Shah","5130146472045","Balochistan","KHARAN"),
("674","Fiyyaz Hussain Khan ","Mumtaz Ali Khan ","3810106665299","Punjab","BHAKKAR"),
("675","Furqan Ahmed Awan ","Mir Afzal Awan","4240142624931","Sindh","Karachi"),
("676","Furqan Qadri ","Habibullah ","4210140196251","Sindh","Karachi"),
("677","Furqan Tariq ","Tariq Zubair ","3410139310259","Punjab","GUJRANWALA"),
("678","Ghafar Ul Haq","Abbas Ali","3540432566369","Punjab","Sheikhupura"),
("679","Ghaffar Ali","Nazeer","1710168512557","KP","CHARSADDA"),
("680","Ghani Rehman","Fazla Rehman","1560204475951","KP","SWAT (AT MINGORA)"),
("681","Ghazi Tanveer Ahmed ","Rasheed Khan","4240155009179","Sindh","Karachi"),
("682","Ghufran Sajid ","Abdul Hayee Awan ","3410131489395","Punjab","GUJRANWALA"),
("683","Ghulam Abass","Muhammad Nazeer","3620209178771","Punjab","LODHRAN"),
("684","Ghulam Abbas ","Irshad Hussain ","3410408347591","Punjab","GUJRANWALA"),
("685","Ghulam Abbas ","Bashir Ahmad ","3610213159809","Punjab","KHANEWAL"),
("686","Ghulam Abbas","Mian Muhammad","3820136040333","Punjab","KHUSHAB"),
("687","Ghulam Abbas ","Abdul Ghani ","3830394276167","Punjab","MIANWALI"),
("688","Ghulam Abbas","Muhammad Bashir","3410174505535","Punjab","GUJRANWALA"),
("689","Ghulam Abbas","Ghulam Akbar","1220145131523","Punjab","BHAKKAR"),
("690","Ghulam Abbas","Abdul Haq","3420104253797","Punjab","GUJRAT"),
("691","Ghulam Abbas ","Muhammad Sardar ","3310091290915","Punjab","FAISALABAD"),
("692","Ghulam Abbas","Manzoor Hussain","3310446480449","Punjab","FAISALABAD"),
("693","Ghulam Abbas ","Gul Muhammad ","3330266934343","Punjab","TOBA TEK SINGH"),
("694","Ghulam Abbas Ulro","Sadhoro Khan Ulro","4520415488435","Sindh","Khairpur"),
("695","Ghulam Akbar ","Ghulam Safdar ","3710170658487","Punjab","Attock    "),
("696","Ghulam Akbar alias Aoun Abbas","Ghulam Shabbir","3220228146727","Punjab","LAYYAH"),
("697","Ghulam ALi @ Sultan Haider","Abdul Rehman","3840242666131","Punjab","SARGODHA"),
("698","Ghulam Ali Shah","Ali Nawaz Shah ","5330409814649","Balochistan","NASIRABAD  (AT D.M.JAMALI)"),
("699","Ghulam Baqir alias Bani ","Ghulam Hussain Jafferi ","3230101255655","Punjab","MUZAFFARGARH"),
("700","Ghulam Bheek alias Abu Bakar","Maqbool Ahmad","3660356720721","Punjab","VEHARI"),
("701","Ghulam Dastageer Hamid ","Ghulam Nabi Khan ","3520223979731","Punjab","LAHORE"),
("702","Ghulam Farid","Rasool Niaz","1110165796486","KP","BANNU"),
("703","Ghulam Haider alias Mehrab Hussain ","Jind Wadda ","3120141908709","Punjab","BAHAWALPUR"),
("704","Ghulam Haider Tonsvi","Ghulam Hassan","3630423441727","Punjab","Multan"),
("705","Ghulam Hussain ","Muhamma Shafi ","3620382470073","Punjab","LODHRAN"),
("706","Ghulam Hussain","Rahim Bakhs Dad Sumalani.","5140155438121","Balochistan","KHUZDAR"),
("707","Ghulam Hussain ","Raheem Bakhsh ","3320338695803","Punjab","JHANG"),
("708","Ghulam Hussain","Sain Ditta ","3310017811273","Punjab","FAISALABAD"),
("709","Ghulam Hussain ","Gul Hassan","3320347592005","Punjab","JHANG"),
("710","Ghulam Hussain","Muhammad Aslam","3310032934585","Punjab","FAISALABAD"),
("711","Ghulam Hussain alias Talibaan ","Allah Ditta ","3120472814565","Punjab","BAHAWALPUR"),
("712","Ghulam Hussain Bhidwal"," Malik Allah Bakhsh Zawar ","3810224720705","Punjab","BHAKKAR"),
("713","Ghulam Mohammad @ Umar ","M. Iqbal (Late)","4230108649365","Sindh","Karachi"),
("714","Ghulam Muhammad","Niamat Khan","4210114307513","KP","LOWER DIR (AT TEMERGARA)"),
("715","Ghulam Muhammad @ Umer ","M.Iqbal (Late) ","4230108649365","Sindh","Karachi"),
("716","Ghulam Murtaza ","Sana Ullah ","3130402162613","Punjab","RAHIM YAR KHAN"),
("717","Ghulam Murtaza ","Muhammad Ali ","3320187311567","Punjab","CHINIOT"),
("718","Ghulam Mustafa ","Muhammad Saleem ","3810266393517","Punjab","BHAKKAR"),
("719","Ghulam Mustafa","Muhammad Nazir ","3740206496395","Punjab","RAWALPINDI"),
("720","Ghulam Mustafa ","Ashiq Hussain","3210224847397","Punjab","DERA GHAZI KHAN"),
("721","Ghulam Mustafa ","M. Hanif","8210255715723","AJ&K","Pidhar Mato Khan , Dhirkot Bagh"),
("722","Ghulam Mustafa alias Haji Iqbal ","Qadir Dad Khan ","3210253241489","Punjab","DERA GHAZI KHAN"),
("723","Ghulam Mustafa alias Nanna ","Mehndi Hassan ","3120256251067","Punjab","BAHAWALPUR"),
("724","Ghulam Mustafa Jadoon","Zardad Khan","1310155033549","KP","ABBOTTABAD"),
("725","Ghulam Mustafa Tabasum","Abdul Rasheed","3660337970545","Punjab","Vehari"),
("726","Ghulam Nabi","Bashir Ahmad ","3310083404117","Punjab","FAISALABAD"),
("727","Ghulam Nabi ","Muhammad Usman","NIL","Sindh","Sanghar"),
("728","Ghulam Nabi Keti ","Muhammad Umar Keti ","4140136088111","Sindh","THATTA"),
("729","Ghulam Nazik ","Noor Muhammad ","3630406900473","Punjab","MULTAN"),
("730","Ghulam Qadir","Ghulam Hussan","1730114145583","KP","CHARSADDA"),
("731","Ghulam Qadir","Muhammad Ibraheem Sona ","3810223515331","Punjab","BHAKKAR"),
("732","Ghulam Qasim","Nazar Hussain","3720116611905","Punjab","CHAKWAL"),
("733","Ghulam Rasool","Abdullah Khan","1530511231577","KP","LOWER DIR (AT TEMERGARA)"),
("734","Ghulam Raza","Ghulam Rasool Arfati","3240443770413","Punjab","Rahim Yar Khan"),
("735","Ghulam Raza","Muhammad Shamla ","3240225604921","Punjab","RAJANPUR"),
("736","Ghulam Raza @ Raza Tayyab","Muhammad Hussain","3720113321295","Punjab","CHAKWAL"),
("737","Ghulam Safdar Khan ","Ghulam Mustafa Khan ","3430250756599","Punjab","HAFIZABAD"),
("738","Ghulam Said","Yasin Khan","1530531151849","KP","Dir Lower"),
("739","Ghulam Sarwar ","Muhammad Bux Chachar","4550118641583","Sindh","Sukkur"),
("740","Ghulam Sarwar ","Lal Deen","3410117914387","Punjab","GUJRANWALA"),
("741","Ghulam Sarwar Abro ","Rajab Ali ","4320395420793","Sindh","Karachi"),
("742","Ghulam Shabbar","Ghulam Hussain","3540443204775","Punjab","Sheikhupura"),
("743","Ghulam Shabbir ","Haitam ","3610235275773","Punjab","KHANEWAL"),
("744","Ghulam Shabbir ","Haji Rahim Bakhsh ","3130233127423","Punjab","RAHIM YAR KHAN"),
("745","Ghulam Shabbir ","Ghulam Rasool ","3120495820877","Punjab","BAHAWALPUR"),
("746","Ghulam Shabbir","Ghulam Sarwar","3240239954065","Punjab","RAJANPUR"),
("747","Ghulam Shabbir Ahmad","Noor Muhammad","3710587862233","Punjab","ATTOCK"),
("748","Ghulam Shahbaz Ali","Ghulam Nabi","6110119436773","Punjab","FAISALABAD"),
("749","Ghulam Shehzad ","Jaffar","7110383536731","Gilgit-Baltistan","BALTISTAN (AT SKARDU)"),
("750","Ghulam Yaseen alias Abu Masood, Kulhara ","Ghulam Rasool ","3120456485327","Punjab","DERA GHAZI KHAN"),
("751","GHULAM YASIM MUAVIA","KAREEM BAKHSH","3630117463523","Punjab","SARGODHA"),
("752","Ghullam Abbas","Riaz Hussain","3320404104429","Punjab","Jhang"),
("753","Ghullam nabi","Ghullam Akbar","3320314732498","Punjab","Jhang"),
("754","Ghullam Qasim Ali","Muhammad Yousaf","3320344110085","Punjab","Jhang"),
("755","Ghullam Raza","Muhammad nawaz","3320213617489","Punjab","Jhang"),
("756","Ghullam Shabbir","Kamal Din Late","3320383832623","Punjab","Jhang"),
("757","Ghuncha Gul","Umar Gul","1710177743631","KP","Charsada"),
("758","Ghuncha Gul","Sherin Jan","1530592094631","KP","LOWER DIR (AT TEMERGARA)"),
("759","Gohar Murtaza Khan Lodhi ","Murtaza Khan Lodhi ","3440264524687","Punjab","MANDI BAHAUDDIN"),
("760","Gran Malik","Abdul Momin","1530579645659","KP","LOWER DIR (AT TEMERGARA)"),
("761","Gul Bar Said","Bacha Said","1530565155697","KP","LOWER DIR (AT TEMERGARA)"),
("762","Gul Faraz","Saaz Karim","1530405449341","KP","LOWER DIR (AT TEMERGARA)"),
("763","Gul Jahan alias Abu Noman  ","Muhammad Ramzan","3840370333777","Punjab","SARGODHA"),
("764","Gul Muhammad","Sargand Khan (Late)","1530119576559","KP","LOWER DIR (AT TEMERGARA)"),
("765","Gul Raiz","Javed","1210163995509","KP","DERA ISMAIL KHAN"),
("766","Gul Sharif","Muhammad Amin","1530259281097","KP","LOWER DIR (AT TEMERGARA)"),
("767","Gul Sher","Umar Din / Samar Din","4230176580405","KP","BUNER"),
("768","Gul Sher @ Kara","Sadbar","1510104173717","KP","BUNER"),
("769","Gul Yousaf","Shahmir Khan @ Toor","2170525717401","KP","DERA ISMAIL KHAN"),
("770","Gul Zada","Shah Gul","1730114229371","KP","PESHAWAR"),
("771","Gul Zada","Rahim","1570169853355","KP","UPPER DIR (AT DIR)"),
("772","Gulab Noor","Raz Muhammad","","KP","SWA"),
("773","Gulab Said","Anat @ Lalat","","KP","Dir Lower"),
("774","Gulfam Khan alias Abu Akasha ","Khan Akbar Hameed ","3460372910123","Punjab","SIALKOT"),
("775","Gulim","s/o Aman","1570117971737","KP","UPPER DIR (AT DIR)"),
("776","Gulraiz Ahmed","Maqsood Ahmed","3520210331455","Punjab","LAHORE"),
("777","Gulzar Ahmed Waseem","Khuda Bhaksh","4210189077825","Punjab","Vehari"),
("778","Gulzar Alam","Gul Ahmad","1570112256391","KP","UPPER DIR (AT DIR)"),
("779","Gulzar Hussain ","Feroz Hussain ","3330222436961","Punjab","TOBA TEK SINGH"),
("780","Gulzar Hussain alias Gulzari","Muhammad Zaman ","3810406351913","Punjab","BHAKKAR"),
("781","Habeeb Ullah","Abdul Hameed","3330390848519","Punjab","T.T.Singh"),
("782","Habib Mullah","Muhammad Habib","1530232889065","KP","LOWER DIR (AT TEMERGARA)"),
("783","Habib Said","Said Baqar","1530516777985","KP","LOWER DIR (AT TEMERGARA)"),
("784","Habib Ul Hassan","Ismail a","1530552556293","KP","LOWER DIR (AT TEMERGARA)"),
("785","Habib Ullah","Amin Ullah","1530209161181","KP","LOWER DIR (AT TEMERGARA)"),
("786","Habib Ullah","Muhammad Shareef","3320294840701","Punjab","JHANG"),
("787","Habib ur Rehman","Akhun Muhammad","1530209695693","KP","LOWER DIR (AT TEMERGARA)"),
("788","Habib Ur Rehman ","Abdul Rehman ","3120112348393","Punjab","BAHAWALPUR"),
("789","Habib Ur Rehman ","Fazal Ur Rehman ","3310603440643","Punjab","FAISALABAD"),
("790","Habib Ur Rehman","Khuda bukhsh","3210324466355","Punjab","DERA GHAZI KHAN"),
("791","Habib-ur-Rehman"," Haji Noor Jahan ","5650318529899","Balochistan","ZHOB"),
("792","Habib-ur-Rehman ","Inayet Ullah ","3410148877251","Punjab","GUJRANWALA"),
("793","Hadayat-ur-Rehman","Malang","5210170289203","Balochistan","GWADAR"),
("794","Hadi Khan","Muzafar Khan","1530745992867","KP","LOWER DIR (AT TEMERGARA)"),
("795","Hafeez ","Habib Dhoobi","4220116906419","Sindh","Karachi"),
("796","Hafeez Ullah ","Ghulam Muhammad ","3810208887459","Punjab","BHAKKAR"),
("797","Hafeez Ullah","Aziz-ur-Rahman","1710165658563","KP","Charsada"),
("798","Hafeez ur Rehman","Asghar Ali","3460254113995","Punjab","Sialkot"),
("799","Hafeez-ur-Rehman alias Hammad","Asghar Ali","3460251986133","Punjab","SIALKOT"),
("800","Hafeezullah   ","Din Mohammad","5530236414071","Balochistan","SIBI"),
("801","Hafiq ul Haq ","Saro Zarin","1320291716463","KP","BATAGRAM (AT BANA)"),
("802","Hafiz  Adul  Shakoor  Mengal","Essa","5140323954205","Balochistan","LASBELA (AT UTHAL)"),
("803","Hafiz Abdul Ghaffar","Ahsam-ud-Din","5421058072627","Balochistan","QUETTA"),
("804","Hafiz Abdul Ghaffar alias Ghaffari ","Haji Muhammad Ashraf ","3640132020031","Punjab","PAKPATTAN"),
("805","Hafiz Abdul Hayee ","Hafiz Haji Muhammad Azeem ","3120121703077","Punjab","BAHAWALPUR"),
("806","Hafiz Abdul Rauf","Sana Ullah","3410104510339","Punjab","GUJRANWALA"),
("807","Hafiz Abdul Samad ","Hakeem Ahmad Hassan  ","3120129895687","Punjab","BAHAWALPUR"),
("808","Hafiz Ali MUhammad","Faiz Muhammad","1720122432817","Punjab","JHELUM"),
("809","Hafiz Asmat Ullah ","Matho Khan","3520094250227","Punjab","DERA GHAZI KHAN"),
("810","Hafiz Attahullah","Haji Yaseen","5410187678593","Balochistan","CHAGAI (AT DALBANDIN)"),
("811","Hafiz Attaullah ","Muhammad Aslam Shaikh","441031188513","Sindh","Mirpurkhas"),
("812","Hafiz Attique Rehman ","Abdul Rehman ","3520263533563","Punjab","LAHORE"),
("813","Hafiz Aziz Ullah","Soran","1102130116515","KP","Toorghar"),
("814","Hafiz Dost Kohsa,","Lashkran","5320163384499","Balochistan","JAFFARABAD"),
("815","Hafiz Farooq Ahmad alias Rajanpuri ","Molvi Abdul Haq ","3110380968241","Punjab","BAHAWALNAGAR"),
("816","Hafiz Fiaz Ahmad","Ghulam Hassan","3620359665643","Punjab","Lodhran"),
("817","Hafiz Ghulam Mustafa","Hafiz Muhammad Waraym","3610245411477","Punjab","KHANEWAL"),
("818","Hafiz Gulzar Ahmed Umer","Ghulam Muhammad","3730144818619","Punjab","JHELUM"),
("819","Hafiz Habibullah","Maulvi Abdul Ghafoor","1610145584693","KP","MARDAN"),
("820","Hafiz Hafeez Ahmed","Muhammad Anwar","1330298828313","KP","Haripur"),
("821","Hafiz Imam @ Hafiz Imran ","Shah Muhammad","5440004802391","Balochistan","QUETTA"),
("822","Hafiz Imran ","Muhammad Yousaf ","3410470089823","Punjab","GUJRANWALA"),
("823","Hafiz Kashif ","M. Hanif","8230314430013","AJ&K","Datoot Rawalakot"),
("824","Hafiz Khalid Mehmood","Haji Muhammad Moosa","3320228120135","Punjab","Jhang"),
("825","Hafiz Mehmood Anwar","Sahib Noor","1120118596627","KP","LAKKI MARWAT"),
("826","Hafiz Mehmood-ul-Hassan ","Tufail Ahmed ","3530236433369","Punjab","OKARA"),
("827","Hafiz Mohd. Alam Tariq  ","Mohammad Hashim Jatak","4250112033079","Balochistan","KALAT"),
("828","Hafiz Muhammad ","Abdullah Indher","NIL","Sindh","Sukkur"),
("829","Hafiz Muhammad Abubakar alias Al Hussaini ","Hafiz Muhammad Idrees ","4240118435861","Punjab","BAHAWALPUR"),
("830","Hafiz Muhammad Ahmad","Abdul Qayyum","3110101474671","Punjab","BAHAWALNAGAR"),
("831","Hafiz Muhammad Ammar alias Muaz Muavia (Rajpoot)","Tariq Pervaiz","3650218255643","Punjab","SAHIWAL"),
("832","Hafiz Muhammad Ashiq","Malik Muhammad Boota","3540465939315","Punjab","Sheikhupura"),
("833","Hafiz Muhammad Ashraf","Ch. Farzand Ali","3110116162161","Punjab","BAHAWALNAGAR"),
("834","HAFIZ MUHAMMAD HAFEEZ UR REHMAN","MUHAMMAD SAJJAD UR REHMAN","3820199043021","Punjab","Khushab"),
("835","Hafiz Muhammad Ishaq ","Muhammad Sadiq","3320139402529","Punjab","Chiniot"),
("836","Hafiz Muhammad Ishfaq alias Ishtiaq ","Noor Muhammad ","3130380315857","Punjab","RAHIM YAR KHAN"),
("837","Hafiz Muhammad Junaid-ur-Rehman ","Muhammad Mehfooz-ur-Rehman ","3610264841381","Punjab","KHANEWAL"),
("838","Hafiz Muhammad Naveed ","Shabbir Ahmed ","353016256925","Sindh","26"),
("839","Hafiz Muhammad Noor","Abdul Qayyum Caste Alizai","5440066280927","Balochistan","QUETTA"),
("840","Hafiz Muhammad Qasim","Raheem Bakhsh","3620105685639","Punjab","LODHRAN"),
("841","Hafiz Muhammad Rafi Mustafa ","Muhammad Sharif Shaikh","4130350573211","Sindh","Hyderabad"),
("842","Hafiz Muhammad Rafique alias Tunda ","Pir Bakhsh ","3130328114607","Punjab","RAHIM YAR KHAN"),
("843","Hafiz Muhammad Raheel","Muhammad Anwar","3520256763255","Punjab","LAHORE"),
("844","Hafiz Muhammad Ramzan ","Allah Bakhsh ","3310091296847","Punjab","FAISALABAD"),
("845","Hafiz Muhammad Ramzan","Bashir Ahmad","3530154145751","Punjab","OKARA"),
("846","Hafiz Muhammad Saeed","Kamal Din","3520255098427","Punjab","LAHORE"),
("847","Hafiz Muhammad Shakir","Muhammad Sifarish","3710403885115","Punjab","Attock    "),
("848","Hafiz Muhammad Sohail","Muhammad Akram","3710114063511","Punjab","Attock    "),
("849","Hafiz Muhammad Tayyab alias Faheem ","Ghulam Sarwar ","3120206866265","Punjab","BAHAWALPUR"),
("850","Hafiz Muhammad Ubaid Ullah ","Muhammad Umar Khan ","3650118267407","Punjab","GUJRANWALA"),
("851","Hafiz Muhammad Usman ","Hafiz Muhammad Ishaq ","3650213747215","Punjab","SAHIWAL"),
("852","Hafiz Muhammad Usman Jami ","Muhammad Rafiq Jami ","3310002298647","Punjab","FAISALABAD"),
("853","Hafiz Muhammad Yousaf alias Al Hussaini ","Hafiz Muhammad Idrees Sabir ","3120202579483","Punjab","BAHAWALPUR"),
("854","Hafiz Naimat Ullah","Rahim Dad","5160243981695","Balochistan","MASTUNG"),
("855","Hafiz Naveed Saddiqi alias Saddiqi ","Abdul Latif ","3320240131841","Punjab","JHANG"),
("856","Hafiz Nazir Ahmed ","Daim Din Samejo","4550105730689","Sindh","Sukkur"),
("857","Hafiz Noman Tariq ","Tariq Mehmood ","3460397390433","Punjab","SIALKOT"),
("858","Hafiz Numan Zia Farooqi ","Maulana Zia-ur-Rehman Farooqi ","3310531408271","Punjab","FAISALABAD"),
("859","Hafiz Saeed Akbar","Shafi Akbar","1620230321640","KP","HARIPUR"),
("860","Hafiz Sanaullah ","Abdul Khaliq Zehri.","5140167012819","Balochistan","KHUZDAR"),
("861","Hafiz Sibghat Ullah","Muhammad Ali","1120107204267","KP","LAKKI MARWAT"),
("862","Hafiz Ullah","Zoor Mast","1570143523109","KP","UPPER DIR (AT DIR)"),
("863","Hafiz Ullah","Bakht Biland","1530520976675","KP","LOWER DIR (AT TEMERGARA)"),
("864","Hafiz ullah","Hamza Khan","","KP","Dir Lower"),
("865","Hafiz Ur Rehman @ Pakhan@Muhsin","Palo Din @ Aamir Din","2220117502041","KP","BANNU"),
("866","Haidar Ali","Adil","1560253170809","KP","SWAT (AT MINGORA)"),
("867","Haider Ali @ Shan","Khursheed Haider ","4230109954729","Sindh","Karachi"),
("868","Haider Ali Raza ","Mohsin Ali Raza Jafri","3130155469165","Punjab","RAHIM YAR KHAN"),
("869","Hajat Ali","Maqbali Khan","1730102379621","KP","CHARSADDA"),
("870","Haji Abbas ","Haji Qasim ","5440083115339","Balochistan","QUETTA"),
("871","Haji Aman ullah caste Adozai","Sheikh Muhammad","5420124393955","Balochistan","KILLA ABDULLAH"),
("872","Haji Bashir Ahmed","Ali Mohammad Qabdani.","5410101212811","Balochistan","CHAGAI (AT DALBANDIN)"),
("873","Haji Faizullah Haidri ","Shah Muhammad","5440027705199","Balochistan","QUETTA"),
("874","haji jind wada","ghulam fareed","3120477393625","Punjab","Bahawalpur"),
("875","Haji Majed Caste Reki","Muhammad Hayat","5130224061527","Balochistan","WASHUK"),
("876","Haji Muhammad Hanif","Habib Jan","1530208521885","KP","LOWER DIR (AT TEMERGARA)"),
("877","Haji Muhammad Nawaz","Mian Abdul Hafeez","3620294324561","Punjab","LODHRAN"),
("878","Haji Muhammad Qasim","Abdul Nabi Caste Kurd","5440044636131","Balochistan","QUETTA"),
("879","Haji Rahim Said","Sher Muhammad","1570595601085","KP","LOWER DIR (AT TEMERGARA)"),
("880","Haji Yar Muhammad ","Hafiz Allah Bakhsh ","3201302876153","Punjab","DERA GHAZI KHAN"),
("881","Haji Zarin","Noor Ahmed","1530513726873","KP","LOWER DIR (AT TEMERGARA)"),
("882","Hakeem Ullah","Said Sher","1730104883589","KP","CHARSADDA"),
("883","Hakim Ali","Zulifqar Ali","3320279668301","Punjab","Jhang"),
("884","Hakim Khan","Gul Sabdar Tazagram","1530209569635","KP","LOWER DIR (AT TEMERGARA)"),
("885","Hakim Khan","Pasand","1510106734331","KP","BUNER"),
("886","Haleem Said","Rahim Said","1530670293987","KP","LOWER DIR (AT TEMERGARA)"),
("887","Hamadullah","Muhammad Sadiq Shaikh","4520365331601","Sindh","Khairpur"),
("888","Hamayun","Habib Khan","1570169390269","KP","UPPER DIR (AT DIR)"),
("889","Hameed Sajjid","Gui Muhammad","3840321279511","Punjab","SARGODHA"),
("890","Hamid Ali ","Allah Yar ","3520203676575","Punjab","LAHORE"),
("891","Hamid Ali Qureshi ","Muhammad Bashir ","3120258249117","Punjab","BAHAWALPUR"),
("892","Hamid Khan","Lachi Khan","1720122409487","KP","NOWSHERA"),
("893","Hamid Mehmood","Mohsin Agha","5420107428505","Balochistan","QUETTA"),
("894","Hamid Rahman","Jamshed Rahman","1530552560819","KP","LOWER DIR (AT TEMERGARA)"),
("895","Hamid Ullah","Salah Uddin","1530525823583","KP","LOWER DIR (AT TEMERGARA)"),
("896","Hamidullah @ Gohar","Hakim Khan","2150314250019","KP","N.WAZIRISTAN (AT MIRAN SHAH)"),
("897","Hamza Imtiaz Yousaf Butt ","Imtiaz Yousaf ","3460194833955","Punjab","SIALKOT"),
("898","Hamza Jhangir ","Muhammad Jhangir ","3740178595225","Punjab","RAWALPINDI"),
("899","Hanif","Aqal Wazir","1530634496083","KP","LOWER DIR (AT TEMERGARA)"),
("900","HANIF-UL-HAQ ","ABDUL KHALIQ","3420248971691","Punjab","GUJRAT"),
("901","HANIF-UR-REHMAN","MUHAMMAD RIAZ","3840538032919","Punjab","SARGODHA"),
("902","Haq Nawaz ","Zahid Iqbal ","3520239995477","Punjab","LAHORE"),
("903","Haq Nawaz","Feroz Din","3130356915183","Punjab","Rahim Yar Khan"),
("904","Haq Nawaz","Arif Khan","1610112397797","KP","UPPER DIR (AT DIR)"),
("905","Haq Nawaz ","Shehbaz Khan","8220391703707","AJ&K","Dral Naka Gojra Muzaffarabad"),
("906","Haq Nawaz ","Noor Muhammad Anwar ","3520196108711","Punjab","LAHORE"),
("907","Haq Nawaz Khan Alias Dr. Haq Nawaz","Muhammad Ayoub Khan","3620296596629","Punjab","LODHRAN"),
("908","Haroon Rasheed ","Maraj-u-Din","3740148490093","Punjab","RAWALPINDI"),
("909","Haroonur Rasheed","Halim","1560287903175","KP","SWAT (AT MINGORA)"),
("910","hashim Ali","faiz Ahmed","3320344015085","Punjab","Jhang"),
("911","Hashim Ali Shah","Farhan Ali Shah","3320165382423","Punjab","CHINIOT"),
("912","Hashim Hussain","Jan Muhammad ","3810160723733","Punjab","BHAKKAR"),
("913","Hashmat Ali ","Bashir Ahmad ","3410422355053","Punjab","GUJRANWALA"),
("914","Hasnain Muavia","Maulana haq Nawaz","3320233541725","Punjab","Jhang"),
("915","Hassan","Khair Muhammad","","KP","Dir Lower"),
("916","Hassan Abbas","Syed Hasnain Shah","4520374051455","Sindh","KHAIRPUR"),
("917","Hassan Ahmed Qureshi ","Ovais Ahmed Qureshi ","3630287304519","Punjab","MULTAN"),
("918","Hassan Ali Shah ","Peer Zada Sarwar Hussain ","3520226024461","Punjab","LAHORE"),
("919","Hassan Mir @ Nana ","Ghulam Meer Kashmiri ","4210199592873","Sindh","Karachi"),
("920","Hassan Raza ","Ali Ashraf ","3320212521059","Punjab","JHANG"),
("921","Hassan Shah","Arman Shah","2120212941041","KP","KHYBER (AT PESHAWAR)"),
("922","Hassan Tariq alias Tari","Muhammad Iqbal ","3310038803979","Punjab","FAISALABAD"),
("923","Hayat","Saeed Ullah","1530574096007","KP","LOWER DIR (AT TEMERGARA)"),
("924","Hayat Khan s/ocaste Mochi "," Juma Khan ","5610174860057","Balochistan","BARKHAN"),
("925","Hayat Ullah","Sadaat","1110182640121","KP","BANNU"),
("926","Hayat Ullah","Muhammad Nawaz","1220171946541","KP","TANK"),
("927","Hayat Ullah","Muhammad Darwaish","1530225279201","KP","LOWER DIR (AT TEMERGARA)"),
("928","Hayat Ullah","Zoor Mast","1570196807539","KP","UPPER DIR (AT DIR)"),
("929","Haziq Ullah","Gul Ahmad","1511022731261","KP","CHITRAL"),
("930","Hazrat","Noor Ullah","1410171966359","KP","HANGU"),
("931","Hazrat Ali","Muhammad Zeb Khan","1560403845735","KP","SWAT (AT MINGORA)"),
("932","Hazrat Ali","Ali Jan @ Ulfat Khan","1570532400663","KP","UPPER DIR (AT DIR)"),
("933","Hazrat Anees Khan @ Jawad ","Mian Gul Akhon Khel","4240163085831","Sindh","Karachi"),
("934","Hazrat Islam","Haji Rehman Shah","1560247918129","KP","SWAT (AT MINGORA)"),
("935","Hazrat Muhammad @ Babu Mavia","Yousaf","1730115938643","KP","PESHAWAR"),
("936","Hazrat Ullah","Mashkoor","1570115828175","KP","UPPER DIR (AT DIR)"),
("937","Hazrat Umar","Khaista Gul","1560205317243","KP","SWAT (AT MINGORA)"),
("938","Hazrat Younas","Muhammad Rahim","1550144837819","KP","SHANGLA (AT ALPURI)"),
("939","Hidayat ullah","Mohd Sadaf","1530209918557","KP","LOWER DIR (AT TEMERGARA)"),
("940","Hikmat Roshan Alias Hikamat Yar","Maulivi Amal Khan","2150542735343","KP","N.WAZIRISTAN (AT MIRAN SHAH)"),
("941","Hubdar Hussain Malik ","Beram Khan ","6110175635685","Punjab","CHAKWAL"),
("942","Humayum Kabir ","Sultan Ahmed ","4210113750723","Sindh","Karachi"),
("943","Humd@Khan Madak ","Bahadar Shah","1410120181669","KP","HANGU"),
("944","Hussain Ahmad","Muhammad Zaman","3710443730723","Punjab","ATTOCK"),
("945","Hussain Ahmad Saddiquee","Shah Muhammad ","3710228649787","Punjab","ATTOCK"),
("946","Hussain Akbar","Gul Bar Shah","1620209911047","KP","SWABI"),
("947","Hussain Ali","Ali Rahim","1560403567235","KP","SWAT (AT MINGORA)"),
("948","Hussain Ali ","Muhammad Shah ","3810171591023","Punjab","BHAKKAR"),
("949","Hussain Bakhsh alias Bagga Reesh ","Phairan","3240485805497","Punjab","RAJANPUR"),
("950","Hussain Shah","Fateh Muhammad","1530598005495","KP","LOWER DIR (AT TEMERGARA)"),
("951","Hussain Zada","Kaki","1510198358047","KP","BUNER"),
("952","Ibrahim","Jahanzeb","1610284206061","KP","NOWSHERA"),
("953","Ibrahim","Mohammad Hakim .","1570177504887","KP","UPPER DIR (AT DIR)"),
("954","Ibrahim Said","Sultan","1570177495311","KP","UPPER DIR (AT DIR)"),
("955","Ibrar","Hassan Faroosh","1560242270065","KP","SWAT (AT MINGORA)"),
("956","Ibrar Hussain","Muhammad Hussain","1530508833149","KP","LOWER DIR (AT TEMERGARA)"),
("957","Ibrar Hussain alias Shahid ","Zakar Hussain ","3530291379081","Punjab","OKARA"),
("958","Ibrar Ul Momin","Sher Ahmed","1570156276089","KP","UPPER DIR (AT DIR)"),
("959","Idrees","Shah Dawran","1560261350803","KP","SWAT (AT MINGORA)"),
("960","Iftakhar Molivi"," M. Shafi ","8230389224517","AJ&K","Chak Dhamni, Rawalakot"),
("961","Iftekhar Ahmad Farooqi alias Farooqi","Noor Muhammad ","3710523460767","Punjab","ATTOCK"),
("962","Iftikahar Majeed ","Ab. Majeed","3740531620355","AJ&K","Bhathal Gunjari Balooch, Sudhnoti"),
("963","Iftikhar","Siraj","1560274888873","KP","SWAT (AT MINGORA)"),
("964","Iftikhar Ahmad ","Muhammad Tufail ","3410340964309","Punjab","GUJRANWALA"),
("965","Iftikhar Ahmad","Bashir Ahmad","3130361906579","Punjab","Vehari"),
("966","Iftikhar Ahmad","Muhammad Safdar","3710387496901","Punjab","Attock    "),
("967","Iftikhar Ahmed","Muhammad Bashir","3460161186635","Punjab","SIALKOT"),
("968","Iftikhar Ahmed ","Muhammad Ibrahim","7150147226933","Gilgit-Baltistan","GILGIT"),
("969","Iftikhar Khan","Shakir Khan","1720121945907","KP","NOWSHERA"),
("970","Iftikhar ud Din","Qayum ud Din","1111111111111","KP","MALAKAND P.A."),
("971","Ihsan Ullah",". Qalandar","1570111649907","KP","UPPER DIR (AT DIR)"),
("972","Ihsan Ullah","Said Rahman","1570111603495","KP","UPPER DIR (AT DIR)"),
("973","Ijaz","Shamus Ur Rahman","1570154969719","KP","UPPER DIR (AT DIR)"),
("974","Ijaz Ahmad ","Abdul Karim ","3130332056305","Punjab","RAHIM YAR KHAN"),
("975","Ijaz Ahmed alias Saddique ","Mian Saddique ","3620279690915","Punjab","LODHRAN"),
("976","Ijaz Amin Alias Ijaz Pashteen","Muhammad Amin","2170643131533","KP","DERA ISMAIL KHAN"),
("977","Ijaz Hussain","Mumtaz Ali","3810120848135","Punjab","BHAKKAR"),
("978","Ijazul Haq ","Abdul Manan","1350209456035","KP","TORGHAR (AT OGHI)"),
("979","Ikhlaq Ahmed","Shahab u Din","3320314435723","Punjab","Jhang"),
("980","Ikram @ Khurasani @ Ajmal Qasab","Yar Mohammad","0000000000006","KP","MOHMAND (AT GHALLANAY)"),
("981","Ikram Rabbani (Caste Awan)","Ghulam Rabbani","3840331820995","Punjab","SARGODHA"),
("982","Ikram ul Haq","Hafiz Sher Ali","1560204791021","KP","SWAT (AT MINGORA)"),
("983","Ikram Ullah ","Abdul Qayoum Khan ","2170266814335","Sindh","Karachi"),
("984","Ikram Ullah","Umar Badshah","1570158481203","KP","UPPER DIR (AT DIR)"),
("985","Ikram Ullah","Abdullah","1520118136319","KP","CHITRAL"),
("986","Ikram Ullah","Sardar Bacha","1530427775309","KP","LOWER DIR (AT TEMERGARA)"),
("987","Ikram Ullah","Sarzameen","1111111111113","KP","PESHAWAR"),
("988","Ikram Ullah","Muhammad Sher","1120181219307","KP","LAKKI MARWAT"),
("989","Ilyas","Hazrat Ali","1110162302169","KP","BANNU"),
("990","Iman Ullah ","Haji Dawai Khan ","4240152242911","Sindh","Karachi"),
("991","Imdad Ali ","Zahri Caste Zakri","5110239271863","Balochistan","KHUZDAR"),
("992","Imdad Hussain ","Sabir Hussain ","1210117771905","Punjab","BHAKKAR"),
("993","Imdad Hussain Khamisani ","Sher Muhammad Khamisani","4520319085757","Sindh","Khairpur"),
("994","Imdad Hussain Malhi","Chaudry Allah Rakha","9100501055965","Punjab","Nankana Sahib"),
("995","Imdad Hussain Qureshi alias Dadu ","Haji Mehmood Qureshi ","3320292906903","Punjab","JHANG"),
("996","Imdad Ullah","Abdul Razaq","3240389943291","Punjab","RAJANPUR"),
("997","Imdad Ullah ","Ahmed","4240111671213","Sindh","Karachi"),
("998","Imdad ullah","Abdul Wahab","1530210024997","KP","LOWER DIR (AT TEMERGARA)"),
("999","Imdad Ullah","Anwar Zeb","1550422278671","KP","SHANGLA (AT ALPURI)"),
("1000","Imran","Ayub","1570149483479","KP","UPPER DIR (AT DIR)"),
("1001","Imran","Iqbal","1570124889045","KP","UPPER DIR (AT DIR)"),
("1002","Imran","Badshah Muhammad","1530535924777","KP","LOWER DIR (AT TEMERGARA)"),
("1003","Imran Abbas ","Ghulam Abbas ","3810257129018","Punjab","BHAKKAR"),
("1004","Imran Abbas ","Maqsood Hussain Shah ","8130218016215","Punjab","MANDI BAHAUDDIN"),
("1005","Imran Ahmed @ Noman","Allah Bakhsh","5440037301685","Balochistan","QUETTA"),
("1006","Imran Ahmed Sagar","Suleman Khan","3460145724099","Punjab","Sialkot"),
("1007","Imran Ahsan alias Mithoo ","Muhammad Hussain Ahmed ","3640185488941","Punjab","PAKPATTAN"),
("1008","Imran Ali Alias Chamman","Basheer Ahmad","3320317918009","Punjab","JHANG"),
("1009","Imran Ali Khan ","Saif Ullah Khan ","3810156366893","Punjab","BHAKKAR"),
("1010","Imran Ashraf ","Muhammad Ashraf ","3120352395277","Punjab","BAHAWALPUR"),
("1011","Imran Hameed ","Abdul Hameed ","4220160574467","Sindh","Karachi"),
("1012","Imran Hussain Shah Alias Mano Shah","Mulazim Hussain Shah","3810262233333","Punjab","BHAKKAR"),
("1013","Imran Rasheed ","Abdul Rasheed Arshad ","3410172365647","Punjab","GUJRANWALA"),
("1014","Imran Said","Muhammad Said","1620257384465","KP","SWABI"),
("1015","Imran Shabbir alias Imran Jani ","Ghulam Shabbir ","3610233425145","Punjab","KHANEWAL"),
("1016","Imran shah","Hafiz Abul Aziz","3650128620595","Punjab","SAHIWAL"),
("1017","Imran Siddique ","Muhammad Bakhsh","3120248884793","Punjab","BAHAWALPUR"),
("1018","Imran Ullah","Khushal Khan","1530651930543","KP","LOWER DIR (AT TEMERGARA)"),
("1019","Imran Yousaf alias Dr. Imran ","Muhammad Yousaf ","3320202762571","Punjab","JHANG"),
("1020","Imtiaz","Dost Muhammad","3340105313663","Punjab","CHINIOT"),
("1021","Imtiaz","Muhammad Shareef","8230158716657","AJ&K","POONCH"),
("1022","Imtiaz Ahmad","Mian Khan ","3440105735317","Punjab","MANDI BAHAUDDIN"),
("1023","Imtiaz Ali Khokhar alias Taji Khokhar","Allah Ditta","6110173392477","Punjab","RAWALPINDI"),
("1024","Inam Ali","Obaid Ali Khan","1610174198851","KP","MARDAN"),
("1025","Inam ul Haq","Mehboob Elahi","3520272054445","Punjab","LAHORE"),
("1026","Inam Ullah","Muhammad Ramzan","1210318920555","KP","Dikhan"),
("1027","Inam Ullah alias Abdullah","Hafiz Muhammad Hussain Arshad ","3210325031507","Punjab","DERA GHAZI KHAN"),
("1028","Inam-Ul-Haq","Muhammad Ashraf","3110177365769","Punjab","BAHAWALNAGAR"),
("1029","Inam-ul-Haq","Hafiz Abdul Haq","3240388098665","Punjab","RAJANPUR"),
("1030","Inam-ur-Rehman alias Abdullah, Talha, Zubair Siyaf","Abdul Sattar ","3120508819733","Punjab","BAHAWALPUR"),
("1031","Inamullah","Ali Hussain  ","4240194603027","Sindh","Karachi"),
("1032","Inayat Khan @ Amir Sahib","Khaista Khan","1530314360939","KP","LOWER DIR (AT TEMERGARA)"),
("1033","Inayat ul Haq","Muhammad Saleh","1510125566963","KP","BUNER"),
("1034","Inayat Ullah","Muhib ullah","1510103247437","KP","BUNER"),
("1035","Inayat Ullah ","Aman Ullah  ","3810148041789","Punjab","BHAKKAR"),
("1036","Inayat ur Rehman","Sher Gul","1530209252979","KP","LOWER DIR (AT TEMERGARA)"),
("1037","Intazar Ahmad","Muhammad Riaz","3650164604315","Punjab","SAHIWAL"),
("1038","Intisar Shah ","Iftikhar Hussain Shah","4550150026473","Sindh","Sukkur"),
("1039","Intizar Hussain","Muhammad Hussain ","3720146635205","Punjab","CHAKWAL"),
("1040","Iqbal Haider ","Ghulam Hyder ","4210118261697","Sindh","Karachi"),
("1041","Iqbal Hassan","Ahmad Habib","1530771122411","KP","LOWER DIR (AT TEMERGARA)"),
("1042","Iqbal Hussain","Nasrullah","1730112313639","KP","PESHAWAR"),
("1043","Iqbal Khan","Abdul Rauf @ Talib","1510149042131","KP","BUNER"),
("1044","Iqrar",". Umar Zada","157018949617","KP","Dir Upper"),
("1045","Irfan","Biban Raziq","1570118858959","KP","UPPER DIR (AT DIR)"),
("1046","Irfan Anjum ","Muhammad Ishaq ","3430117814927","Punjab","HAFIZABAD"),
("1047","Irfan Khan @ Chota ","Muhammad Ibrar Khan","4240134296935","Sindh","Karachi"),
("1048","Irfan Khan Alias Irfan Sanwal","Muhammad Nawaz","3320233127405","Punjab","JHANG"),
("1049","Irfan Raza ","Ali Raza","3120558723015","Punjab","BAHAWALPUR"),
("1050","Irshad","Mubarak Shah","1570171583451","KP","UPPER DIR (AT DIR)"),
("1051","Irshad","Taj Mohammad","1570142606577","KP","UPPER DIR (AT DIR)"),
("1052","Irshad Ahmed Shamsi ","Mukhtar Ahmed","4520343456295","Sindh","Khairpur"),
("1053","Irshadul Haq","Alah Dhand","1540262456795","KP","MALAKAND P.A."),
("1054","Isar ul Haq","Saeed ul Haq","","KP","Haripur"),
("1055","Ishaq","Sher Zada","1530512686223","KP","LOWER DIR (AT TEMERGARA)"),
("1056","Ishfaq Ahmad alias Ishfaq Moavia, Ishfaq Khair Pur","Ghulam Muhammad ","3120465509839","Punjab","BAHAWALPUR"),
("1057","Islam","Gul Rehman","1530209550925","KP","LOWER DIR (AT TEMERGARA)"),
("1058","Islam","Bahadar","1570425096957","KP","UPPER DIR (AT DIR)"),
("1059","Islam","Muhammad Amin","","KP","Peshawar"),
("1060","Ismail","Gul Nawaz","1110168060461","KP","BANNU"),
("1061","Ismail","Ziarat Gul","1531056607331","KP","LOWER DIR (AT TEMERGARA)"),
("1062","Israr "," Munir","8210134003249","AJ&K","Hari Gehl, District Bagh"),
("1063","Israr Ahamd @ Jangi Commander","Abdul Rahim","1560262824993","KP","SWAT (AT MINGORA)"),
("1064","Israr Hussain ","Manzoor Hussain","3330391817125","Punjab","TOBA TEK SINGH"),
("1065","Israr Hussain Shah","Syed Kifayat Hussain Shah","1330205343219","KP","Haripur"),
("1066","Israr Muhammad","Farid Khan","1610165935727","KP","MARDAN"),
("1067","Israr ul Haq","Mula Buzarg","1530209189489","KP","LOWER DIR (AT TEMERGARA)"),
("1068","Izat Ullah","Shakir Ullah","1530555391737","KP","LOWER DIR (AT TEMERGARA)"),
("1069","Izhar","Gul Dad","1530746631749","KP","LOWER DIR (AT TEMERGARA)"),
("1070","Jafar Ali ","Sher Muhammad ","3310060103695","Punjab","FAISALABAD"),
("1071","Jafar Ali Shah","Muhammad Shah","3320116288729","Punjab","CHINIOT"),
("1072","Jaffar Tayiar","Rabnawaz","3210307637313","Punjab","DERA GHAZI KHAN"),
("1073","Jahan Badshah","Hamesh Gul","1530746013283","KP","Dir Lower"),
("1074","Jahangir","Dost Muhammad","1540108276103","KP","MALAKAND P.A."),
("1075","Jahangir","Firdous","1720173411233","KP","NOWSHERA"),
("1076","Jahanzaib Raisani","Orangzaib Raisani.","5440010072083","Balochistan","QUETTA"),
("1077","Jahanzeb","Juma Khan","1610192688697","KP","MARDAN"),
("1078","Jalees Ahmad Khan","Manzoor Ahmad","3810145920009","Punjab","BHAKKAR"),
("1079","Jalil","Shams-ur-Rahim","1530229102229","KP","LOWER DIR (AT TEMERGARA)"),
("1080","Jamal Abdul Nasir","Nisar Ahmad Bhatti","3130316687395","Punjab","Rahim Yar Khan"),
("1081","Jamaldin","Ghulam Nabi Manjhoto ","4540123845255","Sindh","SHAHEED BENAZIRABAD"),
("1082","Jameel Ahmad","Islam Din","3450114959279","Punjab","NAROWAL"),
("1083","Jameel Ahmed Yousafzai. ","Naseer Ahmed","5150384845519","Balochistan","LASBELA (AT UTHAL)"),
("1084","Jamil Shah","Zareen Shah","1620296615049","KP","SWABI"),
("1085","Jamshaid Iqbal","Hafiz Muhammad Ismail","3310312268665","Punjab","Vehari"),
("1086","Jamshaid Khan Tabassum alias Bamboo","Abdul Jabbar ","4200035490057","Punjab","HAFIZABAD"),
("1087","Jamshed","Pam Jan","1560202768569","KP","SWAT (AT MINGORA)"),
("1088","Jamshid","Said Zaman","1530737150495","KP","Dir Lower"),
("1089","Jan Alam","Bakhtiyar","1570165000347","KP","UPPER DIR (AT DIR)"),
("1090","Jan Dost","Hamid Khan","1530210070991","KP","LOWER DIR (AT TEMERGARA)"),
("1091","Jan said Qasab","Aman Khan","1530751107695","KP","LOWER DIR (AT TEMERGARA)"),
("1092","Jan Wali","Muhammad Ramzan","1730193988257","KP","PESHAWAR"),
("1093","Jan Zada","Chamnay","1570111677329","KP","UPPER DIR (AT DIR)"),
("1094","Javaid ","  Nusrat.","7150122093939","Gilgit-Baltistan","GILGIT"),
("1095","Javaid Akhtar ","Muhammad Sadiq ","3310424720253","Punjab","FAISALABAD"),
("1096","Javed","Nawab Uddin ","4210177522715","Sindh","Karachi"),
("1097","Javed","Said Ahmed","1720188032917","KP","NOWSHERA"),
("1098","Javed Akhtar ","Muhammad Ramzan ","3130179161685","Punjab","RAHIM YAR KHAN"),
("1099","Javed Iqbal","Khuda Bakhsh","3710116847535","Punjab","Attock    "),
("1100","Javed Iqbal","Sultan Ahmad","3430169460225","Punjab","HAFIZABAD"),
("1101","Javed Iqbal","Noor Muhammad","3530197814987","Punjab","Okara"),
("1102","Javed Iqbal","Karam Din","4240145386423","Punjab","JHELUM"),
("1103","Javed Khan","Dawai Khan","2240145714133","KP","KOHAT"),
("1104","Javeed Iqbal ","Muhammad Iqbal","3740569277289","Punjab","CHAKWAL"),
("1105","Javeed Iqbal ","Atta Muhammad ","3320216558373","Punjab","JHANG"),
("1106","Javid","Khan Shehzada","1530208643661","KP","Dir Lower"),
("1107","Jawad","Falak Sher","1720109452747","KP","NOWSHERA"),
("1108","Jawad","Islam Gul","1111111111128","KP","PESHAWAR"),
("1109","Jawad Habib Ullah Sawati","Maqsood Alam ","3740555997789","Punjab","LAHORE"),
("1110","Jawad Hadi ul Hassan","Ahmad Shah","2130322599447","KP","PESHAWAR"),
("1111","Jawad Khan","M. Nisar","1530722360759","KP","LOWER DIR (AT TEMERGARA)"),
("1112","Jawad Ur Rehman ","Mazkoor Ahmed Rao ","3520135147631","Punjab","LAHORE"),
("1113","Jehanzeb","Saeed Khan","1730118214071","KP","PESHAWAR"),
("1114","Jihanzaib ","Abdul Qayuum","1350415460841","KP","TORGHAR (AT OGHI)"),
("1115","Juma Khan","Saffar Mohammad ","5620117445527","Balochistan","KILLA SAIFULLAH"),
("1116","Junaid Ahmad  ","Irshad Ahmad","3630231547585","Punjab","MULTAN"),
("1117","Kabeer","Sagheer /Zafeer Ahmad r/o","1310173965521","KP","ABBOTTABAD"),
("1118","Kabir Ahmad","Haji Allah Yar","3620165391257","Punjab","LODHRAN"),
("1119","Kacholl Muhammad","Shah Jamal","2110323066011","KP","BAJAUR (AT KHAR BAJAUR)"),
("1120","Kaleem Ullah ","Haji Abdul Rehman ","3210209217481","Punjab","DERA GHAZI KHAN"),
("1121","Kaleem Ullah ","Fateh Muhammad","3410190271821","Punjab","GUJRANWALA"),
("1122","Kaleem Ullah","Gul Aman","1570117917379","KP","UPPER DIR (AT DIR)"),
("1123","KALEEM ULLAH AZIZ","ABDUL AZIZ","3420207270801","Punjab","GUJRAT"),
("1124","Kaleem Ullah Muavia ","Taj Muhammad","3540271581657","Punjab","NANKANA SAHIB"),
("1125","Kaleem ur Rehman","Fazal ur Rehman","1330205228099","KP","HARIPUR"),
("1126","Kamal ud Din","Dilbar Hussain","1530742146253","KP","LOWER DIR (AT TEMERGARA)"),
("1127","Kamran Ahmed alias Kami","Muhammad Razaq","3420207718289","Punjab","GUJRAT"),
("1128","Kamran Khan ","Mohammad Khan ","NIL","Sindh","Karachi"),
("1129","Kamran Raza alias Goga Shah ","Syed Tajamul Hussain Shah ","3230349528059","Punjab","MUZAFFARGARH"),
("1130","Kamran Waheed","Sheikh Abdul Waheed","3520194659407","Punjab","LAHORE"),
("1131","Karam Ellahi","Khan Zaman ","3710565844721","Punjab","ATTOCK"),
("1132","Karbalai  Rajab  Ali. ","Abbas Counsilor","5440063852795","Balochistan","QUETTA"),
("1133","Karim Bux ","Babal @ Baran @ Bahram Brohi","4330289985805","Sindh","Shikarpur"),
("1134","Kashif","Muhammad Zaman @ Mir Ali","","KP","Bannu"),
("1135","Kashif Hassan @ Hamza ","Gul Hassan Samo","4130326548181","Sindh","Hyderabad"),
("1136","Kashif Husain Attari Qadri ","Mubarak Ali ","3310471281225","Punjab","FAISALABAD"),
("1137","KASHIF mUSHTAQ","MUSHTAQ AHMAD","3420123906473","Punjab","Gujrat"),
("1138","Kashif Nizam alias Kashi ","Nizam Din ","3130326735007","Punjab","RAHIM YAR KHAN"),
("1139","Khadim Hussain","Shamoo Khan","3620105750631","Punjab","MUZAFFARGARH"),
("1140","Khadim Hussain ","Nazir Hussain ","3410341589899","Punjab","GUJRANWALA"),
("1141","Khadim Hussain Badshah","Bashir Hussain Akhtar","3320305952497","Punjab","Jhang"),
("1142","Khadim Hussain Magsi ","Dolat Khan","4220111254569","Sindh","Karachi"),
("1143","Khair","s/o Said Aman","1570159169195","KP","UPPER DIR (AT DIR)"),
("1144","Khair Abba","Muhammad Zareef","3740198226305","Punjab","RAWALPINDI"),
("1145","Khair Muhammad","Gul Azam caste Gian khel","","KP","Bannu"),
("1146","Khaista Rahim","Rehmat Ullah","1530585845697","KP","LOWER DIR (AT TEMERGARA)"),
("1147","Khaista Rahim","Feroz","1530539900205","KP","Dir Lower"),
("1148","Khalid Imran ","Muhammad Hanif ","4210195806221","Sindh","Karachi"),
("1149","Khalid Iqbal ","Haji Ahmed ","4250120451719","Punjab","JHELUM"),
("1150","Khalid Mehmood ","Abdul Razzaq ","3120189158345","Punjab","BAHAWALPUR"),
("1151","Khalid Mehmood ","Tariq Mehmood ","3310007741865","Punjab","FAISALABAD"),
("1152","Khalid Mehmood (Malik Awan)","Abdul Ghafoor","3730347986761","Punjab","JHELUM"),
("1153","Khalid Mehmood @ Khalid ","Fareed Khan Brohi","4330415192839","Sindh","Shikarpur"),
("1154","Khalid Mehmood alias Bilal Naqshbandi ","Sher Muhammad","3710502620181","Punjab","ATTOCK"),
("1155","Khalid Mehmood alias Mooda ","Tayyab Khan ","3720397048597","Punjab","CHAKWAL"),
("1156","Khalid Mehmood S/o Muhammad Subhan  ","Muhammad Subhan Khan ","3520114139885","Punjab","LAHORE"),
("1157","Khalid Saifullah","Mir Muhammad Abbasi","4530452125863","Sindh","N-Feroze"),
("1158","Khalid Usman","Manzoor Ahmad","3840604185101","Punjab","SARGODHA"),
("1159","Khalid Yousaf Bari ","Muhammad Yousuf ","422012833555","Sindh","Karachi"),
("1160","Khalid Zaman ","Mehar Zaman","2170245755545","KP","S.WAZIRISTAN (AT WANA)"),
("1161","Khalil","Mian Sultan Zeb","1510161206939","KP","BUNER"),
("1162","Khalil Ahmad","Noor Muhammad","3710502443313","Punjab","Attock    "),
("1163","Khalil Ahmad","Mubarak Ali","3230448572037","Punjab","Muzaffargarh"),
("1164","Khalil Ahmed ","Ghulam Muhamm","3630190228403","Punjab","MULTAN"),
("1165","Khalil Ahmed","Buland Khan. ","4310133650289","Balochistan","LASBELA (AT UTHAL)"),
("1166","Khalil Ahmed","Haji Ghulam Hussain","3220210265433","Punjab","LAYYAH"),
("1167","Khalil Ahmed Butt","Abdul Majeed","3450128903017","Punjab","Narowal"),
("1168","Khalil Ur Rehman","Fazal Rehman","1730115640465","KP","PESHAWAR"),
("1169","Khalil-ur-Rehman ","Muhammad Rafique","3660314576027","Punjab","VEHARI"),
("1170","Khan Bacha","Shams ul Haq","2140624056109","KP","NOWSHERA"),
("1171","Khan Muhammad","Muhammad Sahib","1510116177747","KP","BUNER"),
("1172","Khan Sahib","Abdullah Khan","1110151334755","KP","BANNU"),
("1173","Khan Shehzada","Zarawar Khan","1530367979011","KP","Dir Lower"),
("1174","Khanzala ","Zarmal Khan","2170569769949","KP","S.WAZIRISTAN (AT WANA)"),
("1175","Khawaja Muhammad Ishaq ","Muhammad Bux","4410303580085","Sindh","Mirpurkhas"),
("1176","Khawaja Muhammad Sadiq ","Seraj Ahmad     ","3120218272807","Punjab","BAHAWALPUR"),
("1177","Khawaja Muhammad Saqib ","Muhammad Saleem Shehryar ","3440261771371","Punjab","MANDI BAHAUDDIN"),
("1178","Khawar Abbas ","Muhammad Latif ","3410319277395","Punjab","GUJRANWALA"),
("1179","Khawar Shahzad","Manzoor Ellahi","3710339462825","Punjab","ATTOCK"),
("1180","Khawar Walayat","Walayat Khan","3410438356791","Punjab","GUJRAT"),
("1181","Khizar Abbas Shah ","Syed Bahar Hussain Shah","3660252113475","Punjab","Vehari"),
("1182","Khizar Hayat","Mir Asad (Hassan)","1720132967133","KP","NOWSHERA"),
("1183","Khizar Hayat ","Talib Hussain ","3320306775179","Punjab","JHANG"),
("1184","Khuda Bakhsh ","Muhammad Noor Caste Marra","5530244332533","Balochistan","SIBI"),
("1185","Khuda Baksh alias Manoo","Ghulam Mehmood","3310432565415","Punjab","FAISALABAD"),
("1186","Khuda-e-Rahim","Muhammad Azam Caste Kasi","5440175207773","Balochistan","QUETTA"),
("1187","Khurram Iqbal","Syed Iqbal Hussain","3520230386923","Punjab","LAHORE"),
("1188","Khurram Shahzad ","Muhammad Taj ","3710287232327","Punjab","Attock    "),
("1189","Khurram Shehzad ","Salah-ud-Din","3520223049407","Punjab","LAHORE"),
("1190","Khurram Shehzad ","Lal Khan ","3440370871051","Punjab","MANDI BAHAUDDIN"),
("1191","Khurshid ","Haji Sawab","2140691998923","KP","KHYBER (AT PESHAWAR)"),
("1192","Khurshid","Haq Dad","1720109873735","KP","NOWSHERA"),
("1193","Khurshid Alam @ Musa","Sahib Zada","1510198895597","KP","BUNER"),
("1194","Khurshid Anwar","Molvi Fazal","1330204546397","KP","HARIPUR"),
("1195","Khurshid Anwar Jowadi","Tahir Azmi","1410107645431","KP","HANGU"),
("1196","Khushal Khan","Abdul Qaddar","1570224997833","KP","LOWER DIR (AT TEMERGARA)"),
("1197","Kifayat Ullah","Ghulam Haider","2250105952553","KP","PESHAWAR"),
("1198","Kin Khab Shah","Masheer","1550454154816","KP","SHANGLA (AT ALPURI)"),
("1199","Konain Abbas ","Jaffar Hussain","3410403386079","Punjab","GUJRANWALA"),
("1200","Laeq Ahmed alias Danish","Muhammad Rafique","3720334974839","Punjab","CHAKWAL"),
("1201","Laiq Zaman","Gul Khan","1720119479291","KP","NOWSHERA"),
("1202","Laiqat Ali","bhageel khan","3540219903151","Punjab","Nankana Sahib"),
("1203","Lajbar Khan","Noor Jamal","1610112089253","KP","MARDAN"),
("1204","Lakhano Rind ","Yar Muhammad","4410432155535","Sindh","Umerkot"),
("1205","Lal Jan  "," Noor Bakhsh","5630356503403","Balochistan","BARKHAN"),
("1206","Lal Shah","Rokhan","2140149710583","KP","BAJAUR (AT KHAR BAJAUR)"),
("1207","Lal Zada","Gul Zada","1510103524341","KP","BUNER"),
("1208","Lal Zaman @ Qari","Abdul Khaliq (Haq)","1530209302937","KP","LOWER DIR (AT TEMERGARA)"),
("1209","Lal Zarin","Zarawar Khan","1530466200051","KP","Dir Lower"),
("1210","Latif","Ayub","1570477737909","KP","UPPER DIR (AT DIR)"),
("1211","Latif Ullah","Hafiz Ullah","1570133190207","KP","UPPER DIR (AT DIR)"),
("1212","Latif ur Rehman","Shah Yousaf","1620209342625","KP","SWABI"),
("1213","Lawang Khan @ Ghulam Farooq","Shah Jahan ","5410275668651","Balochistan","NUSHKI"),
("1214","lftikhar Ahmad","Malik Manzoor Hussain","3660335810017","Punjab","VEHARI"),
("1215","Liaqat Ali ","Wazir Ahmad Khan ","3210396838915","Punjab","DERA GHAZI KHAN"),
("1216","Liaqat Ali ","Noor Muhammad ","3410143365277","Punjab","GUJRANWALA"),
("1217","Liaqat Ali","Hasan Khan","3320371235105","Punjab","Jhang"),
("1218","Liaqat Ali","Qaim-ud-Din","1730118833735","KP","PESHAWAR"),
("1219","Liaqat Ali ","Barkat Ali ","3330283086177","Punjab","TOBA TEK SINGH"),
("1220","Liaqat Ali ","Muhammad Faiz ","3320385834031","Punjab","JHANG"),
("1221","Liaqat Hussain Abbasi ","Muhammad Faris ","3740402378785","Punjab","RAWALPINDI"),
("1222","Liaqat Ullah","Ashiq Hussain","1210117629777","KP","DERA ISMAIL KHAN"),
("1223","Liaquat Ali Sasoli.","Khuda Bakhsh","5140232184241","Balochistan","KHUZDAR"),
("1224","lnayat-ur-Rehman","Muhammad Rafiq","3840401550671","Punjab","SARGODHA"),
("1225","lrfan Shafi","Muhammad Shafi","3740183404581","Punjab","RAWALPINDI"),
("1226","Lutuf Ali","Ghulam Nabi Abro","4120578428549","Sindh","Dadu"),
("1227","M. Arshad","M. Younis","9040301052649","AJ&K","Rawli Dhokan, Hari Gehl Bagh"),
("1228","M. Asghar","Imam Baksh","3660265568769","Punjab","Vehari"),
("1229","M. Ibraheem ","Moulvi Abdul Haq Badeni Brohi","4310220061203","Sindh","Jacobabad"),
("1230","M. Irshad","M. Yaqoob","3660294083195","Punjab","Vehari"),
("1231","M. Ishfaq","Gul Zaman","8220317559233","AJ&K","Seryian Muzaffarabad"),
("1232","M. Iyaz ","Fazal Hussain","8240184124969","AJ&K","Nakar Dana Sudhnoti "),
("1233","M. Kashif ","M Iqbal","8230314430013","AJ&K","Barian Pachiot Rawalakot"),
("1234","M. Naeem "," Abdul Qadeer","8220334242213","AJ&K","Lower Plate Muzaffarabad"),
("1235","M. Rashid","M. Younis","8210141721701","AJ&K","Rawli Dhokan, Hari Gehl Bagh"),
("1236","M. Umair","M. Ajmal","3660266701349","Punjab","Vehari"),
("1237","M. Yasir ","M Yaqoob","4210114616863","AJ&K","Makri Muzaffarabad"),
("1238","M: Basir @ Zarqavi","Muhammad Yaqoob","1530599017209","KP","LOWER DIR (AT TEMERGARA)"),
("1239","Maaz uddin","Izzat Gul","1530725773781","KP","LOWER DIR (AT TEMERGARA)"),
("1240","Mahmood","Baz Mahammad","1570178575415","KP","UPPER DIR (AT DIR)"),
("1241","Mahmood Ahmed alias Muavia ","Abdul Majeed","3640299289999","Punjab","PAKPATTAN"),
("1242","Mahmood Iqbal ","Abdul Khaliq Saeed ","3120332337205","Punjab","BAHAWALPUR"),
("1243","Mahrab","Umar Zada","1570150014965","KP","UPPER DIR (AT DIR)"),
("1244","Mahran Gul","Haji Manzoor Ahmad","3320214266645","Punjab","JHANG"),
("1245","Mairaj Din ","Noor Din ","3120231167261","Punjab","BAHAWALPUR"),
("1246","Majeebullah","Naeemullah  ","5430320110389","Balochistan","PISHIN"),
("1247","Majid Ali","Ahmed Shakoor","3130350492987","Punjab","Rahim Yar Khan"),
("1248","MAJID HUSSAIN","MUHAMMAD NAZIR","3420187028515","Punjab","Gujrat"),
("1249","Majid Imran ","Abdul Hameed ","3450161919463","Punjab","NAROWAL"),
("1250","Major (R) Ch. Zaheer ud Din","Ch. Miraj Din","3520175184001","Punjab","Lahore"),
("1251","Malang Jan","Arsh Ullah","1610148584879","KP","UPPER DIR (AT DIR)"),
("1252","Malik Abid Farooqi ","khan Muhammad","3120103284735","Punjab","Bahawalpur"),
("1253","Malik Amjad Ali alias Amjad Ali ","Ghulam Muhammad ","3430139851275","Punjab","HAFIZABAD"),
("1254","Malik Fiyyaz Haider ","Malik Mohib Hussain ","3810277634257","Punjab","BHAKKAR"),
("1255","Malik Haq Nawaz ","Malik Falak Sher ","3810341814757","Punjab","BHAKKAR"),
("1256","Malik Hassan Abbas","Malik Muhammad Waris","3320158473283","Punjab","CHINIOT"),
("1257","Malik Jalal Ud Din ","Hassan Muhammad ","3810209106205","Punjab","BHAKKAR"),
("1258","Malik Khizar Hayat"," Malik Ghulam Hussain ","3520231505723","Punjab","LAHORE"),
("1259","Malik Muhammad Arslan ","Malik Muhammad Baqir ","3520278370683","Punjab","LAHORE"),
("1260","Malik Muhammad Faisal alias Malik Bloch","Muhammad Anwar","3310603219877","Punjab","FAISALABAD"),
("1261","Malik Muhammad Rizwan ","Muhammad Aslam ","3120117036223","Punjab","BAHAWALPUR"),
("1262","Malik Muhammad yaqoob","Muhammad Rafique","3130114988953","Punjab","Rahim Yar Khan"),
("1263","Malik Rashid Mehmood ","Malik Manzoor Ahmed","3130221304207","Punjab","RAHIM YAR KHAN"),
("1264","Malik Sajjad Hussain ","Malik Barkhurdar Khan ","3210307694481","Punjab","DERA GHAZI KHAN"),
("1265","Malik Shah Nawaz Khalil ","Khalil Ahmed ","3810209190155","Punjab","BHAKKAR"),
("1266","Malik Shahzad Nadeem","Malik Sadar ud Din","3710528475287","Punjab","Attock    "),
("1267","Malik Zafar Iqbal Shahbaz ","Malik Sardar Ali ","3520241359487","Punjab","SHEIKHUPURA"),
("1268","Malki Khan","Subati","1510108115443","KP","BUNER"),
("1269","Malook","Khanam Roz","1570244404541","KP","UPPER DIR (AT DIR)"),
("1270","Mamu Khan ","Abdullah Khan (Late)","4210116480767","Sindh","Karachi"),
("1271","Mansoor Ahmad","Muhammad Haleem","1530284565499","KP","LOWER DIR (AT TEMERGARA)"),
("1272","MANSOOR AHMED","MOLANA SHEIKH AHMED","3730182785469","Punjab","Gujranwala"),
("1273","Mansoor Lehri","Ghulam Sarwar","5440078672139","Balochistan","QUETTA"),
("1274","Manzar Abbas ","Ghulam Abbas","3820193589305","Punjab","KHUSHAB"),
("1275","Manzar Abbas","Abid Hussain","3320116602795","Punjab","CHINIOT"),
("1276","Manzoor","Muhammad Ramzan ","3310426584229","Punjab","FAISALABAD"),
("1277","Manzoor Ahmad Alias Akasha","Ameer Ahmad","3810208848485","Punjab","BHAKKAR"),
("1278","MANZOOR AHMAD Alias Saif-ur-Rehman","KHUSHI MUHAMMAD","3530138305925","Punjab","OKARA"),
("1279","Manzoor Ahmed Lehri","Ghulam Sarwar","5440083411531","Balochistan","QUETTA"),
("1280","Manzoor Hussain ","Charagh Din ","3310006492889","Punjab","FAISALABAD"),
("1281","Manzoor Parwana ex president BSF "," Muhammad Hussain","4220105394855","Gilgit-Baltistan","BALTISTAN (AT SKARDU)"),
("1282","Maqbool Ahmed","Ghulam Nabi","3460101515667","Punjab","Sialkot"),
("1283","Maqbool Ahmed ","Abdul Rasheed ","3130321209785","Punjab","RAHIM YAR KHAN"),
("1284","Maqbool Hussain","Muhammad Shafi","3410160638027","Punjab","GUJRANWALA"),
("1285","Maqbool Raisani @ Chotay","Saleh Muhammad","5440154050121","Balochistan","QUETTA"),
("1286","Maqsood Ahmad alias Javeed Ahmad","Sardar Muhammad ","3650221226503","Punjab","BAHAWALPUR"),
("1287","Maqsood Ahmed","Rehmat Ali","3640230446095","Punjab","PAKPATTAN"),
("1288","Maqsood Ahmed","Muhammad yaqoob","3320312793043","Punjab","Jhang"),
("1289","Maqsood Ahmed ","Mohd. Ishaq ","5440156191045","Balochistan","QUETTA"),
("1290","Maqsood Ali Khan ","Muhammad Ali","1520189454643","KP","CHITRAL"),
("1291","Maqsood Yameen ","Naik Muhammad ","3630256516931","Punjab","MULTAN"),
("1292","Marham Ullah @ Rahim Ullah","Muhammad Amin Ullah","1510103733083","KP","BUNER"),
("1293","Maroof Ahmad Mirza alias Hafiz Gee (Mughal)","Mirza Nizam ud Din","3730109541207","Punjab","JHELUM"),
("1294","Mashkoor Hussain ","Mian Safdar Hussain ","3230360067747","Punjab","MUZAFFARGARH"),
("1295","Masjood Ahmad","Ghulam Mustafa","3130135216813","Punjab","Rahim Yar Khan"),
("1296","Masood","Abdul Jabar","1730114661543","KP","PESHAWAR"),
("1297","MASOOD-UL-HASSAN","GHULAM RASOOL","3840553299185","Punjab","SARGODHA"),
("1298","Masroor Nawaz","Maulana Haq Nawaz","3320231521181","Punjab","Jhang"),
("1299","Master Hafeez-ur-Rehman ","Hafiz Abdul Rehman ","3210333588211","Punjab","DERA GHAZI KHAN"),
("1300","Master Sher Afzal","Abdul Hameed","1310128367385","KP","ABBOTTABAD"),
("1301","Master Syed Qaisar Abbass","Mazhar/ (Syed Nazar Hussain) Nazeer Hussain","1430126633381","KP","Kohat"),
("1302","Mateh Ul Haq","s/o Akbar Khan r/o Shaore","1570173890185","KP","UPPER DIR (AT DIR)"),
("1303","Mati ullah","Sazullah","1530552804979","KP","LOWER DIR (AT TEMERGARA)"),
("1304","Mati Ullah","Attiqur Rehman","1560161525815","KP","SWAT (AT MINGORA)"),
("1305","Mati Ullah ","Anwar Ullah ","3330388788075","Punjab","TOBA TEK SINGH"),
("1306","Mati Ullah ","Said Hassan","1730176533499","KP","PESHAWAR"),
("1307","Matloob ur Rehman @ Salah ud Din","Maqsood ur Rehman","3740589186211","KP","ABBOTTABAD"),
("1308","Maulana Abdul Aziz","Muhammad Abdullah","6110119576777","ICT","ISLAMABAD\n\n"),
("1309","Maulana Abdul Hakeem Mengal","Mohammad Noor. ","5340219589301","Balochistan","NASIRABAD  (AT D.M.JAMALI)"),
("1310","Maulana Abdul Wakeel","Sham ur Rehman","1620208963955","KP","SWABI"),
("1311","Maulana Aziz Ahmad","Ameen ul Haq r","1620209855373","KP","SWABI"),
("1312","Maulana Faraz Ahmed "," Walayat Khan.","7150129104315","Gilgit-Baltistan","GILGIT"),
("1313","Maulana Hafiz Muhammad Awais ","Muhammad Saddique ","3330303885767","Punjab","TOBA TEK SINGH"),
("1314","Maulana Khalil Ahmed @ Sadi ","Hazoor Bakhsh","5440166298135","Balochistan","QUETTA"),
("1315","Maulana Masood Azhar ","Allah Bakhsh Sabir","0000123456789","Punjab","BAHAWALPUR"),
("1316","Maulana Nazir Ahmad","Amir Muhammad","1350331400083","KP","MANSEHRA"),
("1317","Maulana Sahib Ali Tunio @ Haideri","Gul Mohammad. ","5340212417687","Balochistan","NASIRABAD  (AT D.M.JAMALI)"),
("1318","Maulana Shah Abdul Aziz","Maulana Shaheed Ahmad","6110167944045","KP","KARAK"),
("1319","Maulana Waheed Abbas","Abbas Ali Shah","1330234890923","KP","HARIPUR"),
("1320","Maulvi Mohammad Hanif  ","Jallai","5410130066363","Balochistan","CHAGAI (AT DALBANDIN)"),
("1321","Maulvi Sadiq Ullah Daur Alias Sadique","Malik Khanam Shah ","2150661482869","KP","N.WAZIRISTAN (AT MIRAN SHAH)"),
("1322","Maveez Khan Alia Maveezgai ","Zangay","2150180828031","KP","N.WAZIRISTAN (AT MIRAN SHAH)"),
("1323","Maysam Timar","Ashiq Hussain","3320327157301","Punjab","Jhang"),
("1324","Mazhar Abbas","Ghazanfar Abbas","3330386080257","Punjab","SAHIWAL"),
("1325","Mazhar Abbas Khan ","Riaz Hussain Khan ","3320290147945","Punjab","JHANG"),
("1326","Mazhar Ali","Malik Muhammad Shafi","3320403578099","Punjab","Jhang"),
("1327","Mazhar Hussain ","Muhammad Ali ","3310098608225","Punjab","FAISALABAD"),
("1328","Mazhar Mukhtar","Mukhtar Ahmed ","3460123298241","Punjab","SIALKOT"),
("1329","Meeran Bakhsh alias Meero Caste Syedani Bugti","Niaz Muhammad","3240459803991","Punjab","RAJANPUR"),
("1330","Mehar Dad @ Bola","Shahbaz Khan","1610160194329","KP","MARDAN"),
("1331","Mehboob Ahmad ","Muhammad Munir ","3410262064795","Punjab","GUJRANWALA"),
("1332","Mehboob Ali","Shama Khel","1560276992619","KP","SWAT (AT MINGORA)"),
("1333","Mehboob Ali","Noor ul Wahab","1550448773551","KP","SHANGLA (AT ALPURI)"),
("1334","Mehboob Ali ","Muhammad Shareef","3810384795737","Punjab","BHAKKAR"),
("1335","Mehboob Hussain ","Hukamdad Khan ","4220176078953","Punjab","RAWALPINDI"),
("1336","Mehfooz-ul-Haq ","Ghulam Fareed","3520272835703","Punjab","VEHARI"),
("1337","Mehmood alias Babi  ","Imam Bakhsh","3610316332171","Punjab","KHANEWAL"),
("1338","Mehmood Aslam","Muhammad Aslam Javed","3110420268965","Punjab","BAHAWALNAGAR"),
("1339","Mehmood Babar @ Durkey Shah ","Sagheer Ahmed ","3410305393313","Sindh","Karachi"),
("1340","Mehmood Jhangir","Muhammad Jhangir","3640108810663","Punjab","Pakpattan"),
("1341","Mehmood ul Hassan","Sher Muhammad","1430155938109","KP","KOHAT"),
("1342","Mehmood Yaseen","Ghulam Yaseen","3120481563199","Punjab","DERA GHAZI KHAN"),
("1343","Mehmood-ul-Hassan ","Abdul Haq ","3110394345761","Punjab","BAHAWALNAGAR"),
("1344","Mehmood-ul-Hassan Awan ","Muhammad Khan Awan ","3410411539695","Punjab","GUJRANWALA"),
("1345","Mehmood-Ur-Rehman Siddiqi ","Hafiz Muhammad Sadiq Siddiqi ","3120218041619","Punjab","BAHAWALPUR"),
("1346","Mehr Muhammad Ali khan","Ghullam Hussain","3320240377943","Punjab","Jhang"),
("1347","Mehrban Ali Sultan","nasib u Din","3320279399295","Punjab","Jhang"),
("1348","Memboob shah","Bachal Shah Caste Kehri","5340144936799","Balochistan","NASIRABAD  (AT D.M.JAMALI)"),
("1349","Mian Amir Hasnain ","Mian Mushtaq Ahmad ","3230307866779","Punjab","MUZAFFARGARH"),
("1350","Mian Bali Shah","Bakht Biland","1560292341351","KP","SWAT (AT MINGORA)"),
("1351","Mian Mehmood ul Hassan ","Mian Ghulam Muhammad ","3520294520255","Punjab","LAHORE"),
("1352","Mian Miraj Uddin ","Lali Mian ","1530208617161","KP","LOWER DIR (AT TEMERGARA)"),
("1353","Mian Muhammad Naeem","Muhammad Abdullah","3540415657827","Punjab","Sheikhupura"),
("1354","Mian Munib Malak","Mian Muhammad Malak","3460206541565","Punjab","Sialkot"),
("1355","Minhas Adrees caste Abbasi","Muhammad Adrees","3740435795255","Punjab","RAWALPINDI"),
("1356","Mir Anwar Talpur ","Mir Hyder Bux","4550202405193","Sindh","Sukkur"),
("1357","Mir Fida Ahmed  Qalandrani. ","Muhammad Ishaq","5140169726759","Balochistan","KHUZDAR"),
("1358","Mir Khatim @ Faqir"," Badshah","2150983707077","KP","N.WAZIRISTAN (AT MIRAN SHAH)"),
("1359","Mir Nasir Hasnain Ramal "," Mir Aman","7150403936959","Gilgit-Baltistan","HUNZA"),
("1360","Mirza","Zareen Khan","1570163901657","KP","UPPER DIR (AT DIR)"),
("1361","Mirza","s/o Zareen Khan","","KP","Toorghar"),
("1362","Mirza Ghafoor Baig ","Mirza Abdul Khaliq Baig ","3740527603587","Punjab","RAWALPINDI"),
("1363","Mirza Khan ","unknown","Resident of Pakistan","Punjab","Mian Channu Lahore"),
("1364","Mirza Khan ","Naik Mohammad","5630259445761","Balochistan","LORALAI"),
("1365","Mirza Khan caste Qutabzai","Saleh Muhammad","5420398789613","Balochistan","KILLA ABDULLAH"),
("1366","Mirza Maqsood Amir ","Mirza Shafique Baig ","3520207676565","Punjab","LAHORE"),
("1367","Mirza Muhammad Luqman","Niaz Muhammad","3630204561851","Punjab","Multan"),
("1368","Mirza Qadeer Baig","Mirza Abdul Rehman Baig","3730172591697","Punjab","JHELUM"),
("1369","Mirza Saleem Baig ","Mirza Abdul Khaliq Baig ","3740535357267","Punjab","RAWALPINDI"),
("1370","Mirza Yousif  Hussain ","Shaikh Ghulam Muhammad","4210130570895","Sindh","Karachi"),
("1371","Moazam Hayat ","Rehmat Ali ","3460178863169","Punjab","SIALKOT"),
("1372","Mobeen Ahmed alias Shaqat","Muhammad Yaqoob","3510113055839","Punjab","KASUR"),
("1373","Mobeen Rehmat Ullah ","Muhammad Jameel ","3640221494669","Punjab","PAKPATTAN"),
("1374","Mohammad","Iqbal","","KP","Dikhan"),
("1375","Mohammad Afzal @ Murri","Naik Mohammad","5630193171613","Balochistan","LORALAI"),
("1376","Mohammad Ali Lehri","Mohammad Hussain ","5160286105913","Balochistan","MASTUNG"),
("1377","Mohammad Asif","Raheem Bakhsh","5210140095521","Balochistan","GWADAR"),
("1378","Mohammad Awaz ","Zarif Khan.","5330539863591","Balochistan","KACHHI (BOLAN) (AT DHADAR)"),
("1379","Mohammad Ayub","Mohammad Akbar","1570488716283","KP","Dir Upper"),
("1380","Mohammad Azam Nosherwani ","Haji  Mohd. Usman.","5140112108159","Balochistan","Khuzdar"),
("1381","Mohammad Azeem Miraji Mengal ","Mohammad Rahim.","5140386901321","Balochistan","KHUZDAR"),
("1382","Mohammad Bakhsh ","Sher Mohammad Kori.","5140144142221","Balochistan","KHUZDAR"),
("1383","Mohammad Hassan ","Mohammad Ismail","5140345000707","Balochistan","KHUZDAR"),
("1384","Mohammad Hotman Sasoli.","Gul Muhammad","5140198708487","Balochistan","KHUZDAR"),
("1385","Mohammad Hussain","Umar Khan","1570193901657","KP","UPPER DIR (AT DIR)"),
("1386","Mohammad Ibrahim","Mohd.Afzal ","5440047618725","Balochistan","QUETTA"),
("1387","Mohammad Ishaq","Abdul Karim. ","5230180645381","Balochistan","PANJGUR"),
("1388","Mohammad Mehdi @ Capt: Hadi ","Faqir Hussain ","4250153335415","Balochistan","QUETTA"),
("1389","Mohammad Nadeem @ Burger @ Nadeem Mulla","Mohammad Saleem Patel","NIL","Sindh","Karachi"),
("1390","Mohammad Shahid @ Sani ","Abdul Hakim ","NIL","Sindh","Karachi"),
("1391","Mohammad Shaid Sultan. ","Saifullah","5630273907807","Balochistan","LORALAI"),
("1392","Mohammad Shakir","Sheikh Mohammad Yaseen ","3740565359881","Punjab","RAWALPINDI"),
("1393","Mohammad Shareef Rind ","Gahi Khan","5320295931005","Balochistan","JAFFARABAD"),
("1394","Mohee Uddin Shah Holding ","Syed Hassan-ul-wahab","4250130209779","Sindh","Karachi"),
("1395","Mohib Ullah","Nowshad","4220104136545","KP","LOWER DIR (AT TEMERGARA)"),
("1396","Mohsin","Masood Kaimkhani","NIL","Sindh",""),
("1397","Mohsin Abbas ","Muhammad Nawaz ","3820104668569","Punjab","KHUSHAB"),
("1398","Mohsin Abbas","Riaz Hussain","3720152726917","Punjab","CHAKWAL"),
("1399","Mohsin Ali ","Ibrar Hussain ","3740569672241","Punjab","RAWALPINDI"),
("1400","Mohsin Mehmood ","Taj Mehmood ","3240244179059","Punjab","RAJANPUR"),
("1401","Mokamil @ Kamil","Gul Said","1610233276407","KP","MARDAN"),
("1402","Molan Abdul Razzaq","Abdul Manan Afghan National","1530702478977","KP","LOWER DIR (AT TEMERGARA)"),
("1403","Molana Abdul Raheem Sajid. ","Ali Sher","5440156763025","Balochistan","QUETTA"),
("1404","Molana Abdul Wahid","Abdullah","1540263100385","KP","MALAKAND P.A."),
("1405","Molana Agha Jehanzeb","Hanif Ghulam Bangash,","1410165593455","KP","ABBOTTABAD"),
("1406","Molana Aurangzaib Farooqi ","Misri Khan","4250124740951","Sindh","Karachi"),
("1407","Molana Gul Feroz","Gul Shereen","1350478060903","KP","MANSEHRA"),
("1408","Molana Maqbool Mir .","Muhammad Ayaz.","7150124765381","Gilgit-Baltistan","GILGIT"),
("1409","Molana Mati ul Haq","Molana Sufi Muhammad","1530765657133","KP","LOWER DIR (AT TEMERGARA)"),
("1410","Molana Muhammad Ayub","Gul Roz","1530482115155","KP","LOWER DIR (AT TEMERGARA)"),
("1411","Molana Muhammad Fayaz ","Muhammad Razi","4250122144801","Sindh","Karachi"),
("1412","Molana Muhammad Ghulam @ Ahmad Raza ","Pir Ghulam ","1120197387465","KP","TANK"),
("1413","Molana Muhammad Iqbal","Muhammad Ayub","1510114364229","KP","BUNER"),
("1414","Molana Muhammad Sadiq Khan","Kala Khan","1330288129237","KP","Haripur"),
("1415","Molana Said Raziq @ Haji Sahib","Fazal Raziq","1530210029677","KP","LOWER DIR (AT TEMERGARA)"),
("1416","Molana Toheed ur Rehman Tohidi @ Toheed","Sher Bahadar","1330251966375","KP","Haripur"),
("1417","Molvi Ab.Ghafoor ","Ab.Aziz","8230301761657","AJ&K","Tarar, District Poonch"),
("1418","Molvi Abdul Hakim","Mohammad Bacha","1570405255175","KP","UPPER DIR (AT DIR)"),
("1419","Molvi Abdullah Phulpoto","Sono Khan Phulpoto","4520463990149","Sindh","Khairpur"),
("1420","Molvi Abul Rehman ","Muhammad Bashir","3330321904873","Punjab","TOBA TEK SINGH"),
("1421","Molvi Asghar Ali @ Allah Nawaz Kharos","Abdul Rehman alias Humar Khan ","4520468825911","Sindh","Khairpur"),
("1422","Molvi Badshah Zaib","Abdul Jalil","1570179609727","KP","UPPER DIR (AT DIR)"),
("1423","Molvi Bakh Sher ","Abdul Wahab.","7120221823245","Gilgit-Baltistan","DIAMIR (AT CHILAS)"),
("1424","Molvi Bashir Ahmad","Zoor Talab","1570107684923","KP","UPPER DIR (AT DIR)"),
("1425","Molvi Jahangir","Muqadar","1510103353079","KP","BUNER"),
("1426","Molvi Muhammad Hayat Shaikh","","4330495158989","Sindh","Shikarpur"),
("1427","Molvi Muhammad Umar","Allah Din alias Allah Dino Bhayo","4510160453751","Sindh","Khairpur"),
("1428","Molvi Munir Ahmed ","Gul Muhammad Indher","4550118896027","Sindh","Sukkur"),
("1429","Molvi Nabi","Muhammad Shafiq","1410181177655","KP","HANGU"),
("1430","Molvi Nazir Ahmed Chotai"," Kher Muhammad Jan (Pesh Imam)","5330660140507","Balochistan","KACHHI (BOLAN) (AT DHADAR)"),
("1431","Molvi Salar","Sardar","1510126494599","KP","Toorghar"),
("1432","Molvi Ubeedullah ","Ghulam Ullah Korai","4530367063159","Sindh","N-Feroze"),
("1433","Molvi Usman","Sher Mohammad","1570111224613","KP","UPPER DIR (AT DIR)"),
("1434","Molvi Waheed ur Rehman ","Ahmed Bux Shar ","4520344375885","Sindh","Khairpur"),
("1435","Molvi Zafar","Sayal Khan","1410146707791","KP","HANGU"),
("1436","Mondar Ahmed","Haiwa Sasoli./ Maiwa Khan","5140122973995","Balochistan","KHUZDAR"),
("1437","Mosa Raza","Ghulam Sarwar","3240337305601","Punjab","RAJANPUR"),
("1438","Moulana Abdul Hameed @ Abdul Majeed","Abdul Qadir. ","5140101889545","Balochistan","KHUZDAR"),
("1439","Moulana Abdul Kabir Shakir","Inayat Ullah","5410204082165","Balochistan","QUETTA"),
("1440","Moulana Abdul Rauf alias Yazdani caste Bhatti","Abdul Ghafoor","3410155070167","Punjab","GUJRANWALA"),
("1441","Moulana Abdul Razzaq Haideri","Abdul Rehman","6110187652727","ICT","ISLAMABAD\n\n"),
("1442","Moulana Attaullah ","Moulana Muhammad Essa","4550429730549","Sindh","Sukkur"),
("1443","Moulana Faiz Muhammad Sikanderi","Muhammad Nawaz Bughio","4540348120297","Sindh","Shaeed Benizrabad"),
("1444","Moulana Farooque Azad ","Master Abdul Razzak Marwari Rajput","4210176048347","Sindh","Hyderabad"),
("1445","Moulana Hafiz Abdul Salam ","Abdul Manan ","4120578428549","Sindh","Karachi"),
("1446","Moulana Imadadullah ","Abdullah Ibe-e-Azad Bhutto","4550118595781","Sindh","Sukkur"),
("1447","Moulana Mohammad Akram ","Khuda Nazar. ","5410215546579","Balochistan","NUSHKI"),
("1448","Moulana Mohd. Ramzan Mengal","Abdul Qayum","5440004114699","Balochistan","QUETTA"),
("1449","Moulana Muhammad Nadeem Iqbal ","Bashir Ahmed ","3110377248087","Sindh","Karachi"),
("1450","Moulana Nazir Ahmed ","Arbab Ali Mirbahar","4310247889841","Sindh","Jacobabad"),
("1451","Moulana Saeed Jadoon ","Muhammad Sadiq Jadoon","4130326110345","Sindh","Hyderabad"),
("1452","Moulana Saiful-ul-Islam ","Saifur Rahim","4130360457229","Sindh","Hyderabad"),
("1453","Moulana Sher Ghazi Malik ","Abdul Ghafoor Malik ","4210164122633","Sindh","Karachi"),
("1454","Moulana Syed Paral Shah ","Muhammad Ali Shah","4520375472513","Sindh","Khairpur"),
("1455","Moulvi Abdul Baqi ","Moulana Mohammad Alam","5440004281409","Balochistan","QUETTA"),
("1456","Moulvi Abdul Wali Khan Farooqi ","Abdul Sattar","5440012375111","Balochistan","QUETTA"),
("1457","Moulvi Jamil","Khari Mula","","KP","Dir Upper"),
("1458","Moulvi Naseem Ahmed ","Ghulam Qadir Tagar","4320536379383","Sindh","Larkana"),
("1459","Movli Abdul Qayoum Janwri ","Faqir Jam Khan","4520301416703","Sindh","Khairpur"),
("1460","Movli Shoukat Ali Farooqui ","Karimullah Arain","4420670726309","Sindh","Sanghar"),
("1461","Mst. Porada","W/O Abdul Kabir @ Musa","2110320997194","KP","BAJAUR (AT KHAR BAJAUR)"),
("1462","Muasab Zubair ","Abdul Khaliq ","3330327655319","Punjab","TOBA TEK SINGH"),
("1463","Muavia","Khadim Hussain","3810386182331","Punjab","SAHIWAL"),
("1464","Muavia Hassan ","Sana Ullah Rabani","3410258160433","Punjab","GUJRANWALA"),
("1465","Mubarik Sher","Bakhtawar Sher","1730154666573","KP","PESHAWAR"),
("1466","Mubashar Miraj ","Muhammad Hussain ","3540187926373","Punjab","SHEIKHUPURA"),
("1467","Mubasher Ali Khan ","Ghulam Muhammad ","3320202680739","Punjab","JHANG"),
("1468","Mubashir","Yar Mula","1570150063545","KP","Dir Upper"),
("1469","Mubashir Rahman ","Muhammad Arshad Saeed ","3310012715251","Punjab","FAISALABAD"),
("1470","Mubashir Ullah","Attaullah","7120204287201","Gilgit-Baltistan","DIAMIR (AT CHILAS)"),
("1471","Mubeen Ali","Saif Ali","3420106052133","Punjab","GUJRAT"),
("1472","Mubeen Shehzad alias Doctor ","Muhammad Arshad","3460316147409","Punjab","SIALKOT"),
("1473","Mudasar Ali Shah","Zahir Shah","1610182104277","KP","MARDAN"),
("1474","Mudassar  Hussain","Ghulam Hussain","3720197234227","Punjab","CHAKWAL"),
("1475","Mudassar Akhtar ","Muhammad Akhtar Bhatti ","3420138407457","Punjab","GUJRAT"),
("1476","MUDASSAR HUSSAIN","NAZAR HUSSAIN","3420271654751","Punjab","GUJRAT"),
("1477","Mudassar Mehmood","Hakim Khan","3710510172165","Punjab","Attock    "),
("1478","Mudassir Hussain ","Mazhar Hussain ","NIL","Sindh","Karachi"),
("1479","Muddasir Shafique ","Muhammad Shafique ","3520286405451","Punjab","LAHORE"),
("1480","Mufti Abdul Rehman Khalid ","Ghulam Farid ","3210363674511","Punjab","DERA GHAZI KHAN"),
("1481","Mufti Abdul Wakeel","z","1111111111127","KP","PESHAWAR"),
("1482","Mufti Imran","Muhammad Afzal","1410103984441","KP","Peshawar"),
("1483","Mufti Kafayatullah","Maulana Muhammad Rafique","1350391443715","KP","MANSEHRA"),
("1484","Mufti Muhammad Ali "," Abdul Ghafoor.","4250118985979","Gilgit-Baltistan","GHANCHE (AT KHAPLU)"),
("1485","Mufti Muhammad Shah","Naik Muhammad","5440011412529","Balochistan","QUETTA"),
("1486","Mufti Munir Shakir","Rehmat Khan","1410195675099","KP","HANGU"),
("1487","Mufti Najeebullah Farooqi","Abdullah","1730142298491","KP","PESHAWAR"),
("1488","Mufti Nasir Mehmood","Abdul Rehman","3710533543411","Punjab","Attock    "),
("1489","Mufti Zakir Hussain Siddqui ","Siddique Rehman ","4210176048347","Sindh","Karachi"),
("1490","Muhammad","Ghulam Muhammad","1530598420169","KP","LOWER DIR (AT TEMERGARA)"),
("1491","Muhammad Aamir Usman ","Muhammad Iqbal ","3830211599561","Punjab","CHAKWAL"),
("1492","Muhammad Abbas ","Nazir Ahmad","3130415009801","Punjab","GUJRANWALA"),
("1493","Muhammad Abbas","Muhammad Siddique","3220344890141","Punjab","LAYYAH"),
("1494","Muhammad Abbas ","Zafar","3320404868747","Punjab","JHANG"),
("1495","Muhammad Abbas","Faqir Muhammad","1111111111111","KP","MALAKAND P.A."),
("1496","Muhammad Abbas Nasir ","Hakim Ali ","3640195939873","Punjab","PAKPATTAN"),
("1497","Muhammad Abdul Malik","Muhammad Hashim","3660318647061","Punjab","Vehari"),
("1498","Muhammad Abdul Rehman Baig alias Hafiz Abdul Rehma","Shafique Ahmed Baig ","3420193050021","Punjab","GUJRAT"),
("1499","Muhammad Abdul Shakoor ","Abdul Wahid ","3130276743997","Punjab","BAHAWALPUR"),
("1500","Muhammad Abdulbaki ","Molvi Muhammad Haneef ","3630262385575","Punjab","Multan"),
("1501","Muhammad Abdullah ","Allah Ditta","3640103467653","Punjab","PAKPATTAN"),
("1502","Muhammad Abdullah","Muhammad Riaz","3320248228133","Punjab","Jhang"),
("1503","Muhammad Abdullah","Abdul Rehman","3520115108583","Punjab","LAHORE"),
("1504","Muhammad Abdullah ","Muhammad Saddique","3660242150717","Punjab","VEHARI"),
("1505","Muhammad Abdullah","Muhammad Munir","3110170169751","Punjab","BAHAWALNAGAR"),
("1506","Muhammad Abdullah ","Molvi Ghulam Kibrya ","3130323795707","Punjab","RAHIM YAR KHAN"),
("1507","Muhammad Abdullah","Khuda-e-Dad Caste Kakar","5540167445041","Balochistan","ZIARAT"),
("1508","Muhammad Abid ","Muhammad Hanif ","3810294466463","Punjab","BHAKKAR"),
("1509","Muhammad Abid","Aulia Khan","3710525935331","Punjab","Attock    "),
("1510","Muhammad Abid Farooq ","Hafiz Muhammad Aslam ","3810207347061","Punjab","BHAKKAR"),
("1511","MUHAMMAD ABID SHAHZAD","Sheikh Muhammad Rafi ","3220268085477","Punjab","LAYYAH"),
("1512","Muhammad Abu Bakar alias Ali ","Muhammad Babar","3460311595221","Punjab","SIALKOT"),
("1513","Muhammad Abu Bakar Saddique ","Abdul Latif ","3630410639175","Punjab","MULTAN"),
("1514","Muhammad Abu Bakar Siddiq","Allah Bakhsh","3220296595069","Punjab","LAYYAH"),
("1515","Muhammad Abu Bakar Siddique","Muhammad Sadiq","3510379229753","Punjab","KASUR"),
("1516","Muhammad Abu Sufiyan ","Muhammad Idrees ","3310257065541","Punjab","FAISALABAD"),
("1517","Muhammad Abu Zar","Hafiz Muhammad Tayyab","3650283079519","Punjab","BAHAWALNAGAR"),
("1518","Muhammad Abubakar","Ghulam Rabani","3840336017685","Punjab","SARGODHA"),
("1519","Muhammad Adil ","Ghulam Mustafa ","3310044722639","Punjab","FAISALABAD"),
("1520","Muhammad Afzal","Gulzar Ahmad","3540218283775","Punjab","Nankana Sahib"),
("1521","Muhammad Afzal","Muhammad Irshad","3630234611243","Punjab","Multan"),
("1522","Muhammad Afzal ","Muhammad Amin ","3120151337389","Punjab","BAHAWALPUR"),
("1523","Muhammad Afzal","Mehmood Khan","3620209245569","Punjab","LODHRAN"),
("1524","Muhammad Afzal ","Muhammad Aslam ","3330264534351","Punjab","TOBA TEK SINGH"),
("1525","Muhammad Afzal","Muh: Rasool","1530767827105","KP","Dir Lower"),
("1526","Muhammad Afzal ","Irshad Ali ","3640213236239","Punjab","PAKPATTAN"),
("1527","Muhammad Afzal ","Muhammad Munir ","3460346616875","Punjab","SIALKOT"),
("1528","Muhammad Afzal alias Afzal Ratta ","Rahim Bakhsh ","3120138252793","Punjab","BAHAWALPUR"),
("1529","Muhammad Afzal alias Mansoor ","Abdul Ghani ","3130423656549","Punjab","RAHIM YAR KHAN"),
("1530","Muhammad Afzal Almaroof Muhammad Afzaal","Muhammad Shareef","3320252944287","Punjab","Jhang"),
("1531","Muhammad Ahmad ","Muhammad Hussain ","3130466967979","Punjab","RAHIM YAR KHAN"),
("1532","Muhammad Ahmad Khalid ","Atta Muhammad","3110195254353","Punjab","BAHAWALNAGAR"),
("1533","Muhammad Ahsan Ullah Barki ","Misal khan Barki","2170201962915","Sindh","Karachi"),
("1534","Muhammad Ajmal ","Muhammad Bux ","4220129436363","Sindh","Karachi"),
("1535","Muhammad Ajmal","Ghulam Hussain ","3120321121639","Punjab","BAHAWALPUR"),
("1536","Muhammad Ajmal ","Deen Muhammad ","3320212843985","Punjab","JHANG"),
("1537","Muhammad Ajmal caste Jutt","Khan Muhammad","3620178198493","Punjab","LODHRAN"),
("1538","Muhammad Ajmal Chohan ","Nawab Deen ","3120399759405","Punjab","BAHAWALPUR"),
("1539","Muhammad Akbar ","Muhammad Jameel ","3240397743869","Punjab","RAWALPINDI"),
("1540","Muhammad Akhtar","Muhammas Saddique","3840320972807","Punjab","SARGODHA"),
("1541","Muhammad Akhtar ","Edu Khan ","3120103687049","Punjab","BAHAWALPUR"),
("1542","Muhammad Akhtar ","Ghulam Ahmad @ Ghulam Muhammad","3130323636907","Punjab","RAHIM YAR KHAN"),
("1543","Muhammad Akhter ","Farooq Ahmed ","3210405914783","Punjab","DERA GHAZI KHAN"),
("1544","Muhammad Akmal","Saleem Khan","1720121016509","KP","Nowshera"),
("1545","Muhammad Akmal Haidri ","Muhammad Nawaz ","3320370847087","Punjab","JHANG"),
("1546","MUHAMMAD AKRAM ","MUHAMMAD ASLAM ","3220237329919","Punjab","LAYYAH"),
("1547","Muhammad Akram","Umer Hayat","3440347781771","Punjab","MANDI BAHAUDDIN"),
("1548","Muhammad Akram","Aleem u Din ","3320213900077","Punjab","Jhang"),
("1549","Muhammad Akram ","Muhammad Sadiq ","3640256555393","Punjab","PAKPATTAN"),
("1550","Muhammad Akram"," Ahmad Bakhsh ","3120481551407","Punjab","BAHAWALPUR"),
("1551","Muhammad Akram ","Khuda Bakhsh ","3630180671487","Punjab","MULTAN"),
("1552","Muhammad Akram Farooqi ","Mureed Hussain ","3210209505971","Punjab","DERA GHAZI KHAN"),
("1553","Muhammad Alamgir ","Bashir Ahmad ","3810232952669","Punjab","BHAKKAR"),
("1554","Muhammad Aleem ","Mehar Din","3666022299132","Punjab","VEHARI"),
("1555","Muhammad Ali","Basit Ali","3320332425983","Punjab","Jhang"),
("1556","Muhammad Ali","Nizam-ud-Din","3810192503159","Punjab","BHAKKAR"),
("1557","Muhammad Ali ","Ikram-ul-Haq ","3740502257721","Punjab","RAWALPINDI"),
("1558","Muhammad Ali","Haji Muhammad Fayyaz ","3310217664619","Punjab","FAISALABAD"),
("1559","Muhammad Ali alias Mamdo ","Intezar Mehdi ","3230189207375","Punjab","MUZAFFARGARH"),
("1560","Muhammad Ali Irfan","Ali jaan","3840388486059","Punjab","Jhang"),
("1561","Muhammad Aman Ullah Arif ","Taj Muhammad ","3230306916875","Punjab","MUZAFFARGARH"),
("1562","Muhammad Ameen","Muhammad Ilam Din","3320272224789","Punjab","Jhang"),
("1563","Muhammad Ameen ","Allah Ditta","4240119676935","Sindh","Karachi"),
("1564","Muhammad Ameen Sadiq ","Kaly Khan ","3530119954611","Punjab","OKARA"),
("1565","Muhammad Ameen Talha ","Allah Ditta ","3640258223025","Punjab","PAKPATTAN"),
("1566","Muhammad Amin ","Bahadur Khan ","3520191251587","Punjab","LAHORE"),
("1567","Muhammad Amin ","Ch Sardar Muhammad","3130401058601","Punjab","Rahim Yar Khan"),
("1568","Muhammad Amin ","Peer Bakhsh","3210208992133","Punjab","DERA GHAZI KHAN"),
("1569","Muhammad Amin","Ghulam Farid","3110118717517","Punjab","BAHAWALNAGAR"),
("1570","MUHAMMAD AMIN ","MUHAMMAD RAFI","3220201799857","Punjab","LAYYAH"),
("1571","Muhammad Amir Makki ","Muhammad Sadiq","3120260436399","Punjab","BAHAWALPUR"),
("1572","Muhammad Amir Shahzad alias Amir ","Muhammad Anwar ","3330146760051","Punjab","TOBA TEK SINGH"),
("1573","Muhammad Amjad Awan","Malik Iman","3520126607103","Punjab","LAHORE"),
("1574","Muhammad Amjad Ishaq","Muhammad Ishaaq ","3630267214547","Punjab","Multan"),
("1575","Muhammad Ammar Raza ","Muhammad Hanif Basharat ","3320220403127","Punjab","JHANG"),
("1576","Muhammad Ammar Yasir ","Ghulam Murtaza","3630276631589","Punjab","MULTAN"),
("1577","Muhammad Anees ","Lal Din ","3630204563349","Punjab","MULTAN"),
("1578","Muhammad Anwar ","Abdul Sattar ","3410350353999","Punjab","GUJRANWALA"),
("1579","Muhammad Anwar","Miraj Din","3310093015559","Punjab","FAISALABAD"),
("1580","Muhammad Anwar ","Mahiwal ","3740618755703","Punjab","RAWALPINDI"),
("1581","Muhammad Anwar Caste Reki","Abdul Ghani","5130204524527","Balochistan","WASHUK"),
("1582","Muhammad Aqib","Muhammad Ameen","3550201708187","Punjab","NANKANA SAHIB"),
("1583","Muhammad Arib Soomro","Khameso Soomro ","4110144846267","Sindh","BADIN"),
("1584","Muhammad Arif ","Muhammad Murad ","3130149781467","Punjab","RAHIM YAR KHAN"),
("1585","Muhammad Arif","Muhammad Ramzan","3810222475331","Punjab","BHAKKAR"),
("1586","Muhammad Arif","Mushtaq Hussain","3320403697465","Punjab","Jhang"),
("1587","Muhammad Arif","Muhammad hussain","3320217002721","Punjab","Jhang"),
("1588","Muhammad Arif  Qasmani ","Muhammad Umar Qasmani","4220123932869","Sindh","Karachi"),
("1589","Muhammad Arif Alias Muhammad Moavia","Faqeer Muhammad","3610398031009","Punjab","KHANEWAL"),
("1590","Muhammad Arshad","Muhammad Khan","3840345860625","Punjab","SARGODHA"),
("1591","Muhammad Arshad","Umer Din","3330193624735","Punjab","TOBA TEK SINGH"),
("1592","Muhammad Arshad ","Muhammad Munshi ","3410204284077","Punjab","GUJRANWALA"),
("1593","Muhammad Arshad alias Acha ","Abdul Khaliq","3640193353083","Punjab","PAKPATTAN"),
("1594","Muhammad Arslan alias Muhammad","Muhammad Suleman","3510117924701","Punjab","KASUR"),
("1595","Muhammad Asad ","Fayyaz Hussain   ","3120132652727","Punjab","BAHAWALPUR"),
("1596","Muhammad Asad ","Shoukat Ali ","3520214555407","Punjab","LAHORE"),
("1597","Muhammad Asad Khan ","Khan Akbar Hameed ","3450219062425","Punjab","SIALKOT"),
("1598","Muhammad Asghar","Naseer ud din","3820111560049","Punjab","KHUSHAB"),
("1599","Muhammad Asghar ","Abdul Rehman ","3240220202389","Punjab","RAJANPUR"),
("1600","Muhammad Asghar Ali Qadri","Muhammad Sadiq","3660295424267","Punjab","Vehari"),
("1601","Muhammad Asghar Hussain ","Zawar Hussain Shah ","3230465061505","Punjab","MUZAFFARGARH"),
("1602","Muhammad Ashfaq","Muhammad Ishaq","3710116420849","Punjab","Attock    "),
("1603","Muhammad Ashfaq alias Saleem ","SALEEM","3310422595279","Punjab","FAISALABAD"),
("1604","Muhammad Ashfaq Aslam","Muhammad Aslam","3310404100277","Punjab","FAISALABAD"),
("1605","Muhammad Ashfaq Hussain Nadeem","Muhammad Sarwar Khan","3610360296557","Punjab","Khanewal"),
("1606","Muhammad Ashraf ","Allaha Ditta ","3540403938403","Punjab","Sheikhupura"),
("1607","Muhammad Ashraf ","Muhammad Sharif ","3630217530383","Punjab","MULTAN"),
("1608","Muhammad Ashraf ","Fakhar-ul-Din ","3630217894367","Punjab","MULTAN"),
("1609","Muhammad Ashraf","Muhammad Amin","3110503954867","Punjab","BAHAWALNAGAR"),
("1610","MUHAMMAD ASHRAF","MUHAMMAD ASLAM","3650167663955","Punjab","SAHIWAL"),
("1611","Muhammad Ashraf ","Muhammad Panah ","3320295603169","Punjab","JHANG"),
("1612","Muhammad Ashraf @ Ashraf Memon ","M Siddiqu ","4210169942729","Sindh","Karachi"),
("1613","Muhammad Ashraf Ali ","Haji Muhammad Hussain ","3130413587023","Punjab","RAHIM YAR KHAN"),
("1614","Muhammad Ashraf Asif Jalali","Ghulam Sarwar","3440216955139","Punjab","LAHORE"),
("1615","Muhammad Ashraf Iqbal alias Mam Safdar","Muhammad Iqbal","3120286385175","Punjab","LODHRAN"),
("1616","Muhammad Ashraf Shahid ","Gulzar Ahmad ","3120525442089","Punjab","BAHAWALPUR"),
("1617","Muhammad Ashraf Zahid ","Shah Muhammad","3120501937839","Punjab","BAHAWALPUR"),
("1618","Muhammad Asif ","Malik Fooaj Ali ","3130334089869","Punjab","RAHIM YAR KHAN"),
("1619","Muhammad Asif  ","m. qasim","3458645947300","Punjab","Bahawalpur"),
("1620","Muhammad Asif","Muhammad Yousaf ","3410433046899","Punjab","GUJRANWALA"),
("1621","Muhammad Asif ","Muhammad Iftikhar ","3520285022735","Punjab","LAHORE"),
("1622","MUHAMMAD ASIF","MUHAMMAD AKRAM","3650143322963","Punjab","SAHIWAL"),
("1623","Muhammad Asif","Muhammad Riaz","3720341564055","Punjab","CHAKWAL"),
("1624","Muhammad Asif ","Muhammad Ali ","NIL","Sindh","Karachi"),
("1625","Muhammad Asif ","Muhammad Hussain ","NIL","Sindh","Karachi"),
("1626","Muhammad Asif ","Muhammad Hussain","4210141062777","Sindh","Karachi"),
("1627","Muhammad Asif","Abdullah","1410159552549","KP","HANGU"),
("1628","Muhammad Asif ","Muhammad Iqbal ","3320404915939","Punjab","JHANG"),
("1629","Muhammad Asif ","Manzoor Hussain ","3320404055717","Punjab","JHANG"),
("1630","Muhammad Asif alias Muzamil ","Jewan Khan ","3210368529489","Punjab","DERA GHAZI KHAN"),
("1631","Muhammad Asif Caste Arian","Maqsood Ahmad","3330386375891","Punjab","TOBA TEK SINGH"),
("1632","Muhammad Asif Javeed alias Dr. Asif Javed ","Bashir Ahmad ","3640177170075","Punjab","PAKPATTAN"),
("1633","Muhammad Asif Nadeem ","Abdul Ghafar ","3320265729427","Punjab","JHANG"),
("1634","Muhammad Asif Naveed ","Naveed Iqbal ","3120317313985","Punjab","BAHAWALPUR"),
("1635","Muhammad Asif Shah","Baksh Shah","3840414462873","Punjab","SARGODHA"),
("1636","Muhammad Asif Sheikh ","Gulraiz Akhtar ","3520274524799","Punjab","LAHORE"),
("1637","Muhammad Asim ","Muhamamd Ismail ","3340203969451","Punjab","CHINIOT"),
("1638","Muhammad Asim @ Tipu Sultan ","Muhammad Hakeem","4230111111451","Sindh","Karachi"),
("1639","Muhammad Asim alias Jawad ","Abdul Rasheed","3610255303731","Punjab","KHANEWAL"),
("1640","Muhammad Asim Nawaz","Master Muhammad Nawaz","3660217308693","Punjab","Vehari"),
("1641","Muhammad Aslam ","Allah Dad","3310049400649","Punjab","FAISALABAD"),
("1642","Muhammad Aslam ","Haji Allah Bakhsh ","3210267506361","Punjab","DERA GHAZI KHAN"),
("1643","Muhammad Aslam ","Ahmad Din ","3330244751147","Punjab","TOBA TEK SINGH"),
("1644","Muhammad Aslam","Mola Bakhsh","3620141756449","Punjab","LODHRAN"),
("1645","Muhammad Aslam ","Ghulam Muhammad","3620349734531","Punjab","LODHRAN"),
("1646","Muhammad Aslam ","Haji Muhammad Ramzan ","3120428183059","Punjab","BAHAWALPUR"),
("1647","Muhammad Aslam ","Muhammad Bakhsh ","3120425762981","Punjab","BAHAWALPUR"),
("1648","Muhammad Aslam ","Karam Din ","3130435201295","Punjab","RAHIM YAR KHAN"),
("1649","Muhammad Aslam","Ghulam Akbar","1210175951973","KP","DERA ISMAIL KHAN"),
("1650","Muhammad Aslam ","Abdul Malik ","3120163721915","Punjab","BAHAWALPUR"),
("1651","Muhammad Aslam alias Tariq ","Faiz Bakhsh ","3230419190231","Punjab","MUZAFFARGARH"),
("1652","Muhammad Aslam Asim Bhatti alias Asim caste Bhatti","Ghulam Rasool","3620252109217","Punjab","LODHRAN"),
("1653","Muhammad Aslam Farooqi","Khusi  Muhammad","3330217746481","Punjab","TOBA TEK SINGH"),
("1654","Muhammad Aslam Khan","Akhtar Jan","1720196452435","KP","KURRAM (AT PARACHINAR)"),
("1655","Muhammad Aslam Saddiqui ","Malik Daim Khan ","3120151406907","Punjab","BAHAWALPUR"),
("1656","Muhammad Aslam Sheikh ","Sher Gull ","3740658524009","Punjab","RAWALPINDI"),
("1657","Muhammad Aslam Siddiqui ","Muhammad Siddiqui ","3640222172265","Punjab","PAKPATTAN"),
("1658","Muhammad Aslam Usmani alias Usmani","Abdul latif ","3710547731959","Punjab","ATTOCK"),
("1659","Muhammad Ata Ullah Usmani","Asghar Ali","3520203727387","Punjab","LAHORE"),
("1660","Muhammad Atif Iqbal ","Muhammad Iqbal","4210160766311","Sindh","Karachi"),
("1661","Muhammad Awais ","Mehdi Hassan ","3330353532031","Punjab","TOBA TEK SINGH"),
("1662","Muhammad Awais ","Muhammad Yaqoob ","3320257852207","Punjab","JHANG"),
("1663","Muhammad Ayaz","Mehtab","4240120156871","KP","BUNER"),
("1664","Muhammad Ayaz @ Ayaz","Akbar Khan","1510175558063","KP","BUNER"),
("1665","Muhammad Ayub Abid ","Abdul Hafeez ","3810209092975","Punjab","BHAKKAR"),
("1666","Muhammad Azam","Rehmat Ali ","3460141552239","Punjab","Sialkot"),
("1667","Muhammad Azam ","Muhammad Idrees ","3520153090825","Punjab","LAHORE"),
("1668","Muhammad Azam ","Ameer Ali ","3310492633589","Punjab","FAISALABAD"),
("1669","Muhammad Azam alias Azam Tariq ","Abdul Kareem ","3640201596349","Punjab","OKARA"),
("1670","Muhammad Azam Tariq ","Atta Muhammad ","3320258860599","Punjab","JHANG"),
("1671","Muhammad Azhar Farooq","Zahoor-ul-Din","3230471011973","Punjab","Muzaffargarh"),
("1672","Muhammad Azmat Cheena","Abdul Ghani ","3410126185961","Punjab","GUJRANWALA"),
("1673","Muhammad Bachal ","Muhammad Ishaque Maheri ","411020150627","Sindh","Badin"),
("1674","Muhammad Bashir","Muhammad Yaqoob","3110158533911","Punjab","Bahawalnagar   "),
("1675","Muhammad Bashir","Muhammad Saddique ","3820154183459","Punjab","KHUSHAB"),
("1676","Muhammad Bilal","Abdul Aziz","3520241942631","Punjab","LAHORE"),
("1677","Muhammad Bilal ","Manzoor Ahmad ","3120131844095","Punjab","BAHAWALPUR"),
("1678","Muhammad Bilal ","Muhammad Panah ","3120401859557","Punjab","BAHAWALPUR"),
("1679","Muhammad Bilal ","Ashiq Hussain ","3120185478355","Punjab","BAHAWALPUR"),
("1680","Muhammad Bilal ","Abdul Rashid ","3710208581917","Punjab","Attock    "),
("1681","Muhammad Bilal ","Shareef Gul ","NIL","Sindh","Karachi"),
("1682","Muhammad Bilal ","Shareef Gul","4250196705091","Sindh","Karachi"),
("1683","Muhammad Bilal","Muhammad Qasim","5160206164631","Balochistan","QUETTA"),
("1684","Muhammad Bilal ","Islam Ud Din","3120202062791","Punjab","BAHAWALPUR"),
("1685","Muhammad Bilal Ahmad ","Jind Wada ","3120401823283","Punjab","BAHAWALPUR"),
("1686","Muhammad Bilal alias Annas ","Irshad Ahmed ","3320404881283","Punjab","JHANG"),
("1687","Muhammad Bilal Makwal ","Fareed Bakhsh","3240349431711","Punjab","RAJANPUR"),
("1688","Muhammad Bilal Waseem","Muhammad Sarwar (late) ","3120186482863","Punjab","BAHAWALPUR"),
("1689","Muhammad Danyal","Nasir Shaheed ","3520256320527","Punjab","LAHORE"),
("1690","Muhammad Daood ","Muhammad Yaqoob","3740559906489","Punjab","RAWALPINDI"),
("1691","Muhammad Din","Muhammad Rasheed","3520137953617","Punjab","LAHORE"),
("1692","Muhammad Ejaz ","Muhammad Nawaz ","3630272616439","Punjab","MULTAN"),
("1693","Muhammad Fahad Ali ","Bashir Ahmad ","3120158192257","Punjab","BAHAWALPUR"),
("1694","Muhammad Faisal Farooq ","Muhammad Idrees ","3520150335325","Punjab","GUJRANWALA"),
("1695","Muhammad Farhan alias Hafiz ","Muhammad Asghar ","3320234254497","Punjab","JHANG"),
("1696","Muhammad Farhan Rehman alias Farhan Qadri ","Fazal Ur Rehman Raja  ","3420374178617","Punjab","GUJRAT"),
("1697","Muhammad Farooq","Manzoor Hussain","3610415468249","Punjab","Khanewal"),
("1698","Muhammad farooq","Allah Din","3320301680109","Punjab","Jhang"),
("1699","Muhammad Farooq","Abdul Rehman","3710320690231","Punjab","Attock    "),
("1700","Muhammad Farooq ","Ahmad Bakhsh ","3120401794641","Punjab","BAHAWALPUR"),
("1701","Muhammad Farooq","Muhammad Hussain","1530570859533","KP","LOWER DIR (AT TEMERGARA)"),
("1702","Muhammad Farooq alias Umar Farooq","Rana Muhammad Ishaq","3620316538575","Punjab","BAHAWALPUR"),
("1703","Muhammad Fayaz Haideri","(Tahir Gul) Muhammad Tahir","1430119712219","KP","KOHAT"),
("1704","Muhammad Fayyaz ","Haji Ahmad Bakhsh ","3120197542019","Punjab","BAHAWALPUR"),
("1705","Muhammad Fiaz ","Muhammad Akram ","3130354933857","Punjab","RAHIM YAR KHAN"),
("1706","Muhammad Furqan ","Abdul Wahab ","1320189837693","KP","BATAGRAM (AT BANA)"),
("1707","Muhammad Ghayoor Sabir ","Sabir Hussain ","3810110399743","Punjab","BHAKKAR"),
("1708","Muhammad Gulraiz","Muhammad Parvaiz","3520220980589","Punjab","LAHORE"),
("1709","Muhammad Habib","Muhammad Azam ","3630259869605","Punjab","Multan"),
("1710","Muhammad Haleem ","Muhammad Saleem","3120598651665","Punjab","BAHAWALPUR"),
("1711","Muhammad Hameed ","Muhammad Tufail","3220225385519","Punjab","LAYYAH"),
("1712","Muhammad Hanif ","Haji Nazir Ahmad","3120103422887","Punjab","BAHAWALPUR"),
("1713","Muhammad Hanif","Muhammad Sharif","3520136619713","Punjab","LAHORE"),
("1714","Muhammad Hanif","Muhammad Bukhsh","3120211107319","Punjab","BAHAWALPUR"),
("1715","Muhammad Hanif ","Shafi Muhammad Khoso, ","NIL","Sindh","Karachi"),
("1716","Muhammad Hanif alias Moavia ","Imam Bakhsh ","3210272314013","Punjab","DERA GHAZI KHAN"),
("1717","Muhammad Hanif Tayyeb","Ahmad Bux","3230197205031","Punjab","Muzaffargarh"),
("1718","Muhammad Hashim","Gehwar Khan Caste Rind Kloi","5440133688023","Balochistan","QUETTA"),
("1719","Muhammad Hashim alias Nazeer Ahmed ","Muhammad Qasim ","3120520766355","Punjab","RAHIM YAR KHAN"),
("1720","Muhammad Hassaan Talha ","Abdul Ghafoor ","3240299415915","Punjab","RAJANPUR"),
("1721","Muhammad Hassan Aqai Mubbaligh ","Ali Yawar","5440004649659","Balochistan","QUETTA"),
("1722","Muhammad Hayat Siddiqui","Noor Muhammad","3710531174915","Punjab","ATTOCK"),
("1723","MUHAMMAD HUSSAIN","JAN MUHAMMAD","3640133776849","Punjab","Pakpattan"),
("1724","Muhammad Hussain","Muhammad Ramzan","5420356271857","Balochistan","KILLA ABDULLAH"),
("1725","Muhammad Hussain alias Pervaiz","Muhammad Saddique ","3310098704667","Punjab","FAISALABAD"),
("1726","Muhammad Hussain Moavia ","Haji Jindwada (late) ","3120168535127","Punjab","BAHAWALPUR"),
("1727","Muhammad Ibraheem ","Ghulam Muhammad Khan ","3201209767887","Punjab","DERA GHAZI KHAN"),
("1728","MUHAMMAD IBRAHEEM ","KHUSHI MUHAMMAD","3640280842741","Punjab","Pakpattan"),
("1729","Muhammad Ibraheem Akhtar","Mian Allah bakhash","3320214206951","Punjab","Jhang"),
("1730","Muhammad Ibrahim ","Haji Rasool Bakhsh ","3120287433587","Punjab","BAHAWALPUR"),
("1731","Muhammad Ibrahim ","Ghulam Muhammad ","4230147036323","Sindh","Karachi"),
("1732","Muhammad Ibrahim ","Haji Musafir Khan","4210118435787","Sindh","Karachi"),
("1733","Muhammad Ibrahim","Muhammad Hanif","3730183521941","Punjab","JHELUM"),
("1734","Muhammad Ibrahim ","Khadim Hussain","3620265015125","Punjab","LODHRAN"),
("1735","Muhammad Ibrahim Qasmi ","Abdul Hameed ","3120133383019","Punjab","BAHAWALPUR"),
("1736","Muhammad Ibrar","Muhammad Siddique","1540299193827","KP","MALAKAND P.A."),
("1737","Muhammad Idrees","Ahmad Khan(Late)","3450168533067","Punjab","Narowal"),
("1738","Muhammad Idrees ","Muhammad Abdul Haee ","3130362856581","Punjab","RAHIM YAR KHAN"),
("1739","Muhammad Idrees","Muhammad Alam","1220197535929","KP","S.WAZIRISTAN (AT WANA)"),
("1740","Muhammad Idrees Nawaz","Rab Nawaz","3340304969317","Punjab","CHINIOT"),
("1741","Muhammad Idress Rajput ","Noor Muhammad Rajput","4320325321341","Sindh","Larkana"),
("1742","Muhammad Ijaz","Riaz Ul Haq","3710457735741","Punjab","Attock    "),
("1743","Muhammad Ijaz ","Muhammad Ismail ","3410124433207","Punjab","GUJRANWALA"),
("1744","Muhammad Ijaz ","Muhammad Riaz ","3740504885435","Punjab","RAWALPINDI"),
("1745","Muhammad Ijaz ","Muhammad Taj ","3740605395839","Punjab","RAWALPINDI"),
("1746","Muhammad Ijaz","Muhammad Bakash","3630322998991","Punjab","MULTAN"),
("1747","Muhammad Ijaz /Ahmed","Mian Dad","1310157494019","KP","ABBOTTABAD"),
("1748","Muhammad Ijaz Ahmad Alias Abu Muhammad","Muhammad Rafique ","3530197549889","Punjab","OKARA"),
("1749","Muhammad Ikhlaq","Noor Muhammad","3710501977879","Punjab","ATTOCK"),
("1750","Muhammad Ikram ","Mian Muhammad Aslam ","3420202782547","Punjab","GUJRAT"),
("1751","Muhammad Ikram ","Ali Sher ","3640292310871","Punjab","PAKPATTAN"),
("1752","Muhammad Ikram ","Muhammad Yousaf ","3720116448637","Punjab","CHAKWAL"),
("1753","MUHAMMAD IKRAM KHAN","IRAN KHAN","3640207767887","Punjab","Pakpattan"),
("1754","Muhammad Ilyas","Muhabbat Khan","3710140263965","Punjab","Attock    "),
("1755","Muhammad Ilyas ","Sher Muhammad ","3810115397865","Punjab","BHAKKAR"),
("1756","Muhammad Ilyas Hamdani","Khalid Javed","3710117660019","Punjab","ATTOCK"),
("1757","Muhammad Imdad Ullah Makki ","Muhammad Ubaid Ullah ","3120238757499","Punjab","BAHAWALPUR"),
("1758","Muhammad Imran ","Nazir Ahmad ","3410394636565","Punjab","GUJRANWALA"),
("1759","Muhammad Imran","Muhammad Aslam","3520204688293","Punjab","LAHORE"),
("1760","Muhammad Imran","Imamuddin Arain","4220179645691","Sindh","Hyderabad"),
("1761","Muhammad Imran","Pir Muhammad ","1570188695371","KP","UPPER DIR (AT DIR)"),
("1762","Muhammad Imran","Hazrat Umar","1560270533823","KP","SWAT (AT MINGORA)"),
("1763","Muhammad Imran","Muhammad Aslam","3110453153877","Punjab","BAHAWALNAGAR"),
("1764","Muhammad Imran alias Imran Warraich ","Ghulam Rasool ","3120203415067","Punjab","BAHAWALPUR"),
("1765","Muhammad Imran case Hajjaam","Muhammad Aslam","3330373091999","Punjab","TOBA TEK SINGH"),
("1766","Muhammad Imran Cheema ","Chaudhry Muhammad Ilyas ","3410464137099","Punjab","GUJRANWALA"),
("1767","Muhammad Imran Iqbal","Muhammad Aslam","3710135140869","Punjab","ATTOCK"),
("1768","Muhammad Imran Khan Farooqi alias Noora Sheikh ","Sheikh Muhammad Iqbal ","3460120065723","Punjab","SIALKOT"),
("1769","Muhammad Imran Saeed Alias Chand","Saeed Hussain","3730295460793","Punjab","JHELUM"),
("1770","Muhammad Imran Saqib","Sher Muhammad","3650162054075","Punjab","SAHIWAL"),
("1771","Muhammad Inaam Hanif Memon","Hanif Qasim ","4220137390113","KP","CHITRAL"),
("1772","Muhammad Inaam Hanif Memon","Hanif  Qasim","4220137390139","KP","CHITRAL"),
("1773","Muhammad Inam","Sher Zaman ","1610189002333","KP","MARDAN"),
("1774","Muhammad Inam","Sher Zaman","1560202959325","KP","SWAT (AT MINGORA)"),
("1775","Muhammad Iqbal","Kareem Bakhash","3810157409583","Punjab","BHAKKAR"),
("1776","Muhammad Iqbal","Muhammad Riaz","3320313594963","Punjab","Jhang"),
("1777","Muhammad Iqbal","Bahshir Ahmad ","3650226943923","Punjab","SAHIWAL"),
("1778","Muhammad Iqbal","Abdul Ghani","3810137510999","Punjab","BHAKKAR"),
("1779","Muhammad Iqbal (Mishori)","Ahmed Khan","3220320696685","Punjab","DERA GHAZI KHAN"),
("1780","Muhammad Iqbal @khalid Irshad","Muhammad Latif","3840525954395","Punjab","SARGODHA"),
("1781","Muhammad Iqbal alias Maali ","Allah Yar ","3320313385007","Punjab","JHANG"),
("1782","Muhammad Irfan ","Muhammad Nawaz ","3320316203847","Punjab","JHANG"),
("1783","Muhammad Irfan ","Muhammad Yaqoob ","3440105635147","Punjab","MANDI BAHAUDDIN"),
("1784","Muhammad Irfan","Sultan Muhammad","","KP","Dir Lower"),
("1785","Muhammad Irfan ","Muhammad Tariq ","3650269511429","Punjab","SAHIWAL"),
("1786","Muhammad Irfan","Sabir Ali","3320403402201","Punjab","Jhang"),
("1787","Muhammad Irfan ","Muhammad Hayat ","3120256562499","Punjab","BAHAWALPUR"),
("1788","Muhammad Irfan","Muhammad Ashraf","3110521536721","Punjab","BAHAWALNAGAR"),
("1789","MUHAMMAD IRFAN ALVI","Abdul Latif Alvi","3420119832725","Punjab","GUJRAT"),
("1790","Muhammad Irfan Anwar","Muhammad Anwar","3720116254815","Punjab","CHAKWAL"),
("1791","Muhammad Irfan Ashraf ","Muhammad Ashraf ","3120319172041","Punjab","BAHAWALPUR"),
("1792","Muhammad Irfan Farooq ","Umar Farooq Azam ","3310007119333","Punjab","FAISALABAD"),
("1793","Muhammad Irfan Khan","Nazir Ahmad (","3840605828419","Punjab","SARGODHA"),
("1794","Muhammad Irfan Zafar ","Muhammad Zafar ","3410423675903","Punjab","GUJRANWALA"),
("1795","Muhammad Irshad","Muhammad Hayyat","3230446091731","Punjab","Muzaffargarh"),
("1796","Muhammad Ishaq","Muhammad Ismaeel","3710507605919","Punjab","ATTOCK"),
("1797","Muhammad Ishaq","Hayat Muhammad","1530698465095","KP","Dir Lower"),
("1798","Muhammad Ishaq alias Ghazi ","Muhammad Ibraheem ","3530218774187","Punjab","OKARA"),
("1799","Muhammad Ishfaq","Sher Muhammad","3540416250669","Punjab","Sheikhupura"),
("1800","Muhammad Ishtiaq ","Mukhtiar Ahmad ","3320404211673","Punjab","JHANG"),
("1801","Muhammad Islam ","Allah Yar ","3320381221015","Punjab","JHANG"),
("1802","Muhammad Islam","Nazir Khan","1110104721605","KP","BANNU"),
("1803","Muhammad ismaeel Khalil alias Abu Saif","Ghulam Mustafa","3630270028115","Punjab","MULTAN"),
("1804","Muhammad Ismail ","Abdul Karim ","3201219514911","Punjab","DERA GHAZI KHAN"),
("1805","Muhammad Ismail ","Noor Muhammad ","3120249217323","Punjab","BAHAWALPUR"),
("1806","Muhammad Ismail ","Abdul Karim ","3130420394201","Punjab","RAHIM YAR KHAN"),
("1807","Muhammad Ismail","Bahaudar Khan","3710147723419","Punjab","Attock    "),
("1808","Muhammad Ismail","Toor Jan","1530505497031","KP","LOWER DIR (AT TEMERGARA)"),
("1809","Muhammad Ismail","Subhani Gul","1530659748397","KP","UPPER DIR (AT DIR)"),
("1810","Muhammad Ismail","Muhammad Hashim Notkani","4110265185301","Sindh","Badin"),
("1811","Muhammad Ismail Muavia ","Muhammad Shareef","4230137468647","Sindh","Karachi"),
("1812","Muhammad Ismail Riffat ","Molvi Abdul Malik (late)","3120103598713","Punjab","BAHAWALPUR"),
("1813","Muhammad Israr","Allah Ditta","3320221944589","Punjab","Jhang"),
("1814","Muhammad Israr","Abdul Hameed","1530209605873","KP","LOWER DIR (AT TEMERGARA)"),
("1815","Muhammad Israr Abbasi ","Muhammad Ishaq Abbasi ","6110171557777","Punjab","RAWALPINDI"),
("1816","Muhammad Jafar alias Jhangvi, Abu Muhammad ","Bashir Ahmed ","3520253303605","Punjab","LAHORE"),
("1817","Muhammad Jaffar ","Ajar Din ","3320343400195","Punjab","JHANG"),
("1818","Muhammad Jahangir ","Bashir Ahmad ","3810242380303","Punjab","BHAKKAR"),
("1819","Muhammad Jahangir Alias Jhanga","Abdul Waheed","3810252988469","Punjab","BHAKKAR"),
("1820","Muhammad Jamal Qasmi alias Ihtisham ","Qari Ubaid Ullah ","3210277959707","Punjab","DERA GHAZI KHAN"),
("1821","Muhammad Jameel","Faqir Hussain","1730114068569","KP","PESHAWAR"),
("1822","Muhammad Jameel","Sher Zaman","3710467839555","Punjab","ATTOCK"),
("1823","Muhammad Jameel alias Soba Bhatti ","Ghulam Nabi","3660106657271","Punjab","VEHARI"),
("1824","Muhammad Jamil ","Muhammad Saddique ","3540406442027","Punjab","LAHORE"),
("1825","Muhammad Jamil","Muhammad Ibrahim","1530576579685","KP","LOWER DIR (AT TEMERGARA)"),
("1826","Muhammad Jamil ","Muhammad Sharif ","3120266652539","Punjab","BAHAWALPUR"),
("1827","Muhammad Jamshed Aliaz","Zumurrad Khan","3710102175939","Punjab","ATTOCK"),
("1828","Muhammad Javaid ","Muhammad Iqbal","3720115683531","Punjab","CHAKWAL"),
("1829","Muhammad Javed","Mushtaq Ahamad","3130351090485","Punjab","Rahim Yar Khan"),
("1830","Muhammad Javed","Abdul Majeed","3130388106735","Punjab","Rahim Yar Khan"),
("1831","Muhammad Javed alias Saeed ","Manzoor Ahmad","3630109586325","Punjab","MULTAN"),
("1832","Muhammad Javed Anwer","Muhammad Anwer","3330125522825","Punjab","TOBA TEK SINGH"),
("1833","Muhammad Javed Farooqi ","Ahmad Ali ","3120155776627","Punjab","BAHAWALPUR"),
("1834","Muhammad Javed Iqbal ","Muhammad Ramzan ","3810261037215","Punjab","BHAKKAR"),
("1835","Muhammad Javed Manzoor ","Manzoor Hussain ","3120236093055","Punjab","BAHAWALPUR"),
("1836","Muhammad Javid","Hamid ur Rehman","1530683621841","KP","Dir Lower"),
("1837","Muhammad Junain","Abdul Raheem","3510124991753","Punjab","KASUR"),
("1838","Muhammad Kabir","Sher Muhammad ","4250195022263","Punjab","CHAKWAL"),
("1839","Muhammad Kaleem ","Unknown","","AJ&K","Kafl Garh Bagh"),
("1840","Muhammad Kamran alias Hafiz","Abdul Rehman","3720199164675","Punjab","CHAKWAL"),
("1841","Muhammad Karim","Sadbar","1560110096207","KP","Swat"),
("1842","Muhammad Kashif","Rehmat Ullah","1530771126411","KP","LOWER DIR (AT TEMERGARA)"),
("1843","Muhammad Kashif ","Abdul Rehman ","4240153853109","Punjab","BHAKKAR"),
("1844","Muhammad Kashif","Ashiq Hussain","3810107022691","Punjab","BHAKKAR"),
("1845","Muhammad Kazim Raza Madni ","Mehar Ullah","3210209775631","Punjab","DERA GHAZI KHAN"),
("1846","Muhammad Khair","Haji Abdul Qadir","5160203918527","Balochistan","MASTUNG"),
("1847","Muhammad Khalid","Habib Ahmed","3320268703629","Punjab","Jhang"),
("1848","Muhammad Khalid Javed ","Ali Hassan ","3410355463313","Punjab","GUJRANWALA"),
("1849","Muhammad Khalid Loan ","Abdul Latif","3410440983167","Punjab","GUJRANWALA"),
("1850","Muhammad Khalil","Chuadhry Muhammad Latif","3540416372815","Punjab","Sheikhupura"),
("1851","Muhammad Khalil ","Fazal Hussain","8130213554989","AJ&K","POONCH"),
("1852","Muhammad Khan","Fazal Haleem","1530743446831","KP","Dir Lower"),
("1853","Muhammad Khan","Pir Muhammad","1310188238613","KP","ABBOTTABAD"),
("1854","Muhammad Khan","Shad Muhammad Khan","1510104171347","KP","BUNER"),
("1855","Muhammad Khursheed ","Muhammad Bakhsh ","3120168314617","Punjab","BAHAWALPUR"),
("1856","Muhammad Latif ","Muhammad Iqbal","3720313935747","Punjab","Chakwal"),
("1857","Muhammad Liaqat Ali","Muhammad Asghar","3110545662719","Punjab","BAHAWALNAGAR"),
("1858","Muhammad lnaam Shah ","Ali Akhtar Shah","3660132141323","Punjab","VEHARI"),
("1859","MUHAMMAD LUQMAN","MUZAFFAR HUSSAIN","3420292148861","Punjab","Gujrat"),
("1860","Muhammad Luqman ","Muhammad Ikram ","3120316931663","Punjab","BAHAWALPUR"),
("1861","Muhammad Luqman","Muhammad Ali","3450140916197","Punjab","NAROWAL"),
("1862","Muhammad Madni ","Khuda Bakhsh ","3120175454557","Punjab","BAHAWALPUR"),
("1863","Muhammad Mahfooz ","Muhammad Syed Khan","8230246859983","Punjab","LAHORE"),
("1864","Muhammad Majeed Mavia","Qari Abdul Manan","3630201620069","Punjab","MULTAN"),
("1865","Muhammad Makki (Jam.Jhabali)","Kareem Buksh","3620308533923","Punjab","LODHRAN"),
("1866","Muhammad Makki alias Abbas, Haris, Abdullah ","Muhammad Shafi ","3120109402609","Punjab","BAHAWALPUR"),
("1867","Muhammad Mansha","Khushaal","3340304141445","Punjab","CHINIOT"),
("1868","Muhammad Mansha ","Fazal Muhammad ","3320293904933","Punjab","JHANG"),
("1869","Muhammad Masood alias Pasha ","Sakhi Muhammad ","3720156349311","Punjab","CHAKWAL"),
("1870","Muhammad Mazhar","Muhammad Nawaz ","3630268404809","Punjab","MULTAN"),
("1871","Muhammad Mehboob Alam ","Muhammad Zikriya ","3320315076191","Punjab","JHANG"),
("1872","Muhammad Moavia ","Muhammad Azam Tariq ","3320280604999","Punjab","JHANG"),
("1873","Muhammad Mohsin","Ghulam Muhammad","3320138415369","Punjab","CHINIOT"),
("1874","Muhammad Moosa ","Ummed Ali Malik","4530423942345","Sindh","N-Feroze"),
("1875","Muhammad Muavia alias Muavia","Muhammad Habib Ullah Muavia ","3310062592795","Punjab","FAISALABAD"),
("1876","Muhammad Mudasar Baig ","Ghulam Abbas Baig ","3460257756349","Punjab","SIALKOT"),
("1877","Muhammad Mudassar ","Muhammad Yaqoob ","3330325162467","Punjab","TOBA TEK SINGH"),
("1878","Muhammad Mudassar Nadeem ","Muhammad Ishaq ","3610281764173","Punjab","KHANEWAL"),
("1879","Muhammad Mujahid ","Ghulam Ali","3120399647227","Punjab","BAHAWALPUR"),
("1880","Muhammad Mumtaz Ahmad ","Jafran ","3310421568831","Punjab","FAISALABAD"),
("1881","Muhammad Munawar ","Muhammad Wakeel Qamar ","3330120884987","Punjab","FAISALABAD"),
("1882","Muhammad Munawar lqbal ","Allah Wasaya","3830376288117","Punjab","MIANWALI"),
("1883","Muhammad Murtaza Usmani","Ghaus Muhammad","3320403524929","Punjab","Jhang"),
("1884","Muhammad Mustafa Latif ","Hafiz Muhammad Latif Abid","3660164386543","Punjab","VEHARI"),
("1885","Muhammad Muzamil @ Mehboob @ Chacha","Muhammad","4220106257911","Sindh","Karachi"),
("1886","Muhammad Muzammal ","abdul Kareem","3230416384111","Punjab","Muzaffargarh"),
("1887","Muhammad Nadeem","Taaj Deen","3520014923411","Punjab","LAHORE"),
("1888","Muhammad Nadeem","Wazir Ali","3460368334591","Punjab","SIALKOT"),
("1889","Muhammad Nadeem","Liaqat Ali ","3810258584801","Punjab","BHAKKAR"),
("1890","Muhammad nadeem","Muhammad yameen","3320212236023","Punjab","Jhang"),
("1891","Muhammad Nadeem","Qasim Ali","3810158592129","Punjab","BHAKKAR"),
("1892","Muhammad Naeem ","Muhammad Naseem ","3120148769581","Punjab","BAHAWALPUR"),
("1893","Muhammad Naeem ","Muhammad Akram ","3310031788013","Punjab","FAISALABAD"),
("1894","Muhammad naeem","Ghullam fareed","3320224407543","Punjab","Jhang"),
("1895","Muhammad Naeem","Abdul Qayyum","1560110305883","KP","SWAT (AT MINGORA)"),
("1896","Muhammad Naeem Akhtar","Muhammad Sidique","3320216506655","Punjab","Jhang"),
("1897","Muhammad Naqi Abbas ","Ghulam Abbas ","3720115988891","Punjab","CHAKWAL"),
("1898","Muhammad Nasir","Muhammad Latif","3710206678135","Punjab","ATTOCK"),
("1899","Muhammad Nasir","Muhammad Bashir","1720168142729","KP","NOWSHERA"),
("1900","Muhammad Nasir alias Nasir Muavia ","Muhammad Iqbal ","3320250641933","Punjab","JHANG"),
("1901","Muhammad Naveed ","Muhammad Sharif ","3130330294895","Punjab","RAHIM YAR KHAN"),
("1902","Muhammad Naveed ","Zaheer-u-Din ","3410238243417","Punjab","GUJRANWALA"),
("1903","Muhammad Naveed ","Muhammad Bakhsh ","3220366603935","Punjab","LAYYAH"),
("1904","Muhammad Naveed Afzal ","Afzal Abbasi ","3130142174283","Punjab","RAHIM YAR KHAN"),
("1905","Muhammad Naveed alias Mian ","Javeed Iqbal ","3310116893859","Punjab","FAISALABAD"),
("1906","Muhammad Naveed Aslam","Muhammad Aslam","3460271094221","Punjab","SIALKOT"),
("1907","Muhammad Nawaz","Muhammad Ibraheem ","3210278761077","Punjab","DERA GHAZI KHAN"),
("1908","Muhammad Nawaz","Ghullam fareed","3320299206467","Punjab","Jhang"),
("1909","Muhammad Nawaz ","Muhammad Yar Brohi ","4310204208507","Sindh","Jacobabad"),
("1910","Muhammad Nawaz","Muhammad Ameer","3840603715071","Punjab","SARGODHA"),
("1911","Muhammad Nawaz","Sher jan","1710103992339","Sindh","KAMBAR SHAHDADKOT"),
("1912","Muhammad Nawaz Khan ","Muhammad Shareen Khan","4230146041093","Sindh","Karachi"),
("1913","Muhammad Nazeer ","Mian Muhammad","3710192308993","Punjab","Attock    "),
("1914","Muhammad Nisar","Abdur Razaq","1530210056111","KP","LOWER DIR (AT TEMERGARA)"),
("1915","Muhammad Noor ","Wali Khan","2170218316201","Sindh","Karachi"),
("1916","Muhammad Nouman alias Nomi ","Ghulam Rasool ","3240301545539","Punjab","RAJANPUR"),
("1917","Muhammad Numan Anwar alias Zain","Ubaid Ullah Anwar","3510249368475","Punjab","KASUR"),
("1918","Muhammad Owais Raheel ","Muhammad Sohail Raheel ","NIL","Sindh","Karachi"),
("1919","Muhammad Qaisar Abbas ","Peer Chan Shah (late)","3810287678057","Punjab","BHAKKAR"),
("1920","Muhammad Qamar Zaman","M. Ismail","3230395760831","Punjab","Vehari"),
("1921","Muhammad Qasim ","Fazla-e-Rabi ","3740574591985","Punjab","RAWALPINDI"),
("1922","Muhammad Qasim ","Molvi Abdul Malik ","3410182226831","Punjab","GUJRANWALA"),
("1923","Muhammad Qasim Moavia","Abdul Razzaq ","3710187827653","Punjab","Attock    "),
("1924","Muhammad Qasim Siddiqi ","Nazir Ahmed Caste Kashmiri ","3450119953031","Punjab","NAROWAL"),
("1925","Muhammad Rafaqat","Abdul Sattar","3320313591049","Punjab","Jhang"),
("1926","Muhammad Rafiq alias Feeka","Abdul Ghafoor ","3540394840473","Punjab","NANKANA SAHIB"),
("1927","Muhammad Rafiq Anjam ","Muhammad Shafi ","3650299799047","Punjab","SAHIWAL"),
("1928","Muhammad Rafique ","Allah Bakhsh ","3630281948725","Punjab","MULTAN"),
("1929","Muhammad Rafique","Muhammad Arshad","3710102176579","Punjab","Attock    "),
("1930","Muhammad Rafique","Hashmat Ali","3660158170233","Punjab","VEHARI"),
("1931","Muhammad Rafique Bhutta","Ghulam Rasool Bhutta","3620269143399","Punjab","BAHAWALPUR"),
("1932","Muhammad Rafique Qasmi","Muhammad Din","3460250200161","Punjab","Sialkot"),
("1933","Muhammad Ramzan","Wali Muhammad","3320393260537","Punjab","Jhang"),
("1934","Muhammad Ramzan","Ghulam Abbas","3130328424995","Punjab","Rahim Yar Khan"),
("1935","Muhammad Ramzan","Muhammad Ashiq ","3120215115443","Punjab","BAHAWALPUR"),
("1936","Muhammad Ramzan ","Ghulam Qadir ","3120223894545","Punjab","BAHAWALPUR"),
("1937","Muhammad Ramzan","Noor Muhammad ","3320213853353","Punjab","Jhang"),
("1938","Muhammad Ramzan","kareem u din","3320249282093","Punjab","Jhang"),
("1939","Muhammad Ramzan","Muhammad Shaban","3530265653251","Punjab","Okara"),
("1940","Muhammad Ramzan alias Papu","Abdul Majeed ","3310225354495","Punjab","FAISALABAD"),
("1941","Muhammad Ramzan Khan @ Naveed-Ur-Rehman","Ghulam Muhammad","3110491352529","Punjab","BAHAWALNAGAR"),
("1942","Muhammad Ramzan Shakir","Abdul Islam","3320117010329","Punjab","CHINIOT"),
("1943","Muhammad Rashid ","Muhammad Ashraf ","3810229162133","Punjab","BHAKKAR"),
("1944","Muhammad Rashid","Muhammad Sarwar","3530176688023","Punjab","OKARA"),
("1945","Muhammad Rashid","Irshad Ali","3840312767441","Punjab","SARGODHA"),
("1946","Muhammad Rashid","Muhammad Afsar","8230174343285","AJ&K","POONCH"),
("1947","Muhammad Rashid Khan","Muhammad Ashraf Khan","8230333285127","AJ&K","POONCH"),
("1948","Muhammad Rashid Nadeem alias Naeem Ullah urf Abdul","Latif Ahmad","3620144651093","Punjab","LODHRAN"),
("1949","Muhammad Rauf","Mera Gul","2160189120637","KP","ORAKZAI (AT KALAYA)"),
("1950","Muhammad Raza Konain","Nawab Din (","3520222008393","Punjab","LAHORE"),
("1951","Muhammad Raziq","Saif Ur Rehman","1530572580727","KP","LOWER DIR (AT TEMERGARA)"),
("1952","Muhammad Rehan Haider ","Muhammad Iqbal Mungla ","3450157915211","Punjab","NAROWAL"),
("1953","Muhammad Rehman","Abdur  Rahim","1560221898393","KP","SWAT (AT MINGORA)"),
("1954","Muhammad Rehmat Ullah Khan","Sher Muhammad","3320212897511","Punjab","JHANG"),
("1955","Muhammad Riaz ","Bashir Ahmad ","3120102666987","Punjab","BAHAWALPUR"),
("1956","Muhammad Riaz ","Sultan Mahmood ","3320211671997","Punjab","TOBA TEK SINGH"),
("1957","Muhammad Riaz","Muzaffar","1310109180015","KP","ABBOTTABAD"),
("1958","Muhammad Riaz","Rana Muhammad Yaseen","3840373070863","Punjab","SARGODHA"),
("1959","Muhammad Riaz @ Riaz Moulai  ","Nawab Ali ","4220156118631","Sindh","Karachi"),
("1960","Muhammad Rizwan ","Javed Akhtar ","3810203834433","Punjab","BHAKKAR"),
("1961","Muhammad Rizwan ","Abdul Ghafoor ","3650298156953","Punjab","SAHIWAL"),
("1962","Muhammad Rizwan ","Muhammad Shareef ","3320214378797","Punjab","JHANG"),
("1963","Muhammad Rizwan Ali alias Muhammad Ali ","Sher Ali ","3720374807749","Punjab","CHAKWAL"),
("1964","Muhammad Rizwan alias Zakir","Muhammad Ramzan","3840396428479","Punjab","SARGODHA"),
("1965","Muhammad Roshan","Muhammad Roshan","1560202263959","KP","SWAT (AT MINGORA)"),
("1966","MUHAMMAD SABTAIN","AZHAR HUSSAIN","3840220210033","Punjab","Sargodha"),
("1967","Muhammad Sabtain","Malik Azher Hussain","3840220210633","Punjab","SARGODHA"),
("1968","Muhammad Sabtain Jaffari ","Allah Ditta ","3210317094513","Punjab","DERA GHAZI KHAN"),
("1969","Muhammad Saddique ","Hafiz Mahar Din ","3130353107517","Punjab","RAHIM YAR KHAN"),
("1970","Muhammad Saddique ","Allah Ditta","3330331685335","Punjab","TOBA TEK SINGH"),
("1971","Muhammad Sadiq","Sanab Gul","1430115868521","KP","KOHAT"),
("1972","Muhammad Sadiq","Muhammad Akbar Caste Rind","5440198455299","Balochistan","QUETTA"),
("1973","Muhammad Sadiq ","Nabi Bakhsh ","3130270556877","Punjab","RAHIM YAR KHAN"),
("1974","Muhammad Sadiq Hussain alias Hassnain ","Abdul Rehman ","3210219980069","Punjab","DERA GHAZI KHAN"),
("1975","Muhammad Sadiq Khan","Khadim Hussain ","3630110467563","Punjab","BAHAWALPUR"),
("1976","Muhammad Sadique alias Madni","Abdul Majeed","5630238816165","Punjab","LAYYAH"),
("1977","Muhammad Saeed","Dilawar Khan","1730143807325","KP","PESHAWAR"),
("1978","Muhammad Saeed","Noor Muhammad","3710416767743","Punjab","Attock    "),
("1979","Muhammad Saeed ","Muhammad Lateef ","3540311237095","Punjab","Nankana Sahib"),
("1980","Muhammad Saeed ","Manzoor Ahmed","3640126396665","Punjab","VEHARI"),
("1981","Muhammad Safdar ","Hafiz Ghulam Fareed ","3120173488087","Punjab","BAHAWALPUR"),
("1982","Muhammad Safdar ","Molvi Siraj Din ","3120177710063","Punjab","BAHAWALPUR"),
("1983","Muhammad Sagheer","Bashir Ahmed","3660212653547","Punjab","Vehari"),
("1984","Muhammad Saghir Alias Mouvia","Muhammad Saleem","3730161169783","Punjab","JHELUM"),
("1985","Muhammad Saif Ullah ","Muhammad Iqbal ","3120293419395","Punjab","BAHAWALPUR"),
("1986","Muhammad Sajid","Saad mir","3710580232807","Punjab","Attock    "),
("1987","Muhammad Sajid Farooqi ","Haji Sikandar Ali","3310483914603","Punjab","FAISALABAD"),
("1988","Muhammad Sajjad","Nasir Ali","3230388045283","Punjab","Muzaffargarh"),
("1989","Muhammad Sajjad /Sajid","Malik Wazir","1310109440407","KP","ABBOTTABAD"),
("1990","Muhammad Salam ","Abdul Aziz","4210180699489","Sindh","Karachi"),
("1991","MUHAMMAD SALEEM","MUHAMMAD SHABIR","3220302976601","Punjab","LAYYAH"),
("1992","Muhammad Saleem ","Noor Hassan ","3410184311807","Punjab","GUJRANWALA"),
("1993","Muhammad Saleem Akhtar","Abdul Rasheed","3320213913531","Punjab","Jhang"),
("1994","Muhammad Saleem Moavia ","Muhammad Sharif ","3630207751189","Punjab","MULTAN"),
("1995","Muhammad Saleem Shahzad ","Muhammad Latif ","3520108723737","Punjab","LAHORE"),
("1996","Muhammad Salman Riaz ","Riaz Ahmad ","4220150177951","Punjab","BAHAWALPUR"),
("1997","Muhammad Samer Abbas ","Muhammad Sultan ","3610295262251","Punjab","KHANEWAL"),
("1998","Muhammad Saqib Saeed ","Saeed Ahmad ","3310534173233","Punjab","FAISALABAD"),
("1999","Muhammad Saqlain","Ghulam Ali Rehan","3430212608589","Punjab","CHINIOT"),
("2000","Muhammad Sarfraz ","Muhammad Yar ","3820122795699","Punjab","FAISALABAD"),
("2001","Muhammad Sarwar ","Muhammad Yousaf","3660397314611","Punjab","BHAKKAR"),
("2002","Muhammad Shaban ","Wahid Bakhsh","3130161451385","Punjab","RAHIM YAR KHAN"),
("2003","Muhammad Shabbir alias Hanzila, Ali ","Hafeez Ullah ","3120103414763","Punjab","BAHAWALPUR"),
("2004","Muhammad Shabir ","Ghulam Muhammad","3610322157799","Punjab","Khanewal"),
("2005","Muhammad Shafi ","Hafeez Ullah","3130333588645","Punjab","RAHIM YAR KHAN"),
("2006","Muhammad Shafiq ","Muhammad Rafiq ","3810242216647","Punjab","BHAKKAR"),
("2007","Muhammad Shafiq  ","Safiullah","4210160328249","Sindh","Karachi"),
("2008","Muhammad Shafique","Ghulam Qadir","3130420289477","Punjab","Rahim Yar Khan"),
("2009","Muhammad Shafique @ Abu Haris ","Muhammad Bashir","4210184592979","Sindh","Karachi"),
("2010","Muhammad Shafique alias Moavia ","Rasheed Ahmad ","3120109885111","Punjab","BAHAWALPUR"),
("2011","Muhammad Shah","Dilaram Khan","1530537039897","KP","LOWER DIR (AT TEMERGARA)"),
("2012","Muhammad Shah @ Soor","Muhammad Zarin","1560203794053","KP","SWAT (AT MINGORA)"),
("2013","Muhammad Shah Zaman","Shahik Khan","5320128731391","Balochistan","JAFFARABAD"),
("2014","Muhammad Shahbaz ","Muhammad Ishfaaq ","3410351589947","Punjab","GUJRANWALA"),
("2015","Muhammad Shahbaz ","Zulfiqar Ahmad ","3310064622541","Punjab","FAISALABAD"),
("2016","Muhammad Shahbaz ","Muhammad Zakria ","3410127105467","Punjab","GUJRANWALA"),
("2017","Muhammad Shahbaz Anwar ","Muhammad Anwar Shah ","3120286095827","Punjab","BAHAWALPUR"),
("2018","Muhammad Shahbaz Nawaz alias Shahbaz Muavia ","Muhammad Nawaz ","3440318866619","Punjab","GUJRAT"),
("2019","Muhammad Shahid ","Muhammad Zubair ","3820163748735","Punjab","KHUSHAB"),
("2020","Muhammad Shahid"," Sardar Muhammad (late) ","3410204716673","Punjab","GUJRANWALA"),
("2021","Muhammad Shahid","Muhammad lqbal","3840373625859","Punjab","SARGODHA"),
("2022","Muhammad Shahid alias Shahid Khalil Inkalabi  ","Qari Khalil Ahmad","3120173879381","Punjab","BAHAWALPUR"),
("2023","Muhammad Shahid Iqbal ","Muhammad Iqbal ","3120144991257","Punjab","BAHAWALPUR"),
("2024","Muhammad Shahid Nafees","Muhammad Sharif","3650223912529","Punjab","SAHIWAL"),
("2025","Muhammad Shahzad"," Abdul Hadi ","3130199945479","Punjab","RAHIM YAR KHAN"),
("2026","Muhammad Shahzad Hanif (Dhodi)","Muhammad Hanif","3640249381375","Punjab","PAKPATTAN"),
("2027","Muhammad Shakeel ","Abdul Ghani Khanzada @ Natho","4540318693531","Sindh","Sanghar"),
("2028","Muhammad Shakeel ","Raheem Uddin ","4240142614367","Sindh","Karachi"),
("2029","Muhammad Shakeel ","Nazir Ahmad ","3130124569585","Punjab","RAHIM YAR KHAN"),
("2030","Muhammad Shakil alias Fahim ","Taaj Deen","3520244235375","Punjab","LAHORE"),
("2031","Muhammad Shakir","Qabil Khan","","KP","Hangu"),
("2032","Muhammad Shakirullah @ Mufti Shakir","Haji Fazal Karim","4240116761181","Sindh","Karachi"),
("2033","Muhammad Shamim Alias Farooqi","Rustam Ali","3730138171473","Punjab","JHELUM"),
("2034","Muhammad Shamsher @ Qari Umar","Syed Uddin","4240171776369","Sindh","Karachi"),
("2035","Muhammad Sharif ","Noor Khan ","3720116688813","Punjab","CHAKWAL"),
("2036","Muhammad Sharif ","Imam Din ","3630247480215","Punjab","MULTAN"),
("2037","Muhammad Shehbaz","Muhammad Ameen(Late)","3130447041071","Punjab","Rahim Yar Khan"),
("2038","Muhammad Shehzad ","Abdul Sattar","3130307324231","Punjab","Rahim Yar Khan"),
("2039","Muhammad Shireen","Said Farraz r","1570590006611","KP","Dir Upper"),
("2040","Muhammad Shoaib","Abdul Raheem","3710492343071","Punjab","ATTOCK"),
("2041","Muhammad Shoaib","Meer Muhammad Akbar","3410101178013","Punjab","GUJRANWALA"),
("2042","Muhammad Shoaib ","Molvi Abdul Rasheed","3410132861183","Punjab","GUJRANWALA"),
("2043","Muhammad Shoaib alias Abu Saeed","Iqbal Ahmad","3840322037761","Punjab","KHUSHAB"),
("2044","Muhammad Shoaib alias Muavia ","Muhammad Nawaz ","3640208027905","Punjab","PAKPATTAN"),
("2045","Muhammad Shoaib Khan alias Ahmed Shoaib ","Abdul Rauf Khan","1210180719427","Punjab","MIANWALI"),
("2046","Muhammad Siddique","Ghulam Farid","3110116121823","Punjab","BAHAWALNAGAR"),
("2047","Muhammad Siddique","Ghulam Farid","3110116121813","Punjab","Bahawalnagar   "),
("2048","Muhammad Siddique","Haji Allah Wasaya (late) ","3120265934239","Punjab","BAHAWALPUR"),
("2049","Muhammad Siddique","Muhammad Sharif","3320214395843","Punjab","Jhang"),
("2050","Muhammad Siddique Gurchani ","Muhammad Ghazi ","3240273805889","Punjab","RAJANPUR"),
("2051","Muhammad Sidique Sajid","Gehna Khan","3320275434905","Punjab","Jhang"),
("2052","Muhammad Sohail","Kala Khan","3710251062581","Punjab","Attock    "),
("2053","Muhammad Sohail ","Noor Muhammad","4210164924561","Sindh","Karachi"),
("2054","Muhammad Sohail ","Islam Gul","1111111111137","KP","PESHAWAR"),
("2055","Muhammad Sufyan","Noor Ahmad","3630295194665","Punjab","MULTAN"),
("2056","Muhammad Sufyan Bashir alias Saifi Butt ","Muhammad Abdullah Bashir ","3420286454973","Punjab","GUJRAT"),
("2057","Muhammad Suleman ","Abdul Malik ","3310037921415","Punjab","FAISALABAD"),
("2058","Muhammad Suleman","Abdul Rasheed","3520193450527","Punjab","LAHORE"),
("2059","Muhammad Suleman ","Ghulam Fareed ","3120185427781","Punjab","BAHAWALPUR"),
("2060","Muhammad Suleman","Muhammad Jan","2110511198041","KP","PESHAWAR"),
("2061","Muhammad Suleman Saeed ","Muhammad Saeed ","4220164577327","Sindh","Karachi"),
("2062","Muhammad Sultan","Muhammad yaseen","3320212075001","Punjab","Jhang"),
("2063","Muhammad Tahir ","Allah Nawaz ","3210379217795","Punjab","DERA GHAZI KHAN"),
("2064","Muhammad Tahir","Raham Dil","1530210077107","KP","LOWER DIR (AT TEMERGARA)"),
("2065","Muhammad Tahir","Abdul Hussain","5440062728443","Balochistan","QUETTA"),
("2066","Muhammad Tahir ","Muhammad Yousaf ","3810242513243","Punjab","BHAKKAR"),
("2067","Muhammad Tahir Shah","Mohammad Hayat / Syed Abdul Nasir","1570144557137","KP","UPPER DIR (AT DIR)"),
("2068","Muhammad Tahir Siddique alias Tahir Rashidi (Gujja","Muhammad Siddique","3650294662231","Punjab","SAHIWAL"),
("2069","Muhammad Taj   ","Mahiwal","3740615549173","Punjab","RAWALPINDI"),
("2070","Muhammad Talha","Muhammad Shajeh","3520209198185","Punjab","LAHORE"),
("2071","Muhammad Talib","Suleman","3110116458147","Punjab","BAHAWALNAGAR"),
("2072","Muhammad Tanveer ","Abdul Majeed ","3320287523031","Punjab","FAISALABAD"),
("2073","Muhammad Taqi Shah ","Ghulam Shabbir Shah ","3230381930861","Punjab","MUZAFFARGARH"),
("2074","Muhammad Tariq ","Jahangir ","3810173386493","Punjab","BHAKKAR"),
("2075","Muhammad Tariq"," Shabbir Ahmad ","3120116440323","Punjab","BAHAWALPUR"),
("2076","Muhammad Tariq ","Ghualm Shabbir Khan ","3210239995085","Punjab","DERA GHAZI KHAN"),
("2077","Muhammad Tariq","Ali Ahmad ","3660358400213","Punjab","VEHARI"),
("2078","Muhammad Tariq","Muhammad Younis","3540406252411","Punjab","Sheikhupura"),
("2079","Muhammad Tariq ","Kareem Deen ","3810244343411","Punjab","BHAKKAR"),
("2080","Muhammad Tariq ","Muhammad Ishaq ","3120203500683","Punjab","BAHAWALPUR"),
("2081","Muhammad Tariq","Rizwan Shah","1620274706317","KP","SWABI"),
("2082","Muhammad Tariq alias Shahid","Muhammad Iqbal","3510133280053","Punjab","KASUR"),
("2083","Muhammad Tariq Shah","Gul Muhammad","1530624567011","KP","LOWER DIR (AT TEMERGARA)"),
("2084","Muhammad Tayyab","Habib Mullah","1530296101547","KP","LOWER DIR (AT TEMERGARA)"),
("2085","Muhammad Tayyab","Muslim Khan","1530558899399","KP","LOWER DIR (AT TEMERGARA)"),
("2086","Muhammad Tayyab ","Qari Muhammad Ashiq ","3630139975775","Punjab","MULTAN"),
("2087","MUHAMMAD TAYYAB","MUHAMMAD ASLAM","3650109080441","Punjab","SAHIWAL"),
("2088","Muhammad Tayyab ","Inayyat Ullah ","3810144546553","Punjab","BHAKKAR"),
("2089","Muhammad Tayyab (Bagra)","Muhammad Hafeez ur Rehman","3620317747589","Punjab","LODHRAN"),
("2090","Muhammad Tayyab Qasmi ","Muhammad Ahsan ","3320108941077","Punjab","MULTAN"),
("2091","Muhammad Tufail","Azmat Ali","3220225350037","Punjab","LAYYAH"),
("2092","Muhammad Tufail alias Master","Sardar Ali","3110148911961","Punjab","BAHAWALNAGAR"),
("2093","Muhammad Ubaid Ullah","Muhammad Rafique","3620223449509","Punjab","LODHRAN"),
("2094","Muhammad Ubaid Ullah","Hafiz Ghulam Muhammad ","3130324438279","Punjab","Rahim Yar Khan"),
("2095","Muhammad Ubaid Ullah ","Ghulam Muhammad ","3130324438479","Punjab","RAHIM YAR KHAN"),
("2096","Muhammad Umair @ Sardar ","Zareef Khan ","NIL","Sindh","Karachi"),
("2097","Muhammad Umair Chheena","Muhammad Ismail","3410172506245","Punjab","GUJRANWALA"),
("2098","Muhammad Umar ","Habib-Ur-Rehman Shahid ","3120272921297","Punjab","BAHAWALPUR"),
("2099","MUHAMMAD UMAR","NOOR MUHAMMAD","3220278465879","Punjab","LAYYAH"),
("2100","Muhammad Umar","Ghullam Shabbir","3320314577585","Punjab","Jhang"),
("2101","Muhammad Umar ","Ghulam Farid ","3210217320129","Punjab","DERA GHAZI KHAN"),
("2102","Muhammad Umar ","Abdul Kareem ","3120184077879","Punjab","BAHAWALPUR"),
("2103","Muhammad Umar @ Sohrab ","Haji Bazed Khan","4250113185987","Sindh","Karachi"),
("2104","Muhammad Umar Farooq ","Abdul Haq ","3120120565219","Punjab","BAHAWALPUR"),
("2105","Muhammad Umar Farooq","Muhammad Ilyas","3410358044261","Punjab","GUJRANWALA"),
("2106","Muhammad Umar Farooq ","Bashir Ahmad ","3630407032381","Punjab","MULTAN"),
("2107","Muhammad Umar Tahir alias Umar Haidri ","Muhammad Yaseen ","4210193411765","Punjab","JHANG"),
("2108","Muhammad Umer farooq","Muhammad Riaz","3320288535773","Punjab","Jhang"),
("2109","Muhammad Usman","Khaista Rahman","1530543890503","KP","LOWER DIR (AT TEMERGARA)"),
("2110","Muhammad Usman ","Muhammad Anwar","3410104371427","Punjab","GUJRANWALA"),
("2111","Muhammad Usman ","Muhammad Ameer Farooqi ","3320346806181","Punjab","JHANG"),
("2112","Muhammad Usman Alias Kala","Muhammad Sabir","3810213878061","Punjab","BHAKKAR"),
("2113","Muhammad Usman alias Muhammad Ismail, Abdul Qudos ","Muhammad Javed","3740624711673","Punjab","RAWALPINDI"),
("2114","Muhammad Usman Haider ","Hafiz Muhammad Ashraf ","3320225228917","Punjab","SAHIWAL"),
("2115","Muhammad Usman Haider","Nimat Ullah ","3210351127973","Punjab","DERA GHAZI KHAN"),
("2116","Muhammad Usman Zia ","Muhammad Bashir Zia ","3740572376539","Punjab","RAWALPINDI"),
("2117","Muhammad Uzair ","Talib Hussain ","3410112095661","Punjab","GUJRANWALA"),
("2118","Muhammad Uzair","Mahmood","3120114631603","Punjab","BAHAWALPUR"),
("2119","Muhammad Waheed ","Abdul Ghafoor ","3120175387359","Punjab","BAHAWALPUR"),
("2120","Muhammad Waheed Khan Niazi ","Haji Kashmir Khan Niazi","4230128676807","Sindh","Karachi"),
("2121","Muhammad Wajid Ali ","Muhammad Iqbal ","3410358748927","Punjab","GUJRANWALA"),
("2122","Muhammad Wajid alias Qari Wajid","Muhammad Sharif","3510403953487","Punjab","KASUR"),
("2123","Muhammad Waqar Amir alias Azeem","Muhammad Younis","3720117584485","Punjab","CHAKWAL"),
("2124","Muhammad Waqas","Shah Nawaz","3610336692887","Punjab","Khanewal"),
("2125","Muhammad Waqas","Muhammad Rasheed","3320404150381","Punjab","Jhang"),
("2126","Muhammad Waseem Ahmad Shahzad","Zafar Ahmad","3660179389171","Punjab","VEHARI"),
("2127","Muhammad Waseem Butt","Muhammad Sharif Butt","3460207237427","Punjab","Sialkot"),
("2128","Muhammad Waseem Nawaz ","Muhammad Nawaz ","3330326030243","Punjab","TOBA TEK SINGH"),
("2129","Muhammad Wazeer ","Taj Muhammad ","3120182779613","Punjab","BAHAWALPUR"),
("2130","Muhammad Yahya ","Muhammad Arshad ","3310063442677","Punjab","FAISALABAD"),
("2131","Muhammad Yahya Aziz ","Ch. Ilam Din ","3540415773099","Punjab","SHEIKHUPURA"),
("2132","Muhammad Yameen ","Ghulam Shabeer ","3210246015897","Punjab","DERA GHAZI KHAN"),
("2133","Muhammad Yamin ","Ghulam Muhammad ","3230477996197","Punjab","Muzaffargarh"),
("2134","Muhammad Yaqoob ","Muhammad Ishaq ","3820135259827","Punjab","KHUSHAB"),
("2135","Muhammad Yaqoob","Muhammad Hanif","3540415807189","Punjab","Sheikhupura"),
("2136","Muhammad Yaqoob","Ghullam Abbas","3710520019369","Punjab","ATTOCK"),
("2137","Muhammad Yaqoob ","Haji Muhammad Ramzan ","3810219431943","Punjab","BHAKKAR"),
("2138","Muhammad Yaqoob ","Muhammad Ishaq ","3120349251293","Punjab","BAHAWALPUR"),
("2139","Muhammad Yaqoob Qasmi","Noor Muhammad Marhoom","3540117362225","Punjab","Sheikhupura"),
("2140","Muhammad Yaqoob Qasmi ","Muhammad Farzand Ali ","3630296569393","Punjab","MULTAN"),
("2141","Muhammad Yaseen","Muhammad Ramzan","3320383590735","Punjab","Jhang"),
("2142","Muhammad Yasin ","Muhammad Younas ","3330222617871","Punjab","TOBA TEK SINGH"),
("2143","Muhammad Yasin ","Rahmat Ali","3530175346017","Punjab","OKARA"),
("2144","Muhammad Yasin ","Muhammad Shafi ","3310071896451","Punjab","FAISALABAD"),
("2145","Muhammad Yasin","AHMAD BAKHSH","3220291521429","Punjab","LAYYAH"),
("2146","Muhammad Yasin Farooqi ","Muhammad Ibrahim","3520124888573","Punjab","LAHORE"),
("2147","Muhammad Younas","Ghullam Qasim","3320285953253","Punjab","Jhang"),
("2148","Muhammad Younas","Mian Sultan Zeb","1510163229829","KP","BUNER"),
("2149","Muhammad Younas","Ghulam Hussain","3520014313453","Punjab","LAHORE"),
("2150","Muhammad Younas Ali ","Ghulam Shahbaz Ali ","6110168715079","Punjab","FAISALABAD"),
("2151","Muhammad Younas alias Master ","Sher Muhammad ","3110116398931","Punjab","BAHAWALNAGAR"),
("2152","Muhammad Younis","Sultan Ali","3420250967819","Punjab","GUJRAT"),
("2153","Muhammad Younis Khan ","Saeed Ahmad ","3220294954073","Punjab","LAYYAH"),
("2154","Muhammad Yousaf","Atta Muhammad ","3620204919429","Punjab","LODHRAN"),
("2155","Muhammad Yousaf","Aleem Ud Din","3330201485759","Punjab","T.T.Singh"),
("2156","Muhammad Yousaf","Bundu","3320297299163","Punjab","Jhang"),
("2157","Muhammad Yousaf ","karamat Ali","3410106829997","Punjab","GUJRANWALA"),
("2158","Muhammad Yousaf Bodla ","Shafqat Rasool Bodla ","3630477582301","Punjab","MULTAN"),
("2159","Muhammad Yousaf Raheemi ","Muhammad Hanif ","3530120286859","Punjab","OKARA"),
("2160","Muhammad Zahid ","Jinnah Khan","2170460059317","Sindh","Karachi"),
("2161","Muhammad Zahid","Muqadas Shah","1550442852365","KP","SHANGLA (AT ALPURI)"),
("2162","Muhammad Zahid","Muhammad Farooq","4220160369519","Punjab","BAHAWALNAGAR"),
("2163","Muhammad Zahid ","Rafiq Ahmad","3130130799865","Punjab","RAHIM YAR KHAN"),
("2164","Muhammad Zahid ","Abdul Hadi ","3130343054163","Punjab","RAHIM YAR KHAN"),
("2165","Muhammad Zahid Mahmood","Abdul Aziz","3660314330883","Punjab","Vehari"),
("2166","Muhammad Zahoor ","Aurangzaib ","3740402703285","Punjab","RAWALPINDI"),
("2167","Muhammad Zakiria Azam ","Muhammad Azam ","3120164057263","Punjab","BAHAWALPUR"),
("2168","Muhammad Zaman","Fateh Khan","1530210071239","KP","LOWER DIR (AT TEMERGARA)"),
("2169","Muhammad Zaman","Gul Zaman","1571010108372","KP","UPPER DIR (AT DIR)"),
("2170","Muhammad Zikriya ","Abdul Rehman ","3640109019893","Punjab","PAKPATTAN"),
("2171","Muhammad Zohaib Arif  ","Muhammad Arif ","3230372625089","Punjab","MUZAFFARGARH"),
("2172","Muhammad Zubair","Kifayat Ur Rahman","1710259544467","KP","CHARSADDA"),
("2173","Muhammad Zubair ","Muhammad Rasheed ","3310007341293","Punjab","FAISALABAD"),
("2174","Muhammad Zubair","Afzal","3810170583659","Punjab","BHAKKAR"),
("2175","Muhammad Zubair Ahmad","Muhammad Bakhsh alias Muhammad Khan ","3120104312507","Punjab","BAHAWALPUR"),
("2176","Muhammad Zubair Khan ","Qaisar Hussain Khan ","3630405704545","Punjab","MULTAN"),
("2177","Muhammad Zulfiqar","Kameer ","3840598603451","Punjab","SARGODHA"),
("2178","MuhammadJaved Akhtar(Gujjar)","Nazir Ahmad","3650206923833","Punjab","SAHIWAL"),
("2179","Muhib","Manjawar","1560258507251","KP","SWAT (AT MINGORA)"),
("2180","Muhib Ullah","Muhammad Darwaish","1530575185121","KP","LOWER DIR (AT TEMERGARA)"),
("2181","Muhmmad Asghar @ Commando ","Muhammad Ibrahim ","4210131338615","Sindh","Karachi"),
("2182","Mujahid","Hidayat ullah (Alias)","1530737452823","KP","LOWER DIR (AT TEMERGARA)"),
("2183","Mujahid Abbas ","Mazhar Hussain ","3320227340671","Punjab","JHANG"),
("2184","Mujahid Ahmad","Muhammad Ramzan","3610219151977","Punjab","GUJRAT"),
("2185","Mujahid Iqbal alias Muja, Sufiyan, Bugti ","Allah Bakhsh ","3210302788277","Punjab","DERA GHAZI KHAN"),
("2186","Mujahid Islam","Rehmatullah","3650253079021","Punjab","SAHIWAL"),
("2187","Mujtaba","Manazar Abbas ","3340104006671","Punjab","Chiniot"),
("2188","Mukaram","Bahram","1570140511671","KP","UPPER DIR (AT DIR)"),
("2189","Mukhtar Hussain Malik","Zawar Ullah Dad","3220225024151","Punjab","LAYYAH"),
("2190","Mukhtiar","Aqil","1510166735363","KP","BUNER"),
("2191","Mukhtiar Ahmad ","Ghulam Ali ","3120197294659","Punjab","BAHAWALPUR"),
("2192","Mukhtiar Hussain ","Lashkar Ali","3810105848449","Punjab","BHAKKAR"),
("2193","Mukhtiar Hussain ","Allah Diwaya ","3230369197887","Punjab","MUZAFFARGARH"),
("2194","Mulana Abdullah Shah Mazhar ","Mazhar Muhammad Saeed","4220105583081","Sindh","Karachi"),
("2195","Mulana Hafiz Abdul Ghani ","Mian Ghulam Fareed ","3120396281245","Punjab","BAHAWALPUR"),
("2196","Mulana Taj Muhammad Hanfi ","Nasir Ahmed","1520206574661","Sindh","Karachi"),
("2197","Mulvi Abdur Raziq","Fazal Raziq","","KP","Toorghar"),
("2198","Mulvi Shah Imran","Bakht Zamin","1560277646943","KP","SWAT (AT MINGORA)"),
("2199","Mumtaz Ahmed @ Pehewlan","Abdul Khaliq (late)","5160211314771","Balochistan","MASTUNG"),
("2200","Mumtaz Ali ","Muhammad Hussain Brohi","4200044779397","Sindh","KARACHI EAST"),
("2201","Mumtaz Hussain","Imam bakhash","3320307801685","Punjab","Jhang"),
("2202","Munawar ","Sultan","4210188511481","KP","S.WAZIRISTAN (AT WANA)"),
("2203","MUNAWAR ABBAS","MULAZIM HUSSAIN","3220279450031","Punjab","LAYYAH"),
("2204","Munawar Hussain  ","Malik Ghulam Hussain ","3120119578217","Punjab","BAHAWALPUR"),
("2205","Munawar Hussain","Muhammad Suleman Khan","3410372566685","Punjab","GUJRANWALA"),
("2206","Munawar Khan","Bahadar Khan","1110141395079","KP","Bannu"),
("2207","Munazzam Ali alias Usama, Shaka, Muhammad, Ali ","Muhammad Mushtaq ","3460356591441","Punjab","SIALKOT"),
("2208","Munir","Habib Ullah","1530209859715","KP","LOWER DIR (AT TEMERGARA)"),
("2209","Munir Ahmad ","Khalil Ahmad ","3810290521757","Punjab","BHAKKAR"),
("2210","Munir Ahmed","Ali Muhammad","3320211359485","Punjab","Jhang"),
("2211","Munir Ahmed ","Muhammad Nawaz","1310197990043","Sindh","Karachi"),
("2212","Munir Ahmed Shahid","Muhammad Ismail","3320212324569","Punjab","Jhang"),
("2213","Muntazir Abbas","Nasir Abbas","3720175635605","Punjab","CHAKWAL"),
("2214","Muqadar Shah","Maqbool Shah","1730144604435","KP","PESHAWAR"),
("2215","Mureed Abbas alias Yazdani ","Fateh Sher ","3810105938007","Punjab","BHAKKAR"),
("2216","Mureed Hussain ","Fida Hussain ","3120194926579","Punjab","BAHAWALPUR"),
("2217","Mursaleen @ Paya","Abdul Qadir ","4210152597851","Sindh","Karachi"),
("2218","Murtaza Ali @ Sajid ","Risat Ali ","4210131852275","Sindh","Karachi"),
("2219","Musa Khan",".Haje Nawab","1560258048423","KP","SWAT (AT MINGORA)"),
("2220","Mushtaq Ahmad ","Muhammad Yousaf ","3410147987259","Punjab","GUJRANWALA"),
("2221","Mushtaq Ahmad alias Mullan Rocketee ","Sher Muhammad ","3610285963085","Punjab","KHANEWAL"),
("2222","Mushtaq Ahmad alias Saqi ","Muhammad Yar","3660209825725","Punjab","VEHARI"),
("2223","Mushtaq Ahmad Tabasum","Sufi Lal Khan","3710406757519","Punjab","ATTOCK"),
("2224","Muslim","Amer Zaman","1560204686455","KP","SWAT (AT MINGORA)"),
("2225","Muslim Shah","Dilawar Shah","1510140187063","KP","BUNER"),
("2226","Mustafa Kamal","Farid Khan","1610141371611","KP","MARDAN"),
("2227","Muzafar Hussain Shah ","Anwar Hussain Shah ","3310082420037","Punjab","FAISALABAD"),
("2228","Muzaffar Hussain","Mukhtiar  Hussain Nangraj ","4530218782389","Sindh","NAUSHAHRO FEROZE"),
("2229","Muzam Rasheed","Abdul Rasheed","3520224237911","Punjab","Lahore"),
("2230","Muzamal Hussain ","Khan Muhammad ","3460328393021","Punjab","SIALKOT"),
("2231","N.A","N.A","1530280457455","KP","Dir Lower"),
("2232","Nadeem","Mehboob Ali","4220193729715","Sindh","Karachi"),
("2233","Nadeem Abbas alias Kaka/Jaun Abbas","Ghulam Hussain","3220231924243","Punjab","LAYYAH"),
("2234","Nadeem Ahmad","Abdul Rasheed","3660184783525","Punjab","VEHARI"),
("2235","Nadeem Ahmad ","Hakim Abdul Waheed ","3520290601999","Punjab","LAHORE"),
("2236","Nadeem Iqbal ","Kareem Bakhsh ","3120425244337","Punjab","BAHAWALPUR"),
("2237","Nadeem Iqbal","Noor Ahmad","3110536504931","Punjab","BAHAWALNAGAR"),
("2238","Nadeem Iqbal alias Abu Anus ","BASHIR AHMAD","3220283281607","Punjab","LAYYAH"),
("2239","Nadeem Qureshi ","Saeed Ahmed","NIL","Sindh","Hyderabad"),
("2240","Nadeem Yaqoob","Muhammad Yaqoob","3720172752037","Punjab","CHAKWAL"),
("2241","Nadir Khan","Raza Khan","1560204960083","KP","SWAT (AT MINGORA)"),
("2242","Naeem Akhtar alias Munna ","Ghulam Fareed ","3320360619411","Punjab","JHANG"),
("2243","Naeem Arshad","Nazar Muhammad","3420120469623","Punjab","GUJRAT"),
("2244","Naeem Ullah Khan ","Abdul Munaf Khan ","3450246603757","Punjab","GUJRAT"),
("2245","Nafees Abbas ","Muhammad Ahmed","42301.91590795","Sindh","Karachi"),
("2246","Nafees Akbar","Muhammad Akbar","3710409455447","Punjab","Attock    "),
("2247","Naimat Khan","Abdul Malik","1560203869399","KP","SWAT (AT MINGORA)"),
("2248","Najam Abbass","Ashiq Hussain Shah","3840122255639","Punjab","SARGODHA"),
("2249","Najam Din @ Mujahid S/o Mujahid","Muhammad Qasim Leghari ","4120279794021","Sindh","Dadu"),
("2250","Najam-ul-Hassan ","Muhammad Hassan ","3130326233803","Punjab","FAISALABAD"),
("2251","Najam-ul-Hassan ","Syed Muhammad Ali Kazmi ","3460321763961","Punjab","SIALKOT"),
("2252","Najamul Haq alias Najoo","Hakeem ","4520111080389","Sindh","Khairpur"),
("2253","Najeeb Ullah","Hafeez Ullah","3420286791739","Punjab","GUJRAT"),
("2254","Najeeb Ullah"," Akbar","2170524036809","KP","DERA ISMAIL KHAN"),
("2255","Najeeb Ullah","Wasam Khan","2120219822589","KP","KHYBER (AT PESHAWAR)"),
("2256","Najeebullah Jamaldini","Mohammad Arif.","5140122162129","Balochistan","KHUZDAR"),
("2257","Naqeeb Ullah","Abdul Wahid (Late)","5440109815107","Balochistan","QUETTA"),
("2258","Naqeeb Ullah","Wasim Khan","1111111111114","KP","PESHAWAR"),
("2259","Nasar Khan","Bakht Rawan","1560240711583","KP","SWAT (AT MINGORA)"),
("2260","Naseeb Shah","Aman Khan","1560403439823","KP","SWAT (AT MINGORA)"),
("2261","Naseem","Khaista War Khan","","KP","Dir Lower"),
("2262","Naseem","Hameed Khan Caste Akhel Tappa Mohsin Khel","1410154030499","KP","KOHAT"),
("2263","Naseem Abbas ","Ghulam Abbas ","3810106815773","Punjab","BHAKKAR"),
("2264","Naseem Hajjaz ","Manzoor Ahmad ","3130338678395","Punjab","RAHIM YAR KHAN"),
("2265","NASEER UL RAZA SAFDAR","Ghazanfar Ali Khan","3650176753493","Punjab","SAHIWAL"),
("2266","Nasib Ullah (Nasib Zada)","Qashqaray","1550551258573","KP","SHANGLA (AT ALPURI)"),
("2267","Nasir Abbas","Zahoor Hussain (Late)","3660209374013","Punjab","Vehari"),
("2268","Nasir Ahmad","Amir","1530232394011","KP","LOWER DIR (AT TEMERGARA)"),
("2269","Nasir Ali","Dalmeer Khan","3320227802425","Punjab","Jhang"),
("2270","Nasir Ali ","Rehmat Ali ","3410262143683","Punjab","GUJRANWALA"),
("2271","Nasir Hussain alias Haji ","Altaf Hussain ","3630280079795","Punjab","MULTAN"),
("2272","Nasir Iqabal @ Saifullah ","Muhammad Habib","4240185033473","Sindh","Karachi"),
("2273","Nasir Iqbal @ Saifullh ","Muhammad Habib ","4240185033473","Sindh","Karachi"),
("2274","Nasir Javed ","Allah Bakhsh ","3320313886495","Punjab","JHANG"),
("2275","Nasir Khan","Hakim Khan","1330204275003","KP","HARIPUR"),
("2276","Nasir Mahmood ","Shabbir Ahmad ","3320259804593","Punjab","JHANG"),
("2277","Nasir Mehmood ","Mehndi Hassan ","3620112376613","Punjab","LODHRAN"),
("2278","Nasir Mehmood Abbasi ","Muhammad Abbas Abbasi ","3740402704627","Punjab","RAWALPINDI"),
("2279","Nasrullah ","Abdul Habib","5430384615179","Balochistan","PISHIN"),
("2280","Naveed Ahmad","Muhammad Sharif","3430132976723","Punjab","HAFIZABAD"),
("2281","Naveed Hussain","Ghani ur Rehman","1620404289607","KP","SWABI"),
("2282","Naveed Majeed ","Abdul Majeed","3420220471919","Punjab","GUJRAT"),
("2283","Naveed Ur Rehman ","Abdul Rehman ","3520205814569","Punjab","LAHORE"),
("2284","Nawab","Shahzada Undak","1530269021577","KP","LOWER DIR (AT TEMERGARA)"),
("2285","Nawab Zada","Mohammad Zada","1570121144463","KP","UPPER DIR (AT DIR)"),
("2286","Nawaz Ali Shah ","Murad Ali Shah ","4140104866681","Sindh","THATTA"),
("2287","Nawaz Khan","Sher Zaman","1310172360777","KP","ABBOTTABAD"),
("2288","Nawaz Khan","Iqrar Khan","3320162318467","Punjab","CHINIOT"),
("2289","Nayyar Abbas Jafery","Ghulam Murtaza Jafery","1330251140773","KP","HARIPUR"),
("2290","Nayyer Abbas ","Zulfiqar Khan ","3320266843559","Punjab","JHANG"),
("2291","Nazakat Ali","Dilawar Khan","3710601302815","Punjab","Attock    "),
("2292","Nazakat Ali alias Khalid Joiya","Liaqat Ali","3530306789993","Punjab","OKARA"),
("2293","Nazakat Ali Usmani","Raja Bagh Ali (Late)","3740559184471","Punjab","CHAKWAL"),
("2294","Nazamin khan","Abdul Ghaffar","","KP","Dir Lower"),
("2295","Nazamin Khan","Khaista War Khan","1530566908913","KP","LOWER DIR (AT TEMERGARA)"),
("2296","Nazar Abbas ","Hafeez Ahmad ","3810106235223","Punjab","BHAKKAR"),
("2297","Nazar Abbas ","Mehmood Ahmed Bhatti ","3450144314899","Punjab","NAROWAL"),
("2298","Nazar Abbas ","Inayat Ali ","3450119927897","Punjab","NAROWAL"),
("2299","Nazar Hussain","Khan Muhammad","3710516819677","Punjab","Attock    "),
("2300","Nazar Ul Hassan "," Zahoor Ul Hassan ","3310009746437","Punjab","TOBA TEK SINGH"),
("2301","Nazeem","Zaman Khan","2110140384323","KP","BAJAUR (AT KHAR BAJAUR)"),
("2302","Nazeer Ahmad alias Nazeer Ghamb","Haji Rasool Bakhsh","3120133069401","Punjab","BAHAWALPUR"),
("2303","Nazeer Ahmed @ Nazeer ","Abdul Rahim.","4240142297085","Balochistan","LASBELA (AT UTHAL)"),
("2304","Nazeer Hussain Shah","Rahmat Shah Kazmi","1330296476411","KP","HARIPUR"),
("2305","Nazir Ahmad","Shah Muhammad","3120450393369","Punjab","Bahawalpur"),
("2306","NAZIR AHMAD ","JAN MUHAMMAD ","3650130073367","Punjab","SAHIWAL"),
("2307","Nazir Ahmad ","Muhammad Subhan ","3120198836595","Punjab","BAHAWALPUR"),
("2308","Nazir Ahmad Asad alias Asad ","Noor Ahmad","3450167784081","Punjab","NAROWAL"),
("2309","Nazir Ahmad Bukhari ","Hussain Shah ","3310008488157","Punjab","FAISALABAD"),
("2310","Nazir Khan","Naik Khan","4220123694443","KP","KOHAT"),
("2311","Nazir ul Salam","Altaf","8230377735949","AJ&K","Chinatt, District Bagh"),
("2312","Niaz Ali","Wazir Gul","1310199827493","KP","ABBOTTABAD"),
("2313","Niaz Hussain","Mumtaz Ali","3810157456471","Punjab","BHAKKAR"),
("2314","Niaz Muhammad","Man dad","1620107360459","KP","SWABI"),
("2315","Niaz Muhammad ","Syed Muhammad","1111111111126","KP","PESHAWAR"),
("2316","Niazullah","Shahnawaz Banglani","4330353976235","Sindh","Shikarpur"),
("2317","Nisar Ahmad Alias Haider, Khalid, Abdul Rehman","Muhammad Rafique","3820111669313","Punjab","KHUSHAB"),
("2318","Nisar Ahmed ","Hakim Ali Simair","4550186332497","Sindh","Sukkur"),
("2319","Nisar Ahmed","Abdul Shakoor","3410254751635","Punjab","GUJRANWALA"),
("2320","Nisar Caste Baloch","Meeran","5220364859599","Balochistan","KECH (AT TURBAT)"),
("2321","Nisar Khan","Muhammad Zahir Shah","1530767582317","KP","LOWER DIR (AT TEMERGARA)"),
("2322","Nisar Ullah","Mohammad Essa Khan","1570111781637","KP","UPPER DIR (AT DIR)"),
("2323","Nizam .","s/o Kashar Khan","1570197457995","KP","UPPER DIR (AT DIR)"),
("2324","Noor Ahmad","Muhammad Mansha ","3430117449393","Punjab","HAFIZABAD"),
("2325","Noor Ahmad Farooqi ","Rehmat Ali ","3640226565491","Punjab","PAKPATTAN"),
("2326","Noor Alam Khan","Hazrat Gulab","1530331867853","KP","LOWER DIR (AT TEMERGARA)"),
("2327","Noor Khan @ Zarqqavi ","Shahjjahan","1320260821673","KP","BATAGRAM (AT BANA)"),
("2328","Noor Muhammad","Haji Muhamad","1540126130021","KP","MALAKAND P.A."),
("2329","Noor Muhammad Caste Adozai","Abdul Nabi","5420124582889","Balochistan","KILLA ABDULLAH"),
("2330","Noor ul Ameen","Yaqoob Khan","1620283938319","KP","SWABI"),
("2331","Noor Wali","Haji Atlas","","KP","Bannu"),
("2332","Noor-ul-Akbar","Malik Shah","1620206665671","KP","SWABI"),
("2333","Noor-ul-Ameen","Abdul Haleem ","5440058424177","Balochistan","QUETTA"),
("2334","Noor-ul-Haq","Abdul Bari","5650304872141","Balochistan","ZHOB"),
("2335","Nooran Gul ","Bakht Jan","4240118161829","Sindh","Karachi"),
("2336","Noroz","Bahadar Khan","1730108377605","KP","CHARSADDA"),
("2337","Nouman Abbas alias Nomi ","Ghulam Akbar","3720108053605","Punjab","CHAKWAL"),
("2338","Nowroz","Sikandar Shah","1610195175753","KP","MARDAN"),
("2339","Obaid ur Rehman","Abdul Sattar","1120199877447","KP","LAKKI MARWAT"),
("2340","Parvez","Hakim Khan","1570144315991","KP","UPPER DIR (AT DIR)"),
("2341","Peer Rehman ","Muhammad Deen ","2170504458077","Sindh","Karachi"),
("2342","Pir Fareed Ali Shah ","Farhad Ali Shah","4510287757121","Sindh","Khairpur"),
("2343","Pir Hujat Ullah","Abdul Kabir","1730159666493","KP","PESHAWAR"),
("2344","Pir Muhammad","Shah Madar","1570224955787","KP","UPPER DIR (AT DIR)"),
("2345","Professor Qaim Ahmad","Salar Khan","1620285491877","KP","Swabi"),
("2346","Qaimoos Khan","Behroz","1560254408499","KP","SWAT (AT MINGORA)"),
("2347","Qaisar Abbas ","Bashir Hussain Khan ","3810192853905","Punjab","BHAKKAR"),
("2348","Qaisar Abbas ","Fida Hussain Khan","3320238530985","Punjab","JHANG"),
("2349","Qaisar Abbas ","Zulfiqar Khan","3320356562855","Punjab","JHANG"),
("2350","Qaisar Abbas alias Bhalla ","Riaz Ahmad ","3320244629349","Punjab","JHANG"),
("2351","Qaiser Abbas "," Muhammad Ramzan ","3320372108369","Punjab","JHANG"),
("2352","Qaiser Abbas ","Pervaiz ","3610288741215","Punjab","KHANEWAL"),
("2353","Qaiser Hanif ","Muhammad Hanif ","3310090063365","Punjab","FAISALABAD"),
("2354","Qalab Abbas ","Muhammad Iqbal Jafri ","3310007175091","Punjab","FAISALABAD"),
("2355","Qamar Abbas ","Ghulam Abbas ","4250137409469","Punjab","TOBA TEK SINGH"),
("2356","Qamar Raza","Ghullam Raza","3320204275587","Punjab","Jhang"),
("2357","Qamar Shah","Umar Khan","1530572377971","KP","LOWER DIR (AT TEMERGARA)"),
("2358","Qamar Ul Haq","s/o Lajbar","1570591341305","KP","LOWER DIR (AT TEMERGARA)"),
("2359","QAMAR-U-ZAMAN","MUHAMMAD YOUNAS","3420208509871","Punjab","GUJRAT"),
("2360","Qari  Naeem Ullah ","Ghulam Rasool Khan ","3210397964625","Punjab","DERA GHAZI KHAN"),
("2361","Qari Abdul Ghaffar Shakir ","Muhammad Sharif  Rajput @ Sipla Rajput ","4130245228313","Sindh","Hyderabad"),
("2362","Qari Abdul Hameed","Muhammad Yaqoob","1330204912025","KP","Haripur"),
("2363","Qari Abdul Nasir","Ahmed Shah ","5430320194553","Balochistan","PISHIN"),
("2364","Qari Abdul Samad","Abdullah  ","5430337503511","Balochistan","PISHIN"),
("2365","Qari Abdul Shakir ","Wazeer","","Sindh","Hyderabad"),
("2366","Qari Abdur Rashid","Muhammad Zaman","1350422318467","KP","MANSEHRA"),
("2367","Qari Abdur Rehman","Kohistani Mola","1570196088795","KP","UPPER DIR (AT DIR)"),
("2368","Qari Abdur Rehman","Abdur Razaq","1310160074033","KP","ABBOTTABAD"),
("2369","Qari Akhtar Hussain","Fateh Muhammad","3730187987891","Punjab","JHELUM"),
("2370","Qari Allah Wasaya ","Ghulam Muhammad ","3120202526065","Punjab","BAHAWALPUR"),
("2371","Qari Anwar Sher","Muhammad Rashad","1560232525555","KP","SWAT (AT MINGORA)"),
("2372","Qari Anwar-ul-Hassan","Imam Din","3320214242311","Punjab","JHANG"),
("2373","Qari Asad Irfan","Shafa Khan (Late)","3720122698987","Punjab","CHAKWAL"),
("2374","Qari Ayub","Haq Nawaz Khan","1110114753469","KP","BANNU"),
("2375","Qari Bilal Qasmi @ Farooqi","Muhib Ullah","1730102394707","KP","PESHAWAR"),
("2376","Qari Hammad Ullah alias Madni ","Abdul Raheem ","3130358990001","Punjab","RAHIM YAR KHAN"),
("2377","Qari Ikram Ullah","Amin Gul","1610299601005","Punjab","Attock    "),
("2378","Qari Ikramullah ","Amanullah.","7150101251555","Gilgit-Baltistan","GILGIT"),
("2379","Qari Imtiaz ","Mustajab","4220124331376","Sindh","Karachi"),
("2380","Qari inayatullah ","Allah Yar","3210347694491","Punjab","D.G.Khan"),
("2381","Qari Iqbal","Hamid Gul","1550176941211","KP","SHANGLA (AT ALPURI)"),
("2382","Qari Iqrar Abbassi","Abdul Razaq Abbassi","1310108475041","KP","ABBOTTABAD"),
("2383","Qari Khalid Hussain Rehmani ","Nooral Solangi","4530183389021","Sindh","N-Feroze"),
("2384","Qari Khalil","Mohammad Saeed","1570174453053","KP","UPPER DIR (AT DIR)"),
("2385","Qari Masood ur Rehman","Abdul Mehboob","1234567891011","Punjab","Lahore"),
("2386","Qari Muhamamd Imran","Bashir Ahmad","3610290731261","Punjab","Khanewal"),
("2387","Qari Muhammad Ajmal","Hafiz Jaan Muhammad","3660221667605","Punjab","Vehari"),
("2388","Qari Muhammad Asghar Ali","Chirag Din","3660259625953","Punjab","Vehari"),
("2389","Qari Muhammad Aslam Farooqi","Khushi Muhammad","3330217746461","Punjab","T.T.Singh"),
("2390","Qari Muhammad Ayoub","Hafiz Abdul Rauf","6110117665251","Punjab","Attock    "),
("2391","Qari Muhammad Faisal","Bahadur khan","3210274965399","Punjab","DERA GHAZI KHAN"),
("2392","Qari Muhammad Hayyat","MUHAMMAD ALI","3220201040319","Punjab","LAYYAH"),
("2393","Qari Muhammad Imran","Bashir Ahmad","3610290731561","Punjab","KHANEWAL"),
("2394","Qari Muhammad Iqbal","Shabbir Ahmad @ Shabbira Foji","3610310973191","Punjab","KHANEWAL"),
("2395","qari muhammad naseer","khadim hussain joyia","3120103594339","Punjab","Bahawalpur"),
("2396","Qari Muhammad Ramzan","Muhammad Sultan","1330217674451","KP","ABBOTTABAD"),
("2397","Qari Muhammad Rasheed","Mehtab Khan ","3630240797463","Punjab","MULTAN"),
("2398","Qari Muhammad Riaz","Muhammad Aslam","3710113104499","Punjab","Attock    "),
("2399","Qari Muhammad Sajjad ","Bashir Ahmad ","3120111590817","Punjab","BAHAWALPUR"),
("2400","Qari Muhammad Sharif","Hazoor Muhammad","3710111217179","Punjab","Attock    "),
("2401","Qari Muhammad Suleman","Muhammad Azam","3710533689825","Punjab","Attock    "),
("2402","Qari Mukhtar Ahmed alias (Rajpoot)","Gulzar Ahmed ","3730211750289","Punjab","GUJRAT"),
("2403","Qari Naveed ur Rehman alias Sufi Nasir","Muhammad Saleem","3630213812411","Punjab","MULTAN"),
("2404","Qari Rafiq","Abdul Jalil","1620255741529","KP","SWABI"),
("2405","Qari Raqib ","Hafiz Nadeem","NIL","Sindh","Hyderabad"),
("2406","Qari Rooh-ul-Amin","Rehmat Ullah","1530618253019","KP","LOWER DIR (AT TEMERGARA)"),
("2407","Qari Saif Ullah","az","1111111111133","KP","PESHAWAR"),
("2408","Qari Sakhawat Ali","Allah Rakha","3460362295053","Punjab","Sialkot"),
("2409","Qari Sami Ullah","Taj Muhammad","1570199767571","KP","UPPER DIR (AT DIR)"),
("2410","Qari Sher Zaman ","Syed Zaman","1111111111134","KP","PESHAWAR"),
("2411","Qari Ubaid Ur Rehman","Abdur Rehman","3740605376079","KP","ABBOTTABAD"),
("2412","Qari Umar Farooq","Qari Asgar Ali","3660247306581","Punjab","Vehari"),
("2413","Qari Yaseen ","M. Nazeer","4210114005961","Sindh","Karachi"),
("2414","Qasim","Mian Sher","1530209306169","KP","LOWER DIR (AT TEMERGARA)"),
("2415","Qasim Ali "," Allah Ditta Khan ","3320282279599","Punjab","JHANG"),
("2416","Qasim Din","Malik Fazil ","3130323655249","Punjab","RAHIM YAR KHAN"),
("2417","Qasim Shah","Abdullah Shah","1330257195869","KP","Haripur"),
("2418","Qasim-ul-Hassan ","Shooqeen Ali ","3740283026507","Punjab","RAWALPINDI"),
("2419","Qayum Khan ","Karim Jan","1520123405687","KP","CHITRAL"),
("2420","Qazi Fakhar Hussain","Qazi Muhammad Hussain","3710499182837","Punjab","Attock    "),
("2421","Qazi Kashif Hussain","Qazi Bashir Ahmed","3520015781271","Punjab","LAHORE"),
("2422","Raaz Muhammad @ Kakai ","Sher Khan","4230191499763","Sindh","Karachi"),
("2423","Rab Nawaz ","Barkat Ali ","3210241458403","Punjab","DERA GHAZI KHAN"),
("2424","Rab Nawaz","Ghulam Qasim Khan","3810106962449","Punjab","BHAKKAR"),
("2425","Rab Nawaz Khan ","Mahiwal ","3740616221651","Punjab","RAWALPINDI"),
("2426","Rabnawaz ","Ghulam Fareed ","3120183163833","Punjab","BAHAWALPUR"),
("2427","Raees","Abdul Mateen","1570440344701","KP","UPPER DIR (AT DIR)"),
("2428","Raees Khan","Muhammad Ramzan","3710163280653","Punjab","ATTOCK"),
("2429","Rafaqat Ali ","Ghulam Ali ","3320396548651","Punjab","JHANG"),
("2430","Rafeeq Jan","Saz Mir","1710232013827","KP","CHARSADDA"),
("2431","Rafi ullah","Said ullah","1530799633855","KP","LOWER DIR (AT TEMERGARA)"),
("2432","Rafi Ullah","Muhammad Raziq","1570135812881","KP","UPPER DIR (AT DIR)"),
("2433","Rafi Ullah","Habib ur Rehman","1550549283001","KP","SHANGLA (AT ALPURI)"),
("2434","Rafi Ullah","Hamid Ullah","4200004091683","KP","MALAKAND P.A."),
("2435","Rafiullah","Saleem @ Rabbani","1560603550541","KP","SWAT (AT MINGORA)"),
("2436","Rafiullah ","Khalil ur Rehman","1550546318275","KP","SHANGLA (AT ALPURI)"),
("2437","Raghib Hussain","Mian Ghullam Shabbir","3320313669495","Punjab","Jhang"),
("2438","Raham Ali ","Phairan Khan","3240453115377","Punjab","RAJANPUR"),
("2439","Raham Ghani","Abdul Ghani","1570141125343","KP","UPPER DIR (AT DIR)"),
("2440","Rahamd Ullah","Rizwan Ullah","1510112828857","KP","BUNER"),
("2441","Rahamdullah","Rizwan Ullah","1510112828851","KP","SWAT (AT MINGORA)"),
("2442","Rahat Ullah","Hayat Ullah","1570104454517","KP","UPPER DIR (AT DIR)"),
("2443","Raheem Javed","Javed lqbal","3420182270339","Punjab","GUJRAT"),
("2444","Rahim Bakhsh","Naik Muhammad","1510173020549","KP","BUNER"),
("2445","Rahim Gul","Khusamand Khan","1560202448247","KP","SWAT (AT MINGORA)"),
("2446","Rahim Jaffari ","Ahmed Ali","5440003952627","Balochistan","QUETTA"),
("2447","Rahim Khan","Razi Mand Khan","1530799288963","KP","LOWER DIR (AT TEMERGARA)"),
("2448","Rahim Said","Ghulam Said","4220104606489","KP","LOWER DIR (AT TEMERGARA)"),
("2449","Rahim Ullah s/o","Sahib Jan","1560257795981","KP","Swat"),
("2450","Rahman Hakim","Sultanat .","1570181660301","KP","UPPER DIR (AT DIR)"),
("2451","Rahmat Ali s/o","Akbar Ali","1560298181407","KP","SWAT (AT MINGORA)"),
("2452","Rai Nadeem Abbas ","Arshad Muhammad ","3330297591905","Punjab","TOBA TEK SINGH"),
("2453","Raj Wali","Shakir","1730115543091","KP","PESHAWAR"),
("2454","Raja Habib Ur Rehman ","Raja Muhammad Akram ","3710489573121","Punjab","ATTOCK"),
("2455","Raja Hamid Nawaz","Rab Nawaz","3840194239133","Punjab","SARGODHA"),
("2456","Raja Khawar ","Walayat Khan","3420204567807","Punjab","Gujrat"),
("2457","Raja Muhammad Nazuk","Kala Khan","6110154782069","ICT","ISLAMABAD\n\n"),
("2458","Raja Nasir  ","Shah Sultan","7150116332281","Gilgit-Baltistan","GILGIT"),
("2459","Raja Shahzad Mehmood ","Raja Khushhal Khan ","3730357323935","Punjab","MANDI BAHAUDDIN"),
("2460","Raja Tahir Abbas ","Raja Muhammad Khan ","3740505466131","Punjab","RAWALPINDI"),
("2461","Raja Waqas Khalid","Khalid Mehmood","3840603404233","Punjab","SARGODHA"),
("2462","Rajab Ali","Lal Hussain","3810105698199","Punjab","BHAKKAR"),
("2463","Ramzan Farooqi ","Syed Mohammad Naseem.","5430379899223","Balochistan","PISHIN"),
("2464","Ramzan Khan ","Zangi Khan Rind","4330466651793","Sindh"," Sanghar "),
("2465","Rana Abdur Rehman alias Khushi ","Rana Farzand Ali ","3130154828875","Punjab","RAHIM YAR KHAN"),
("2466","Rana Allah Yar","Muhammad Bakhsh","3620224795333","Punjab","LODHRAN"),
("2467","Rana Amjad Ali ","Muhammad Afzal ","3810236536235","Punjab","BHAKKAR"),
("2468","Rana Fakhar-ul-Islam Hamza  ","Rana Muhammad Yousaf","3320370678363","Punjab","JHANG"),
("2469","Rana Muhammad Akram ","Rasheed Ahmad ","3810209019197","Punjab","BHAKKAR"),
("2470","Rana Muhammad Asghar","Ali Muhammad ","3310006161097","Punjab","Faisalabad"),
("2471","Rana Muhammad Khalil alias Nanha ","Muhammad Khan ","3520246891245","Punjab","LAHORE"),
("2472","Rana Muhammad Mubeen alias Danial ","Muhammad Sana Ullah @ Mahar Caste Rajput","3230104834137","Punjab","MUZAFFARGARH"),
("2473","Rana Naeem Abbas","Ghanzfar Ali","3330351412725","Punjab","TOBA TEK SINGH"),
("2474","Rana Tufail","Abdul Shakoor","3810127835229","Punjab","BHAKKAR"),
("2475","Rana Umar Farooq alias Umar Jhangbi ","Rana Habib Ullah ","3640136096903","Punjab","PAKPATTAN"),
("2476","Rao Habib ur Rehman","Abdul Qayum","3660151767603","Punjab","Vehari"),
("2477","Rao Karamat Ali ","Rao Liaqat Ali","3130290742031","Punjab","RAHIM YAR KHAN"),
("2478","Rao Muhammad Javed Iqbal ","Rao Muhammad Iqbal","3120393388081","Punjab","BAHAWALPUR"),
("2479","Rao Nadeem-ur-Rehman","Rao Aziz-ur-Rehman","3660130365265","Punjab","Vehari"),
("2480","Rasheed Abbass","Muhammad Khan","3840145671369","Punjab","SARGODHA"),
("2481","Rasheed Ahmad","Abdul Aziz","3110585689199","Punjab","BAHAWALNAGAR"),
("2482","Rasheed Ahmad ","Ghulam Hussain ","3120378844111","Punjab","BAHAWALPUR"),
("2483","Rasheed Ahmad ","Jumma Khan ","3210330321849","Punjab","GUJRANWALA"),
("2484","Rasheed Ahmad Soomro ","Haji Ahmad Soomro ","3130422511179","Punjab","RAHIM YAR KHAN"),
("2485","Rasheed Ahmed Alias Abdul Rasheed @Maovia @Ghalib","Muhammad Adrees (CNIC Father)","3620293340885","Punjab","LODHRAN"),
("2486","Rashid","Shatamas","1530515707775","KP","LOWER DIR (AT TEMERGARA)"),
("2487","Rashid Ahmad","Rasool Ahmad","1530210004607","KP","LOWER DIR (AT TEMERGARA)"),
("2488","Rashid Javed ","Javed Iqbal","3640250048463","Punjab","PAKPATTAN"),
("2489","Rashid khan","Sultani Room","1530770996653","KP","LOWER DIR (AT TEMERGARA)"),
("2490","Rashid Mehmood Farooqi","Mian Muhammad","3710115917505","Punjab","Attock    "),
("2491","Rasool Bakhsh ","Muhammad Noor","5440172248025","Balochistan","QUETTA"),
("2492","Raz Muhammad ","Syed Muhammad","1111111111125","KP","PESHAWAR"),
("2493","Raza Khan","Abdul Khaliq","1730115706367","KP","PESHAWAR"),
("2494","Razzaq "," Muhammad Musa","7150110011149","Gilgit-Baltistan","GILGIT"),
("2495","Reema","Tariq","1111111111123","KP","PESHAWAR"),
("2496","Rehan Iqbal","Mohammad Iqbal ","5440091003235","Balochistan","QUETTA"),
("2497","Rehan Mehmood Zia ","Zia Ul Rehman ","3310503571377","Punjab","FAISALABAD"),
("2498","Rehan Waseem ","Sibqhat Ullah ","3320226990159","Punjab","JHANG"),
("2499","Rehman Gul","Noor Ahmad Shah","1620228270331","KP","SWABI"),
("2500","Rehman Shah","Faqeer","1560153165223","KP","SWAT (AT MINGORA)"),
("2501","Rehman ud Din","Noor Muhammad Din","1530209002855","KP","LOWER DIR (AT TEMERGARA)"),
("2502","Rehman ullah","Ghulam Qadar","1530757432097","KP","LOWER DIR (AT TEMERGARA)"),
("2503","Rehman Ullah ","Malak Jan","2120120135199","KP","KHYBER (AT PESHAWAR)"),
("2504","Rehmat Din","Nizam-ud-Din","1520208109033","KP","CHITRAL"),
("2505","Rehmat Ullah ","Metho Khan ","3520050897483","Punjab","LAHORE"),
("2506","Rehmatullah","Ghulam Rasool Rakshani.","5140221972915","Balochistan","KHUZDAR"),
("2507","Riaz","Shams","1530208493273","KP","LOWER DIR (AT TEMERGARA)"),
("2508","Riaz","Gulambar Khan","1560220796305","KP","SWAT (AT MINGORA)"),
("2509","Riaz Ahmad ","Allah Bakhsh ","3210209479895","Punjab","FAISALABAD"),
("2510","Riaz Ahmad","Bashir Ahmad","3650252340279","Punjab","VEHARI"),
("2511","Riaz Ahmad","Muhammad Aslam","3620298756881","Punjab","LODHRAN"),
("2512","Riaz Ahmad ","Ashiq Hussain ","3310021723125","Punjab","FAISALABAD"),
("2513","Riaz Ali","Ali Sher","3610476453251","Punjab","KHANEWAL"),
("2514","Riaz Ali Chandio","Rasool Bux Chandio ","4250145802529","Sindh","KARACHI EAST"),
("2515","Riaz Hussain ","Allah Ditta ","3230435819421","Punjab","MUZAFFARGARH"),
("2516","Riaz Hussain ","Muhammad Nawaz ","1220168572741","Punjab","BHAKKAR"),
("2517","Riaz Hussain alias Saeed Hussain","Haq Nawaz","3220286796525","Punjab","LAYYAH"),
("2518","Riaz Khan","Ayub","1720136669179","KP","NOWSHERA"),
("2519","Riaz Shahid ","Ghuolam Jillani ","3640108810443","Punjab","PAKPATTAN"),
("2520","Riaz-ul-Haq Haidri","Muhammad Ramzan","3660209151929","Punjab","Vehari"),
("2521","Rifaqatullah","Muhammad Suleman Jarwar ","4110442059149","Sindh","BADIN"),
("2522","Rizwan","Abdul Razzaq ","4210179736049","Sindh","Karachi"),
("2523","Rizwan Ahmed @ Jimmy","Rasheed ","NIL","Sindh","Karachi"),
("2524","Rizwan Akbar","Muhammad Akbar","3420103573139","Punjab","Gujrat"),
("2525","Rizwan Akbar ","Muhammad Akbar","3420103573131","Punjab","GUJRAT"),
("2526","Rizwan Haider ","Taqi Hussain ","3320213709795","Punjab","JHANG"),
("2527","Rizwan Haider ","Iqbal Hussain Gohar ","3330339993907","Punjab","TOBA TEK SINGH"),
("2528","Rizwan Haider ","Muhammad Nawaz","3340103609195","Punjab","CHINIOT"),
("2529","Rizwan Iqbal","Muhammad Iqbal","3810261069009","Punjab","BHAKKAR"),
("2530","Rizwan Shah","Noorwas Sha","1620210205793","KP","SWABI"),
("2531","Rizwan ullah","Abdul Wahab","1530780978741","KP","LOWER DIR (AT TEMERGARA)"),
("2532","Rizwan ullah","Sofi Muahmmad","1530585476359","KP","LOWER DIR (AT TEMERGARA)"),
("2533","Rizwan Ullah","Taj Mer","1550544537391","KP","SHANGLA (AT ALPURI)"),
("2534","Rooh ul Wahab Alias Rooh Ullah","Said Rasool","1620167244435","KP","SWABI"),
("2535","S. Kashif  Hussain Rizvi ","S.Salman Bahadur Rizvi","4210116488299","Sindh","Karachi"),
("2536","Saad Abdur Rehman Jagranvi","Habib ur Rehman Jagranvi","3520206393769","Punjab","LAHORE"),
("2537","Sabir",". Kashar Khan","1570113364881","KP","UPPER DIR (AT DIR)"),
("2538","Sabir Gul","Ghareeb Gul","6110113309311","KP","KOHAT"),
("2539","sabir hussain ","Noor Muhammad","3540311008321","Punjab","Nankana Sahib"),
("2540","Sabir Hussain Alvi ","Barkat Ali ","3410116815721","Punjab","GUJRANWALA"),
("2541","Sabir Jamshaid ","Mushtaq Ahmad ","3310007768889","Punjab","FAISALABAD"),
("2542","Sabir Rahman","Abdul Rehman","1530119427053","KP","LOWER DIR (AT TEMERGARA)"),
("2543","Sabir Raza ","Zafar Au","3660125602495","Punjab","VEHARI"),
("2544","Sadaf Ali Khan","Nasir Ali Khan","3320385891081","Punjab","JHANG"),
("2545","Sadar Ahmad","Gul Mast","1570474795779","KP","UPPER DIR (AT DIR)"),
("2546","Saddam Ahmed "," Gul Baz.","7150198126527","Gilgit-Baltistan","GILGIT"),
("2547","Saddam Hussain","Bakht Biland","1530579241269","KP","LOWER DIR (AT TEMERGARA)"),
("2548","Saddam Hussain","Noor Zada","1710303784691","KP","CHARSADDA"),
("2549","Saddar Hayat @ Abu Sofyan","Wakeel Khan","2220123854619","KP","BANNU"),
("2550","Sadiq Azeem ","Qaseemuddin","","Sindh","Karachi"),
("2551","Sadique-u-Rehman ","Muhammad Bakhsh ","3210208759717","Punjab","DERA GHAZI KHAN"),
("2552","Saeed","Mohammad Kareem","1570119654189","KP","UPPER DIR (AT DIR)"),
("2553","Saeed Ahmad","Abdul Ghani","3540143823989","Punjab","Sheikhupura"),
("2554","Saeed Ahmad ","Ameer Muhammad ","3210399321467","Punjab","DERA GHAZI KHAN"),
("2555","Saeed Akhtar ","Munir Akhtar","3410356804879","Punjab","GUJRANWALA"),
("2556","Saeed Ullah ","Muhammad Nawaz","1220197975257","Punjab","BHAKKAR"),
("2557","Saeed Ullah","Amir Khan","1620274555669","KP","SWABI"),
("2558","Saeed Ur Rehman","Nawab Khan","3710465879401","Punjab","ATTOCK"),
("2559","Saeed-ur-Rehman","Habib Ur Rehman","8220339201911","AJ&K","Haryala Danna Kacheli Muzaffarabad"),
("2560","Safdar Ali ","Muhammad Ilyas ","3810256867375","Punjab","BHAKKAR"),
("2561","Safdar Ali","Sultan Ali ","5440004380837","Punjab","FAISALABAD"),
("2562","Safdar Mehmood","Mian Muhammad ","4220104427257","Punjab","SARGODHA"),
("2563","Safeer Hussain ","Muhammad Ali ","3310525767523","Punjab","FAISALABAD"),
("2564","Safi Ud Din","Haq Nawaz","6110198221913","Punjab","ATTOCK"),
("2565","Sagheer Hussain ","Muhammad Hussain","9040601546103","Punjab","GUJRAT"),
("2566","Saghir Ahmad","Safeer Ahmed","6110126779977","KP","KOHAT"),
("2567","Sahib Gul","Mian Gul","1530751940941","KP","LOWER DIR (AT TEMERGARA)"),
("2568","Sahib Khan","Haji Ameenullah Caste Barrach","5450120943947","Balochistan","NUSHKI"),
("2569","Sahib Ullah ","Saro Zarin","4240199695019","KP","BATAGRAM (AT BANA)"),
("2570","Sahib Zada","Muhammad Umar","1570199375663","KP","UPPER DIR (AT DIR)"),
("2571","Sahib Zada (Alias) Batangary","Muhammad","1530209128167","KP","LOWER DIR (AT TEMERGARA)"),
("2572","Sahib Zada @ Sheena","Amir Muhammad","1560277948585","KP","SWAT (AT MINGORA)"),
("2573","Sahib-ur-Rehman ","o Abdul Rehman","4210180358277","Sindh","Karachi"),
("2574","Saib shah","Rasool Said","1530513225251","KP","LOWER DIR (AT TEMERGARA)"),
("2575","Said Ahmad","Muhammad Yar","3840172727149","Punjab","SARGODHA"),
("2576","Said Ahmad Shah","Said Laiq Shah","1510105920629","KP","BUNER"),
("2577","Said Amil Shah","Said Mahboob Shah","1550454849569","KP","SHANGLA (AT ALPURI)"),
("2578","Said Amin","Said Haroon","1530208516967","KP","LOWER DIR (AT TEMERGARA)"),
("2579","Said Awal Shah","Said Qabil Shah","1550428564779","KP","SHANGLA (AT ALPURI)"),
("2580","Said Bacha","Jalat","1530729659505","KP","LOWER DIR (AT TEMERGARA)"),
("2581","Said Bayan Shah","Muhammad Tahir Shah","1550564959223","KP","Shangla"),
("2582","Said Bayan Shah","Qabil Shah","1550567959223","KP","SHANGLA (AT ALPURI)"),
("2583","Said Ghani","Said Ali","1510154790233","KP","BUNER"),
("2584","Said Hayat Shah","Said Raghib Shah Shah","1550502126531","KP","SHANGLA (AT ALPURI)"),
("2585","Said Ishfaq Ali Shah","Said Rasool Shah","1720105101071","KP","NOWSHERA"),
("2586","Said Karim","Abdur Rahim","1510108414789","KP","BUNER"),
("2587","Said Khan","Mohd: Akbar","1570247575031","KP","UPPER DIR (AT DIR)"),
("2588","Said Muhammad","Umar Muhammad","1530575015103","KP","LOWER DIR (AT TEMERGARA)"),
("2589","Said Muhammad .","Gul","1570185526887","KP","UPPER DIR (AT DIR)"),
("2590","Said Nadeem Shah","Said Bakht Naeem Shah","1540260050637","KP","MALAKAND P.A."),
("2591","Said Qavi Shah","Said Ghazi","3520212840309","KP","SHANGLA (AT ALPURI)"),
("2592","Said Ullah","Sher Mohammad","1570184033539","KP","UPPER DIR (AT DIR)"),
("2593","Said Zaman","Shams ur Rahman","1530560958803","KP","LOWER DIR (AT TEMERGARA)"),
("2594","Said Zubair Shah","Said Qabil Shah","1550463499715","KP","SHANGLA (AT ALPURI)"),
("2595","Saif Ullah Khalid ","Abdul Hameed ","3120103648911","Punjab","BAHAWALPUR"),
("2596","Saif ur Rehan ","Ghulam Mustafa ","4210181033229","Sindh","Karachi"),
("2597","Saif ur Rehman","Abdur Rehman","1310168133853","KP","ABBOTTABAD"),
("2598","Saif ur Rehman","Abdur Razzaq","1210109696187","KP","DERA ISMAIL KHAN"),
("2599","SAIF UR REHMAN ","MUHAMMAD RAMZAN","3640227061739","Punjab","Pakpattan"),
("2600","Saif ur Rehman ","Ghulam Rasool ","3120340044351","Punjab","BAHAWALPUR"),
("2601","Saif-Ul-Islam","Muhammad Bux","3240271753071","Punjab","RAJANPUR"),
("2602","Saif-ur-Rehman ","Haji Allah Dewaye ","3630109733611","Punjab","MULTAN"),
("2603","Saif-ur-Rehman ","Bahadar Khan ","3320280372813","Punjab","JHANG"),
("2604","Saifullah","Muhammad Hassan","4240184637399","Sindh","Karachi"),
("2605","Sajawal Khan","Faiz Muhammad","3810133031951","Punjab","BHAKKAR"),
("2606","Sajeel-ur-Rehman ","Ch. Abdul Rehman ","3630247770751","Punjab","MULTAN"),
("2607","Sajid ","Ghuffar Awan","8240163271087","AJ&K","Bhettik Baloch, Sudhnoti"),
("2608","Sajid","Abdul Ghafoor","1570158916481","KP","UPPER DIR (AT DIR)"),
("2609","Sajid Ali","Allah Yar","3320181620969","Punjab","CHINIOT"),
("2610","Sajid Hussain  ","Nazar Hussain","3820147597939","Punjab","KHUSHAB"),
("2611","Sajid Hussain","Muhammad Ayub","1330222007633","KP","ABBOTTABAD"),
("2612","Sajid Mehmood ","Muhammad Jamil ","3440324266557","Punjab","MANDI BAHAUDDIN"),
("2613","Sajid Mehmood","Mehmood Ahmed","3510262012995","Punjab","KASUR"),
("2614","Sajjad","Gulab","1530689185497","KP","LOWER DIR (AT TEMERGARA)"),
("2615","Sajjad Ahmad","Jabin","1510139873293","KP","BUNER"),
("2616","Sajjad Ahmed ","Muhammad Yar","3640255387821","Punjab","PAKPATTAN"),
("2617","Sajjad Ahmed alias Sufi ","Muhammad Sharif ","3420206850549","Punjab","GUJRAT"),
("2618","Sajjad Hussain ","Shah Muhammad ","3120289391433","Punjab","BAHAWALPUR"),
("2619","Sajjad Hussain ","Rahim Bakhsh ","3120373987757","Punjab","BAHAWALPUR"),
("2620","Sajjad Hussain alias Sajju ","Muhammad Nawaz ","3230417441351","Punjab","MUZAFFARGARH"),
("2621","Sajjad Khan","Hayat Noor","2120188095235","KP","KURRAM (AT PARACHINAR)"),
("2622","Sakhi","Lal Jan","1570122659553","KP","HARIPUR"),
("2623","Saleem","Aman Khan","1570470908673","KP","UPPER DIR (AT DIR)"),
("2624","Saleem Ahmed ","Feroz Ahmed","4220190929621","Sindh","Karachi"),
("2625","Saleem Akhtar","Suleman","3320360450997","Punjab","Jhang"),
("2626","Saleem Ilyas ","Muhammad Ilyas","1310181860779","Sindh","Karachi"),
("2627","Saleem Khan","Umar Muhammad","1540176176157","KP","MALAKAND P.A."),
("2628","Saleem Ullah ","Abdul Salam  Rakhshani ","5130191574263","Balochistan","KHARAN"),
("2629","Saleemullah Khan ","Mirdad Khan ","4220175641963","Sindh","Karachi"),
("2630","Saleh Hayat","Perveez","1610126401411","KP","MARDAN"),
("2631","Saleh Muhammad","Abdul Qadir","1530119451045","KP","LOWER DIR (AT TEMERGARA)"),
("2632","Salim Ullah","Abdullah","1530249246233","KP","LOWER DIR (AT TEMERGARA)"),
("2633","Salman Ahmad ","Muhammad Sharif ","3630245223725","Punjab","MULTAN"),
("2634","Samad Siddique ","Shakeel Siddqiue","NIL","Sindh","Karachi"),
("2635","Sami uddin @ Pupo ","Qaiymuddin","4230196049641","Sindh","Karachi"),
("2636","Sami Ullah","Bazir Khan","1530651095573","KP","LOWER DIR (AT TEMERGARA)"),
("2637","Sami Ullah","Muhammad Riaz Khan","1530550370633","KP","LOWER DIR (AT TEMERGARA)"),
("2638","Sami Ullah","Muhammad Ullah @ Saad Ullah","1730135059893","KP","PESHAWAR"),
("2639","Sami Ullah","Abdul Ghafoor","3610371949191","Punjab","Khanewal"),
("2640","Sami Ullah @ Sami Pashteen","Nawal Khan","2170286105081","KP","DERA ISMAIL KHAN"),
("2641","Sami-ur-Rehman","Said ur Rahman","1710109181355","KP","Charsada"),
("2642","Samiullah","Aurangzaib ","5440172482085","Balochistan","QUETTA"),
("2643","Sammar Abbas ","Haq Nawaz","3220243936385","Punjab","LAYYAH"),
("2644","Sammar Abbas Shah alias Shah G ","Mureed Kazim Shah ","3810408731191","Punjab","BHAKKAR"),
("2645","Samra Jabeen","Muhammad Mehboob","9040301403286","AJ&K","KOTLI"),
("2646","Sana ullah ","Muhammad Zareef","5440134907123","Balochistan","QUETTA"),
("2647","Sana Ullah","GHULAM RASOOL ","3220362100533","Punjab","LAYYAH"),
("2648","Sanaullah","Shahi Room","1560258860721","KP","SWAT (AT MINGORA)"),
("2649","Saqlain Abu Bakar Saddiqi ","Saddique Ahmed Saddiqi ","3320404343037","Punjab","JHANG"),
("2650","Saqlian Abbas","Muhammad Shafique ","3310444100453","Punjab","FAISALABAD"),
("2651","Sar Zamin Khan","Syed Quresh","1510150930811","KP","BUNER"),
("2652","Sardar Ahmad","Gul Ahmad","1570144795779","KP","UPPER DIR (AT DIR)"),
("2653","SARDAR AHMAD","GHULAM HAIDER","3640207542613","Punjab","PAKPATTAN"),
("2654","Sardar Ahmed @ Abu Mashab ","Ashiq Hussain Arain","NIL","Sindh",""),
("2655","Sardar Hussain","Iqbal Hussain","1560239606921","KP","SWAT (AT MINGORA)"),
("2656","Sardar Iqbal","Muhib ullah","1510103248865","KP","BUNER"),
("2657","Sardar Khan","Ishaq","1430179984529","KP","KOHAT"),
("2658","Sardar Munir Hussain Khan Dreshak ","Fazal Hussain Khan Dreshak ","3240316205891","Punjab","RAJANPUR"),
("2659","Sardar ud Din","Nizam ud Din","1530753862257","KP","LOWER DIR (AT TEMERGARA)"),
("2660","Sarfraz","Muhammad Raza","5440091541489","Balochistan","QUETTA"),
("2661","Sarfraz Khan ","Ghulam Ali Khan ","3520251029355","Punjab","RAJANPUR"),
("2662","Sarfraz Shamoon Khan","Muhammad Shamoon Khan","3520014771073","Punjab","LAHORE"),
("2663","Sarmast Khan Alias Haji","Purdil","1620125713139","KP","SWABI"),
("2664","Sarwat Ijaz Qadri President Pakistan Sunni Tehreek","","NIL","Sindh","Karachi"),
("2665","Sayed Khawar Hussain","Sayed Nazar Hussain Shah","3320281013327","Punjab","Jhang"),
("2666","Sayed Mohsin Raza Ali shah","Sayed Dubeer Hussain shah","3320218426975","Punjab","Jhang"),
("2667","Sayed Qaisar Abbas Shah","Mazhar Hussain Hussain","3320209375865","Punjab","Jhang"),
("2668","Sayed Zain ul Abdin Shah","Sayed Zulifqar Ali Shah","3320295626403","Punjab","Jhang"),
("2669","Saz Mohammad","Qalandar","1570151116369","KP","UPPER DIR (AT DIR)"),
("2670","Serajullah @ Zeshan ","Gulzaer Syed ","4240117147061","Sindh","Karachi"),
("2671","Serajullah @ zeshan ","Gulzer Syed","4240117147061","Sindh","Karachi"),
("2672","Shabbir Afzal ","Din Muhammad","3330375499571","Punjab","TOBA TEK SINGH"),
("2673","Shabbir Ahmad ","Jamal Din ","3130350519417","Punjab","RAHIM YAR KHAN"),
("2674","Shabbir Hussain ","Talib Hussain  ","3410176573231","Punjab","GUJRANWALA"),
("2675","Shabbir Hussain ","Ghulam Muhammad","4250132767623","Gilgit-Baltistan","KHARMANG"),
("2676","Shabeer Ahmad","Muhammad Shoaib","1530781144709","KP","LOWER DIR (AT TEMERGARA)"),
("2677","Shabir","Jamshid","1610105770315","KP","MARDAN"),
("2678","Shabir Husain Shah ","Manzoor Husain Shah ","3310051248683","Punjab","FAISALABAD"),
("2679","Shafaqat Ali ","Muhammad Arshad ","3310021330983","Punjab","FAISALABAD"),
("2680","Shafi Ullah","Abdul Malik","1530487641015","KP","LOWER DIR (AT TEMERGARA)"),
("2681","Shafi Ullah","Muhammad Hayat","1530233180909","KP","LOWER DIR (AT TEMERGARA)"),
("2682","Shafi Ullah alias Shafo Shah ","Pehlwan Khan ","3210372307451","Punjab","DERA GHAZI KHAN"),
("2683","Shafi ur Rehman @ Shafi","Patang","1110102960141","KP","Bannu"),
("2684","Shafiq","Mir Zafar","1510131747359","KP","BUNER"),
("2685","Shafiq Ahmad Khan ","Misri Khan ","3610496434845","Punjab","KHANEWAL"),
("2686","Shafiq Ur Rehman ","Nawab Deen ","3320172793763","Punjab","CHINIOT"),
("2687","Shafiq(Shafi Mauvia)  ","M. Latif","8230386910217","AJ&K","Jandali, District Poonch"),
("2688","Shafiq-ur-Rehman","Muhammad Sarwar","6110158395265","ICT","ISLAMABAD\n\n"),
("2689","Shafiq-ur-Rehman ","Fateh Muhammad","3460169024913","Punjab","SIALKOT"),
("2690","Shafique Ur Rehman","Muhammad Ismail","3610201519125","Punjab","Khanewal"),
("2691","Shafique-ur-Rehman ","Bahadur Sher","4240137590021","Sindh","Karachi"),
("2692","Shafqat Abbas"," Riaz Hussian","3660352286499","Punjab","Vehari"),
("2693","Shafqat Hussain","Muhammad Yar","3840103738839","Punjab","SARGODHA"),
("2694","Shafqat Ullah","Awal Khan","1120104120273","KP","LAKKI MARWAT"),
("2695","Shah Akbar Khan","Mir Jaffar","4250113704981","KP","Swabi"),
("2696","Shah Alam","Noor Alam ","4220196919445","KP","S.WAZIRISTAN (AT WANA)"),
("2697","Shah Fahad","Kishwar","1620297061453","KP","SWABI"),
("2698","Shah Faisal @ Ganderi ","Abdul Raheem","4210197790347","Sindh","Karachi"),
("2699","Shah Faisal Ghazi","Mehmood Sultan","2170566866147","KP","DERA ISMAIL KHAN"),
("2700","Shah Hakeem","Zakir Khan","1540261517423","KP","MALAKAND P.A."),
("2701","Shah Hussain","Shah Sawar","1720119715335","KP","NOWSHERA"),
("2702","Shah Jehan","Shereen","1620107286609","KP","SWABI"),
("2703","Shah Karam","Sher Zaman","1530208817829","KP","LOWER DIR (AT TEMERGARA)"),
("2704","Shah Khalid","Subhani  Gul","1530633797267","KP","LOWER DIR (AT TEMERGARA)"),
("2705","Shah Khalid","Palas","1510132437031","KP","BUNER"),
("2706","Shah Meer alias Shahzad ","Jannat Khan ","3420183126613","Punjab","GUJRAT"),
("2707","Shah Muhammad","Gul Muhammad","1111111111111","KP","MALAKAND P.A."),
("2708","Shah Muhammad caste Khiazai bugti","Abdul Rehman","3240368107749","Punjab","RAJANPUR"),
("2709","Shah Saood","Yar Gul","","KP","Dir Lower"),
("2710","Shah Saood","Fateh Gul","1530578848769","KP","LOWER DIR (AT TEMERGARA)"),
("2711","Shah Sawar","Muhammad Ali","3640235683489","Punjab","PAKPATTAN"),
("2712","Shah Wazir","Mian Gul Khan","1530553999345","KP","LOWER DIR (AT TEMERGARA)"),
("2713","Shah Zamin","Sher Alam","1570111944517","KP","UPPER DIR (AT DIR)"),
("2714","Shah Zeb","Nasrai","1530790778619","KP","LOWER DIR (AT TEMERGARA)"),
("2715","Shahab-ud-Din","Muhammad Shah","1520157373571","KP","CHITRAL"),
("2716","SHAHAB-UD-DIN","MOBEEN ALI","3630218674695","Punjab","Multan"),
("2717","Shahbaz Ahmad ","Fajru Khan ","3520195567177","Punjab","LAHORE"),
("2718","Shahbaz Ali","Rafiq Ahmed Jokhio","4530447698721","Sindh","N-Feroze"),
("2719","Shahbaz Ali ","Mushtaq Ahmed ","3120103368739","Punjab","BAHAWALPUR"),
("2720","Shahbaz Khaliq ","Abdul Khaliq ","3330337405817","Punjab","TOBA TEK SINGH"),
("2721","Shaheen Ahmed Talbani ","Shafiq Iqbal","8240124623183","AJ&K","Danna Papa Nar, Sudhnoti"),
("2722","Shaheer Hassan alias Mustaqeem","Bashir Ahmed","3220221738455","Punjab","LAYYAH"),
("2723","Shahen Shah","Tota","1560224918157","KP","SWAT (AT MINGORA)"),
("2724","Shahid","Shams ul Haq","1720170674137","KP","NOWSHERA"),
("2725","Shahid @ Karela","Abdur Raheem","1210177939617","KP","DERA ISMAIL KHAN"),
("2726","Shahid Ali Haidri @ Muhammad Ramzan ","Muhammad Suleman Butt","41201195932095","Sindh","Dadu"),
("2727","Shahid Ali Khan ","Shah Zaman","1560138978621","KP","SWAT (AT MINGORA)"),
("2728","Shahid Bibkik ","Khair Muhammad","4210135880469","Sindh","Karachi"),
("2729","Shahid Hussain ","Mayoon Shah","7150129682969","Gilgit-Baltistan","GILGIT"),
("2730","Shahid Hussain ","Mulazim Hussain ","3120485422041","Punjab","BAHAWALPUR"),
("2731","Shahid Hussain ","Nazar Hussain","3630203404239","Punjab","MULTAN"),
("2732","Shahid Imran alias Ramzan Shahdi ","Muhammad Sharif ","3330178347857","Punjab","TOBA TEK SINGH"),
("2733","Shahid Iqbal ","Allah Ditta ","3740698007765","Punjab","MUZAFFARGARH"),
("2734","Shahid Irfan","Nayamat Ali ","3520229749001","Punjab","LAHORE"),
("2735","Shahid Khan","Abdul Azeem","1530774335517","KP","LOWER DIR (AT TEMERGARA)"),
("2736","Shahid Khan @ Khalifa Muhammad ","Saib Khan","2170467394459","Sindh","Karachi"),
("2737","Shahid Khan Shirani","Ibrahim Shirani","1210179898793","KP","DERA ISMAIL KHAN"),
("2738","Shahid Mahmood","Muhammad Aslam","3310008176211","Punjab","FAISALABAD"),
("2739","Shahid Mehmood","Khalid Iqbal ","3130395390483","Punjab","RAHIM YAR KHAN"),
("2740","Shahid Munir ","Muhammad Younas ","3520116940403","Punjab","LAHORE"),
("2741","Shahid Raza ","Ziaullah","4420327785751","Sindh","SANGHAR"),
("2742","Shahid Zarin","Khan Zarin","1530501300727","KP","LOWER DIR (AT TEMERGARA)"),
("2743","Shahnoor Rehman ","Asal Jan","2170657146759","KP","S.WAZIRISTAN (AT WANA)"),
("2744","Shahzad "," Baba Jan.","7150141341369","Gilgit-Baltistan","GILGIT"),
("2745","SHAHZAD AHMAD","MUHAMMAD ASLAM","3420104235505","Punjab","Gujrat"),
("2746","SHAHZAD AKRAM","MUHAMMAD AKRAM","3420275585861","Punjab","Gujrat"),
("2747","Shahzad Shafique ","Muhammad Shafique","3520230251397","Punjab","LAHORE"),
("2748","Shahzada Ghulam Hussain","Inayat Hussain","3520201358705","Punjab","LAHORE"),
("2749","Shaikh Izhar @ Imran ","Shaikh Ansar Ahmed","4240119988075","Sindh","Karachi"),
("2750","Shaikh Muhammad Adeel","Abdul Shakoor","0000000000004","Sindh","KARACHI SOUTH"),
("2751","Shair Muhammad (Caste Rajpoot Bhatti)","Noor Hassan","3620110008829","Punjab","LODHRAN"),
("2752","Shakeel","Gul Mohammad","1610163687437","KP","UPPER DIR (AT DIR)"),
("2753","Shakeel","Faqir Hussain","1730146224531","KP","PESHAWAR"),
("2754","Shakeel","Janat Khan","6110163560317","KP","KOHAT"),
("2755","Shakeel Afridi","as","1111111111136","KP","PESHAWAR"),
("2756","Shakeel Ahmad ","Abdul Jabbar","3530136948373","Punjab","OKARA"),
("2757","Shakeel Ahmad Rashid ","Huji Muhammad Sharif","3660116095911","Punjab","VEHARI"),
("2758","Shakeel Ahmed","Muhammad Aslam","3740681977161","Punjab","RAWALPINDI"),
("2759","Shakeel Ahmed ","Abdul Hameed.","7150190255983","Gilgit-Baltistan","GILGIT"),
("2760","Shakeel Ahmed ","Shabir Ahmed Ghangro ","4530243635019","Sindh","NAUSHAHRO FEROZE"),
("2761","Shakeel Ahmed @ Hanzala ","Imam Bux","4240123841233","Sindh","Karachi"),
("2762","Shakeel Ahmed Alias Ali","Abid Hussain","3320169843199","Punjab","CHINIOT"),
("2763","Shakeel Haider","Zawar Hussain","3810235456245","Punjab","Bhakkar   "),
("2764","Shakeel Shahzad ","Muhammad Sharif","3420103444669","Punjab","GUJRAT"),
("2765","Shakir","Habib Khan","1570109558327","KP","UPPER DIR (AT DIR)"),
("2766","Shakir","Mohammad Rahim","3520227550973","KP","UPPER DIR (AT DIR)"),
("2767","Shakir Hussain","Muhammad Hussain","3220378907493","Punjab","LAYYAH"),
("2768","Shakir Hussain Naqvi","Nazar Husain Shah Naqvi","3710160565093","Punjab","Attock    "),
("2769","Shakir Hussain s","Muhammad Hussain","1620265032377","KP","SWABI"),
("2770","Shalyar","Muhammad Arif","1570142187285","KP","UPPER DIR (AT DIR)"),
("2771","Shamas Ul Haq ","Abdul Hameed ","3710557304823","Punjab","Attock    "),
("2772","Shams ul Hadi","Fazal Rabi @ Koka","1510196288183","KP","BUNER"),
("2773","Shams ul Nabi Moavia","Chashti Khan","1520214818923","KP","PESHAWAR"),
("2774","Shams ul Qamar","Ismail","1620209835511","KP","SWABI"),
("2775","Shams-ud-Din","Mohammad Usman Nothani.","5410122945281","Balochistan","Khuzdar"),
("2776","Shamshad Ahmad alias Abu Hanzala","Muhammad Sakhi","3810106165847","Punjab","BHAKKAR"),
("2777","Shamsher","Rahman Zarin","1570154586681","KP","UPPER DIR (AT DIR)"),
("2778","Shamsher","Faiz Ali","1570176838991","KP","UPPER DIR (AT DIR)"),
("2779","Shan Hussain ","Amjad Hussain ","3630234100255","Punjab","MULTAN"),
("2780","Shaukat Abbas ","Muhammad Afzal ","3320213382031","Punjab","JHANG"),
("2781","Shaukat Ali ","Kazim Ali","3320342479557","Punjab","JHANG"),
("2782","Shaukat Ali","Habib Ullah","1560218332633","KP","SWAT (AT MINGORA)"),
("2783","Shaukat Hussain","Sakhawat Hussain","3320285157663","Punjab","Jhang"),
("2784","Shedi Khan","Muhammad Shareef","3710421371565","Punjab","Attock    "),
("2785","Shehbaz Khan","Muhammad Arif","1570111684067","KP","UPPER DIR (AT DIR)"),
("2786","Shehriyar","Alamgir","1220127170239","KP","S.WAZIRISTAN (AT WANA)"),
("2787","Shehzad","Sher Dil Khan","1310163266011","KP","ABBOTTABAD"),
("2788","Shehzad Haider Danish ","Laal Khan ","3230347726953","Punjab","MUZAFFARGARH"),
("2789","Shehzad Hussain ","Miraj Din ","3310226563357","Punjab","FAISALABAD"),
("2790","Shehzada","Said Haleem","1530522234017","KP","LOWER DIR (AT TEMERGARA)"),
("2791","Sheikh Mirza Ali ","Mohsin Ali.","7150311820071","Gilgit-Baltistan","GILGIT"),
("2792","Sheikh Qaisar ","Hussain","4220140089625","Gilgit-Baltistan","GILGIT"),
("2793","Sheikh Sarwar Hussain ","Muhammad Deen","4240170662981","Sindh","Karachi"),
("2794","Sher Afzal","Qari @ Kakoray","1510146844485","KP","BUNER"),
("2795","Sher Afzal ","Rehman ","3740114570373","Punjab","MANDI BAHAUDDIN"),
("2796","Sher Afzal Khan","Abdul Majeed","1310128377385","KP","Abbottabad"),
("2797","Sher Alam","Siraj","1730141777157","KP","PESHAWAR"),
("2798","Sher Ali","Gul Zaman @ Sher Zaman","2110654122273","KP","LOWER DIR (AT TEMERGARA)"),
("2799","Sher Ali","Gul Sher","4220125018053","KP","BUNER"),
("2800","Sher Ali Khan ","Lateef Khan ","4240161566557","Sindh","Karachi"),
("2801","Sher Azim","Zarawar","1570111738409","KP","UPPER DIR (AT DIR)"),
("2802","Sher Gul","Ghani @ Essa","1510144592919","KP","BUNER"),
("2803","Sher Jan ","Khalid Jan ","7150175592917","Gilgit-Baltistan","GILGIT"),
("2804","Sher Muhammad","Muhammad Yousuf","1430177160505","KP","KOHAT"),
("2805","Sher Muhammad","Taj Muhammad","1530209454465","KP","LOWER DIR (AT TEMERGARA)"),
("2806","Sher Ullah","Khyber","1570174717787","KP","UPPER DIR (AT DIR)"),
("2807","Sher Zada","Shams ur Rahman","1570155482317","KP","UPPER DIR (AT DIR)"),
("2808","Shezan Rasheed ","M. Rasheed","8240138335533","AJ&K","Sudhnoti"),
("2809","Shiekh Bilal Sumairi "," Dayood.","4220175653929","Gilgit-Baltistan","NAGAR"),
("2810","Shifa Ullah","Allah Bakhsh","3610207831387","Punjab","BHAKKAR"),
("2811","Shoaib","Habib Ur Rehman","2110420690813","KP","BAJAUR (AT KHAR BAJAUR)"),
("2812","Shoaib ","Ibadat.","7150149549911","Gilgit-Baltistan","GILGIT"),
("2813","Shoaib ","Aqal Khan","1410203707447","KP","HANGU"),
("2814","Shoaib","Shamraiz, Caste Pathan","1310151908115","KP","ABBOTTABAD"),
("2815","Shoaib","Nazir","1730171737825","KP","LOWER DIR (AT TEMERGARA)"),
("2816","Shoaib","Gul Rehman","1560276759643","KP","SWAT (AT MINGORA)"),
("2817","Shoaib Dawood Sheikh ","Sheikh Ahmed Dawood ","3520257370559","Punjab","LAHORE"),
("2818","Shoaib Nadeem ","Abdul Ghafoor Nadeem","4210103361935","Sindh","Karachi"),
("2819","Shoukat Ali ","Syed Muhammad Shafi Shah ","3540375391147","Punjab","FAISALABAD"),
("2820","SHOUKAT HAYAT","SIRAJ GULL","1620159932941","Punjab","Okara"),
("2821","Shoukat Naz ","Murad Ali Sumalani.","5410157303397","Balochistan","CHAGAI (AT DALBANDIN)"),
("2822","Siddique Akbar @ Babu ","Muhammad Asghar Ali","4210118310725","Sindh","Karachi"),
("2823","Sifat Ullah","Umar Gul","1111111111115","KP","PESHAWAR"),
("2824","Sijjad Bajwa ","Muhammad Ismaeel","3430118002045","Punjab","HAFIZABAD"),
("2825","Sikandar Hayat (Caste Awan)","Muhammad Hayat","3840475600881","Punjab","SARGODHA"),
("2826","Sikander Raza ","Muhammad Raza","421015256349","Sindh","Karachi"),
("2827","Sikander Shah ","Mir Muhammad Shah","4130155987365","Sindh","Matiari"),
("2828","Sir Zamin","Majeed Khan","1570111861509","KP","UPPER DIR (AT DIR)"),
("2829","Siraj Ahmad","Mukhtar Ahmad","1620214324313","KP","SWABI"),
("2830","Siraj Uddin","Muhib Mohammad .","1570105812563","KP","UPPER DIR (AT DIR)"),
("2831","Siraj Ullah @ Qari Siraj","Gulzar Saeed ","NIL","Sindh","Karachi"),
("2832","Sohail","Azat Khan","1530606754415","KP","LOWER DIR (AT TEMERGARA)"),
("2833","Sohail Anjum ","Muhammad Yasin ","3440268253395","Punjab","MANDI BAHAUDDIN"),
("2834","Sohail Aslam alias Zakki ","Haq Nawaz ","3320244641633","Punjab","JHANG"),
("2835","Sohail Ijaz ","Ijaz Hussain ","3810138302127","Punjab","BHAKKAR"),
("2836","Sohail Imran ","Muhammad Shafi","3320246267483","Punjab","JHANG"),
("2837","Subhan Ullah","Abdul Hamid","1570196175309","KP","UPPER DIR (AT DIR)"),
("2838","Subhan Ullah","Yousaf Khan","","KP","Dir Lower"),
("2839","Subhan-e-Mulk","Dilawar Khan","1530572587017","KP","LOWER DIR (AT TEMERGARA)"),
("2840","Suleman","Jahanzeb","1720166178189","KP","NOWSHERA"),
("2841","Sultan @ Sultany","Mehmood","1530209228939","KP","LOWER DIR (AT TEMERGARA)"),
("2842","Sultan Ahmed Alias Bahoo","Noor Muhammad","3710503775065","Punjab","ATTOCK"),
("2843","Sultan Mehmood","Shaukat Ali","3320313831623","Punjab","Jhang"),
("2844","Sultan Mehmood Buneri @ Saifullah ","Syed Talib ","4210116892587","Sindh","Karachi"),
("2845","Sultan Mohammad","Rahman Gul","1570128335385","KP","Dir Upper"),
("2846","Sultan Rahman","Yousif","1570111654285","KP","UPPER DIR (AT DIR)"),
("2847","Sultan Wali","Ghulam Farooq","1520187900597","KP","CHITRAL"),
("2848","Sultan Zeb","Walab","1510182019287","KP","BUNER"),
("2849","Syed Abbas Ali","Syed Ibrahim Shah","5440005528697","Balochistan","QUETTA"),
("2850","Syed Abbas Hamdani Aka Abbas Mohsin","Syed Mohsin Raza","3410101290695","Punjab","GUJRANWALA"),
("2851","Syed Abbas Hussain ","Syed Bashir Hussain Shah ","3810255655789","Punjab","BHAKKAR"),
("2852","Syed Afzaal Hussain Shah ","Syed Sajjad Hussain Shah","3520228170497","Punjab","LAHORE"),
("2853","Syed Agha Imran Mohsan Naqvi","Syed Agha Zameer-ul-Hassan Naqvi ","3220225363711","Punjab","LAYYAH"),
("2854","Syed Ahmed Abbas","Syed Muhammad Askar","1430194472011","KP","KOHAT"),
("2855","Syed Ahmed Ali Shah","Syed Abid Hussain Shah (Late)","3720117584191","Punjab","CHAKWAL"),
("2856","Syed Ahmed Raza @ Hunzala ","Syed Shabbir Hussain ","NIL","Sindh","Karachi"),
("2857","Syed Ali Muhammad Naqvi ","Taswar Hussain ","4230118350235","Sindh","Karachi"),
("2858","Syed Ali Raza ","Manzoor Hussain ","3460321551227","Punjab","SIALKOT"),
("2859","Syed Ali Zain-ul-Abideen ","Syed Ajaib Ali","3820151773203","Punjab","KHUSHAB"),
("2860","Syed All Abbas Shah","Riaz Hussain","3330243338965","Punjab","TOBA TEK SINGH"),
("2861","Syed Ameer Haider Sherazi ","Syed Mureed Hussain Sherazi ","3820112111743","Punjab","KHUSHAB"),
("2862","Syed Amjad Ali Naqvi","Syed Shabbir Hussain Naqvi","3630262265457","Punjab","LODHRAN"),
("2863","Syed Anees Abbas Zaidi","Syed Zaigham Abbas Zaidi","3320110886811","Punjab","CHINIOT"),
("2864","Syed Anjum Abbas Naqvi ","Syed Ikram Ali Shah ","3520232234577","Punjab","LAHORE"),
("2865","Syed Anjum Hussain Bukhari","Intazar Hussain Shah Bukhari ","3420225647729","Punjab","GUJRAT"),
("2866","Syed Anwar Ali Shah","Syed Atta Hussain Shah","3630297579901","Punjab","Multan"),
("2867","Syed Anwar Hussain Shamsi ","Syed Nazar Hussain Shamsi ","3130254392477","Punjab","RAHIM YAR KHAN"),
("2868","Syed Asad Abbas","Syed Manzoor Hussain","3440114227999","Punjab","MANDI BAHAUDDIN"),
("2869","Syed Asad Ali","Ghulam Haider","3840118930469","Punjab","SARGODHA"),
("2870","Syed Asad Ullah ","Syed Atta Ullah ","3460379753823","Punjab","SIALKOT"),
("2871","Syed Asghar Abbas Naqvi","Karam Hussain Shah","6110135552347","ICT","ISLAMABAD\n\n"),
("2872","Syed Ashiq Hussain Bukhari ","Manzoor Hussain  Shah","3320108872477","Punjab","CHINIOT"),
("2873","Syed Atif Raza ","Syed Rehmat Ali Naqvi Bukhari ","3520227179359","Punjab","LAHORE"),
("2874","Syed Azhar Hussain Rizvi @ Major ","Syed Shabbir Hussain ","4210177692623","Sindh","Karachi"),
("2875","Syed Bakht Bedar  Hussain ","Syed Nazar Hussain Shah","3320115927903","Punjab","CHINIOT"),
("2876","Syed Baqir Hussain","Syed Bashir Hussain ","3810190871031","Punjab","BHAKKAR"),
("2877","Syed Chan Peer ","Syed Sardar Shah ","3120372292503","Punjab","BAHAWALPUR"),
("2878","Syed Ejaz Haider ","Syed Shabbir Hussain Shah ","3740649728261","Punjab","RAWALPINDI"),
("2879","Syed Faisal Ali Shah ","Ghulam Akbar Shah ","3320201949857","Punjab","JHANG"),
("2880","Syed Farooq Shah ","Mehmood Shah","4520488797481","Sindh","Khairpur"),
("2881","Syed Fazal Hussain Shah","Syed Atta Hussain Shah","3130324357097","Punjab","Rahim Yar Khan"),
("2882","Syed Ghulam Kazim Shah ","Syed Raham Ali Shah ","3120317331497","Punjab","BAHAWALPUR"),
("2883","Syed Haider Abbas Naqvi ","Syed Imtiaz Hussain Shah ","3320259902051","Punjab","JHANG"),
("2884","Syed Haider Ali Shah ","Syed Sakhawat Hussain Shah ","1350330802289","Punjab","RAWALPINDI"),
("2885","Syed Hasnain Raza ","Syed Ghulam Murtaza ","3130315478367","Punjab","RAHIM YAR KHAN"),
("2886","Syed Hassan Mahndi Zaidi ","Syed Zahoor Hussain Zaidi ","3640157935349","Punjab","PAKPATTAN"),
("2887","Syed Hassan Shah Kazmi "," Abdullah Shah","7150185529413","Gilgit-Baltistan","GILGIT"),
("2888","Syed Ibrar Ali Shah","Mushtaq Ali Shah","1730149756553","KP","PESHAWAR"),
("2889","Syed Iftikhar Hussain Shah ","Syed Khadim Hussain Shah ","3810223323935","Punjab","BHAKKAR"),
("2890","Syed Ijaz Hussain Shah ","Syed Ashiq Hussain ","3730242063889","Punjab","MANDI BAHAUDDIN"),
("2891","Syed Ikhlaq Hussain Shah ","Syed Ghulam Murtaza Shah ","3320110442523","Punjab","CHINIOT"),
("2892","Syed Imran Ali Gillani Caste Syed","Syed Sajjad Haider ","3420198520763","Punjab","GUJRAT"),
("2893","Syed Imtiaz Husssain Shah ","Syed Zamir Hussain Shah","4520331220391","Sindh","Khairpur"),
("2894","Syed Intizar Hussain Shah ","Syed Bashir Hussain Shah ","3450119625579","Punjab","NAROWAL"),
("2895","Syed Irfan Ali ","Haji Syed Dilbar Hussain ","3410361133333","Punjab","GUJRANWALA"),
("2896","Syed Ittehad Shah ","Muhammad Rafiq","4220169774089","Sindh","Karachi"),
("2897","Syed Khadim Hussain ","Syed Gulzar Hussain Shah ","3110295801613","Punjab","BAHAWALNAGAR"),
("2898","Syed lmran Hussain","Syed Munawar Hussain Shah","3840103140261","Punjab","SARGODHA"),
("2899","Syed Mazhar Abbas alis Shah G ","Sher Muhammad ","3310097789521","Punjab","FAISALABAD"),
("2900","Syed Mehmood Haider Shah Bukhari (CAste Syed Bukha","Javed Haider Shah","3460207253937","Punjab","SIALKOT"),
("2901","Syed Mohib Ullah","Syed Haji Ahmed Ullah","5440090472801","Balochistan","QUETTA"),
("2902","Syed Mudassir Abbas","Syed Abid Hussain Shah","3710116818387","Punjab","Attock    "),
("2903","Syed Muhammad ","Naik Muhammad / yar Muhammad","5440042981825","Balochistan","QUETTA"),
("2904","Syed Muhammad Arif Rizvi","Syed Muhammad Anwar ","NIL","Sindh","Karachi"),
("2905","Syed Muhammad Athar Jillani","Munawar Hussain Jillani","3240389190513","Punjab","KHANEWAL"),
("2906","Syed Muhammad Hashim ","Syed Abdul Qadeer ","3120101067329","Punjab","BAHAWALPUR"),
("2907","Syed Muhammad Hassan Zaidi ","Syed Zulfiqar Hussain Zaidi","3230183985181","Punjab","MUZAFFARGARH"),
("2908","Syed Muhammad Raza Kazmi ","Syed Ashraf Hussain ","3130310646765","Punjab","RAHIM YAR KHAN"),
("2909","Syed Muhammad Siddique Jillani","Munawar Hussain Jillani","3240377346453","Punjab","KHANEWAL"),
("2910","Syed Mujahid Ali Shah ","Syed Habdar Hussain Shah ","6110198887559","Punjab","RAWALPINDI"),
("2911","Syed Mujtaba Haider ","Syed Walayat Ali Shah ","3440179120985","Punjab","MANDI BAHAUDDIN"),
("2912","Syed Munir Hussain Shah ","Syed Mukhtar Hussain Shah ","3740631948723","Punjab","RAWALPINDI"),
("2913","Syed Musarrat Hussain.","Syed Agha Hussain","5440019018569","Balochistan","QUETTA"),
("2914","Syed Mussarat Shah","Syed Kewan Shah ","1430125130731","KP","KOHAT"),
("2915","Syed Naeem Hyder Najfi @ Bara","Syed Najaf Hussan ","4210161885766","Sindh","Karachi"),
("2916","Syed Nasir Abbas ","Taqi Abbas ","3440318355285","Punjab","MANDI BAHAUDDIN"),
("2917","Syed Naveed Akhtar ","Syed Akhtar Ali ","3810210423881","Punjab","BHAKKAR"),
("2918","Syed Nazar Abbas ","Syed Riaz Hussain","3660376863621","Punjab","VEHARI"),
("2919","Syed Niaz Rahim","Syed Sharif Hakim","1111111111111","KP","MALAKAND P.A."),
("2920","Syed Nizar Shah ","Syed Ghuldan Shah","1520248675603","KP","CHITRAL"),
("2921","Syed Qaim Raza ","Syed Muhammad Ishati","4210163460605","Sindh","Karachi"),
("2922","Syed Qamar Hussain Zaidi ","Syed Razi Shah ","3130377940757","Punjab","RAHIM YAR KHAN"),
("2923","Syed Qasim Raza ","Imam Ali Shah ","3440129115003","Punjab","MANDI BAHAUDDIN"),
("2924","Syed Qasir Ameer","Syed Ameer Hussain Shah","3120268141949","Punjab","BAHAWALPUR"),
("2925","Syed Qayim  Ali Shah Kazmi ","Syed Ibrahim Shah Kazmi","4220198699569","Gilgit-Baltistan","GILGIT"),
("2926","Syed Rashid Ali Shah ","Syed Zeeshan Ali Shah ","3340103638973","Punjab","Chiniot"),
("2927","Syed Raza Abbas Hamdani","Syed Shafqat Ali Shah Hamdani","3650274842975","Punjab","SAHIWAL"),
("2928","Syed Raza Hussain Shah","Safdar Ali Shah ","3310010252441","Punjab","FAISALABAD"),
("2929","Syed Rizwan Haider","Syed Safdar Hussain ","3440186174087","Punjab","MANDI BAHAUDDIN"),
("2930","Syed Saim Ali ","Syed Asim Ali","4220163257639","Sindh","Karachi"),
("2931","Syed Sajawal Munir","Munir Hussain Shah","3420294963761","Punjab","GUJRAT"),
("2932","Syed SAJID ALI ","Syed ZAWAR HUSSAIN Shah","3320114468689","Punjab","CHINIOT"),
("2933","Syed Sajid Ali Naqvi ","Muhammad Ali ","3460321416923","Punjab","SIALKOT"),
("2934","Syed Samar Abbas ","Syed Alamdar Hussain","3110116580213","Sindh","Karachi"),
("2935","Syed Sardar Shah ","Syed Zameer Haider Shah ","3120482138481","Punjab","BAHAWALPUR"),
("2936","SYED SHAFQAT HUSSAIN SHAH","SYED QAISAR ALI SHAH","3420195217969","Punjab","GUJRAT"),
("2937","Syed Shahid Hussain alias Shade Shah ","Inayat Ali ","3520151609455","Punjab","LAHORE"),
("2938","Syed Shakeel Ali Raza Naqvi ","Syed Sajjad Hussain Shah Naqvi ","3740698217259","Punjab","RAWALPINDI"),
("2939","Syed Shakir Hussain ","Syed Abbas Ali Shah ","3120273022183","Punjab","BAHAWALPUR"),
("2940","Syed Suleman Saqib @ Ali Junaid","Abdul Rauf","4250110488289","Sindh","KARACHI SOUTH"),
("2941","Syed Tahir Ali ","Syed Riaz Hussain ","3240480410739","Punjab","RAJANPUR"),
("2942","Syed Wasim Abbas Shah ","Syed Ahmad Ali Shah ","3120429629767","Punjab","BAHAWALPUR"),
("2943","Syed Yasir Abbas","Syed Azmat Ali  Shah","3740681015857","Punjab","RAWALPINDI"),
("2944","Syed Zafar Ali Shah ","Syed Said Ali Shah   ","3120219646999","Punjab","BAHAWALPUR"),
("2945","Syed Zahid Alisha","Khadim Hussain","1730107107977","KP","PESHAWAR"),
("2946","Syed Zaigham Abbas Kazmi","Syed Nisar Hussain Kazmi","3420174547993","Punjab","GUJRAT"),
("2947","Syed Zakir Hussain","Juma","5440020019573","Balochistan","QUETTA"),
("2948","Syed Zeeshan Abbas Shah Hamdani","Syed Ghulam Abbas Shah ","3310577112099","Punjab","FAISALABAD"),
("2949","Syed Zia Hussain Shah ","Khalid Hussain Shah","4240118747173","Sindh","Karachi"),
("2950","Tabasam Sibtain Ali ","Nazeer Hussain Shah ","1210187015741","Punjab","BHAKKAR"),
("2951","Tabassum Raza","Nayyar Hussain Zaidi","3320116104761","Punjab","CHINIOT"),
("2952","Tabbasum Abbas","Ejaz Hussain","3720178576793","ICT","ISLAMABAD\n\n"),
("2953","Taha @ Viki ","Badar Ahmed","42101878012883","Sindh","Karachi"),
("2954","Tahir","Juma Khan","1610159777359","KP","MARDAN"),
("2955","Tahir Abbas @ Bawa","Zameer Hussain Shah @ Hubdar Hussain","1330277071443","KP","HARIPUR"),
("2956","Tahir Abdullah","Nawab Din","3320355349181","Punjab","JHANG"),
("2957","Tahir Hayat Abbasi ","Hafiz Abdul Kareem Abbasi ","3120215825655","Punjab","BAHAWALPUR"),
("2958","Tahir Mehmood Haidri ","Muhammad Tufail Haidri ","3740271084931","Punjab","RAWALPINDI"),
("2959","Tahir Sardar alias Baksha","Sardar Ahmad","3840125063031","Punjab","SARGODHA"),
("2960","Taj Ali @ Taju","Sayada Khan","4240132428657","Sindh","Karachi"),
("2961","Taj Mohammad","Khan Mohammad","5210357794367","Balochistan","GWADAR"),
("2962","Taj Muhammad","Noor Muhammad","1720182258065","KP","NOWSHERA"),
("2963","Taj Muhammad alias Qari Taj Muhammad Saqib ","Fateh Muhammad","3230341159945","Punjab","MUZAFFARGARH"),
("2964","Taj Muhammad Hanfi ","Nazeer Khan ","1520206574661","Sindh","Karachi"),
("2965","Talib Hussain","Shafi Muhammad ","3110339801651","Punjab","BAHAWALNAGAR"),
("2966","Talib Hussain","Malik Mahir","3240354939993","Punjab","Rajanpur"),
("2967","Talib Hussain","Imam Din Mamoo","3320220373535","Punjab","Jhang"),
("2968","Talib Hussain ","Muhammad Nawaz ","3120369561757","Punjab","BAHAWALPUR"),
("2969","Talib Hussain ","Abdul Hakeem ","3130324206841","Punjab","RAHIM YAR KHAN"),
("2970","Talib Hussain alias Fani ","Muhammad Sadiq","3660313217187","Punjab","VEHARI"),
("2971","Talimand","Hasham","1510146414061","KP","BUNER"),
("2972","TANVEER ABBAS","GHULAM AKBAR","3220395473941","Punjab","LAYYAH"),
("2973","Tanveer Ahmad ","Abdul Shakoor ","3660388741951","Punjab","BAHAWALPUR"),
("2974","Tanveer Ahmad @ Jarrar","Basheer Ahmad","1220140166615","KP","S.WAZIRISTAN (AT WANA)"),
("2975","Tanveer Ahmed ","Bashir Ahmed ","3710198143981","Punjab","CHAKWAL"),
("2976","Tanveer Anwar ","Muhammad  Anwar","4210163501569","Sindh","Karachi"),
("2977","Tanveer Hussain ","Muhammad Hussain ","3460156037073","Punjab","SIALKOT"),
("2978","Tanvir Sajjad ","Muhammad Inayat alias Maroofia ","3420108530829","Punjab","GUJRAT"),
("2979","Taqi Ullah","Ahmad Shah ","3310277864651","Punjab","FAISALABAD"),
("2980","Taraj Ahmed","Rahmat Gul","1710103684801","KP","CHARSADDA"),
("2981","Tariq","Ashraf","1111111111122","KP","PESHAWAR"),
("2982","Tariq Abbas ","Basheer Hussain Khan ","3810113718663","Punjab","BHAKKAR"),
("2983","Tariq Abbas","Muhammad Rafiq","3220176987201","Punjab","LAYYAH"),
("2984","Tariq Aziz","Fazal Aziz","1710104024287","KP","Charsada"),
("2985","Tariq Bilal ","Muhammad Iqbal ","3210357909465","Punjab","DERA GHAZI KHAN"),
("2986","Tariq Jafari.","Sher Ahmed","5440016979471","Balochistan","QUETTA"),
("2987","Tariq Khan","Naik Rehman","1560168937581","KP","SWAT (AT MINGORA)"),
("2988","Tariq Mahmood ","Ghous Bakhsh ","3240327639833","Punjab","RAJANPUR"),
("2989","Tariq Mahmood"," Noor Muhammad ","3460111729761","Punjab","SIALKOT"),
("2990","Tariq Mahmood ","Abdul Majeed Khan ","3120327032265","Punjab","BAHAWALPUR"),
("2991","Tariq Mehmood ","Shadi khan ","3540218497577","Punjab","Nankana Sahib"),
("2992","Tariq Mehmood ","Hazoor Ahmad      ","3120545082295","Punjab","BAHAWALPUR"),
("2993","Tariq Mehmood Abbasi ","Abdul Ghafoor Abbasi ","3740418854013","Punjab","RAWALPINDI"),
("2994","Tasawar Ameen Caste Awan","Muhammad Ameen","3840393193701","Punjab","KHUSHAB"),
("2995","Tasawar Hussain ","Ghulam Shabeer ","3810106261119","Punjab","BHAKKAR"),
("2996","Tasawar Hussain ","Muhammad Riaz ","3330386659219","Punjab","TOBA TEK SINGH"),
("2997","Tayyab Hussain Shah ","Muhammad Sarwar ","3630223387701","Punjab","MULTAN"),
("2998","Taz Meen","Fazal Qadar","1530589970533","KP","LOWER DIR (AT TEMERGARA)"),
("2999","Tehseen Askari","Munir Hussain Sethi","3420290110159","Punjab","GUJRAT"),
("3000","Tila Muhammad","Babrak Khan","","KP","SWA"),
("3001","Toor Khan","s/o Abdul Majeed .","1570111877141","KP","UPPER DIR (AT DIR)"),
("3002","Toor Mohammad","Qabil","1570141141867","KP","UPPER DIR (AT DIR)"),
("3003","Toti","Sadbar","1560204170823","KP","SWAT (AT MINGORA)"),
("3004","Touqeer Abbas ","Muhammad Ramzan ","3810215745385","Punjab","BHAKKAR"),
("3005","Touqeer Abbas alias Taqi Shah ","Akhtar Abbas ","3320352473055","Punjab","JHANG"),
("3006","Touqeer Abbasi ","Syed Akbar","8230313949867","AJ&K","Jhandala, Rawalakot"),
("3007","Touseef Ishtiaq","Ishtiaq Hussain ","3720181042391","Punjab","CHAKWAL"),
("3008","Touseef Khan code name Molvi  Akhter ","Talib Hussain","3740569368513","AJ&K","Harna Mera Rawalakot"),
("3009","TS Commander Molvi Azmat Ullah @ Lala","Rabistan","2170603746263","KP","S.WAZIRISTAN (AT WANA)"),
("3010","Ubaid Ullah","Muhammad Ashraf Ali","3110491349377","Punjab","BAHAWALNAGAR"),
("3011","UBAID ULLAH ANWAR","Khalil Ahmad ","3220238480119","Punjab","LAYYAH"),
("3012","Ubaid ur Rehman Qamar ","Abdul Hakeem ","3120538922375","Punjab","BAHAWALPUR"),
("3013","Ubaid Ur Rehman Siddiqui ","Abdul Rehman Siddiqui ","3220320331645","Punjab","LAYYAH"),
("3014","Ubaid-Ur-Rehman","Ghulam Sarwar","3110416908913","Punjab","BAHAWALNAGAR"),
("3015","UBAIDULLAH","MUHAMMAD ZAHID","3640223527319","Punjab","Pakpattan"),
("3016","Ubeedullah @ Hussain @ Sajad @ Oragzai ","Abdullah Oragzai Pathan ","4410391607759","Sindh","Mirpurkhas"),
("3017","ulla","0","","KP","Dir Upper"),
("3018","Umair Sajjad","Sajjad Akhtar ","3740665328515","Punjab","RAWALPINDI"),
("3019","Umar Ali  ","Muhammad Ramzan","3320204452845","Punjab","JHANG"),
("3020","Umar Badshah","Shams ul Hamid","1530203841383","KP","LOWER DIR (AT TEMERGARA)"),
("3021","Umar Farooq","Mushtaq ahmad","3710502003135","Punjab","Attock    "),
("3022","Umar Farooq","Dost Muhammad","3740559815317","Punjab","Attock    "),
("3023","UMAR FAROOQ","MUHAMMAD SIDDIQUE","3650179875579","Punjab","SAHIWAL"),
("3024","Umar Farooq","Hafiz Habib Ellahi Mansoor","3710117650237","Punjab","Attock    "),
("3025","Umar Farooq","Moulana Abdu-ur-Rauf Nomani","3660147229181","Punjab","Vehari"),
("3026","Umar Farooq","Muhammad Maqbool","3320166698975","Punjab","CHINIOT"),
("3027","Umar Farooq","Sajid Mehmood ","3740659168477","Punjab","RAWALPINDI"),
("3028","Umar Farooq @ Umer","Allah Wasaya ","4220186421355","Sindh","Karachi"),
("3029","Umar Farooq alias Sardar Mithu","Muhammad Sabir","3840376092279","Punjab","SARGODHA"),
("3030","Umar Hayat","Mustafa","1530680328165","KP","LOWER DIR (AT TEMERGARA)"),
("3031","Umar Rehman","Fazal Rehamn","1530222357105","KP","LOWER DIR (AT TEMERGARA)"),
("3032","Umar Rehman","Ghazi Khan","1570349317955","KP","UPPER DIR (AT DIR)"),
("3033","Umar Said","Momin","1570168837797","KP","UPPER DIR (AT DIR)"),
("3034","Umar Wahid","Haji Wali","1530625392565","KP","LOWER DIR (AT TEMERGARA)"),
("3035","Umer Farooq","Muhammad Siddique","3230429340769","Punjab","Muzaffargarh"),
("3036","Umer Farooq ","Noor Hassan","3130328660949","Punjab","RAHIM YAR KHAN"),
("3037","Umer Khayam ","Sulah-ud-Din ","3520271182373","Punjab","LAHORE"),
("3038","Umer Saeed ","Syed Muhammad ","5440007615239","Balochistan","QUETTA"),
("3039","Umer Zada Alias Dildar","Bacha Gul","1560154038675","KP","SWAT (AT MINGORA)"),
("3040","Ummar Zada ","Zainullah ","1560224505681","Sindh","Karachi"),
("3041","Usama Hamid","Bashir Ahmed Hamid","3130371492117","Punjab","RAHIM YAR KHAN"),
("3042","Usma Ali Qureshi","Noor Bazz","7120235749015","Gilgit-Baltistan","DIAMIR (AT CHILAS)"),
("3043","Usman","Nazir","1730115726037","KP","PESHAWAR"),
("3044","Usman Ghani","Abdul Ghani","1530208619253","KP","LOWER DIR (AT TEMERGARA)"),
("3045","Usman Ghani","Abdul Shakoor ","3310058860369","Punjab","FAISALABAD"),
("3046","Usman Haider","Ghulam Haider","3710440263707","Punjab","ATTOCK"),
("3047","Usman Hanif ","Muhammad Hanif","3540505249301","Sindh","Karachi"),
("3048","Usman Sabir alias Tayyab Pehlwan","Muhammad Sabir ","3310266636469","Punjab","FAISALABAD"),
("3049","Venumdhave Dongara","a","1111111111116","KP","PESHAWAR"),
("3050","Waheed Ahmad alias Kashi ","Nazir Ahmad ","3330304044809","Punjab","TOBA TEK SINGH"),
("3051","Waheed Ahmed","Zahoor Ahmed","3440106413719","Punjab","MANDI BAHAUDDIN"),
("3052","Waheed Ullah Khan","Sher Gul","1111111111111","KP","MALAKAND P.A."),
("3053","Wahid ullah","Mian Gul","1530554884653","KP","LOWER DIR (AT TEMERGARA)"),
("3054","Wajahat Hussain Farooqi ","Sakhawat Hussain Caste Malik ","3240474614841","Punjab","RAJANPUR"),
("3055","Wakeel Ahmad","Muhammad Talib","3430170446681","Punjab","HAFIZABAD"),
("3056","Walayat Ullah ","Muhammad Ishaq ","3410166843847","Punjab","GUJRANWALA"),
("3057","Wali Mohammad","Mir Dost","1570179616169","KP","UPPER DIR (AT DIR)"),
("3058","Wali Muhammad","Haji Sharif","1730166139621","KP","Peshawar"),
("3059","Wali Muhammad","Haji Sharif","1730163513319","KP","PESHAWAR"),
("3060","Wali Muhammad","Muhammad Ali Chandio","4410402418245","Sindh","Umerkot"),
("3061","Wali Rahman","Badshah Khan","1570147919103","KP","UPPER DIR (AT DIR)"),
("3062","Wali Ullah","Rafi Ullah","Gx 11058463721","KP","Dir Lower"),
("3063","Wali Ullah Awan ","Ahsanullah Awan","4240135443717","Sindh","Karachi"),
("3064","Waliullah","Rafiq Ahmad","1550595767695","KP","SHANGLA (AT ALPURI)"),
("3065","Waqar Ahmed alias Qari ","Muhammad Sardar ","3640243242929","Punjab","PAKPATTAN"),
("3066","Waqas Abid ","Malik Abid Hussain Awan ","3460398708497","Punjab","SIALKOT"),
("3067","Waqas Ahmad","Muhammad Ibrahim","3410186986503","Punjab","GUJRANWALA"),
("3068","Waqas Ahmed ","M. Shafi","8230310126233","AJ&K","Chak Dhamni,District Poonch"),
("3069","Waqas Ahmed ","Dilawar Khan.","7150112539873","Gilgit-Baltistan","GILGIT"),
("3070","Waqas Haider","Waris Ali","3810399921625","Punjab","BHAKKAR"),
("3071","Waqas Hussain ","Nazar Hussain","3810107733825","Punjab","BHAKKAR"),
("3072","Waqas Shafique Ghuncha","Shafique Ahmad Ghuncha ","3220225266197","Punjab","LAYYAH"),
("3073","Wasal","Syed Muhammad","1111111111124","KP","PESHAWAR"),
("3074","Waseem Abbas ","Ghulam Ali ","3440309982317","Punjab","MANDI BAHAUDDIN"),
("3075","Waseem Abbas ","Manzoor Hussain ","3740503412049","Punjab","RAWALPINDI"),
("3076","Waseem Abbas ","Zahoor u Din ","3320385261729","Punjab","JHANG"),
("3077","Waseem Ahmed Baroodi ","Sami Ahmed ","50472189844","Sindh","Karachi"),
("3078","Waseem Hashmi ","Muhammad Sadiq ","3120204596727","Punjab","BAHAWALPUR"),
("3079","Waseem Sajjad Shah ","Sajjad Hussain Shah ","3810209058013","Punjab","BHAKKAR"),
("3080","Wasif Raza ","Mulazim Hussain ","3320279246369","Punjab","JHANG"),
("3081","Wazir Ahmad ","Sawan Khan ","3210208042123","Punjab","DERA GHAZI KHAN"),
("3082","WAZIR AHMED","ALLAH DAWAYA","3630308059541","Punjab","Multan"),
("3083","Wazir Zada","Bakhat Zada","1710184006171","KP","CHARSADDA"),
("3084","Yaeen @ Khalid Bugti ","Ghulam Nabi. ","5440004500301","Balochistan","QUETTA"),
("3085","Yahya Khan","Khudai Rahim","5310312708051","Balochistan","KACHHI (BOLAN) (AT DHADAR)"),
("3086","Yasir","Muhammad Ijaz caste Awan","1310118805783","KP","ABBOTTABAD"),
("3087","Yasir Akhlas ","Muhammad Akhlas ","4220177827007","Sindh","Karachi"),
("3088","Yasir Ali ","Saif Ullah Khan ","3810104980707","Punjab","BHAKKAR"),
("3089","Yasir Irfat","Fazal-e-Wadood","1530360895297","KP","LOWER DIR (AT TEMERGARA)"),
("3090","Yasir Rehman Jaghranvi","Abdul Rehman Jughranvi ","3520228865045","Punjab","LAHORE"),
("3091","Yawar Abbas "," Bakht Ali","7170403481273","Gilgit-Baltistan","NAGAR"),
("3092","Yousaf","Munir","1730117791609","KP","PESHAWAR"),
("3093","Yousaf Khan","Abdul Hakim","1710203777111","KP","CHARSADDA"),
("3094","Yousaf Shah","Ibrahim Shah","1510103731543","KP","SWAT (AT MINGORA)"),
("3095","Yousaf Shah","Ibrahim Shah","1510103731541","KP","BUNER"),
("3096","Zabeeh Ullah","Abdullah","","KP","Dir Lower"),
("3097","Zafar","Mohammad Arif","1570137511501","KP","UPPER DIR (AT DIR)"),
("3098","Zafar Ali Khan","Jamil Ahmad","1530209178981","KP","LOWER DIR (AT TEMERGARA)"),
("3099","Zafar Ali Shah","Zamin Shah","1530517487375","KP","LOWER DIR (AT TEMERGARA)"),
("3100","Zafar All","Ghulam Haider","3840156288469","Punjab","SARGODHA"),
("3101","Zafar Iqbal","Pir Muhammad Khan","1560232171003","KP","SWAT (AT MINGORA)"),
("3102","Zafar Iqbal ","Ahmed Iqbal","","Sindh","Hyderabad"),
("3103","Zafar Iqbal","Muhammad Ejaz","3710230263867","Punjab","ATTOCK"),
("3104","Zafar Iqbal alias Fauji ","Ahmad Ali ","3420182268963","Punjab","GUJRAT"),
("3105","Zafar Iqbal alias Zafar Farooqi ","Nazar Muhammad ","3440303019551","Punjab","MANDI BAHAUDDIN"),
("3106","Zafar Khursheed","Dil Khursheed","3710485359485","Punjab","ATTOCK"),
("3107","Zafar Mehmood","Abdul Ghani","6110186086381","ICT","ISLAMABAD\n\n"),
("3108","Zafeer Ahmad ","Muhammad Fazal-ul-Haq ","3130152770757","Punjab","RAHIM YAR KHAN"),
("3109","Zafran Khan caste Kakozai ","Haji Wazir Khan","5420311723221","Balochistan","KILLA ABDULLAH"),
("3110","Zahid Abbas ","Muhammad Afzal ","3630247231969","Punjab","MULTAN"),
("3111","Zahid Akram","Allah Bakhsh","3660209892337","Punjab","Vehari"),
("3112","Zahid Anwar Niazi","Muhammad Anwar (Late)","3630203357751","Punjab","Multan"),
("3113","Zahid Bacha","Anwar Khan","1570139257941","KP","UPPER DIR (AT DIR)"),
("3114","Zahid Gul","Mera Khan","1720121248483","KP","NOWSHERA"),
("3115","Zahid Gul @ Hamza ","Ghulam Fareed ","","Sindh","Karachi"),
("3116","Zahid Hussain ","Ashiq Hussain ","4230196085917","Sindh","Karachi"),
("3117","Zahid iqbal","Zafar iqbal","3320403917323","Punjab","Jhang"),
("3118","Zahid Khan","Master Abdul Aziz","1330204930211","KP","ABBOTTABAD"),
("3119","Zahid Mehmood","Feroz din","3460290675373","Punjab","Sialkot"),
("3120","Zahid Mushtaq ","Muhammad Mushtaq ","3410182806289","Punjab","GUJRANWALA"),
("3121","Zahid Shah","Javed","1210197974691","KP","DERA ISMAIL KHAN"),
("3122","Zahid Ullah","Abdul Wahab","","KP","Dir Lower"),
("3123","Zahoor Abbass","Muhammad Yousaf.","7150127558615","Gilgit-Baltistan","GILGIT"),
("3124","Zahoor Ahmad","Rehmat Ali","3640215737891","Punjab","PAKPATTAN"),
("3125","Zahoor Ahmad Gorsi ","Ubaid Ul Haq ","3520099233617","Punjab","LAHORE"),
("3126","Zahoor Ahmed","Mehr Mapal","3320403875181","Punjab","Jhang"),
("3127","Zahoor Hashmi ","Mohiuddin Pathan","4240101084685","Sindh","Karachi"),
("3128","Zahoor Khan","Malook Taj","1720108772038","KP","NOWSHERA"),
("3129","Zahoor-ul-Ameen Hashmi","Muhammad Amin Hashmi","3420216712671","Punjab","GUJRAT"),
("3130","Zaid Mustafa","Ghulam Rabbani","3840396112325","Punjab","SARGODHA"),
("3131","Zaigham Naeem","Muhammad Naeem","3240253074761","Punjab","RAJANPUR"),
("3132","Zain Shahid ","Shahid Kamal ","4210189312781","Sindh","Karachi"),
("3133","Zain-ul-Abdin ","Abdul Muneen.","7150123839137","Gilgit-Baltistan","GILGIT"),
("3134","Zain-ul-Abideen","Mirza Zafar Iqbal","3320404474885","Punjab","JHANG"),
("3135","Zaki Raza ","Raja Muhammad Saddique","3740107057871","Punjab","RAWALPINDI"),
("3136","Zakir Ullah","Ihsan Ullah","1530773159715","KP","LOWER DIR (AT TEMERGARA)"),
("3137","Zakir Ullah","Nowsher Rawan","1540232969029","KP","UPPER DIR (AT DIR)"),
("3138","Zakria Kalim Ullah","Molana Atta Ullah ","3710409673177","Punjab","ATTOCK"),
("3139","Zameer / Zahir Ahmad / Kabeer Ahmad","Sagheer/ Zafeer Ahmad","1310161837275","KP","ABBOTTABAD"),
("3140","Zamin Khan","Afridi","1510103657877","KP","BUNER"),
("3141","Zar Mehmood","Sarfaraz","1530630429395","KP","LOWER DIR (AT TEMERGARA)"),
("3142","Zar Muhammad","Yar Muhammad","1730104724633","KP","PESHAWAR"),
("3143","Zarawar","Khalid Khan","1570108051207","KP","UPPER DIR (AT DIR)"),
("3144","Zardad Khan @ Fateh Gul ","Sher Adat Khan","4130325893919","Sindh","Hyderabad"),
("3145","Zareen Abbas","Kazam Ali","3320393709645","Punjab","JHANG"),
("3146","Zarizadgei @ Perveen ","Mewa Khan","1111111111119","KP","PESHAWAR"),
("3147","Zarmeen Said","Amanat Khan","1620216144887","KP","SWABI"),
("3148","Zawar Hussain Jaffari ","Riaz Hussain ","3320382607307","Punjab","JHANG"),
("3149","Zayed Ahmed Zubair","Zubair Ahmed","4220148251407","Punjab","Rahim Yar Khan"),
("3150","Zeeshan Haider","Matloob Hussain Jafri ","3720198784075","Punjab","CHAKWAL"),
("3151","Zeeshan Haider alias Shani ","Khawaja Zahid ","3440278053295","Punjab","MANDI BAHAUDDIN"),
("3152","Zeeshan Mauvia","Hafiz Mehboob","1330281054861","KP","HARIPUR"),
("3153","Zewar Ahmad","Shahir Habib","1610162397115","KP","MARDAN"),
("3154","Zia Hussain","Fida Hussain ","3820126019459","Punjab","KHUSHAB"),
("3155","Zia Mairaj","Mairaj Ud Din Ahmad ","3520229219367","Punjab","LAHORE"),
("3156","Zia Ud Din","Mian Said Laiq","","KP","Swat"),
("3157","Zia Ullah Shah","Sultan Ghani","1610175854667","KP","MARDAN"),
("3158","Zia ur Raheem ","Shams ul Zareen ","1320151902609","KP","BATAGRAM (AT BANA)"),
("3159","Zia ur Rehman","Noor Muhammad","3710403562369","Punjab","Attock    "),
("3160","Zil E Hussnain Zaidi ","Muhammad Ashraf Shah ","3330221947753","Punjab","TOBA TEK SINGH"),
("3161","Zohaib","Muhammad Kareem","5220329733335","Balochistan","KECH (AT TURBAT)"),
("3162","Zohaib Fiaz","Muhammad Fiaz","3840191009013","Punjab","SARGODHA"),
("3163","Zohaib Hassan Khan @ Pashteen","Muhammad Qaddafi","1220148083689","KP","S.WAZIRISTAN (AT WANA)"),
("3164","Zor Zamin Khan","Ferdos Khan","1530209694525","KP","LOWER DIR (AT TEMERGARA)"),
("3165","Zubair Ahmad ","Zahoor Ahmad ","3340105584919","Punjab","CHINIOT"),
("3166","Zubair Shaheen","Abdul Sattar","1210109109629","KP","DERA ISMAIL KHAN"),
("3167","Zulfiqar Ahmad ","Ghulam Rasool ","3410423343787","Punjab","GUJRANWALA"),
("3168","Zulfiqar Ali ","Talib Hussain ","3310088810677","Punjab","FAISALABAD"),
("3169","Zulfiqar Ali ","Mansab Ali ","3310456127699","Punjab","FAISALABAD"),
("3170","Zulfiqar Ali ","Ghulam Akbar ","3810106697029","Punjab","BHAKKAR"),
("3171","Zulfiqar Au Muavia alias Muavia","Taj Muhammad","3840594928377","Punjab","SARGODHA"),
("3172","Zulfiqar Sasoli ","Mir Hassan Khan.","5140193123225","Balochistan","KHUZDAR");



DROP TABLE IF EXISTS employee_documents;

CREATE TABLE `employee_documents` (
  `employee_id` int(11) NOT NULL,
  `url` text NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS employee_policies;

CREATE TABLE `employee_policies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` int(10) unsigned NOT NULL,
  `policy_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_policies_employee_id_foreign` (`employee_id`),
  KEY `employee_policies_policy_id_foreign` (`policy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS employees;

CREATE TABLE `employees` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `basic_salary` double NOT NULL DEFAULT 0,
  `employee_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `manager_id` int(10) unsigned DEFAULT NULL,
  `department_id` int(10) unsigned DEFAULT NULL,
  `designation_id` int(10) unsigned DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `employee_type` int(11) NOT NULL DEFAULT 1,
  `working_hours` int(11) NOT NULL,
  `working_days` int(11) NOT NULL DEFAULT 5,
  `bank_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gender` tinyint(1) NOT NULL DEFAULT 1,
  `dob` date DEFAULT NULL,
  `emer_person` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `emer_relation` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `emer_phone_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `emer_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `reference` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employees_manager_id_foreign` (`manager_id`),
  KEY `employees_department_id_foreign` (`department_id`),
  KEY `employees_designation_id_foreign` (`designation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS expense_categories;

CREATE TABLE `expense_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS expense_payments;

CREATE TABLE `expense_payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_id` int(11) NOT NULL,
  `amount` double NOT NULL,
  `account_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `notes` text DEFAULT NULL,
  `reference` text DEFAULT NULL,
  `payment_method` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `approval_status` tinyint(1) DEFAULT NULL,
  `file` text DEFAULT NULL,
  `is_reconciled` tinyint(1) DEFAULT 1,
  `is_book` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS expenses;

CREATE TABLE `expenses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `vendor_id` int(11) DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `bill_number` int(11) DEFAULT NULL,
  `billed_at` date DEFAULT NULL,
  `due_at` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `image_url` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expense_type` int(11) DEFAULT NULL,
  `is_book` tinyint(1) DEFAULT 0,
  `entry_no` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS fixed_asset_accounts;

CREATE TABLE `fixed_asset_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_type_id` int(11) NOT NULL,
  `ftp` double NOT NULL DEFAULT 0 COMMENT 'For The Period',
  `wdv` double NOT NULL DEFAULT 0 COMMENT 'Writen Down Value',
  `maint` double NOT NULL COMMENT 'Maintainance',
  `type` enum('depreciation','sold') NOT NULL,
  `is_book` int(1) NOT NULL DEFAULT 0,
  `from_date` date NOT NULL,
  `to_date` date NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS fixed_asset_for_sales;

CREATE TABLE `fixed_asset_for_sales` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `maintainance_cost` double NOT NULL DEFAULT 0,
  `writen_down_value` double NOT NULL DEFAULT 0,
  `asset_id` int(11) NOT NULL,
  `sold_date` date NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS fixed_asset_types;

CREATE TABLE `fixed_asset_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `depreciation_policy` enum('straight_line_method','reducing_balance_method') NOT NULL,
  `depreciation_rate` int(10) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS fixed_assets;

CREATE TABLE `fixed_assets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `asset_tag` varchar(50) DEFAULT NULL,
  `item_id` int(10) DEFAULT NULL,
  `warranty` int(10) DEFAULT NULL,
  `asset_location` int(11) DEFAULT NULL,
  `status` enum('in_use','in_storage') NOT NULL DEFAULT 'in_storage',
  `serial` varchar(100) DEFAULT NULL,
  `cost` double DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `asset_type` varchar(50) DEFAULT NULL,
  `physical_status` enum('in_use','sold') NOT NULL DEFAULT 'in_use',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS general_journal_entries;

CREATE TABLE `general_journal_entries` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `entry_no` int(11) NOT NULL,
  `adjusting_entry` tinyint(1) DEFAULT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `amount` double NOT NULL,
  `memo` text DEFAULT NULL,
  `name` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name_type` int(11) DEFAULT NULL,
  `type` varchar(100) DEFAULT NULL,
  `is_approved` tinyint(1) DEFAULT 1,
  `voucher_type` int(11) DEFAULT NULL,
  `transaction_type` int(100) DEFAULT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `is_check` tinyint(1) NOT NULL DEFAULT 0,
  `is_post` tinyint(1) NOT NULL DEFAULT 0,
  `check_by` tinyint(1) NOT NULL DEFAULT 0,
  `post_by` tinyint(1) NOT NULL DEFAULT 0,
  `prepare_by` int(11) DEFAULT NULL,
  `voucher_no` text DEFAULT NULL,
  `is_cleared` tinyint(1) NOT NULL DEFAULT 1,
  `bank_name` text DEFAULT NULL,
  `cheaque_no` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS hrm_attendances;

CREATE TABLE `hrm_attendances` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `employ_id` int(10) NOT NULL,
  `present_absent` int(10) NOT NULL COMMENT '1-present\r\n2-leave\r\n0-absent',
  `date` date NOT NULL,
  `user_id` int(11) NOT NULL,
  `checkin` time DEFAULT NULL,
  `checkout` time DEFAULT NULL,
  `status` int(11) NOT NULL,
  `leave_type` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS hrm_bank_account_details;

CREATE TABLE `hrm_bank_account_details` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `account_holder_name` varchar(156) DEFAULT NULL,
  `bank_name` text DEFAULT NULL,
  `branch_location` varchar(156) DEFAULT NULL,
  `account_no` varchar(36) DEFAULT NULL,
  `bank_code` varchar(35) DEFAULT NULL,
  `employ_id` bigint(20) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employ_id` (`employ_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS hrm_company_detail;

CREATE TABLE `hrm_company_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `employee_code` varchar(60) DEFAULT NULL,
  `department` int(156) DEFAULT NULL,
  `country` varchar(156) DEFAULT NULL,
  `city` varchar(25) DEFAULT NULL,
  `employ_id` int(11) DEFAULT NULL,
  `date_of_joining` date DEFAULT NULL,
  `monthly_salary` double(8,2) DEFAULT NULL,
  `salary_method` enum('cheque','bank','cash','') NOT NULL,
  `designation` int(35) DEFAULT NULL,
  `contract_type` enum('full_time','contract') DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS hrm_employee_adjustment_loan;

CREATE TABLE `hrm_employee_adjustment_loan` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `date` date DEFAULT NULL,
  `employ_id` int(11) DEFAULT NULL,
  `loan_id` int(11) DEFAULT NULL,
  `type` varchar(11) DEFAULT NULL,
  `adjustment_amount` double(8,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `is_approved` int(10) NOT NULL DEFAULT 0 COMMENT '0=>not approved,1=>approved',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS hrm_employee_allownces;

CREATE TABLE `hrm_employee_allownces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS hrm_employee_attendance_scheduales;

CREATE TABLE `hrm_employee_attendance_scheduales` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `medical_leave` int(10) DEFAULT NULL,
  `anual_leave` int(11) DEFAULT NULL,
  `other_leave` int(11) DEFAULT NULL,
  `special_leave` int(11) DEFAULT NULL,
  `weekend` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS hrm_employee_commissions;

CREATE TABLE `hrm_employee_commissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `employ_id` int(10) NOT NULL,
  `commission_month` int(10) NOT NULL,
  `commission_title` varchar(191) NOT NULL,
  `commission_amount` double(8,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS hrm_employee_deductions;

CREATE TABLE `hrm_employee_deductions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `employ_id` int(10) NOT NULL,
  `deduction_title` varchar(191) NOT NULL,
  `deduction_amount` double(8,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS hrm_employee_designations;

CREATE TABLE `hrm_employee_designations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(156) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS hrm_employee_expences;

CREATE TABLE `hrm_employee_expences` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `employ_id` int(10) NOT NULL,
  `allownace_title` varchar(191) NOT NULL,
  `allownace_amount` double(8,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS hrm_employee_loan_advance_documents;

CREATE TABLE `hrm_employee_loan_advance_documents` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `employ_id` int(11) NOT NULL,
  `document_url` varchar(156) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS hrm_employee_salaries;

CREATE TABLE `hrm_employee_salaries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employ_id` int(11) NOT NULL,
  `month` int(11) DEFAULT NULL,
  `year` int(10) DEFAULT NULL,
  `total_deduction` double(8,2) DEFAULT NULL,
  `total_earning` double(8,2) DEFAULT NULL,
  `net_salary` double(8,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS hrm_employees;

CREATE TABLE `hrm_employees` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `email` varchar(191) NOT NULL,
  `password` varchar(191) DEFAULT NULL,
  `cnic` varchar(30) NOT NULL,
  `gender` enum('Male','Female') NOT NULL,
  `dob` date NOT NULL,
  `phone_no` varchar(25) NOT NULL,
  `residential_address` varchar(156) NOT NULL,
  `pemanent_address` varchar(191) NOT NULL,
  `status` int(11) NOT NULL DEFAULT 1 COMMENT '1=>for active employee\r\n0=>for in active\r\n2=>for terminate',
  `user_id` int(10) NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS hrm_employees_benevolent_fund_settings;

CREATE TABLE `hrm_employees_benevolent_fund_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bf_fund` double(8,0) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS hrm_employees_benevolent_funds;

CREATE TABLE `hrm_employees_benevolent_funds` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employ_id` int(11) NOT NULL,
  `month` int(11) DEFAULT NULL,
  `year` int(11) DEFAULT NULL,
  `bf_fund` double(8,2) DEFAULT NULL,
  `bf_fund_company_con` double(8,2) DEFAULT NULL,
  `status` int(11) DEFAULT 1 COMMENT '1 => not received bf\r\n , 0 => received bf',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `is_approved` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS hrm_employees_deductions;

CREATE TABLE `hrm_employees_deductions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS hrm_employees_documents;

CREATE TABLE `hrm_employees_documents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employ_id` bigint(20) unsigned NOT NULL,
  `certificate` varchar(156) DEFAULT NULL,
  `resume` varchar(156) DEFAULT NULL,
  `photo` varchar(156) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS hrm_employees_loans;

CREATE TABLE `hrm_employees_loans` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `employ_id` int(11) NOT NULL,
  `type` varchar(156) DEFAULT NULL,
  `loan_amount` double(8,2) DEFAULT NULL,
  `remaning` double(8,2) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `is_sent` int(11) NOT NULL DEFAULT 1 COMMENT '1-sent to accounts 2-voucher created',
  `is_book` int(11) NOT NULL DEFAULT 0,
  `payment_method` varchar(156) DEFAULT NULL,
  `receipt_no` varchar(156) DEFAULT NULL,
  `notes` varchar(156) DEFAULT NULL,
  `instrument_no` int(11) DEFAULT NULL,
  `is_approved` int(10) NOT NULL DEFAULT 0 COMMENT 'is_approved=>1,loan/advanve is approved\r\n''is_approved''=>1, not approved\r\n',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS hrm_employees_overtimes;

CREATE TABLE `hrm_employees_overtimes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `employ_id` int(10) NOT NULL,
  `month` int(10) NOT NULL,
  `title` varchar(191) NOT NULL,
  `hourse` int(11) NOT NULL,
  `rate` double(8,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS hrm_monthly_earning_deductions;

CREATE TABLE `hrm_monthly_earning_deductions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `employ_id` int(10) NOT NULL,
  `year` int(11) DEFAULT NULL,
  `month` int(11) DEFAULT NULL,
  `basic_salary` double(8,2) DEFAULT NULL,
  `title` varchar(156) DEFAULT NULL,
  `tax` double(8,2) DEFAULT NULL,
  `amount` double(8,2) DEFAULT NULL,
  `type` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `is_sent` int(1) NOT NULL DEFAULT 1 COMMENT '1-sent to accounts\r\n2-voucher created',
  `is_book` int(1) NOT NULL DEFAULT 0,
  `is_approved` int(10) DEFAULT 0 COMMENT '0 => not approved\r\n1=>approved\r\n',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS hrm_settings;

CREATE TABLE `hrm_settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `checkin` time NOT NULL,
  `checkout` time NOT NULL,
  `late_fine` double(8,2) DEFAULT NULL,
  `weekend_day` varchar(156) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS hrm_taxcitions;

CREATE TABLE `hrm_taxcitions` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `minimum` double DEFAULT NULL,
  `no` int(10) NOT NULL,
  `maximum` double DEFAULT NULL,
  `deduct_amount` double DEFAULT NULL,
  `deduct_percentage` double DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS installment_plan_attributes;

CREATE TABLE `installment_plan_attributes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `installment_plan_id` int(10) unsigned NOT NULL,
  `payment_head_id` int(10) unsigned NOT NULL,
  `value` double(8,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `installment_plan_attributes_installment_plan_id_foreign` (`installment_plan_id`),
  KEY `installment_plan_attributes_payment_head_id_foreign` (`payment_head_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS installment_plans;

CREATE TABLE `installment_plans` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `plot_type` int(10) unsigned NOT NULL,
  `plot_size` int(10) unsigned NOT NULL,
  `cost_amount` double NOT NULL,
  `down_payment` double NOT NULL,
  `confirmation_fee` double NOT NULL,
  `plot_belting_fee` double DEFAULT NULL,
  `possession_fee` double NOT NULL,
  `installment` double NOT NULL,
  `total_months` int(11) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `six_installment` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `installment_plans_plot_type_foreign` (`plot_type`),
  KEY `installment_plans_plot_size_foreign` (`plot_size`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS inventories;

CREATE TABLE `inventories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `unit_category_id` int(10) unsigned DEFAULT NULL,
  `unit_size_id` int(10) unsigned NOT NULL,
  `unit_number` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_price` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `extra_amount_description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `extra_amount` double DEFAULT NULL,
  `unit_type_id` int(10) unsigned NOT NULL,
  `unit_floor_id` int(10) unsigned DEFAULT NULL,
  `name` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cnic` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone_number` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `dealer_id` int(11) DEFAULT NULL,
  `area` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `token_amount` int(11) DEFAULT NULL,
  `inventory_type` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `inventories_unit_category_id_foreign` (`unit_category_id`),
  KEY `inventories_unit_size_id_foreign` (`unit_size_id`),
  KEY `inventories_unit_floor_id_foreign` (`unit_floor_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO inventories VALUES("1","","1","LG-01","10935000","2022-12-23 00:55:37","2022-12-23 01:09:35","2","","","0","1","1","","","","","0","","","","0");



DROP TABLE IF EXISTS inventory_categories;

CREATE TABLE `inventory_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `inventory_id` int(10) unsigned NOT NULL,
  `unit_category_id` int(10) unsigned NOT NULL,
  `amount` double DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inventory_categories_inventory_id_foreign` (`inventory_id`),
  KEY `inventory_categories_plot_category_id_foreign` (`unit_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS inventory_old_names;

CREATE TABLE `inventory_old_names` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `inventory_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS item_manufactures;

CREATE TABLE `item_manufactures` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS item_purchase_order;

CREATE TABLE `item_purchase_order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `purchase_order_id` int(11) NOT NULL DEFAULT 0,
  `purchase_request_id` int(11) NOT NULL DEFAULT 0,
  `total_quantity` double(8,2) NOT NULL DEFAULT 0.00,
  `demand_quantity` double(8,2) NOT NULL DEFAULT 0.00,
  `item_id` int(11) NOT NULL DEFAULT 0,
  `price` double(8,2) NOT NULL DEFAULT 0.00,
  `received_quantity` double(8,2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `remaining_quantity` float NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS item_purchase_request;

CREATE TABLE `item_purchase_request` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `purchase_request_id` int(11) NOT NULL DEFAULT 0,
  `item_id` int(11) NOT NULL DEFAULT 0,
  `quantity` double(8,2) NOT NULL DEFAULT 0.00,
  `remaining_quantity` double(8,2) NOT NULL DEFAULT 0.00,
  `receive_quantity` double(8,2) NOT NULL DEFAULT 0.00,
  `price` double(8,2) NOT NULL DEFAULT 0.00,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS item_purchase_request_vendor;

CREATE TABLE `item_purchase_request_vendor` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `purchase_request_vendor_id` int(11) NOT NULL DEFAULT 0,
  `item_id` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS item_releasing_data;

CREATE TABLE `item_releasing_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_releasing_id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL,
  `item_quantity` int(11) NOT NULL,
  `return_quantity` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS item_releasings;

CREATE TABLE `item_releasings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `project_id` int(11) NOT NULL DEFAULT 0,
  `department_id` int(11) NOT NULL DEFAULT 0,
  `releaser_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `releasing_date` datetime DEFAULT NULL,
  `receiver_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `purchase_request_id` int(11) DEFAULT NULL,
  `mir_id` int(11) DEFAULT NULL,
  `returning_name` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS item_units;

CREATE TABLE `item_units` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS items;

CREATE TABLE `items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `item_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `item_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` enum('consumable','tools','direct_material') COLLATE utf8mb4_unicode_ci NOT NULL,
  `risk_type` enum('critical','non_critical') COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'critical or non critical items mean how much risk we take on item',
  `manufacture_id` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category_id` int(11) NOT NULL DEFAULT 0,
  `quantity` double NOT NULL DEFAULT 0,
  `size` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unit` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `minqty` int(11) NOT NULL DEFAULT 0,
  `maxqty` int(11) NOT NULL DEFAULT 0,
  `created_by` int(11) NOT NULL DEFAULT 0,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `available_quantity` int(11) NOT NULL DEFAULT 0,
  `fixed_asset_type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `depreciation_policy` enum('straight_line_method','reading_balance_method') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `depreciation_rate` int(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `items_item_code_unique` (`item_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS links;

CREATE TABLE `links` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(11) NOT NULL,
  `source` int(11) NOT NULL,
  `target` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS material_issue_request_data;

CREATE TABLE `material_issue_request_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mir_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `item_requesting_quantity` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS material_issue_requests;

CREATE TABLE `material_issue_requests` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pr_id` int(11) DEFAULT NULL,
  `department_id` int(11) DEFAULT NULL,
  `request_person_name` varchar(20) DEFAULT NULL,
  `request_date` date DEFAULT NULL,
  `status` enum('release','pending','partial_release') NOT NULL DEFAULT 'pending',
  `mir_type` tinyint(1) NOT NULL DEFAULT 0,
  `description` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS material_request_approvals;

CREATE TABLE `material_request_approvals` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `approval_id` int(11) DEFAULT NULL,
  `mir_id` int(11) DEFAULT NULL,
  `is_approve` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS merging_properties;

CREATE TABLE `merging_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mrf_no` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `maf_no` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `property_code` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `requested_by` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contact_no` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sale_agent_name` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city` int(11) NOT NULL,
  `street` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phase` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `area` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `demand_for_property` double NOT NULL DEFAULT 0,
  `details` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `merging_value` double NOT NULL DEFAULT 0,
  `merging_assessed_value` double NOT NULL DEFAULT 0,
  `appraised_by` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `appraised_by_sale_agent` enum('yes','no') COLLATE utf8_unicode_ci NOT NULL,
  `assessment_amount` double NOT NULL DEFAULT 0,
  `assessment_adjusted_against` enum('rebate','cash') COLLATE utf8_unicode_ci NOT NULL,
  `employee_id` int(11) DEFAULT 0,
  `visit_time` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contact_person_at_location` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contact_person_no` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `requestor_accompanied` enum('yes','no') COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_approve` tinyint(1) NOT NULL DEFAULT 0 COMMENT '1-approve , 2-disapprove , 0-pending',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;




DROP TABLE IF EXISTS migrations;

CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=158 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO migrations VALUES("1","2014_10_12_000000_create_users_table","1"),
("2","2014_10_12_100000_create_password_resets_table","1"),
("3","2019_04_23_054422_create_customers_table","1"),
("4","2019_04_24_052527_create_customer_properties_table","1"),
("5","2019_04_24_052640_create_customer_statements_table","1"),
("6","2019_04_24_065638_create_product_sizes_table","1"),
("7","2019_04_24_070836_create_dealers_table","1"),
("8","2019_04_24_072354_create_dealer_transactions_table","1"),
("9","2019_04_24_104939_create_installment_plans_table","2"),
("10","2019_05_02_052748_create_purchases_table","3"),
("11","2019_05_02_053005_create_expenses_table","3"),
("12","2019_05_02_064913_update_customer_property_schedular","4"),
("13","2019_05_06_055828_create_employees_table","5"),
("14","2019_05_06_061220_create_departments_table","5"),
("15","2019_05_06_061258_create_designations_table","5"),
("16","2019_05_06_061519_update_employee_desgination_department","5"),
("17","2019_05_08_055313_update_department_status","6"),
("18","2019_05_08_055440_update_designation_status","6"),
("19","2019_05_09_072613_create_policies_table","7"),
("20","2019_05_09_074302_update_custoemr_property","7"),
("21","2019_05_10_060843_create_employee_policies_table","8"),
("22","2019_05_13_072306_create_payrolls_table","9"),
("23","2019_05_14_102747_create_payment_heads_table","10"),
("24","2019_05_14_105550_create_installment_plan_attributes_table","11"),
("25","2019_05_15_094740_create_receipts_table","12"),
("26","2019_05_20_055914_update_customer_property_dealer","13"),
("27","2019_05_20_064006_update_customer_property_netpay","14"),
("28","2019_05_20_065133_create_plot_categories_table","15"),
("29","2019_05_21_074213_create_dealer_paid_rebates_table","16"),
("31","2019_05_23_121053_create_product_types_table","17"),
("32","2019_05_24_062029_update_customer_propert_membership","18"),
("33","2019_05_29_092204_update_customer_statement_receipt","19"),
("34","2019_06_25_063006_update_customer_properties","20"),
("35","2019_06_26_070342_create_depositor_banks_table","21"),
("36","2019_07_02_051704_update_installmment_plans_new","22"),
("37","2019_07_03_061340_update_customer_properties__schedule_start_date","23"),
("38","2019_07_03_063328_update_customer_nominee_information","24"),
("39","2019_07_05_055903_update_customer_properties","25"),
("40","2019_07_05_061614_update_installmnet_plan_six_installment","26"),
("41","2019_07_08_060734_create_countries_table","27"),
("42","2019_07_08_060839_create_cities_table","27"),
("43","2019_07_08_061203_update_customer_address","28"),
("44","2019_07_08_071241_update_dealer_address","29"),
("45","2019_07_08_074714_create_customer_property_partners_table","30"),
("46","2019_07_09_052614_create_company_banks_table","31"),
("47","2019_07_09_095954_update_receipts_company_account","32"),
("48","2019_07_09_104518_create_company_bank_transactions_table","33"),
("49","2019_07_25_065653_create_transfer_properties_table","34"),
("50","2019_10_15_072619_create_inventories_table","35"),
("51","2019_10_16_071117_create_dealer_types_table","36"),
("52","2019_10_16_075046_update_dealer_type","37"),
("53","2019_10_17_071607_update_customer_property_inventory","38"),
("54","2019_10_18_052343_create_schedule_plans_table","39"),
("55","2019_10_18_065524_update_inventory_description","40"),
("56","2019_10_18_190459_create_project_accounts_table","41"),
("57","2019_10_18_191711_update_project_amount","42"),
("58","2019_10_19_125553_create_customer_property_buy_backs_table","43"),
("59","2019_10_22_080322_update_inventory_extra_charges","44"),
("60","2019_10_22_082921_update_expense_image","45"),
("61","2019_10_22_104716_update_dealer_parent","46"),
("62","2019_10_24_054426_update_project_account_type","47"),
("63","2019_10_24_060517_create_project_account_files_table","48"),
("64","2019_10_24_074225_update_project_account","49"),
("65","2019_10_30_045130_create_customer_property_buy_back_statements_table","50"),
("66","2019_11_11_101635_update_inventories_type","51"),
("67","2019_11_13_091926_create_unit_floors_table","52"),
("68","2019_11_13_092016_create_unit_floor_categories_table","52"),
("69","2019_11_13_120415_update_inventory_unit_floor","53"),
("70","2019_11_18_052303_update_receipt_adjacement","54"),
("71","2019_11_18_124654_update_scheduler_type","55"),
("72","2019_11_27_155121_create_customer_property_full_payments_table","56"),
("73","2019_11_27_155400_create_customer_property_full_payment_statements_table","57"),
("74","2019_11_27_213725_create_customer_adjustments_table","58"),
("75","2019_11_28_064448_create_payments_table","59"),
("76","2019_12_20_182748_create_plot_types_table","60"),
("77","2020_01_15_110148_create_registration_nos_table","61"),
("78","2020_01_15_125923_create_customer_registrations_table","62"),
("79","2020_01_27_110203_create_inventory_categories_table","63"),
("80","2020_01_27_194610_create_customer_documents_table","63"),
("81","2020_01_28_052239_update_block_sizes_add_reg","63"),
("82","2020_01_28_064115_update_customer_registration_add_registration","63"),
("83","2020_02_08_113134_create_dealer_registrations_table","63"),
("84","2020_03_19_062052_update_dealer_code","63"),
("85","2020_03_19_065448_create_customer_nominees_table","63"),
("86","2020_05_08_194445_create_activity_log_table","64"),
("87","2020_07_15_164649_entrust_setup_tables","64"),
("88","2020_07_21_114147_create_dealer_received_amounts_table","65"),
("89","2020_07_25_155038_update_registration_booking","66"),
("90","2020_07_25_184725_update_registration_printcount","67"),
("91","2020_07_25_184754_update_membership_printcount","67"),
("92","2020_09_12_124300_create_customer_requests_table","68"),
("93","2021_03_04_162515_create_property_chat_histories_table","69"),
("94","2021_03_23_184033_create_investors_table","70"),
("95","2021_03_23_185237_create_investor_documents_table","71"),
("96","2021_03_23_185932_update_investor","71"),
("97","2021_03_23_191020_update_investor_is_delete","72"),
("98","2021_03_23_202226_create_investor_files_table","73"),
("99","2019_06_25_063006_update_customer_propertiesbelting","1"),
("100","2019_06_25_063006_update_customer_propertiesbelting","1"),
("101","2021_02_22_000728_create_vendors_table","1"),
("102","2021_02_22_000728_create_vendors_table","1"),
("103","2021_02_22_015128_create_account_transfers_table","1"),
("104","2021_02_22_015128_create_account_transfers_table","1"),
("105","2021_03_05_004106_create_expense_categories_table","1"),
("106","2021_03_05_004106_create_expense_categories_table","1"),
("107","2021_03_05_155219_create_expense_payments_table","1"),
("108","2021_03_05_155219_create_expense_payments_table","1"),
("109","2021_05_26_121802_create_account_types_table","1"),
("110","2021_05_26_121802_create_account_types_table","1"),
("111","2021_05_26_162438_create_chart_of_accounts_table","1"),
("112","2021_05_26_162438_create_chart_of_accounts_table","1"),
("113","2021_05_27_114858_create_general_journal_entries_table","1"),
("114","2021_05_27_114858_create_general_journal_entries_table","1"),
("115","2021_06_07_164911_create_account_classes_table","1"),
("116","2021_06_07_164911_create_account_classes_table","1"),
("117","2022_01_11_002028_create_unit_blocks_table","1"),
("118","2022_01_11_002028_create_unit_blocks_table","1"),
("119","2022_11_14_113805_add_new_col_in_customer_statements_table","74"),
("120","2022_12_05_173555_create_noc_table","1"),
("121","2022_12_12_144559_create_transfer_property_histories_table","75"),
("122","2022_12_12_144747_add_column_transferpropertyhistoryid_in_transfer_properties_table","75"),
("123","2022_12_12_134559_create_transfer_property_histories_table","76"),
("124","2022_12_12_124559_create_transfer_property_histories_table","77"),
("125","2022_12_13_120355_add_column_unit_detail_in_transfer_properties_table","78"),
("126","2022_12_15_114158_create_cancel_properties_table","79"),
("127","2022_12_16_110647_create_unit_refund_histories_table","80"),
("128","2022_12_16_110956_add_column_unit_redund_history_id_in_cancel_properties_table","80"),
("129","2022_12_16_152610_add_refund_or_adjust_column_in_cancel_properties","81"),
("130","2022_12_16_172610_add_refund_or_adjust_column_in_cancel_properties","82"),
("131","2022_12_18_172610_add_refund_or_adjust_column_in_cancel_properties","83"),
("132","2022_12_19_111849_create_statement_histories_table","84"),
("133","2022_12_19_112320_add_total_deduction_percentage_in_unit_refund_histories_table","85"),
("134","2022_12_19_172610_add_refund_or_adjust_column_in_cancel_properties","86"),
("135","2022_12_20_115617_add_block_date_column_in_customer_properties_table","87"),
("136","2022_12_20_133032_create_unit_adjusts_table","88"),
("137","2022_12_20_170952_add_unit_adjust_id_in_statement_histories_table","89"),
("138","2022_12_14_110453_create_customers_fingerprints_table","90"),
("139","2022_12_21_113346_add_unit_detail_col_in_unit_refund_histories_table","90"),
("140","2022_12_21_115929_add_unit_detail__col_in_unit_adjusts_table","90"),
("141","2022_12_22_192811_create_table_customer_fingerprints","91"),
("142","2022_12_21_145402_add_ua_no_col_in_unit_adjusts_table","92"),
("143","2022_12_22_111257_add_voucher_generated_col_in_cancel_properties_table","92"),
("144","2022_12_22_114509_add_cancel_property_id_in_unit_refund_histories_table","92"),
("145","2022_12_22_144201_add_cancel_property_id_in_unit_adjusts_table","92"),
("146","2022_12_23_193944_add_cancel_property_id_in_receipts_table","92"),
("147","2022_12_26_151816_create_open_file_dealer_infos_table","92"),
("148","2022_12_26_153225_add_of_no_column_in_open_file_dealer_infos_table","92"),
("149","2022_12_26_173546_add_open_file_dealer_payment_id_in_open_file_dealer_infos_table","92"),
("150","2022_12_26_173810_create_open_file_dealer_payments_table","92"),
("151","2022_12_27_175816_create_open_file_packages_table","92"),
("152","2022_12_27_180619_create_open_file_package_details_table","92"),
("153","2022_12_27_181541_add_name_col_in_open_file_packages_table","92"),
("154","2022_12_28_120611_create_project_types_table","92"),
("155","2022_12_28_122927_add_colum_project_type_id_in_unit_types_table","92"),
("156","2022_12_28_125032_create_price_lists_table","92"),
("157","2022_12_28_125215_create_price_list_details_table","92");



DROP TABLE IF EXISTS noc;

CREATE TABLE `noc` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `noc_no` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_id` int(11) NOT NULL,
  `unit_number_id` bigint(20) NOT NULL,
  `status` tinyint(4) NOT NULL COMMENT '0 > Pending, 1 > Approve',
  `noc_date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS open_file_dealer_infos;

CREATE TABLE `open_file_dealer_infos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `openfile_dealer_payment_id` bigint(20) NOT NULL,
  `of_no` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `dealer_id` bigint(20) NOT NULL,
  `invertory_id` bigint(20) NOT NULL,
  `issue_date` date NOT NULL,
  `valid_until_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS open_file_dealer_payments;

CREATE TABLE `open_file_dealer_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `amount` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS open_file_package_details;

CREATE TABLE `open_file_package_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `openfile_package_id` bigint(20) NOT NULL,
  `unit_type_id` bigint(20) DEFAULT NULL,
  `unit_size_id` bigint(20) DEFAULT NULL,
  `unit_quantity` bigint(20) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO open_file_package_details VALUES("1","1","1","1","2","2022-12-28 17:58:16","2022-12-28 17:58:16");



DROP TABLE IF EXISTS open_file_packages;

CREATE TABLE `open_file_packages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pricelist_id` bigint(20) DEFAULT NULL,
  `total_price` bigint(20) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO open_file_packages VALUES("1","test","","","2022-12-28 17:58:16","2022-12-28 17:58:16");



DROP TABLE IF EXISTS otps;

CREATE TABLE `otps` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `phone_number` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `otp` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reason` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS password_resets;

CREATE TABLE `password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS payment_head_priorities;

CREATE TABLE `payment_head_priorities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_head` int(11) NOT NULL DEFAULT 0,
  `priority` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

INSERT INTO payment_head_priorities VALUES("1","1","1","2022-12-23 00:52:49","2022-12-23 00:52:49"),
("2","2","3","2022-12-23 00:52:49","2022-12-23 00:52:49"),
("3","3","2","2022-12-23 00:52:49","2022-12-23 00:52:49"),
("4","8","4","2022-12-23 00:52:49","2022-12-23 00:52:49"),
("5","9","5","2022-12-23 00:52:49","2022-12-23 00:52:49"),
("6","10","6","2022-12-23 00:52:49","2022-12-23 00:52:49"),
("7","11","7","2022-12-23 00:52:49","2022-12-23 00:52:49"),
("8","12","8","2022-12-23 00:52:49","2022-12-23 00:52:49"),
("9","13","9","2022-12-23 00:52:49","2022-12-23 00:52:49");



DROP TABLE IF EXISTS payment_heads;

CREATE TABLE `payment_heads` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS payments;

CREATE TABLE `payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int(10) unsigned NOT NULL,
  `property_id` int(10) unsigned NOT NULL,
  `payment_type` int(11) NOT NULL DEFAULT 1,
  `payment_mode` int(11) NOT NULL DEFAULT 1,
  `bank_name` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cheque_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cheque_title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` double NOT NULL,
  `receipt_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payments_customer_id_foreign` (`customer_id`),
  KEY `payments_property_id_foreign` (`property_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS payrolls;

CREATE TABLE `payrolls` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` int(10) unsigned DEFAULT NULL,
  `benefits` double DEFAULT NULL,
  `deductions` double DEFAULT NULL,
  `net_pay` double NOT NULL,
  `date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payrolls_employee_id_foreign` (`employee_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS permission_role;

CREATE TABLE `permission_role` (
  `permission_id` int(10) unsigned NOT NULL,
  `role_id` int(10) unsigned NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2348 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO permission_role VALUES("1","6","2"),
("1","7","3"),
("2","7","5"),
("3","7","7"),
("5","7","10"),
("6","6","12"),
("6","7","13"),
("7","7","15"),
("9","6","18"),
("9","7","19"),
("10","7","22"),
("11","7","24"),
("13","7","27"),
("14","6","29"),
("14","7","30"),
("15","7","33"),
("16","7","35"),
("17","7","37"),
("18","7","40"),
("20","7","43"),
("21","8","45"),
("22","8","47"),
("24","7","50"),
("24","8","51"),
("25","7","54"),
("26","7","56"),
("27","7","58"),
("29","7","61"),
("31","7","64"),
("35","7","69"),
("36","7","71"),
("100","7","120"),
("101","7","122"),
("102","7","124"),
("103","7","126"),
("112","8","136"),
("196","13","543"),
("197","13","544"),
("198","13","545"),
("199","13","546"),
("200","13","547"),
("201","13","548"),
("202","13","549"),
("203","13","550"),
("204","13","551"),
("205","13","552"),
("206","13","553"),
("64","13","554"),
("65","13","555"),
("66","13","556"),
("67","13","557"),
("113","13","558"),
("114","13","559"),
("115","13","560"),
("116","13","561"),
("125","13","562"),
("126","13","563"),
("127","13","564"),
("128","13","565"),
("129","13","566"),
("130","13","567"),
("131","13","568"),
("132","13","569"),
("133","13","570"),
("134","13","571"),
("135","13","572"),
("136","13","573"),
("137","13","574"),
("138","13","575"),
("139","13","576"),
("140","13","577"),
("141","13","578"),
("142","13","579"),
("143","13","580"),
("144","13","581"),
("145","13","582"),
("146","13","583"),
("147","13","584"),
("148","13","585"),
("149","13","586"),
("150","13","587"),
("151","13","588"),
("152","13","589"),
("153","13","590"),
("154","13","591"),
("155","13","592"),
("156","13","593"),
("157","13","594"),
("158","13","595"),
("159","13","596"),
("160","13","597"),
("166","13","598"),
("167","13","599"),
("168","13","600"),
("169","13","601"),
("191","13","602"),
("192","13","603"),
("193","13","604"),
("194","13","605"),
("195","13","606"),
("135","9","607"),
("136","9","608"),
("137","9","609"),
("138","9","610"),
("139","9","611"),
("135","14","635"),
("136","14","636"),
("137","14","637"),
("140","14","638"),
("141","14","639"),
("142","14","640"),
("143","14","641"),
("144","14","642"),
("145","14","643"),
("146","14","644"),
("147","14","645"),
("148","14","646"),
("149","14","647"),
("150","14","648"),
("151","14","649"),
("152","14","650"),
("153","14","651"),
("154","14","652"),
("155","14","653"),
("156","14","654"),
("157","14","655"),
("159","14","656"),
("160","14","657"),
("1","0","673"),
("2","0","674"),
("3","0","675"),
("4","0","676"),
("5","0","677"),
("6","0","678"),
("7","0","679"),
("8","0","680"),
("9","0","681"),
("10","0","682"),
("11","0","683"),
("12","0","684"),
("13","0","685"),
("14","0","686"),
("15","0","687"),
("16","0","688"),
("17","0","689"),
("18","0","690"),
("19","0","691"),
("20","0","692"),
("21","0","693"),
("22","0","694"),
("23","0","695"),
("24","0","696"),
("25","0","697"),
("26","0","698"),
("27","0","699"),
("28","0","700"),
("29","0","701"),
("30","0","702"),
("31","0","703"),
("32","0","704"),
("33","0","705"),
("34","0","706"),
("39","0","707"),
("40","0","708"),
("41","0","709"),
("42","0","710"),
("55","0","711"),
("56","0","712"),
("57","0","713"),
("59","0","714"),
("60","0","715"),
("61","0","716"),
("62","0","717"),
("63","0","718"),
("76","0","719"),
("77","0","720"),
("78","0","721"),
("79","0","722"),
("84","0","723"),
("85","0","724"),
("86","0","725"),
("87","0","726"),
("88","0","727"),
("89","0","728"),
("90","0","729"),
("91","0","730"),
("92","0","731"),
("93","0","732"),
("94","0","733"),
("95","0","734"),
("96","0","735"),
("97","0","736"),
("98","0","737"),
("99","0","738"),
("100","0","739"),
("101","0","740"),
("102","0","741"),
("103","0","742"),
("104","0","743"),
("105","0","744"),
("110","0","745"),
("112","0","746"),
("117","0","747"),
("124","0","748"),
("161","0","749"),
("162","0","750"),
("163","0","751"),
("164","0","752"),
("165","0","753"),
("187","0","754"),
("188","0","755"),
("189","0","756"),
("35","0","757"),
("36","0","758"),
("37","0","759"),
("38","0","760"),
("51","0","761"),
("52","0","762"),
("53","0","763"),
("54","0","764"),
("58","0","765"),
("72","0","766"),
("73","0","767"),
("74","0","768"),
("75","0","769"),
("106","0","770"),
("107","0","771"),
("108","0","772"),
("109","0","773"),
("111","0","774"),
("118","0","775"),
("119","0","776"),
("120","0","777"),
("121","0","778"),
("122","0","779"),
("123","0","780"),
("170","0","781"),
("171","0","782"),
("172","0","783"),
("173","0","784"),
("174","0","785"),
("175","0","786"),
("176","0","787"),
("177","0","788"),
("178","0","789"),
("179","0","790"),
("180","0","791"),
("181","0","792"),
("182","0","793"),
("183","0","794"),
("184","0","795"),
("185","0","796"),
("186","0","797"),
("190","0","798"),
("208","12","818"),
("1","1","2126"),
("2","1","2127"),
("3","1","2128"),
("4","1","2129"),
("5","1","2130"),
("6","1","2131"),
("7","1","2132"),
("8","1","2133"),
("9","1","2134"),
("10","1","2135"),
("11","1","2136"),
("12","1","2137"),
("13","1","2138"),
("14","1","2139"),
("15","1","2140"),
("16","1","2141"),
("17","1","2142"),
("18","1","2143"),
("19","1","2144"),
("20","1","2145"),
("21","1","2146"),
("22","1","2147"),
("23","1","2148"),
("24","1","2149"),
("25","1","2150"),
("26","1","2151"),
("27","1","2152"),
("28","1","2153"),
("29","1","2154"),
("30","1","2155"),
("31","1","2156"),
("32","1","2157"),
("33","1","2158"),
("34","1","2159"),
("39","1","2160"),
("40","1","2161"),
("41","1","2162"),
("42","1","2163"),
("55","1","2164"),
("56","1","2165"),
("57","1","2166"),
("59","1","2167"),
("60","1","2168"),
("61","1","2169"),
("62","1","2170"),
("63","1","2171"),
("76","1","2172"),
("77","1","2173"),
("78","1","2174"),
("79","1","2175"),
("84","1","2176"),
("85","1","2177"),
("86","1","2178"),
("87","1","2179"),
("88","1","2180"),
("89","1","2181"),
("90","1","2182"),
("91","1","2183"),
("92","1","2184"),
("93","1","2185"),
("94","1","2186"),
("95","1","2187"),
("96","1","2188"),
("97","1","2189"),
("98","1","2190"),
("99","1","2191"),
("100","1","2192"),
("101","1","2193"),
("102","1","2194"),
("103","1","2195"),
("104","1","2196"),
("105","1","2197"),
("110","1","2198"),
("112","1","2199"),
("117","1","2200"),
("124","1","2201"),
("161","1","2202"),
("162","1","2203"),
("163","1","2204"),
("164","1","2205"),
("165","1","2206"),
("187","1","2207"),
("188","1","2208"),
("189","1","2209"),
("196","1","2210"),
("197","1","2211"),
("198","1","2212"),
("199","1","2213"),
("200","1","2214"),
("201","1","2215"),
("202","1","2216"),
("203","1","2217"),
("204","1","2218"),
("205","1","2219"),
("206","1","2220"),
("207","1","2221"),
("208","1","2222"),
("209","1","2223"),
("210","1","2224"),
("211","1","2225"),
("212","1","2226"),
("213","1","2227"),
("214","1","2228"),
("215","1","2229"),
("216","1","2230"),
("217","1","2231"),
("218","1","2232"),
("219","1","2233"),
("220","1","2234"),
("221","1","2235"),
("222","1","2236"),
("224","1","2237"),
("225","1","2238"),
("226","1","2239"),
("227","1","2240"),
("228","1","2241"),
("229","1","2242"),
("230","1","2243"),
("231","1","2244"),
("232","1","2245"),
("234","1","2246"),
("235","1","2247"),
("236","1","2248"),
("237","1","2249"),
("238","1","2250"),
("239","1","2251"),
("240","1","2252"),
("241","1","2253"),
("242","1","2254"),
("35","1","2255"),
("36","1","2256"),
("37","1","2257"),
("38","1","2258"),
("51","1","2259"),
("52","1","2260"),
("53","1","2261"),
("54","1","2262"),
("58","1","2263"),
("72","1","2264"),
("73","1","2265"),
("74","1","2266"),
("75","1","2267"),
("106","1","2268"),
("107","1","2269"),
("108","1","2270"),
("109","1","2271"),
("111","1","2272"),
("118","1","2273"),
("119","1","2274"),
("120","1","2275"),
("121","1","2276"),
("122","1","2277"),
("123","1","2278"),
("170","1","2279"),
("171","1","2280"),
("172","1","2281"),
("173","1","2282"),
("174","1","2283"),
("175","1","2284"),
("176","1","2285"),
("177","1","2286"),
("178","1","2287"),
("179","1","2288"),
("180","1","2289"),
("181","1","2290"),
("182","1","2291"),
("183","1","2292"),
("184","1","2293"),
("185","1","2294"),
("186","1","2295"),
("190","1","2296"),
("64","1","2297"),
("65","1","2298"),
("66","1","2299"),
("67","1","2300"),
("113","1","2301"),
("114","1","2302"),
("115","1","2303"),
("116","1","2304"),
("125","1","2305"),
("126","1","2306"),
("127","1","2307"),
("128","1","2308"),
("129","1","2309"),
("130","1","2310"),
("131","1","2311"),
("132","1","2312"),
("133","1","2313"),
("134","1","2314"),
("135","1","2315"),
("136","1","2316"),
("137","1","2317"),
("138","1","2318"),
("139","1","2319"),
("140","1","2320"),
("141","1","2321"),
("142","1","2322"),
("143","1","2323"),
("144","1","2324"),
("145","1","2325"),
("146","1","2326"),
("147","1","2327"),
("148","1","2328"),
("149","1","2329"),
("150","1","2330"),
("151","1","2331"),
("152","1","2332"),
("153","1","2333"),
("154","1","2334"),
("155","1","2335"),
("156","1","2336"),
("159","1","2337"),
("160","1","2338"),
("166","1","2339"),
("167","1","2340"),
("168","1","2341"),
("169","1","2342"),
("191","1","2343"),
("192","1","2344"),
("193","1","2345"),
("194","1","2346"),
("195","1","2347");



DROP TABLE IF EXISTS permissions;

CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `display_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `department` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permissions_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=243 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO permissions VALUES("1","create-customer","Create Customers","Create New Customer","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("2","view-customer","View Customers","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("3","edit-customer","Edit Customers","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("4","delete-customer","Delete Customers","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("5","create-inventory","Create Inventories","Create New Inventory","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("6","view-inventory","View Inventories","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("7","edit-inventory","Edit Inventories","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("8","delete-inventory","Delete Inventories","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("9","create-registration","Create Registrations","Create New Registration","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("10","print-registration","Print Registrations","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("11","edit-registration","Edit Registrations","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("12","delete-registration","Delete Registrations","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("13","download-registration","Download Registrations","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("14","create-membership","Create Memberships","Create New Membership","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("15","view-membership","View Memberships","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("16","print-membership","Print Memberships","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("17","edit-membership","Edit Memberships","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("18","create-schedule","Create Schedules","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("19","delete-membership","Delete Memberships","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("20","download-membership","Download Memberships","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("21","sms-membership","Sms Memberships","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("22","reminder-membership","Reminder Memberships","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("23","approve-membership","Approve Memberships","Approve New Membership","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("24","create-receipt","Create Receipts","Create New Receipt","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("25","view-receipt","View receipts","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("26","print-receipt","Print Receipts","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("27","edit-receipt","Edit Receipts","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("28","delete-receipt","Delete Receipts","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("29","download-receipt","Download Receipts","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("30","create-dealer","Create Dealers","Create New Dealer","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("31","view-dealer","View Dealers","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("32","edit-dealer","Edit Dealers","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("33","delete-dealer","Delete Dealers","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("34","sms-dealer","Sms Dealer Clients","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("35","create-bank-account","Create Bank Account","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("36","view-bank-account","View Bank Account","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("37","edit-bank-account","Edit Bank Account","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("38","delete-bank-account","Delete Bank Account","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("39","create-dealer-rebate","Create Dealer Rebate","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("40","view-dealer-rebate","View Dealer Rebate","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("41","edit-dealer-rebate","Edit Dealer Rebate","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("42","delete-dealer-rebate","Delete Dealer Rebate","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("43","create-customer-adjustment","Create Customer Adjustment","","0000-00-00 00:00:00","0000-00-00 00:00:00","0"),
("44","view-customer-adjustment","View Customer Adjustment","","0000-00-00 00:00:00","0000-00-00 00:00:00","0"),
("45","edit-customer-adjustment","Edit Customer Adjustment","","0000-00-00 00:00:00","0000-00-00 00:00:00","0"),
("46","delete-customer-adjustment","Delete Customer Adjustment","","0000-00-00 00:00:00","0000-00-00 00:00:00","0"),
("47","create-expense","Create Expense","","0000-00-00 00:00:00","0000-00-00 00:00:00","0"),
("48","view-expense","View Expense","","0000-00-00 00:00:00","0000-00-00 00:00:00","0"),
("49","edit-expense","Edit Expense","","0000-00-00 00:00:00","0000-00-00 00:00:00","0"),
("50","delete-expense","Delete Expense","","0000-00-00 00:00:00","0000-00-00 00:00:00","0"),
("51","create-employee","Create Emplpoyee","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("52","view-employee","View Employee","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("53","edit-employee","Edit Employee","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("54","delete-employee","Delete Employee","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("55","manage-payroll","Manage Payroll","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("56","manage-policy","Manage Policy","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("57","view-recovery-report","View Recovery Report","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("58","view-profit-loss-report","view Profit loss Report","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("59","view-rebate-report","View Rebate Report","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("60","manage-messages","Manage Customer Messages","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("61","view-activity-log","view Activity Logs","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("62","view-activity-download-log","View Activity Download Logs","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("63","manage-trashbox","Manage Trash Box","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("64","create-department","Create Department","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("65","view-department","View Department","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("66","edit-department","Edit Department","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("67","delete-department","Delete Department","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("68","create-designation","Create Designation","","0000-00-00 00:00:00","0000-00-00 00:00:00","0"),
("69","view-designation","View Designation","","0000-00-00 00:00:00","0000-00-00 00:00:00","0"),
("70","edit-designation","Edit Designation","","0000-00-00 00:00:00","0000-00-00 00:00:00","0"),
("71","delete-designation","Delete Designation","","0000-00-00 00:00:00","0000-00-00 00:00:00","0"),
("72","create-account","Create Account","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("73","view-account","View Account","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("74","edit-account","Edit Account","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("75","delete-account","Delete Account","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("76","create-dealer-type","Create Dealer Type","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("77","view-dealer-type","View Dealer Type","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("78","edit-dealer-type","Edit Dealer Type","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("79","delete-dealer-type","Delete Dealer Type","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("80","create-reg-no","Create Registration No.","","0000-00-00 00:00:00","0000-00-00 00:00:00","0"),
("81","view-reg-no","View Registration No.","","0000-00-00 00:00:00","0000-00-00 00:00:00","0"),
("82","edit-reg-no","Edit Registration No.","","0000-00-00 00:00:00","0000-00-00 00:00:00","0"),
("83","delete-reg-no","Delete Registration No.","","0000-00-00 00:00:00","0000-00-00 00:00:00","0"),
("84","create-unit-category","Create Unit Category","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("85","view-unit-category","View Unit Category","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("86","edit-unit-category","Edit Unit Category","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("87","delete-unit-category","Delete Unit Category","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("88","create-unit-type","Create Unit Type","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("89","view-unit-type","View Unit Type","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("90","edit-unit-type","Edit Unit Type","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("91","delete-unit-type","Delete Unit Type","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("92","create-unit-size","Create Unit Size","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("93","view-unit-size","View Unit Size","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("94","edit-unit-size","Edit Unit Size","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("95","delete-unit-size","Delete Unit Size","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("96","create-unit-floor","Create Unit Floor","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("97","view-unit-floor","View Unit Floor","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("98","edit-unit-floor","Edit Unit floor","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("99","delete-unit-floor","Delete Unit Floor","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("100","list-customer","List of Customers","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("101","list-inventory","List of Inventories","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("102","list-registration","List of Registrations","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("103","list-membership","List of Memberships","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("104","list-receipt","List of Receipts","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("105","list-dealer","List of Dealers","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("106","list-bank-account","List of Bank Accounts","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("107","list-dealer-rebate","List of Dealer Rebates","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("108","list-customer-adjustment","List of Customer Adjustment","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("109","list-expense","List of Expenses","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("110","list-employee","List of Employees","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("111","dealer-payment","Manage Dealer Payment","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("112","due-payments","Manage Due Payment Clients","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("113","create-vendor","Create Vendor","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("114","view-vendor","View Vendor","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("115","edit-vendor","Edit Vendor","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("116","delete-vendor","Delete Vendor","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("117","view-aging-report","View Aging Report","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("118","view-balance-sheet","View Balance Sheet","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("119","view-chart-of-account","View Chart of Account","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("120","create-chart-of-account","Create Chart of Account","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("121","edit-chart-of-account","Edit Chart of Account","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("122","delete-chart-of-account","Delete Chart of Account","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("123","list-chart-of-account","List Chart of Account","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("124","follow-up","Manage Follow up","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("125","create-item-category","Create Item Category","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("126","list-item-category","List Item Category","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("127","edit-item-category","Edit Item Category","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("128","delete-item-category","Delete Item Category","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("129","list-item","List Item","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("130","create-item","Create Item","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("131","edit-item","Edit Item","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("132","view-item","View Item","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("133","delete-item","Delete Item","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("134","releasing-item","Releasing Item","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("135","list-purchase-request","List Purchase Request","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("136","create-purchase-request","Create Purchase Request","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("137","view-purchase-request","View Purchase Request","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("138","edit-purchase-request","Edit Purchase Request","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("139","delete-purchase-request","Delete Purchase Request","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("140","list-request-for-quotation","List Request For Quotation","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("141","create-request-for-quotation","Create Request For Quotation","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("142","view-request-for-quotation","View Request For Quotation","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("143","edit-request-for-quotation","Edit Request For Quotation","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("144","delete-request-for-quotation","Delete Request For Quotation","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("145","send-request-for-quotation","Send Request For Quotation","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("146","list-comparative-statement","List Comparative Statement","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("147","view-comparative-statement","View Comparative Statement","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("148","send-comparative-statement","Send Comparative Statement","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("149","list-purchase-order","List Purchase Order","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("150","create-purchase-order","Create Purchase Order","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("151","view-purchase-order","View Purchase Order","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("152","edit-purchase-order","Edit Purchase Order","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("153","delete-purchase-order","Delete Purchase Order","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("154","list-po-receipt","List PO Receipt","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("155","view-po-receipt","View PO Receipt","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("156","pay-po-receipt","Pay PO Receipt","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("157","manage-procurement-dashboard","Manage Procurement Dashboard","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("158","manage-department-dashboard","Manage Department Dashboard","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("159","item-in-out-report","Item Int/Out Report","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("160","item-valuation-report","Item Valuation Report","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("161","manage-sales-dashboard","Manage Sales Dashboard","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("162","create-customer-discount-payment","Create Customer Discount Payment","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("163","edit-customer-discount-payment","Edit Customer Discount Payment","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("164","delete-customer-discount-payment","Delete Customer Discount Payment","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("165","view-customer-discount-payment","View Customer Discount Payment","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("166","releasing-item-view","Releasing Item View","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("167","item-aging-report","Item Aging Report","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("168","approval-pending-comparative-statement","Approval Pending Comparative Statement","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("169","approve-po","Approve PO","","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("170","voucher-check","Voucher Check","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("171","voucher-post","Voucher Post","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("172","manage-account-dashboard","Manage Account Dashboard","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("173","create-voucher","Create Voucher","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("174","view-voucher","View Voucher","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("175","delete-voucher","Delete Voucher","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("176","edit-voucher","Edit Voucher","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("177","list-voucher","List Voucher","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("178","reversal-voucher","Reversal Voucher","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("179","print-voucher","Print Voucher","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("180","manage-customer-voucher","Manage Customer Voucher","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("181","manage-vendor-voucher","Manage Vendor Voucher","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("182","manage-dealer-voucher","Manage Dealer Voucher","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("183","manage-employee-voucher","Manage Employee Voucher","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("184","manage-reconciliation","Manage Bank Reconciliation","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("185","view-trial-balance","View Trial Balance Report","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("186","view-cash-flow-statement","View Cash Flow Statement","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("187","view-dealer-commission","View Dealer Commission Report","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("188","view-sold-inventory","View Sold Inventory Report","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("189","view-received-amount","View Received Amount Report","","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("190","view-general-ledger","View General Ledger","","0000-00-00 00:00:00","0000-00-00 00:00:00","2"),
("191","edit-item-manufacture","Edit Item Manufacture","edit Item Manufacture","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("192","delete-item-manufacture","Delete Item Manufacture","delete Item Manufacture","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("193","create-item-manufacture","Create Item Manufacture","Create New Item Manufacture","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("194","item-manufacture","Item Manufacture","Create New Item Manufacture","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("195","work-order","Work Order","Work Order","0000-00-00 00:00:00","0000-00-00 00:00:00","3"),
("196","return-item","Return Item","Return Item","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("197","returning-item-view","Returning Item View","Returning Item View","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("198","item-variance-report","Item Variance Report","Item Variance Report","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("199","item-unit","Item Unit","Item Unit","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("200","store-keeper","Store Keeper","Store Keeper","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("201","store-keeper-view-item-list","Store Keeper View Item List","Store Keeper View Item List","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("202","fixed-assets","Fixed Assets","Fixed Assets","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("203","fixed-asset-types","Fixed Asset Types","Fixed Asset Types","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("204","asset-location","Asset Location","Asset Location","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("205","fixed-assets-maintainance","Fixed Assets Maintainance","Fixed Assets Maintainance","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("206","hrm","HRM","HRM","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("207","approve-receipt","Approve Receipt","Approve Receipt","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("208","mir","Material Issue Request","Material Issue Request (MIR)","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("209","voucher-valid-date","Voucher Valid Date","Voucher Valid Date","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("210","inventory-report","Inventory Report","Inventory Report","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("211","merging-properties-approval","Merging Properties Approval","Merging Properties Approval","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("212","merging-properties-requisition","Merging Properties Requisition","Merging Properties Requisition","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("213","merging-properties","Merging Properties","Merging Properties","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("214","buyback-payment","Buy Back Payment","Buy Back Payment","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("215","buyback-properties","Buy Back Properties","Buy Back Properties","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("216","buy-back-approval","Buy Back Approval","Buy Back Approval","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("217","buy-back-requisition","Buy Back Requisition","Buy Back Requisition","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("218","reopen-membership","Reopen Membership","Reopen Membership","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("219","roll-over-requisition","Roll Over Requisition","Roll Over Requisition","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("220","roll-over-approval","Roll Over Approval","Roll Over Approval","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("221","roll-over-properties","Roll Over Properties","Roll Over Properties","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("222","roll-over-payment","Roll Over Payment","Roll Over Payment","0000-00-00 00:00:00","0000-00-00 00:00:00","1"),
("224","create-noc","Create NOC","Create New NOC","2022-12-05 11:31:45","2022-12-05 11:31:45","1"),
("225","edit-noc","Edit NOC","","2022-12-05 11:31:45","2022-12-05 11:31:45","1"),
("226","delete-noc","Delete NOC","","2022-12-05 11:31:45","2022-12-05 11:31:45","1"),
("227","view-noc","View NOC","","2022-12-05 11:31:45","2022-12-05 11:31:45","1"),
("228","download-noc","Download NOC","","2022-12-05 11:31:45","2022-12-05 11:31:45","1"),
("229","create-cancellation","Create Cancellation Property","Create New Cancellation Property","2022-12-15 13:14:36","2022-12-15 13:14:36","1"),
("230","edit-cancellation","Edit Cancellation Property","","2022-12-15 13:14:36","2022-12-15 13:14:36","1"),
("231","delete-cancellation","Delete Cancellation Property","","2022-12-15 13:14:36","2022-12-15 13:14:36","1"),
("232","view-cancellation","View Cancellation Property","","2022-12-15 13:14:36","2022-12-15 13:14:36","1"),
("234","approve-cancellation","Approve Cancellation Property","","2022-12-15 13:25:32","2022-12-15 13:25:32","1"),
("235","edit-refund","Edit Property Refund","Edit New Property Refund","2022-12-16 16:27:39","2022-12-16 16:27:39","1"),
("236","view-refund","View refund Property","","2022-12-16 16:27:39","2022-12-16 16:27:39","1"),
("237","view-block","View block Property","","2022-12-19 17:47:00","2022-12-19 17:47:00","1"),
("238","edit-block","Edit Block Property","","2022-12-19 17:47:00","2022-12-19 17:47:00","1"),
("239","create-block","Create Block Property ","Create Block","2022-12-19 17:47:00","2022-12-19 17:47:00","1"),
("240","delete-block","Delete block Property","","2022-12-19 17:47:00","2022-12-19 17:47:00","1"),
("241","view-adjust","View Adjust Property","","2022-12-20 12:27:34","2022-12-20 12:27:34","1"),
("242","edit-adjust","Edit Adjust Property","","2022-12-20 13:15:46","2022-12-20 13:15:46","1");



DROP TABLE IF EXISTS policies;

CREATE TABLE `policies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double NOT NULL,
  `type` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS pr_boq_items;

CREATE TABLE `pr_boq_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `task_id` int(11) DEFAULT NULL,
  `purchase_request_id` int(11) NOT NULL,
  `boq_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `rate_per_unit` double(8,2) DEFAULT NULL,
  `total_cost` double(8,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS price_list_details;

CREATE TABLE `price_list_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pricelist_id` bigint(20) NOT NULL,
  `unit_type_id` bigint(20) NOT NULL,
  `price` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO price_list_details VALUES("1","2","0","1000","2022-12-28 17:53:57","2022-12-28 17:53:57");



DROP TABLE IF EXISTS price_lists;

CREATE TABLE `price_lists` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `l_no` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `project_type_id` bigint(20) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO price_lists VALUES("1","LN-001","2","2022-12-28 17:53:27","2022-12-28 17:53:27"),
("2","LN-002","1","2022-12-28 17:53:57","2022-12-28 17:53:57"),
("3","LN-003","2","2022-12-28 17:58:30","2022-12-28 17:58:30");



DROP TABLE IF EXISTS product_types;

CREATE TABLE `product_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `start_from` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS products;

CREATE TABLE `products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_no` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_registration_no` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_size` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_category` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cost_amount` double NOT NULL,
  `sale_amount` double NOT NULL,
  `margin_amount` double DEFAULT NULL,
  `sold_amount` double DEFAULT NULL,
  `date_of_sold` date DEFAULT NULL,
  `creation_description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sold_description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dealer_id` int(10) unsigned DEFAULT NULL,
  `dealer_rebate` double DEFAULT NULL,
  `company_profit` double DEFAULT NULL,
  `product_status` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `title` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `map_address` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lat` float DEFAULT NULL,
  `lng` float DEFAULT NULL,
  `payment_type` int(11) DEFAULT NULL,
  `check_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `due_balance` double DEFAULT NULL,
  `customer_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `products_dealer_id_foreign` (`dealer_id`),
  KEY `products_customer_id_foreign` (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS project_account_files;

CREATE TABLE `project_account_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `project_account_id` int(10) unsigned NOT NULL,
  `file_url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_account_files_project_account_id_foreign` (`project_account_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS project_accounts;

CREATE TABLE `project_accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `inventory_id` int(10) unsigned NOT NULL,
  `payment_head` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `depositor_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payment_type` tinyint(1) NOT NULL,
  `amount` double NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `date` date NOT NULL,
  `adjacement_type` int(11) DEFAULT NULL,
  `pay_order_title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pay_order_date` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pay_order_bank_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_accounts_inventory_id_foreign` (`inventory_id`),
  KEY `project_accounts_pay_order_bank_id_foreign` (`pay_order_bank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS project_types;

CREATE TABLE `project_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO project_types VALUES("1","HighRise","2022-12-28 17:53:07","2022-12-28 17:53:07"),
("2","Society","2022-12-28 17:53:07","2022-12-28 17:53:07");



DROP TABLE IF EXISTS projects;

CREATE TABLE `projects` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `project_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `contact` bigint(20) NOT NULL DEFAULT 0,
  `address` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `projects_project_name_unique` (`project_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS property_chat_histories;

CREATE TABLE `property_chat_histories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `property_id` int(10) unsigned NOT NULL,
  `remarks` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `next_follow_up` date NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `status` varchar(156) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_assign` int(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `property_chat_histories_property_id_foreign` (`property_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS purchase_order_cancel_remarks;

CREATE TABLE `purchase_order_cancel_remarks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pr_id` int(11) DEFAULT NULL,
  `po_id` int(11) DEFAULT NULL,
  `vendor_id` int(11) DEFAULT NULL,
  `remark` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS purchase_order_receipt;

CREATE TABLE `purchase_order_receipt` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `purchase_order_id` int(11) NOT NULL DEFAULT 0,
  `vendor_id` int(11) NOT NULL DEFAULT 0,
  `receipt_date` datetime NOT NULL,
  `purchase_request_id` int(11) NOT NULL DEFAULT 0,
  `status` int(11) NOT NULL DEFAULT 3,
  `receipt_pay_date` datetime DEFAULT NULL,
  `total_amount` double(10,2) NOT NULL DEFAULT 0.00,
  `total_pay_amount` double(10,2) NOT NULL DEFAULT 0.00,
  `remaining_amount` double(10,2) NOT NULL DEFAULT 0.00,
  `quality_test_inspector_name` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quality_test_inspector_date` datetime DEFAULT NULL,
  `invoice_no` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `documents` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quality_insu_docs` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_officer_name` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_officer_name_date` datetime DEFAULT NULL,
  `po_receiver_name` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `po_receiveing_date` datetime DEFAULT NULL,
  `is_book` int(1) NOT NULL DEFAULT 0,
  `receipt_type` int(11) NOT NULL DEFAULT 1 COMMENT '1-purchase-order\r\n\r\n2-advance',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS purchase_order_vendors;

CREATE TABLE `purchase_order_vendors` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` bigint(20) NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cnic` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `vendors_phone_unique` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS purchase_orders;

CREATE TABLE `purchase_orders` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `purchase_request_id` int(11) NOT NULL DEFAULT 0,
  `vendor_id` int(11) NOT NULL DEFAULT 0,
  `status` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `delivery_date` datetime DEFAULT NULL,
  `receiver_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receiving_date` datetime DEFAULT NULL,
  `special_instruction` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_terms` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `advance` int(11) DEFAULT 0,
  `total_amount` double(8,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS purchase_requests;

CREATE TABLE `purchase_requests` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `department_id` int(11) NOT NULL DEFAULT 0,
  `created_by` int(11) NOT NULL DEFAULT 0,
  `status` int(11) NOT NULL DEFAULT 0,
  `task_id` int(11) NOT NULL DEFAULT 0,
  `pr_type` enum('direct_pr','indirect_pr') COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `quotation_valid_date` datetime DEFAULT NULL,
  `quotation_created_date` datetime DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rfq_vendors` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cs_purchase_officer` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cs_purchase_manager` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cs_purchase_officer_date` datetime DEFAULT NULL,
  `cs_purchase_manager_date` datetime DEFAULT NULL,
  `auth_person` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auth_person_date` date DEFAULT NULL,
  `remarks` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cancellation_remarks` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_book` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS purchases;

CREATE TABLE `purchases` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date DEFAULT NULL,
  `product` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `supplier` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rate` double DEFAULT NULL,
  `qty` int(11) NOT NULL,
  `total` double DEFAULT NULL,
  `tax` double DEFAULT NULL,
  `net` double DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `payment_mode` tinyint(1) NOT NULL DEFAULT 1,
  `bank_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bill_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS receipt_document;

CREATE TABLE `receipt_document` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `receipt_id` int(11) NOT NULL DEFAULT 0,
  `document_path` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS receipt_images;

CREATE TABLE `receipt_images` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
  `property_id` int(11) NOT NULL,
  `image` text DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS receipt_items;

CREATE TABLE `receipt_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `purchase_order_id` int(11) NOT NULL DEFAULT 0,
  `purchase_request_id` int(11) NOT NULL DEFAULT 0,
  `vendor_id` int(11) NOT NULL DEFAULT 0,
  `purchase_order_receipt_id` int(11) NOT NULL DEFAULT 0,
  `item_id` int(11) NOT NULL DEFAULT 0,
  `quantity` double NOT NULL DEFAULT 0,
  `quality_test_approve_by` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approval_date` date DEFAULT NULL,
  `approval_status` tinytext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` date DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `pass_quantity` int(11) NOT NULL DEFAULT 0,
  `fail_quantity` int(11) NOT NULL DEFAULT 0,
  `note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS receipts;

CREATE TABLE `receipts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `customer_property_id` int(10) unsigned DEFAULT NULL,
  `payment_head` int(11) NOT NULL,
  `payment_mode` int(11) NOT NULL DEFAULT 1,
  `bank_name` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cheque_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cheque_title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cheaque_status` tinyint(1) NOT NULL DEFAULT 0,
  `drawn_date` date DEFAULT NULL,
  `amount` double NOT NULL,
  `receipt_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `company_account` int(10) unsigned DEFAULT NULL,
  `cancel_property_id` bigint(20) DEFAULT NULL,
  `adjustment_type` int(11) DEFAULT NULL,
  `adjustment_detail` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `inventory_id` int(11) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_approved` tinyint(1) NOT NULL DEFAULT 1,
  `download_count` int(11) DEFAULT NULL,
  `print_count` int(11) DEFAULT NULL,
  `reconciled` tinyint(1) NOT NULL DEFAULT 1,
  `payment_method` int(11) DEFAULT NULL,
  `dealer_adjustment_unit_id` int(11) DEFAULT NULL,
  `vendor_purchase_order_id` int(11) DEFAULT NULL,
  `merging_property_id` int(11) DEFAULT NULL,
  `is_book` tinyint(1) NOT NULL DEFAULT 0,
  `notes` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_paid_by` tinyint(1) DEFAULT NULL,
  `tax_payment_received` tinyint(1) DEFAULT NULL,
  `tax_amount` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `receipts_customer_id_foreign` (`customer_id`),
  KEY `receipts_customer_property_id_foreign` (`customer_property_id`),
  KEY `receipts_company_account_foreign` (`company_account`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO receipts VALUES("1","1","1","1","1","","","","1","","2000000","50000","","2022-12-22","2022-12-23 01:15:34","2022-12-23 01:16:54","","","1","","","0","1","","","1","1","","","","0","","1","0","20000");



DROP TABLE IF EXISTS reconciliations;

CREATE TABLE `reconciliations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `started_at` datetime NOT NULL,
  `ended_at` datetime NOT NULL,
  `closing_balance` double(15,4) DEFAULT 0.0000,
  `reconciled` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;




DROP TABLE IF EXISTS registration_nos;

CREATE TABLE `registration_nos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `number` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cnic` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone_number` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_deleted` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS role_user;

CREATE TABLE `role_user` (
  `user_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `role_user_role_id_foreign` (`role_id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO role_user VALUES("22","1");



DROP TABLE IF EXISTS roles;

CREATE TABLE `roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `display_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO roles VALUES("1","admin","Admin","All system Access","2020-07-16 13:50:26","2020-07-16 13:55:01"),
("6","Data Entry","","Access only registration and membership creation.","2020-07-16 14:04:56","2020-07-25 18:34:43"),
("7","Reviewer","","Access to All modules","2020-07-25 18:36:02","2020-07-25 18:36:02"),
("8","Customer Mng","","Access to customer related modules","2020-07-25 18:36:58","2020-07-25 18:36:58"),
("9","Staff","","Access to membership module","2020-07-25 18:37:38","2020-07-25 18:37:38"),
("12","Test","","","2021-08-11 13:13:37","2021-08-11 13:13:37"),
("13","Procurement Manager","","maneger","2021-12-03 10:17:36","2021-12-03 10:17:36"),
("14","procurement Operations","","test","2021-12-03 10:38:44","2021-12-03 10:38:44"),
("15","Accounts Dept","","","2021-12-30 17:17:21","2021-12-30 17:17:21"),
("16","Information Technology","","IT Solutions, Services & Support","2022-12-22 02:24:25","2022-12-22 02:24:25");



DROP TABLE IF EXISTS schedule_plans;

CREATE TABLE `schedule_plans` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `possession` double(8,2) NOT NULL DEFAULT 1.00,
  `possession_date` date DEFAULT NULL,
  `voucher_valid_after` date DEFAULT NULL,
  `down_payment` double(8,2) NOT NULL DEFAULT 16.00,
  `monthly_installment` double(8,2) NOT NULL DEFAULT 64.00,
  `annual_installment` double(8,2) NOT NULL DEFAULT 19.00,
  `total_months` int(11) NOT NULL DEFAULT 60,
  `allotment` double(8,2) NOT NULL DEFAULT 2.00,
  `confirmation` double(8,2) NOT NULL DEFAULT 2.00,
  `booking` double(8,2) NOT NULL DEFAULT 2.00,
  `development` double(8,2) NOT NULL DEFAULT 2.00,
  `file_processing` double(8,2) NOT NULL DEFAULT 2.00,
  `registration` double(8,2) NOT NULL DEFAULT 2.00,
  `fine` double NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO schedule_plans VALUES("1","15.00","2024-12-01","2018-01-01","25.00","60.00","0.00","24","0.00","0.00","0.00","0.00","0.00","0.00","0.005","0000-00-00 00:00:00","2022-12-23 00:52:49");



DROP TABLE IF EXISTS sms;

CREATE TABLE `sms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` text NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS sms_clients;

CREATE TABLE `sms_clients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(10) unsigned NOT NULL,
  `message_id` int(10) unsigned NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS statement_histories;

CREATE TABLE `statement_histories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `unit_refund_history_id` bigint(20) NOT NULL,
  `unit_adjust_id` bigint(20) NOT NULL,
  `payment_head` int(11) NOT NULL DEFAULT 1,
  `inst_no` int(11) NOT NULL DEFAULT 1,
  `inst_track` tinyint(4) NOT NULL DEFAULT 0,
  `due_date` date DEFAULT NULL,
  `due` double DEFAULT NULL,
  `received` double DEFAULT NULL,
  `balance` double DEFAULT NULL,
  `rcpt_no` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ref_no` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rcpt_date` date DEFAULT NULL,
  `rcpt_amount` double DEFAULT NULL,
  `late_days` int(11) DEFAULT NULL,
  `surcharge` double DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS surcharge_receipts;

CREATE TABLE `surcharge_receipts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `customer_property_id` int(10) unsigned DEFAULT NULL,
  `payment_head` int(11) NOT NULL,
  `payment_mode` int(11) NOT NULL DEFAULT 1,
  `bank_name` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cheque_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cheque_title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `drawn_date` date DEFAULT NULL,
  `amount` double NOT NULL,
  `total_surcharge` double NOT NULL DEFAULT 0,
  `receipt_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `company_account` int(10) unsigned DEFAULT NULL,
  `adjustment_type` int(11) DEFAULT NULL,
  `adjustment_detail` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `inventory_id` int(11) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_approved` tinyint(1) NOT NULL DEFAULT 1,
  `download_count` int(11) DEFAULT NULL,
  `print_count` int(11) DEFAULT NULL,
  `reconciled` tinyint(1) NOT NULL DEFAULT 1,
  `payment_method` int(11) DEFAULT NULL,
  `dealer_adjustment_unit_id` int(11) DEFAULT NULL,
  `vendor_purchase_order_id` int(11) DEFAULT NULL,
  `is_book` tinyint(1) NOT NULL DEFAULT 0,
  `notes` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_paid_by` tinyint(1) DEFAULT NULL,
  `tax_payment_received` tinyint(1) DEFAULT NULL,
  `tax_amount` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `receipts_customer_id_foreign` (`customer_id`),
  KEY `receipts_customer_property_id_foreign` (`customer_property_id`),
  KEY `receipts_company_account_foreign` (`company_account`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS table_customer_fingerprints;

CREATE TABLE `table_customer_fingerprints` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
  `template` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `encodeWEQ` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS tasks;

CREATE TABLE `tasks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `text` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `duration` int(11) DEFAULT NULL,
  `progress` double(8,2) DEFAULT NULL,
  `start_date` datetime DEFAULT NULL,
  `task_end_date` date DEFAULT NULL,
  `parent` int(11) NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `task_priority` enum('high','low','normal') COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_cost` double NOT NULL DEFAULT 0,
  `assign_to` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `task_type` enum('planed','unplaned') COLLATE utf8mb4_unicode_ci NOT NULL,
  `node_name` tinytext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS tax_receipts;

CREATE TABLE `tax_receipts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `receipt_no` bigint(20) DEFAULT NULL,
  `receipt_date` date DEFAULT NULL,
  `receipt_amount` double DEFAULT NULL,
  `payment_method` int(11) DEFAULT NULL,
  `depositer_bank_id` int(11) DEFAULT NULL,
  `company_bank_id` int(11) DEFAULT NULL,
  `drawn_date` date DEFAULT NULL,
  `instrument_no` varchar(50) DEFAULT NULL,
  `inst_no` varchar(10) DEFAULT NULL,
  `payment_head` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `is_book` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS testtable;

CREATE TABLE `testtable` (
  `t` text NOT NULL,
  `e` text NOT NULL,
  `s` text NOT NULL,
  `tt` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS token_receipt;

CREATE TABLE `token_receipt` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `unit_id` int(11) DEFAULT NULL,
  `payment_head` varchar(191) DEFAULT NULL,
  `token_amount` double(8,2) DEFAULT NULL,
  `payment_method` varchar(156) DEFAULT NULL,
  `bank_name` varchar(156) DEFAULT NULL,
  `company_account` varchar(156) DEFAULT NULL,
  `drawn_date` date DEFAULT NULL,
  `instrument_no` varchar(156) DEFAULT NULL,
  `adjustment_type` varchar(156) DEFAULT NULL,
  `vendor_purchase_order_id` int(156) DEFAULT NULL,
  `adjustment_detail` varchar(156) DEFAULT NULL,
  `dealer_adjustment_unit_id` varchar(156) DEFAULT NULL,
  `receipt_number` varchar(156) DEFAULT NULL,
  `receipt_date` date DEFAULT NULL,
  `notes` varchar(156) DEFAULT NULL,
  `is_approved` int(11) NOT NULL,
  `is_book` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS transfer_properties;

CREATE TABLE `transfer_properties` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `property_id` int(10) unsigned NOT NULL,
  `owner_id` int(10) unsigned NOT NULL,
  `transfer_customer_id` int(10) unsigned NOT NULL,
  `transfer_date` date NOT NULL,
  `transfer_note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount_paid` double NOT NULL,
  `surcharge` double DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `old_client_id` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `new_client_id` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transfer_charges` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unit_detail` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transfer_properties_property_id_foreign` (`property_id`),
  KEY `transfer_properties_owner_id_foreign` (`owner_id`),
  KEY `transfer_properties_transfer_customer_id_foreign` (`transfer_customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS transfer_property_histories;

CREATE TABLE `transfer_property_histories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transfer_prop_id` bigint(20) NOT NULL,
  `payment_head` int(11) NOT NULL DEFAULT 1,
  `inst_no` int(11) NOT NULL DEFAULT 1,
  `inst_track` tinyint(4) NOT NULL DEFAULT 0,
  `due_date` date DEFAULT NULL,
  `due` double DEFAULT NULL,
  `received` double DEFAULT NULL,
  `balance` double DEFAULT NULL,
  `rcpt_no` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ref_no` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rcpt_date` date DEFAULT NULL,
  `rcpt_amount` double DEFAULT NULL,
  `late_days` int(11) DEFAULT NULL,
  `surcharge` double DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS unit_adjusts;

CREATE TABLE `unit_adjusts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ua_no` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_id` bigint(20) NOT NULL,
  `cancel_property_id` bigint(20) DEFAULT NULL,
  `customer_property_id` bigint(20) NOT NULL,
  `total_received_amount` double DEFAULT NULL,
  `unit_detail` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS unit_blocks;

CREATE TABLE `unit_blocks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(55) NOT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

INSERT INTO unit_blocks VALUES("1","General","0","2022-12-23 00:49:30","2022-12-23 00:49:30");



DROP TABLE IF EXISTS unit_categories;

CREATE TABLE `unit_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `percent` float NOT NULL,
  `is_deleted` tinyint(4) NOT NULL DEFAULT 0,
  `is_percent` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS unit_floor_sizes;

CREATE TABLE `unit_floor_sizes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `unit_floor_id` int(10) unsigned NOT NULL,
  `unit_size_id` int(10) unsigned DEFAULT NULL,
  `rate` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `unit_type_id` int(10) unsigned NOT NULL,
  `registration_fee` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `unit_floor_categories_unit_floor_id_foreign` (`unit_floor_id`),
  KEY `unit_floor_categories_unit_category_id_foreign` (`unit_size_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO unit_floor_sizes VALUES("1","1","","27000","2022-12-23 00:50:17","2022-12-23 00:50:17","1","");



DROP TABLE IF EXISTS unit_floors;

CREATE TABLE `unit_floors` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `is_deleted` tinyint(4) NOT NULL DEFAULT 0,
  `unit_block_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO unit_floors VALUES("1","Lower Ground 1","2022-12-23 00:50:17","2022-12-23 00:50:17","0","1");



DROP TABLE IF EXISTS unit_old_rates;

CREATE TABLE `unit_old_rates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `unit_floor_id` int(11) NOT NULL,
  `unit_type_id` int(11) NOT NULL,
  `rate` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS unit_refund_histories;

CREATE TABLE `unit_refund_histories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint(20) NOT NULL,
  `cancel_property_id` bigint(20) DEFAULT NULL,
  `customer_property_id` bigint(20) NOT NULL,
  `total_amount` double DEFAULT NULL,
  `total_refund` double DEFAULT NULL,
  `total_deduct` double DEFAULT NULL,
  `unit_detail` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `total_deduct_percentage` double DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS unit_sizes;

CREATE TABLE `unit_sizes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` float NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `is_deleted` tinyint(4) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO unit_sizes VALUES("1","405","1","2022-12-23 00:54:50","2022-12-23 00:54:50","0");



DROP TABLE IF EXISTS unit_types;

CREATE TABLE `unit_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `is_deleted` tinyint(4) NOT NULL DEFAULT 0,
  `projecttype_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO unit_types VALUES("1","Shop","1","2022-12-23 00:48:57","2022-12-23 00:48:57","0","2"),
("2","Penthouse","1","2022-12-28 17:57:25","2022-12-28 00:00:00","0","1");



DROP TABLE IF EXISTS users;

CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `session_id` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone_number` varchar(12) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO users VALUES("22","Admin","admin@gmail.com","$2y$10$bBJDHoruTFN7NOH1FZGk4ONBU0QP2g1Tyn3vftMWYQUuCInwmktd6","uaW0jkyCwdjCzDyr0d3MfYwI6xqpAJcrLZskN7b26rlquKOwCh4rgVUMjBJ7","2020-07-16 19:38:54","2022-07-14 11:53:52","idpDmyyEEQuBtbh22uvhmyAIWYtLepufmzC4oyb1","03124999213");



DROP TABLE IF EXISTS vendor_certificates;

CREATE TABLE `vendor_certificates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `vendor_id` int(11) NOT NULL,
  `date_from` date NOT NULL,
  `date_to` date NOT NULL,
  `specific_nature` varchar(255) NOT NULL,
  `total_tax_amount` double NOT NULL,
  `total_amount` double NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS vendors;

CREATE TABLE `vendors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `phone_number` varchar(100) DEFAULT NULL,
  `opening_balance` double NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `cnic` varchar(50) DEFAULT NULL,
  `rep_name` varchar(50) DEFAULT NULL,
  `vendor_type` int(11) DEFAULT NULL,
  `ntn` varchar(100) DEFAULT NULL,
  `stn` varchar(100) DEFAULT NULL,
  `test_certificate` mediumint(9) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS vouchers;

CREATE TABLE `vouchers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `entry_no` int(11) NOT NULL,
  `narration` text DEFAULT NULL,
  `documents` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




