@extends('layouts.app')


@section('title')
Add New Dealer 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-dealer')
        <li ><a href="{{route('dealer.all')}}">All Dealer List</a></li>
        @endpermission
        <li class="active">Add New Dealer </li>
      </ol>
@stop

@section('content')

<div class="container-fluid">
                <!--.row-->
                <div class="row">

                    <div class="col-md-12">
                         @if($errors->any())
                        <div class="white-box1"><h2>Errors</h2><ul>
    {!! implode('', $errors->all('<li><span class="help-block"><strong>:message</strong></span></li>')) !!}
</ul></div>@endif
                        <div class="white-box">
                            <h3 class="box-title m-b-0"><i class="icon-user fa-fw"></i> Add New Dealer </h3>
                            <p class="text-muted m-b-30 font-13"> Add Basic Information </p>
                            
                   

                            <form class="form-horizontal" action="{{route('dealer.insert')}}" method="post" onsubmit="return validate(this)" autocomplete="off">
                               {{csrf_field()}}
                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">Full Name <span style="color: red">*</span></label>
                                    <div class="col-sm-3">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="ti-user"></i></div>
                                            <input  type="text" class="form-control" name="name" value="{{old('name')}}" id="exampleInputuname" placeholder="Enter Name">
                                        @if ($errors->has('name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                    <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-3 control-label">Code <span style="color: red">*</span></label>
                                    <div class="col-sm-3">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-lock"></i></div>
                                            <input  type="text" class="form-control" name="code" value="d-{{rand(100,999)}}" readonly id="exampleInputuname" placeholder="Enter Code">
                                        @if ($errors->has('code'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('code') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                </div>
                              
                                <div class="form-group">
                                    <label for="address" class="col-sm-2 control-label">Type <span style="color: red">*</span></label>
                                    <div class="col-sm-3">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="fa fa-user-secret"></i></div>
                                            <select class="form-control chosen-select"  name="incentive_type" id="dropdown">
                                                <option value="">None</option>
                                                @foreach($types as $t)
                                                
                                                @if(old('incentive_type') == $t->id)
                                                <option value="{{$t->id}}">{{$t->name}}</option>
                                                @else
                                                <option value="{{$t->id}}">{{$t->name}}</option>
                                                @endif
                                                @endforeach
                                            </select>
                                         
                                        @if ($errors->has('incentive_type'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('incentive_type') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                    <div class="form-group">
                                    <label for="exampleInputEmail1" class="col-sm-3 control-label">Is Filer </label>
                                    <div class="col-sm-3">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-phone"></i></div>
                                            <select class="form-control select2" name="is_filer">
                                                <option value="1">YES</option>
                                                <option value="0">NO</option>
                                            </select>
                                            

                                            @if ($errors->has('is_filer'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('is_filer') }}</strong>
                                    </span>
                                @endif</div>
                                    </div>
                                </div>
                                </div>

                                <div class="form-group" id="cnic" hidden>
                                    <label for="cnic" class="col-sm-2 control-label">CNIC <span style="color: red">*</span></label>
                                    <div class="col-sm-3">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-credit-card"></i></div>
                                            <input type="text"  class="form-control" value="{{old('cnic')}}" name="cnic" data-inputmask="'mask': '99999-9999999-9'" onfocusout="return validateCnic(this)"  placeholder="XXXXX-XXXXXXX-X"  >

                                            <div style="color: red;display: none;" id="cnic_error1">This Dealer cnic is found in list of DNFBP. You can't add this Dealer record. </div>


                                            @if ($errors->has('cnic'))
                                            <span class="help-block">
                                            <strong>{{ $errors->first('cnic') }}</strong>
                                            </span>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-3 control-label">NTN Number</label>
                                    <div class="col-sm-3">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="ti-user"></i></div>
                                            <input  type="text" class="form-control" name="ntn_number" value="{{old('ntn_number')}}" placeholder="Enter NTN">
                                        @if ($errors->has('ntn_number'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('ntn_number') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                                </div>

                                <div class="form-group" id="reg_no" hidden>
                                    <label for="reg_no" class="col-sm-2 control-label">Registration No. <span style="color: red">*</span></label>
                                    <div class="col-sm-3">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-credit-card"></i></div>
                                            <input type="number"  class="form-control" value="{{old('reg_no')}}" name="reg_no" placeholder="Enter Company's Registration Number"  >

                                            @if ($errors->has('reg_no'))
                                            <span class="help-block">
                                            <strong>{{ $errors->first('reg_no') }}</strong>
                                            </span>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-3 control-label">NTN Number</label>
                                    <div class="col-sm-3">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="ti-user"></i></div>
                                            <input  type="text" class="form-control" name="ntn_number" value="{{old('ntn_number')}}" placeholder="Enter NTN">
                                        @if ($errors->has('ntn_number'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('ntn_number') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                                </div>

                                 <!-- <div class="form-group">
                                    <label for="exampleInputEmail1" class="col-sm-3 control-label">Is Filer </label>
                                    <div class="col-sm-3">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-phone"></i></div>
                                            <select class="form-control select2" name="is_filer">
                                                <option value="1">YES</option>
                                                <option value="0">NO</option>
                                            </select>
                                            

                                            @if ($errors->has('is_filer'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('is_filer') }}</strong>
                                    </span>
                                @endif</div>
                                    </div>
                                </div> -->

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">NTN Number</label>
                                    <div class="col-sm-3">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="ti-user"></i></div>
                                            <input  type="text" class="form-control" name="ntn_number" value="{{old('ntn_number')}}" placeholder="Enter NTN">
                                        @if ($errors->has('ntn_number'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('ntn_number') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                    <div class="form-group">
                                    <label for="address" class="col-sm-3 control-label">Country <span style="color: red">*</span></label>
                                    <div class="col-sm-3">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="ti-world"></i></div>
                                            <select class="form-control chosen-select" id="country_id" name="country_id">
                                                <option value="" selected="">None</option>
                                                @foreach($countries as $c)
                                                <option value="{{$c->id}}">{{$c->name}}</option>
                                                @endforeach
                                            </select>
                                        @if ($errors->has('country_id'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('country_id') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                                </div>

                              

                               <div class="form-group">
                                    <label for="address" class="col-sm-2 control-label">City <span style="color: red">*</span></label>
                                    <div class="col-sm-3">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-location-pin"></i></div>
                                            <select class="form-control " id="city_id" name="city_id">
                                                <option value="" selected="">None</option>

                                            </select>
                                        @if ($errors->has('city_id'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('city_id') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                    <div class="form-group">
                                    <label for="address" class="col-sm-3 control-label">Address</label>
                                    <div class="col-sm-3">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-location-pin"></i></div>
                                            <input type="text" class="form-control" name="address" value="{{old('address')}}" id="address1" placeholder="Enter Address">
                                        @if ($errors->has('address'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('address') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                                </div>

                             
                                 <div class="form-group">
                                     <label for="exampleInputEmail1" class="col-sm-2 control-label">Email </label>
                                    <div class="col-sm-3">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="ti-email"></i></div>
                                            <input type="email"  class="form-control" name="email" value="{{old('email')}}" id="exampleInputEmail1" placeholder="Enter email">
                                        @if ($errors->has('email'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                    <div class="form-group">
                                     <label for="exampleInputEmail1" class="col-sm-3 control-label">Password </label>
                                    <div class="col-sm-3">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-key"></i></div>
                                            <input type="text"  class="form-control" name="password" value="{{old('password')}}" id="exampleInputEmail1" placeholder="Enter password">
                                        @if ($errors->has('password'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('password') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                                </div>
                              
                                <div class="form-group">
                                    <label for="exampleInputEmail1" class="col-sm-2 control-label">Phone Number</label>
                                    <div class="col-sm-3">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-phone"></i></div>
                                            <input type="text" class="form-control" maxlength="12" data-inputmask="'mask': '0399-99999999'" type='number' name="phone_number" value="{{old('phone_number')}}"  placeholder="Enter Phone Number">
                                        @if ($errors->has('phone_number'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('phone_number') }}</strong>
                                    </span>
                                @endif</div>
                                    </div>
                                    
                                <div class="form-group">
                                                        <label class="control-label col-md-3">Rebate<span style="color: red">*</span><br> (use percent <input type="checkbox" onclick="percentCheckbox()" name="rebate_in_percent" id="rebate_in_percent" value="1">)</label>
                                                        <div class="col-md-3">
                                                             <div class="input-group" >
                                                                <span class="input-group-addon" style="font-size: 12px; padding: 8px" id="rebate_input">PKR</span>
                                                                <input id='discount_s' type="numeric" class="form-control" name="percentage" value="{{old('percentage')}}" placeholder="Enter Rebate" >
                                                            </div> 

                                        @if ($errors->has('percentage'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('percentage') }}</strong>
                                    </span>
                                @endif

                                                        </div>
                                                    </div>
                                                    
                                                    
                                <div class="alert alert-danger" id="required_error" role="alert" hidden>
                                     All Fields Required*
                                </div>
                                </div>


                               
                                <div class=" col-sm-4">&nbsp;</div>
                                <div class=" col-sm-4">
                                 <div class="form-group">
                                        <button type="submit" class="btn btn-info waves-effect waves-light m-t-10" style="width: 100%">Save</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!--./row-->
            </div>
            <!-- /.container-fluid -->

@stop


@section('js')

    <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js"></script>

    <script>

    $(document).ready(function() {
        $("#dropdown").change(function() {
           
            var value = $("#dropdown :selected").text();
            if (value === "Company" || value === "company") { 
                $("#reg_no").show();
                $("#cnic").hide();
            }
            else if(value === "None"){
                $("#reg_no").hide();
                $("#cnic").hide();
            }
             else {
                $("#cnic").show();
                $("#reg_no").hide();
            }
        });
    });
    
    function validate(self)
    {
    //  value=   $("#dropdown :selected").text();

    //  if(value === 'company' || value === 'Company' ){
    //     if($(self).find('input[name="cnic"]').val() == "")
    //     {
    //         $('#required_error').show()
    //          return false;
    //     }
    //  }
    //  else if(value != 'none' && value === 'company' || value === 'Company'){
    //     if($(self).find('input[name="reg_no"]').val() == "")
    //     {
    //         $('#required_error').show()
    //          return false;
    //     }
    //  }

        
        if($(self).find('input[name="name"]').val() == "")
        {
            $('#required_error').show()
             return false;
        }
        else if($(self).find('input[name="incentive_type"]').val() == "")
        {
           
            $('#required_error').show()
             return false;
        }
        // else if(){
        //     if($(self).find('input[name="cnic"]').val() == "")
        // {
        //     $('#required_error').show()
        //      return false;
        // }
        // }
       
        else if($(self).find('input[name="country_id"]').val() == "")
        {
            $('#required_error').show()
             return false;
        }
        else if($(self).find('input[name="city_id"]').val() == "")
        {
            $('#required_error').show()
             return false;
        }
        else
        {
             return true;
        }
        
    }
    
     setTimeout(function() { 
         $('#required_error').hide()
        }, 3000);
        

         function validateCnic(self) 
        {
           var cnic = $(self).val().replaceAll('-', '');

        $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
        });

        $.ajax({
        url:"{{ route('validate.dnfbp.cnic') }}",
        method:'POST',
        dataType:'json',
        data: {cnic:cnic},
        success:function(data)
        {
          if (data.response == 'invalid') 
          {
                $(self).closest('.input-group').find('#cnic_error1').show();
          }

        }
        })



        return false;
        }


    $(":input").inputmask();
$('#country_id').change(function() {
    $('.preloader').fadeIn();
        var data = { 'country_id': $(this).val() };

        $.get('/getCitiesByCountry', data, function (data) {
           var model = $('#city_id');
                    model.empty();

                     model.append("<option value='' disabled selected>" + '' + "</option>");


                    $.each(data, function(index, element) {
                        model.append("<option value='"+ element.id +"'>" + element.name + "</option>");
                    });
        });
         $('.preloader').fadeOut();
    });

function percentCheckbox() {

        if($('#rebate_in_percent').prop("checked") == false) {
            document.getElementById('rebate_input').innerHTML = 'PKR';
        }
        else {
            document.getElementById('rebate_input').innerHTML = '%';
        }
    }
   </script>
@stop