@extends('layouts.app')

@section('title')
    Dealer Package Detail
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
    <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
    @permission('list-dealer')
    <li ><a href="{{route('dealer.all')}}">All Sale Networks</a></li>
    @endpermission
    <li class="active">Dealer Package Detail</li>
  </ol>
@stop

@section('css')

    <style>
        /*.parent_div::-webkit-scrollbar
   {
     width: 1em;
   }

   .parent_div::-webkit-scrollbar-track
   {
     border-radius: 10px;
     -webkit-box-shadow: inset 0 0 6px rgba(0, 0, 0, 0.3);
   }

   .parent_div::-webkit-scrollbar-thumb
   {
     border-radius: 10px;
     background-color: #00bd86;
     outline: 2px solid slategrey;
   }

   .parent_div::-webkit-scrollbar:vertical
   {
     display: none;
   }*/
    </style>

@stop


@section('content')
    <div class="container-fluid">

                    <div class="col-md-12">
           
                 
                       <div class="white-box">
                          <h3 class="box-title m-b-0"><i class="icon-layers fa-fw"></i>Dealer Package Detail</h3>
                           <p class="text-muted  font-13"> {{$dealer_package->package->name}} Package  @if($dealer_package->payment_status == \App\DealerPackage::pending)
                            <span class="label label-danger">Pending</span>
                             @elseif($dealer_package->payment_status == \App\DealerPackage::completed)
                             <span class="label label-success">Completed</span>
                             @endif </p>
                             <p class="text-muted  font-13"> 
                              Issue Date {{$dealer_package->issue_date}} 
                             </p>
                           <hr>

                       </div>
                   </div>
        <div class="row colorbox-group-widget">
            <div class="col-md-3 col-sm-6 info-color-box">
               <div class="white-box">
                   <div class="profile-widget">
                       <div class="profile-img">
                           <img src="{{asset('plugins/images/users/jeffery.png')}}" height="70px" width="auto" alt="user-img" class="img-circle">
                            <p class="m-t-10 m-b-5"><a href="javascript:void(0);" class="profile-text font-22 font-semibold">{{$dealer_package->dealer->name}}</a></p>
                            <p class="m-t-10 m-b-5"><a  class="profile-text font-16 font-semibold">{{$dealer_package->dealer->dealerType ? $dealer_package->dealer->dealerType->name : ''}}</a></p>

                           @if($dealer_package->dealer->status == true)
                           <span class="label label-success ">Active</span>
                           @else
                           <span class="label label-danger ">InActive</span>
                           @endif
                       </div>
                   </div>
               </div>
           </div>
           <div class="col-md-3 col-sm-6 info-color-box">
               <div class="white-box">
                   <div class="media bg-primary">
                       <div class="media-body">
                           <h3 class="info-count">{{number_format($dealer_package->package->total_price)}}<span class="pull-right"><i class="mdi mdi-coin"></i></span></h3>
                           <p class="info-text font-12">PKR</p>
                           <p class="info-ot font-20">Package Amount</p>
                       </div>
                   </div>
               </div>
           </div>
           <div class="col-md-3 col-sm-6 info-color-box">
               <div class="white-box">
                   <div class="media bg-info">
                       <div class="media-body">
                           <h3 class="info-count">{{number_format($paid_amount)}} <span class="pull-right"><i class="mdi mdi-coin"></i></span></h3>
                           <p class="info-text font-12">PKR</p>
                           <p class="info-ot font-20">Paid Amount</p>
                       </div>
                   </div>
               </div>
           </div>
           <div class="col-md-3 col-sm-6 info-color-box">
               <div class="white-box">
                   <div class="media bg-success">
                       <div class="media-body">
                        
                           <h3 class="info-count">{{number_format(count($sold_inventory))}}<span class="pull-right"><i class="mdi mdi-checkbox-marked-circle-outline"></i></span></h3>
                           <p class="info-text font-12">Files </p>
                           <p class="info-ot font-20">Closed Files</p>
                       </div>
                   </div>
               </div>
           </div>

           

       </div>


       {{-- Rebate Information  --}}
  <!-- /row -->
  <div class="row">
    <div class="col-sm-12">
        <div class="white-box">
            <h3 class="box-title">Package Information</h3>
            <hr>
                    <div class="table-responsive">
                        <table class="table">
                            <tbody>
                               
                                <tr>
                                    <td><strong>Rebate Type</strong></td>
                                    <td><span class="label label-success "> {{$dealer_package->package->rebate_type}}</span> </td>
                                </tr>

                                @if($dealer_package->package->rebate_type == 'cash')
                                <tr>
                                    <td><strong>Rebate Amount</strong></td>
                                    <td>Rs: {{$dealer_package->package->rebate_amount}} </td>
                                </tr>
                                <tr>
                                    <td><strong>Paid Rebate Amount</strong></td>
                                    <td>Rs:   {{$package_paid_rebate}} </td>
                                </tr>
                                @else
                                <tr>
                                    <td><strong>Remaining Rebate Amount</strong></td>
                                    <td>Rs: {{$dealer_package->package->remaining_rebate}} </td>
                                </tr>
                                @endif
                                
                                   
                                

                                

                            </tbody>
                        </table>
                    </div>

        </div>
    </div>
</div>
<!-- /.row -->

            {{-- End Rebate Information --}}


        {{-- Dealer Package Open Files --}}

        <div class="row">
            <div class="col-md-12">
                <div class="white-box user-table">
                    <div class="row">
                        <div class="col-sm-6">
                            <h4 class="box-title">Packages Units</h4>
                        </div>


                    </div><hr>

                    <div class="table-responsive">
                        <table id="myTable" class="table table-striped">
                            <thead>
                            <tr>

                                <th>Unit Number</th>
                                <th>Size</th>
                                <th>Type</th>
                                <th>Status</th>
                                <th>Expiry Date</th>
                                    
                                
                            </tr>
                            </thead>
                           
                            <tbody>

                           @foreach($dealer_package->openFileDealerInfo as $info)

                           <tr>
                            <td>{{$info->inventory->unit_number}}</td>
                            <td>{{ $info->inventory->size->name }} {{ env('SIZE') }}</td>
                            <td>{{$info->inventory->type->name}}</td>
                            {{-- <td>{{$info->inventory->status}}</td> --}}

                            @role('admin')
                            <?php $admin = true;?>
                        @else
                        <?php $admin = false;?>
                        @endrole
                      
                            @if($admin)

                            @if($info->inventory->status == \App\Inventory::open)
                             <td><span class="label label-success">Open</span></td>
                             @elseif($info->inventory->status == \App\Inventory::package_open_file)
                             <td><span class="label label-success">Open/Dealer Package File</span></td>
                             @elseif($info->inventory->status == \App\Inventory::sold)
                             <td><span class="label label-danger">Sold</span></td>
                             @elseif($info->inventory->status == \App\Inventory::hold_client)
                             <td><span class="label label-primary">Client Hold</span></td>
                             @elseif($info->inventory->status == \App\Inventory::hold_company)
                             <td><span class="label label-primary">Company Hold</span></td>
                             @elseif($info->inventory->status == \App\Inventory::token_hold)
                             <td><span class="label label-primary">Token Hold</span></td>
                             @elseif($info->inventory->status == \App\Inventory::temp_hold)
                             <td><span class="label label-primary">Temporary Hold</span></td>
                             @else
                             {{-- <td></td> --}}
                             @endif

                             
                             @else
                             @if($info->inventory->status == \App\Inventory::open)
                             <td><span class="label label-success">Open</span></td>
                             @else
                             <td><span class="label label-danger">Sold</span></td>
                             @endif


                             @endif
                            <td>{{$info->valid_until_date}}</td>

                           </tr>
                           @endforeach


                            </tbody>
                            

                            <tfoot>
                                
                            </tfoot>
                        </table>
                    </div>

                </div>

            </div>

        </div>


             {{-- End Dealer Package Open Files --}}
    </div>



      


       

    @stop


    @section('js')
      
    @Stop
