@extends('layouts.app') 

@section('title') Dealer Receipt @stop 

@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
    <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li> @permission('list-dealer')
    <li><a href="{{route('dealer.all')}}">All Dealer </a></li> @endpermission
    <li class="active">Dealer Receipt</li>
</ol> 
@stop 

@section('css')
<style type="text/css">
/*.page-wrapper {
    margin-top: -55px;
    padding-bottom: 0px;
}*/

.container-fluid {
    padding: 3px 30px 0;
}

@media print {

    .page-wrapper {
        font-size: 12px !important;
        font-family: "time-new-roman", Arial, sans-serif !important;
        padding-top: 0px !important;
        padding-bottom: 0;
    }

    h3 {
        margin: 0;
        line-height: 1;
    }

    .white-box {
        border: none !important;
    }

}

</style> 
@stop 

@section('content')
<div class="container-fluid">
    <div class="row printableArea" id="content">
        <!-- /row -->
        <br>
        <div class="row no-print">
            <div class="col-sm-12">
                <div class="white-box">
                    <h3 class="box-title">Dealer Payment Information</h3>
                    <hr>
                    <div class="table-responsive">
                        <table class="table">
                            <tbody>
                                <tr>
                                    <td>Sales Partner Code</td>
                                    <td>{{ $rebate->dealer->code}}</td>
                                </tr>
                                <tr>
                                    <td>Date</td>
                                    <td>{{date('d-m-Y',strtotime($rebate->date))}}</td>
                                </tr>
                                <tr>
                                    <td>Customer</td>
                                    <td>{{ $rebate->property?$rebate->property->customer->name:''}} </td>
                                </tr>
                                <tr>
                                    <td>Unit No.</td>
                                    <td> {{$rebate->property?$rebate->property->inventory->unit_number:''}}</td>
                                </tr>
                                <tr>
                                    <td>Payment Head</td>
                                    <td> Down Payment</td>
                                </tr>
                                <tr>
                                    <td>Payment Mode</td>
                                    <td> 
                                        @if($rebate->payment_method == \App\Receipt::cash) Cash 

                                        @elseif($rebate->payment_method == \App\Receipt::bank) Bank 

                                        @elseif($rebate->payment_method == \App\Receipt::cheque) Cheque/ DD/ PO 

                                        @else Adjustment @endif 
                                    
                                    </td>
                                </tr>

                                @if($rebate->payment_method == \App\Receipt::bank || $rebate->payment_method == \App\Receipt::cheque)
                                <tr>
                                    <td>Company Account</td>
                                    <td>
                                        
                                        @foreach($cBanks as $company_bank)
                                        
                                        @if($company_bank->id == $rebate->company_account)
                                        {{$company_bank->name}}
                                        @endif

                                        @endforeach

                                    </td>
                                </tr>
                                <tr>
                                    <td>Depositor Bank Account</td>
                                    <td>
                                        
                                        @foreach($banks as $depositor_bank)
                                        
                                        @if($depositor_bank->id == $rebate->bank_name)
                                        {{$depositor_bank->name}}
                                        @endif

                                        @endforeach

                                    </td>
                                </tr>
                                @endif


                                <tr>
                                    <td>Gross Amount</td>
                                    <td>{{number_format($rebate->amount - $rebate->tax_amount)}}</td>
                                </tr>
                                <tr>
                                    <td>Tax Amount</td>
                                    <td>{{number_format($rebate->tax_amount)}}</td>
                                </tr>
                                <tr>
                                    <td>Net Amount</td>
                                    <td>{{number_format($rebate->amount)}}</td>
                                </tr>

                                <tr>
                                    <td>Notes</td>
                                    <td>{{ $rebate->description}}</td>
                                </tr>
                                <tr>
                                    <td>Adjustment Detail</td>
                                    <td>{{ $rebate->description}}</td>
                                </tr>
                                <tr>
                                    <td>Rebate Detail</td>
                                    <td></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="white-box">
            <div class="row " style="text-transform: uppercase; font-weight: 600;">
                <div class="col-sm-12 col-xs-12 text-center">
                    <h3><strong>
                        @if($rebate->property)
                            @if($rebate->property->inventory->multiProject)
                                {{ $rebate->property->inventory->multiProject->name }}
                            @endif
                        @endif
                    </strong></h3>
                    <h3><strong>Rebate Payment</strong></h3> <span class="payment">Office Copy</span> 
                </div>
                
                <div class="col-sm-12 col-xs-12">
                    
                    <div class="row">
                        
                        <div class="col-sm-4 col-xs-4"> 
                            <span class="pull-left">Sales Partner Code:&nbsp;</span>
                            <div style="border-bottom: 1px dotted;display: flex;">&nbsp;
                                <strong> {{ $rebate->dealer->code}}</strong>
                            </div>
                        </div>

                        <div class="col-sm-4 col-xs-4"> &nbsp; </div>
                        
                        <div class="col-sm-4 col-xs-4">
                            <div class="col-sm-12 col-xs-12"><b>Voucher No.</b>&nbsp; 
                                <strong>{{$rebate->id}}</strong></div>
                            <div class="col-sm-12 col-xs-12"><b>Date:</b>&nbsp;
                                <strong>{{date('d-m-Y',strtotime($rebate->date))}}</strong>
                            </div>
                        </div>

                        <br>
                        <br>
                        
                        <div class="col-sm-12 col-xs-12"> 
                            <span class="pull-left">Paying with thanks to Mr.&nbsp;</span>
                            <div style="border-bottom: 1px dotted; display: flex;">&nbsp; 
                                <strong>{{ $rebate->dealer->name}}</strong>
                            </div>
                        </div>
                        <div class="clearfix" style="margin-bottom: 8px"></div>

                        <div class="col-xs-7 col-sm-6"> Payment Mode: 
                        
                             @if($rebate->payment_method == \App\Receipt::cash) 
                            Cash  

                            @elseif($rebate->payment_method == \App\Receipt::bank) 
                            Bank  

                            @elseif($rebate->payment_method == \App\Receipt::cheque) 
                            Cheque 

                            @elseif($rebate->payment_method == \App\Receipt::adjustment) 
                            Adjustment 
                            @endif 
                         

                          &nbsp;&nbsp;&nbsp;&nbsp;<span style="margin-left: 10rem;"> Holding tax: @if($rebate->dealer->is_filer == 1) {{'12%'}} @else {{'24%'}} @endif</span>
                        </div>

                        
                        
                        <div class="col-sm-6 col-xs-5"> <span class="pull-left">On account of Office/shop/Floor&nbsp;&nbsp;</span>
                            <div style="border-bottom: 1px dotted;display: flex;">&nbsp;&nbsp; 
                                <strong>{{$rebate->property?$rebate->property->inventory->unit_number:''}}</strong>
                            </div>
                        </div>
                        <div class="clearfix" style="margin-bottom: 8px"></div>
                        
                        <div class="col-xs-6 col-sm-6"> <span class="pull-left">PKR &nbsp;</span>
                            <div class="col-xs-11 col-sm-11" style="border-bottom: 1px dotted; text-align: center;">&nbsp;
                                <strong>{{ number_format($rebate->amount - $rebate->tax_amount)}}</strong>
                            </div>
                        </div>

                        @if($rebate->payment_method == \App\Receipt::bank || $rebate->payment_method == \App\Receipt::cheque)
                        <div class="col-xs-4 col-sm-4"> 
                            <span class="pull-left">Instruement No.&nbsp;</span>
                            <div style="border-bottom: 1px dotted;display: flex;">
                                {{$rebate->cheque_number}} 
                                <strong></strong>
                            </div>

                        </div>

                        <div class="col-xs-2 col-sm-2"> 
                            <b>Drawn ON:</b>
                            <strong>{{$rebate->drawn_date}}</strong>
                        </div>
                        @endif
                       
                        <br>
                        <br>
                        <div class="clearfix" style="margin-bottom: 8px"></div>
                        
                        <div class="col-xs-4 col-sm-3">Amount in words (PKR)</div>
                        <div class="col-xs-8 col-sm-9">
                            <?php $digit = new \NumberFormatter("en", \NumberFormatter::SPELLOUT);
                                    echo $digit->format($rebate->amount - $rebate->tax_amount);?>
                        </div>

                        <div class="col-sm-12 col-xs-12">
                            <br> <span><strong>Note:&nbsp;</strong> {{ $rebate->description }}</span> </div>
                        <div class="clearfix" style="margin-bottom: 70px"></div>
                        <div class="col-xs-4 col-sm-4"> <b style="border-top: 1px solid;">Received By</b> </div>
                        <div class="col-xs-4 col-sm-4 text-center"> <b style="border-top: 1px solid;">Accountant</b> </div>
                        <div class="col-sm-4 col-xs-4 text-right"> <b style="border-top: 1px solid;">Approved By</b> </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="sperator"></div>
        <div class="white-box">
            <div class="row " style="text-transform: uppercase; font-weight: 600;">
                <div class="col-sm-12 col-xs-12 text-center">
                    <h3><strong>
                        @if($rebate->property)
                            @if($rebate->property->inventory->multiProject)
                                {{ $rebate->property->inventory->multiProject->name }}
                            @endif
                        @endif
                    </strong></h3>
                    <h3><strong>Rebate Payment</strong></h3> <span class="payment">Account Copy</span> 
                </div>
                
                <div class="col-sm-12 col-xs-12">
                    <div class="row">
                        
                        <div class="col-sm-4 col-xs-4"> <span class="pull-left">Sales Partner Code:&nbsp;</span>
                            <div style="border-bottom: 1px dotted;display: flex;">&nbsp;<strong> {{ $rebate->dealer->code}}</strong></div>
                        </div>
                        
                        <div class="col-sm-4 col-xs-4"> &nbsp; </div>
                        
                        <div class="col-sm-4 col-xs-4">
                            <div class="col-sm-12 col-xs-12"><b>Voucher No.</b>&nbsp; <strong>{{ $rebate->id}}</strong></div>
                            <div class="col-sm-12 col-xs-12"><b>Date:</b>&nbsp;<strong>{{date('d-m-Y',strtotime($rebate->date))}}</strong></div>
                        </div>
                        <br>
                        <br>
                        
                        <div class="col-sm-12 col-xs-12"> <span class="pull-left">Paying with thanks to Mr.&nbsp;</span>
                            <div style="border-bottom: 1px dotted; display: flex;">&nbsp; <strong>{{ $rebate->dealer->name}}</strong></div>
                        </div>
                        <div class="clearfix" style="margin-bottom: 8px"></div>
                        
                        <div class="col-xs-7 col-sm-6"> Payment Mode: 
                        
                             @if($rebate->payment_method == \App\Receipt::cash) 
                            Cash  

                            @elseif($rebate->payment_method == \App\Receipt::bank) 
                            Bank  

                            @elseif($rebate->payment_method == \App\Receipt::cheque) 
                            Cheque 

                            @elseif($rebate->payment_method == \App\Receipt::adjustment) 
                            Adjustment 
                            @endif 
                         

                          &nbsp;&nbsp;&nbsp;&nbsp;<span style="margin-left: 10rem;"> Holding tax: @if($rebate->dealer->is_filer == 1) {{'12%'}} @else {{'24%'}} @endif</span>
                        </div>
                        
                        <div class="col-sm-6 col-xs-5"> 
                            <span class="pull-left">On account of Office/shop/Floor&nbsp;&nbsp;</span>
                            
                            <div style="border-bottom: 1px dotted;display: flex;">&nbsp;&nbsp; 
                                <strong>{{$rebate->property?$rebate->property->inventory->unit_number:''}}</strong>
                            </div>
                        </div>
                        <div class="clearfix" style="margin-bottom: 8px"></div>

                        <div class="col-xs-6 col-sm-6"> 
                            <span class="pull-left">PKR &nbsp;</span>
                            <div class="col-xs-11 col-sm-11" style="border-bottom: 1px dotted; text-align: center;">&nbsp;<strong>{{ number_format($rebate->amount - $rebate->tax_amount)}}</strong></div>
                        </div>

                        @if($rebate->payment_method == \App\Receipt::bank || $rebate->payment_method == \App\Receipt::cheque)
                        <div class="col-xs-4 col-sm-4"> 
                            <span class="pull-left">Instruement No.&nbsp;</span>
                            <div style="border-bottom: 1px dotted;display: flex;">
                                {{$rebate->cheque_number}} 
                                <strong></strong>
                            </div>

                        </div>

                        <div class="col-xs-2 col-sm-2"> 
                            <b>Drawn ON:</b>
                            <strong>{{$rebate->drawn_date}}</strong>
                        </div>
                        @endif
                        <br>
                        <br>
                        <div class="clearfix" style="margin-bottom: 8px"></div>
                        
                        <div class="col-xs-4 col-sm-3">Amount in words (PKR)</div>
                        
                        <div class="col-sm-9 col-xs-8">{{ $digit->format($rebate->amount - $rebate->tax_amount) }}</div>
                        
                        <div class="col-sm-12 col-xs-12">
                            <br> 
                            <span><strong>Note:&nbsp;</strong> {{ $rebate->description }}</span> 
                        </div>
                        <div class="clearfix" style="margin-bottom: 70px"></div>
                        
                        <div class="col-xs-4 col-sm-4"> <b style="border-top: 1px solid;">Received By</b></div>

                        <div class="col-xs-4 col-sm-4 text-center"> <b style="border-top: 1px solid;">Accountant</b> </div>
                        
                        <div class="col-sm-4 col-xs-4 text-right"> <b style="border-top: 1px solid;">Approved By</b> </div>
                    
                    </div>
                </div>
            </div>
        </div>

        <div class="sperator"></div>
        
        <div class="white-box">
            <div class="row " style="text-transform: uppercase; font-weight: 600;">
                <div class="col-sm-12 col-xs-12 text-center">
                    <h3><strong>
                        @if($rebate->property)
                            @if($rebate->property->inventory->multiProject)
                                {{ $rebate->property->inventory->multiProject->name }}
                            @endif
                        @endif
                    </strong></h3>
                    <h3><strong>Rebate Payment</strong></h3> <span class="payment">Dealer Copy</span> 
                </div>
                
                <div class="col-sm-12 col-xs-12">
                    <div class="row">
                        
                        <div class="col-sm-4 col-xs-4"> 
                            <span class="pull-left">Sales Partner Code:&nbsp;</span>
                            <div style="border-bottom: 1px dotted;display: flex;">&nbsp;<strong> {{ $rebate->dealer->code}}</strong></div>
                        </div>
                        
                        <div class="col-sm-4 col-xs-4"> &nbsp; </div>
                        
                        <div class="col-sm-4 col-xs-4">
                            <div class="col-sm-12 col-xs-12"><b>Voucher No.</b>&nbsp; 
                                <strong>{{ $rebate->id}}</strong></div>
                            <div class="col-sm-12 col-xs-12"><b>Date:</b>&nbsp;
                                <strong>{{date('d-m-Y',strtotime($rebate->date))}}</strong>
                            </div>
                        </div>
                        <br>
                        <br>
                        
                        <div class="col-sm-12 col-xs-12"> 
                            <span class="pull-left">Paying with thanks to Mr.&nbsp;</span>
                            <div style="border-bottom: 1px dotted; display: flex;">&nbsp; 
                                <strong>{{ $rebate->dealer->name}}</strong>
                            </div>
                        </div>
                        <div class="clearfix" style="margin-bottom: 8px"></div>

                    
                        <div class="col-xs-7 col-sm-6"> Payment Mode: 
                        
                             @if($rebate->payment_method == \App\Receipt::cash) 
                            Cash  

                            @elseif($rebate->payment_method == \App\Receipt::bank) 
                            Bank  

                            @elseif($rebate->payment_method == \App\Receipt::cheque) 
                            Cheque 

                            @elseif($rebate->payment_method == \App\Receipt::adjustment) 
                            Adjustment 
                            @endif 
                         

                          &nbsp;&nbsp;&nbsp;&nbsp;<span style="margin-left: 10rem;"> Holding tax: @if($rebate->dealer->is_filer == 1) {{'12%'}} @else {{'24%'}} @endif</span>
                        </div>
                        
                        <div class="col-sm-6 col-xs-5"> 
                            <span class="pull-left">On account of Office/shop/Floor&nbsp;&nbsp;</span>
                            <div style="border-bottom: 1px dotted;display: flex;">&nbsp;&nbsp; 
                                <strong>{{$rebate->property?$rebate->property->inventory->unit_number:''}}</strong>
                            </div>
                        </div>
                        <div class="clearfix" style="margin-bottom: 8px"></div>
                        
                        <div class="col-xs-6 col-sm-6"> 
                            <span class="pull-left">PKR &nbsp;</span>
                            <div class="col-xs-11 col-sm-11" style="border-bottom: 1px dotted; text-align: center;">&nbsp;<strong>{{ number_format($rebate->amount - $rebate->tax_amount)}}</strong>
                            </div>
                        </div>

                        @if($rebate->payment_method == \App\Receipt::bank || $rebate->payment_method == \App\Receipt::cheque)
                        <div class="col-xs-4 col-sm-4"> 
                            <span class="pull-left">Instruement No.&nbsp;</span>
                            <div style="border-bottom: 1px dotted;display: flex;">
                                {{$rebate->cheque_number}} 
                                <strong></strong>
                            </div>

                        </div>

                        <div class="col-xs-2 col-sm-2"> 
                            <b>Drawn ON:</b>
                            <strong>{{$rebate->drawn_date}}</strong>
                        </div>
                        @endif
                        <br>
                        <br>
                        <div class="clearfix" style="margin-bottom: 8px"></div>

                        <div class="col-xs-4 col-sm-3">Amount in words (PKR)</div>
                        
                        <div class="col-sm-9 col-xs-8">{{ $digit->format($rebate->amount - $rebate->tax_amount) }}</div>
                        
                        <div class="col-sm-12 col-xs-12">
                            <br> <span><strong>Note:&nbsp;</strong> {{ $rebate->description }}</span> </div>
                        <div class="clearfix" style="margin-bottom: 70px"></div>
                        
                        <div class="col-xs-4 col-sm-4"> 
                            <b style="border-top: 1px solid;">Received By</b> 
                        </div>
                        
                        <div class="col-xs-4 col-sm-4 text-center"> 
                            <b style="border-top: 1px solid;">Accountant</b> 
                        </div>
                        
                        <div class="col-sm-4 col-xs-4 text-right"> 
                            <b style="border-top: 1px solid;">Approved By</b> 
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div style="display: inline-block; ">
        <div class="text-right no-print" style="display: inline-block; margin-bottom: 95px">
            <button class="btn btn-default btn-outline" onclick="window.print();return false;" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
        </div>
    </div>
</div>
<!-- /.container-fluid -->
@stop

@section('js')
<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>

<script>

$(function () {
    $("#print").on("click", function () {
        var mode = 'iframe'; //popup
        var close = mode == "popup";
        var options = {
            mode: mode,
            popClose: close
        };
        $("div.printableArea").printArea(options);
    });
});

</script>

<script>
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
</script>
@stop