@extends('layouts.app')

@section('title')
Add Dealer Payment 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-dealer')
        <li ><a href="{{route('dealer.all')}}">All Sale Networks</a></li>
        @endpermission
        <li class="active">Add Dealer Payment</li>
      </ol>
@stop

@section('css')
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">

@stop

@section('content')

<div class="container-fluid">
    <form method="post" action="{{route('dealer.payment.create')}}" class="form-horizontal">
        {{csrf_field()}}
	<div class="row">
		<div class="col-lg-12 col-sm-12 col-xs-12">
             @if($errors->any())
                        <div class="white-box"><h2>Errors</h2><ul>
    {!! implode('', $errors->all('<li><span class="help-block"><strong>:message</strong></span></li>')) !!}
</ul></div>@endif
            <div class="white-box">
                <h3 class="box-title">Dealer Payment Information</h3>
                            <hr>
                 <div class="col-md-6">
                         <div class="form-group">
                           <label class="control-label col-md-4">Select Dealer <span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                            <select name="dealer_id" id='dealer_id' class="form-control chosen-select" onchange="updateProperty(this.value)">
                                                                <option value="" selected="">None</option>
                                                              @foreach($dealers as $dealer)
                                                              @if(old('dealer_id') == $dealer->id)
                                                              <option selected="" value="{{$dealer->id}}">{{$dealer->name}} - {{$dealer->code}}</option>
                                                              @else
                                                               <option value="{{$dealer->id}}">{{$dealer->name}} - {{$dealer->code}}</option>
                                                              @endif
                                                              @endforeach
                                                            </select>
                                                            @if ($errors->has('dealer_id'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('dealer_id') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="col-md-12" id='property'>


                            </div>

                            <div class="clearfix"></div>
                            <br>
                            <br>
                            <div class="col-md-6">
                         <div class="form-group">
                           <label class="control-label col-md-4">Payment Mode <span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                            <select class="form-control chosen-select" name='payment_mode' onchange="changeFunc(this.value)">
                                                                @if(old('payment_mode') == \App\Receipt::cash)
                                                                <option value="{{\App\Receipt::cash}}" selected="">Cash</option>
                                                                <option value="{{\App\Receipt::bank}}">Bank Transfer</option>
                                                                <option value="{{\App\Receipt::cheque}}">Cheque</option>
                                                                <option value="{{\App\Receipt::adjacement}}">Adjustment</option>
                                                                @elseif(old('payment_mode') == \App\Receipt::bank)
                                                                <option value="{{\App\Receipt::cash}}" >Cash</option>
                                                                <option value="{{\App\Receipt::bank}}" selected="">Bank Transfer</option>
                                                                <option value="{{\App\Receipt::cheque}}">Cheque</option>
                                                                <option value="{{\App\Receipt::adjacement}}">Adjustment</option>
                                                                @elseif(old('payment_mode') == \App\Receipt::cheque)
                                                                <option value="{{\App\Receipt::cash}}" >Cash</option>
                                                                <option value="{{\App\Receipt::bank}}">Bank Transfer</option>
                                                                <option value="{{\App\Receipt::cheque}}" selected="">Cheque</option>
                                                                <option value="{{\App\Receipt::adjacement}}">Adjustment</option>
                                                                @elseif(old('payment_mode') == \App\Receipt::cheque)
                                                                <option value="{{\App\Receipt::cash}}" >Cash</option>
                                                                <option value="{{\App\Receipt::bank}}">Bank Transfer</option>
                                                                <option value="{{\App\Receipt::cheque}}" selected="">Cheque</option>
                                                                <option selected="" value="{{\App\Receipt::adjacement}}">Adjustment</option>
                                                                @else
                                                                <option selected='' value="{{\App\Receipt::cash}}" selected="">Cash</option>
                                                                <option value="{{\App\Receipt::bank}}">Bank Transfer</option>
                                                                <option value="{{\App\Receipt::cheque}}">Cheque</option>
                                                                <option value="{{\App\Receipt::adjacement}}">Adjustment</option>
                                                                @endif
                                                            </select>
                                                            @if ($errors->has('payment_mode'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('payment_mode') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>
                            <div class="col-md-6" id='bank'  style="display: none;">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Depositor Bank Name</label>
                                                        <div class="col-md-8">
                                                           <select name="bank_name"  class="form-control chosen-select" >
                                                                <option value="" selected="">None</option>
                                                              @foreach($banks as $bank)
                                                              @if(old('bank_name') == $bank->id)
                                                              <option selected="" value="{{$bank->id}}">{{$bank->name}}</option>
                                                              @else
                                                               <option value="{{$bank->id}}">{{$bank->name}}</option>
                                                              @endif
                                                              @endforeach
                                                            </select>
                                                        @if ($errors->has('bank_name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('bank_name') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>
                            <div id='adjacement'  style="display: none;">
                            <div class="col-md-6" >
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Adjustment Type <span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                           <select class="form-control chosen-select" name='adjacement_type'>
                                                                @if(old('adjacement_type') == \App\ProjectAccount::property)
                                                                <option value="{{\App\ProjectAccount::property}}" selected="">Property</option>
                                                                <option value="{{\App\ProjectAccount::vehicle}}" >Vehicle</option>
                                                                <option value="{{\App\ProjectAccount::others}}" >Other</option>

                                                                @elseif(old('adjacement_type') == \App\ProjectAccount::vehicle)
                                                                <option value="{{\App\ProjectAccount::property}}" >Property</option>
                                                                <option value="{{\App\ProjectAccount::vehicle}}" selected="">Vehicle</option>
                                                                <option value="{{\App\ProjectAccount::others}}" >Others</option>
                                                                @elseif(old('adjacement_type') == \App\ProjectAccount::others)
                                                                <option value="{{\App\ProjectAccount::property}}" >Property</option>
                                                                <option value="{{\App\ProjectAccount::vehicle}}" >Vehicle</option>
                                                                <option value="{{\App\ProjectAccount::others}}" selected="">Others</option>

                                                                @else
                                                                <option selected='' value="{{\App\ProjectAccount::property}}" selected="">Property</option>
                                                                <option value="{{\App\ProjectAccount::vehicle}}">Vehicle</option>
                                                                <option value="{{\App\ProjectAccount::others}}" >Others</option>
                                                                @endif
                                                            </select>
                                                        @if ($errors->has('adjacement_type'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('adjacement_type') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>
                            <div class="col-md-6" >
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Adjustment Detail <span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                          <textarea name="adjacement_detail" class="form-control"></textarea>

                                                        @if ($errors->has('adjacement_detail'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('adjacement_detail') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>
                          </div>
                            <div class="col-md-6" id='company-bank'  style="display: none;">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Company Account</label>
                                                        <div class="col-md-8">
                                                           <select name="company_account"  class="form-control chosen-select" >
                                                                <option value="" selected="">None</option>
                                                              @foreach($cBanks as $bank)
                                                              @if(old('bank_name') == $bank->id)
                                                              <option selected="" value="{{$bank->id}}">{{$bank->bank->name}} - {{$bank->account_number}}</option>
                                                              @else
                                                               <option value="{{$bank->id}}">{{$bank->bank->name}} - {{$bank->account_number}}</option>
                                                              @endif
                                                              @endforeach
                                                            </select>
                                                        @if ($errors->has('company_account'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('company_account') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>
                            <div class="col-md-6" id='cheque' style="display: none;">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Cheque Number</label>
                                                        <div class="col-md-8">
                                                            <input type="text" name='cheque_number' value="{{old('cheque_number')}}" class="form-control" id="exampleInputEmail1" placeholder="Enter Check Number">
                                                        @if ($errors->has('cheque_number'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('cheque_number') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Amount <span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                            <input type="text" name="amount" value="{{old('amount')}}" class="form-control" id="amount" placeholder="Enter Amount">
                                                        @if ($errors->has('amount'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('amount') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>

                            <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Note</label>
                                                        <div class="col-md-8">
                                                          <textarea class="form-control" name="note">{{old('note')}}</textarea>

                                                        </div>
                                                    </div>
                            </div>

                            <br><div class="clearfix"></div>
                            
            

              <div class="col-md-6">
                    <div class="form-group">
                        <label class="control-label col-md-4">Date <span style="color: red">*</span></label>
                    <div class="col-md-8">
                        <input type="date" class="form-control" name='date' value="{{old('date')}}" id="exampleInputEmail1" placeholder="Date">
                    @if ($errors->has('date'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('date') }}</strong>
                                    </span>
                                @endif
                    </div>
                    </div>
              </div>

              <div class="form-group m-b-0 pull-right">
                    <div class="col-sm-offset-3 col-sm-9">
                        <button type="submit" class="btn btn-info  waves-effect waves-light ">Save</button>
                    </div>
              </div>
            </div>
        </div>
    </div>
    </form>
</div>


@stop

@section('js')
<script>
	function changeFunc(a){
		if(a == {{\App\Receipt::cash}})
		{
			$('#bank').css('display', 'none');
      $('#company-bank').css('display', 'none');
			$('#cheque').css('display', 'none');
      $('#adjacement').css('display', 'none');
		}
		else if(a == {{\App\Receipt::bank}})
		{
			$('#bank').css('display', 'block');
      $('#company-bank').css('display', 'block');
			$('#cheque').css('display', 'none');
      $('#adjacement').css('display', 'none');
		}
		else if(a == {{\App\Receipt::cheque}})
		{
			$('#bank').css('display', 'block');
      $('#company-bank').css('display', 'block');
			$('#cheque').css('display', 'block');
      $('#adjacement').css('display', 'none');
		}
    else if(a == {{\App\Receipt::adjacement}})
    {
      $('#bank').css('display', 'none');
      $('#company-bank').css('display', 'none');
      $('#cheque').css('display', 'none');
      $('#adjacement').css('display', 'block');
    }
	}

function updateProperty(){
    $('.preloader').fadeIn();

    var dealer_id = $('#dealer_id').val();


    var data = {'dealer_id':dealer_id};

    $.get('/dealer/payment/update-properties', data, function (data) {

        document.getElementById('property').innerHTML = data;
        $('#myTable').DataTable({
            "paging":   false,
        "ordering": false,
        "info":     false
        });
    });

  //  $('#wait').hide();
   $('.preloader').fadeOut();
}

</script>
@stop