@extends('layouts.app')


@section('title')
Dealer Detail
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-dealer')
        <li ><a href="{{route('dealer.all')}}">All Sale Networks</a></li>
        @endpermission
        <li class="active">Dealer Detail</li>
      </ol>
@stop

@section('content')
            <div class="container-fluid">
                <div class="row colorbox-group-widget">
                     <div class="col-md-3 col-sm-6 info-color-box">
                        <div class="white-box">
                            <div class="profile-widget">
                                <div class="profile-img">
                                    <img src="{{asset('plugins/images/users/jeffery.png')}}" height="70px" width="auto" alt="user-img" class="img-circle">
                                     <p class="m-t-10 m-b-5"><a href="javascript:void(0);" class="profile-text font-22 font-semibold">{{$dealer->name}}</a></p>
                                     <p class="m-t-10 m-b-5"><a  class="profile-text font-16 font-semibold">{{$dealer->dealerType ? $dealer->dealerType->name : ''}}</a></p>

                                    @if($dealer->status == true)
                                    <span class="label label-success ">Active</span>
                                    @else
                                    <span class="label label-danger ">InActive</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-6 info-color-box">
                        <div class="white-box">
                            <div class="media bg-primary">
                                <div class="media-body">
                                    <h3 class="info-count">{{number_format($total_sales)}}<span class="pull-right"><i class="mdi mdi-comment-text-outline"></i></span></h3>
                                    <p class="info-text font-12">PKR</p>
                                    <p class="info-ot font-20">Total Sale</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-6 info-color-box">
                        <div class="white-box">
                            <div class="media bg-info">
                                <div class="media-body">
                                    <h3 class="info-count">{{number_format($total_rebates)}} <span class="pull-right"><i class="mdi mdi-coin"></i></span></h3>
                                    <p class="info-text font-12">PKR</p>
                                    <p class="info-ot font-20">Total Rebate</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-6 info-color-box">
                        <div class="white-box">
                            <div class="media bg-success">
                                <div class="media-body">
                                    <h3 class="info-count">{{number_format($total_paid_rebates)}}<span class="pull-right"><i class="mdi mdi-checkbox-marked-circle-outline"></i></span></h3>
                                    <p class="info-text font-12">PKR </p>
                                    <p class="info-ot font-20"> Paid Amount</p>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title">Basic Information</h3>
                            <hr>
                                    <div class="table-responsive">
                                        <table class="table">
                                            <tbody>
                                                <tr>
                                                    <td>Code</td>
                                                    <td> {{$dealer->code}} </td>
                                                </tr>
                                                @if(!empty($dealer->cnic))
                                                <tr>
                                                    <td>CNIC</td>
                                                    <td> {{$dealer->cnic}} </td>
                                                </tr>
                                                @endif
                                                @if(!empty($dealer->reg_no))
                                                <tr>
                                                    <td>Reg No</td>
                                                    <td> {{$dealer->reg_no}} </td>
                                                </tr>
                                                @endif

                                                <tr>
                                                    <td>Is Filer</td>
                                                    <td> {{$dealer->is_filer ? 'YES' : 'NO'}} </td>
                                                </tr>
                                                <tr>
                                                    <td>NTN Number</td>
                                                    <td>{{$dealer->ntn_number}}</td>
                                                </tr>
                                                <tr>
                                                    <td>Address</td>
                                                    <td> {{$dealer->address}}{{$dealer->city ? ', '.$dealer->city->name.', '.$dealer->city->country->name : ''}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Email</td>
                                                    <td> {{$dealer->email}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Phone Number</td>
                                                    <td> {{$dealer->phone_number}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Percentage</td>
                                                    @if($dealer->rebate_in_percent)
                                                    <td> {{$dealer->percentage}} %</td>
                                                    @else
                                                    <td> {{$dealer->percentage}} PKR</td>
                                                    @endif
                                                </tr>
                                                

                                                <tr>
                                                    <td>Updated at</td>
                                                    <td> {{$dealer->updated_at}}</td>
                                                </tr>
                                                <tr>
                                                    <td>Created at</td>
                                                    <td> {{$dealer->created_at}}</td>
                                                </tr>

                                            </tbody>
                                        </table>
                                    </div>

                        </div>
                    </div>
                </div>
                <!-- /.row -->

                {{-- Dealer Open Files --}}
                @if(\App\ProjectType::getProjectType() == \App\ProjectType::society)
                <div class="row">
                    <div class="col-md-12">
                        <div class="white-box user-table">
                            <div class="row">
                                <div class="col-sm-6">
                                    <h4 class="box-title">Open File Packages</h4>
                                </div>


                            </div><hr>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped myTable">
                                    <thead>
                                    <tr>

                                        <th>Package Name</th>
                                        <th>Total Amount</th>
                                        <th>Received Amount</th>
                                        <th>Issue Date</th>
                                        <th>Payment Status</th>
                                           <th>Action</th>
                                        
                                    </tr>
                                    </thead>
                                   
                                    <tbody>

                                   @foreach($dealer_openfile_package as $dealer_package)
                                    
                           <tr>

                                    <td>
                                        {{$dealer_package->package->name}}
                                    </td>
                                    <td>
                                        {{$dealer_package->package->total_price}} pkr
                                    </td>
                                    <td>   
                                        {{$dealer_package->dealerPackagePaymentReceipt->where('is_approved', 1)->sum('amount')}} pkr
                                    </td>
                                    <td>
                                        {{$dealer_package->issue_date}} 
                                    </td>
                                    <td>
                                        @if($dealer_package->payment_status == \App\DealerPackage::pending)
                                        <span class="label label-danger">Pending</span>
                                         @elseif($dealer_package->payment_status == \App\DealerPackage::completed)
                                         <span class="label label-success">Completed</span>
                                         @endif 
                                    </td>
                                    <td>
                                       
                                        <a href="{{route('dealer.package.detail',$dealer_package->id)}}" data-toggle="tooltip" data-original-title="View"> <i class="fa fa-eye text-inverse m-r-10"></i> </a>
                                       

                                      
                                        {{-- <a href="#" data-toggle="tooltip" data-original-title="Edit"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a>
                                       
                                        <a data-toggle="confirmation" data-title="Are you sure to delete?" href="#"> <i class="fa fa-close text-danger"></i> </a>
                                         --}}
                                    </td>
                                    
                           </tr> 
                                   @endforeach


                                    </tbody>
                                    

                                    <tfoot>
                                        {{-- <tr>
                                            <th colspan="2" style="text-align: center;">Total</th>
                                            <th>{{number_format($net_amount)}}</th>
                                           
                                            <th>{{number_format($total_rebate)}}</th>
                                            
                                            <th>{{number_format($total_received)}}</th>
                                            <th>{{number_format($paid_rebates)}}</th>
                                        </tr> --}}
                                    </tfoot>
                                </table>
                            </div>

                        </div>

                    </div>

                </div>
                @endif
                {{-- End Dealer Open Files --}}

                <div class="row">
                    <div class="col-md-12">
                        <div class="white-box user-table">
                            <div class="row">
                                <div class="col-sm-6">
                                    <h4 class="box-title">Dealer Rebate</h4>
                                </div>


                            </div>
                            <div class="container">
                                <ul class="nav customtab nav-tabs" role="tablist">
        
                                    <li role="presentation" class="active"><a href="#inventory_dealer_rebate" aria-controls="home" role="tab" data-toggle="tab" aria-expanded="true"><span class="visible-xs"><i class="ti-home"></i></span><span class="hidden-xs">Inventory Rebate <span class="label label-rounded pull-right" style="line-height: 1.8;    min-width: 0px;font-size: 14px;padding: 0px 8px;background-color: rgb(204 2 2);">{{count($transactions)}}</span></span></a></li>
                                    @if($projectType->id == \App\ProjectType::society)
                                    <li role="presentation" class=""><a href="#package_dealer_rebate" aria-controls="profile" role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i class="ti-user"></i></span> <span class="hidden-xs">Package Rebate <span class="label label-rounded pull-right" style="line-height: 1.8;    min-width: 0px;font-size: 14px;padding: 0px 8px;background-color: rgb(204 2 2);">{{count($package_transactions)}}</span></span></a></li>
                                    @endif
                                </ul>
                                </div>
                            <hr>
                            <div class="tab-content">
                                <div id="inventory_dealer_rebate" class="tab-pane fade in active"> 
                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped myTable">
                                    <thead>
                                    <tr>

                                        <th>Unit No.</th>
                                        <th>Client</th>
                                        <th>Net Amount</th>

                                        <th>Total Rebate Payable</th>

                                        
                                        
                                        <th>Total Received Amount</th>
                                        <th>Paid Rebate</th>

                                           <th>Status</th>
                                        
                                    </tr>
                                    </thead>
                                    <?php $net_amount = 0;$total_rebate = 0;$total_received = 0;$paid_rebates = 0;?>
                                    <tbody>

                                    @foreach($transactions as $t)
                                        @if($t->property)
                                            <tr>


                                                <td>

                                                    
                                                    {{$t->property->inventory->unit_number}}</td>
                                                <td>{{$t->property->customer->name}}</td>

                                                <td>{{number_format($t->property->net_pay)}}
                                                    <?php $net_amount +=$t->property->net_pay;?></td>

                                                <td>{{number_format($t->amount)}}
                                                    <?php $total_rebate += $t->amount;?></td>
                                                

                                                <td>{{number_format($received_amount[$t->id])}}
                                                    <?php $total_received +=$received_amount[$t->id];?> </td>
                                                <td>{{number_format($paid_rebate[$t->id])}}
                                                    <?php $paid_rebates += $paid_rebate[$t->id];?></td>
                                                    
                                                    
                                                @if($t->property->status == \App\CustomerProperty::pending)
                                                <td><span class="label label-primary" style="background-color:#cd703d;">Pending</span></td>
                                                
                                                @elseif($t->property->status == \App\CustomerProperty::approved)
                                                <td><span class="label label-success">Approved</span></td>
                                                @elseif($t->property->status == \App\CustomerProperty::cancel)
                                                <td><span class="label label-danger">Canceled</span></td>
                                                @else
                                                <td></td>
                                                @endif
                                            
                                            

                                            </tr>
                                        @endif
                                    @endforeach


                                    </tbody>
                                    

                                    <tfoot>
                                        <tr>
                                            <th colspan="2" style="text-align: center;">Total</th>
                                            <th>{{number_format($net_amount)}}</th>
                                           
                                            <th>{{number_format($total_rebate)}}</th>
                                            
                                            <th>{{number_format($total_received)}}</th>
                                            <th>{{number_format($paid_rebates)}}</th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                                </div>


                                <div id="package_dealer_rebate" class="tab-pane fade in "> 
                                    <div class="table-responsive">
                                        <table id="ajax_myTable" class="table table-striped myTable">
                                            <thead>
                                            <tr>
        
                                                <th>Package</th>
                                                
                                                <th>Net Amount</th>
        
                                                <th>Total Rebate Payable</th>
        
                                                
                                                
                                                <th>Total Received Amount</th>
                                                <th>Paid Rebate</th>
                                               
                                                   
                                                
                                            </tr>
                                            </thead>
                                            <?php $package_net_amount = 0;$package_total_rebate = 0;$package_total_received = 0;$package_paid_rebates = 0;?>
                                            <tbody>
        
                                            @foreach($package_transactions as $t)
                                                @if($t->dealerPackage)
                                                    <tr>
        
        
                                                        <td>
        
                                                            
                                                            {{$t->dealerPackage->package->name}}</td>
                                                       
        
                                                        <td>{{number_format($t->dealerPackage->package->total_price)}}
                                                            <?php $package_net_amount +=$t->dealerPackage->package->total_price;?></td>
        
                                                        <td>{{number_format($t->amount)}}
                                                            <?php $package_total_rebate += $t->amount;?></td>
                                                        
        
                                                        <td>{{number_format($package_received_amount[$t->id])}}
                                                            <?php $package_total_received +=$package_received_amount[$t->id];?> </td>
                                                        <td>{{number_format($package_paid_rebate[$t->id])}}
                                                            <?php $package_paid_rebates += $package_paid_rebate[$t->id];?></td>
                                                            
                                                            
                                                       
                                                    
                                                    
        
                                                    </tr>
                                                @endif
                                            @endforeach
        
        
                                            </tbody>
                                            
        
                                            <tfoot>
                                                <tr>
                                                    <th  >Total</th>
                                                    <th>{{number_format($package_net_amount)}}</th>
                                                   
                                                    <th>{{number_format($package_total_rebate)}}</th>
                                                    
                                                    <th>{{number_format($package_total_received)}}</th>
                                                    <th>{{number_format($package_paid_rebates)}}</th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                        </div>

                            </div>

                        </div>

                    </div>

                </div>
                

                  <div class="row">
                    <div class="col-md-12">
                        <div class="white-box user-table">
                            <div class="row">
                                <div class="col-sm-6">
                                    <h4 class="box-title">Dealer Paid Rebates</h4>
                                </div>
                               
                            </div>
                            
                            <div class="container">
                                <ul class="nav customtab nav-tabs" role="tablist">
        
                                    <li role="presentation" class="active"><a href="#inventory" aria-controls="home" role="tab" data-toggle="tab" aria-expanded="true"><span class="visible-xs"><i class="ti-home"></i></span><span class="hidden-xs">Inventory Rebate <span class="label label-rounded pull-right" style="line-height: 1.8;    min-width: 0px;font-size: 14px;padding: 0px 8px;background-color: rgb(204 2 2);">{{count($inventory_rebate)}}</span></span></a></li>
                                    @if($projectType->id == \App\ProjectType::society)
                                    <li role="presentation" class=""><a href="#package" aria-controls="profile" role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i class="ti-user"></i></span> <span class="hidden-xs">Package Rebate <span class="label label-rounded pull-right" style="line-height: 1.8;    min-width: 0px;font-size: 14px;padding: 0px 8px;background-color: rgb(204 2 2);">{{count($package_rebate)}}</span></span></a></li>
                                    @endif
                                </ul>
                                </div>
                                <hr>
                          
                       
                                <div class="tab-content">
                                    <div id="inventory" class="tab-pane fade in active"> 
                            <div class="table-responsive" style=" overflow-y: auto; max-height: 400px">
                                <table class="table table-responsive myTable" >
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Unit #</th>
                                            <th>Amount</th>
                                            <th>Date</th>

                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;$t_rebate = 0;?>
                                        @if(!$inventory_rebate->isEmpty())
                                        
                                    
                                        @foreach($inventory_rebate as $rebate)
                                        <tr>
                                            <td>{{$count++}}</td>
                                            <td>{{$rebate->property?$rebate->property->inventory->unit_number:''}}</td>
                                           <td>{{number_format($rebate->amount)}}
                                            <?php $t_rebate += $rebate->amount;?></td>

                                            <td>{{date('d-m-Y', strtotime($rebate->date)) }}</td>
                                        </tr>
                                        @endforeach
                                        <tfoot>
                                        <tr>
                                            <td colspan="2" style="text-align: center;"><b>Total </b></td>
                                            <td><b>{{number_format($t_rebate)}}<b></td>
                                        </tr>
                                        </tfoot>
                                        @else

                                        <tr><td></td><td></td><td >No record found.<td></tr>
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                                    </div>



                                    <div id="package" class="tab-pane fade in"> 
                                        <div class="table-responsive" style=" overflow-y: auto; max-height: 400px">
                                            <table class="table table-responsive myTable" >
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>Package </th>
                                                        <th>Amount</th>
                                                        <th>Date</th>
            
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $count =1;$t_rebate = 0;?>
                                                    @if(!$package_rebate->isEmpty())
                                                    @foreach($package_rebate as $rebate)
                                                    <tr>
                                                        <td>{{$count++}}</td>
                                                        <td>{{$rebate->dealerPackage?$rebate->dealerPackage->package->name:''}}</td>
                                                       <td>{{number_format($rebate->amount)}}
                                                        <?php $t_rebate += $rebate->amount;?></td>
            
                                                        <td>{{date('d-m-Y', strtotime($rebate->date)) }}</td>
                                                    </tr>
                                                    @endforeach
                                                    <tfoot>
                                                    <tr>
                                                        <td colspan="2" style="text-align: center;"><b>Total </b></td>
                                                        <td><b>{{number_format($t_rebate)}}<b></td>
                                                    </tr>
                                                    </tfoot>
                                                    @else
            
                                                    <tr><td></td><td></td><td >No record found.<td></tr>
                                                    @endif
                                                </tbody>
                                            </table>
                                        </div>
                                                </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>


<div class="row">
                    <div class="col-md-12">
                        <div class="white-box user-table">
                            <div class="row">
                                <div class="col-sm-6">
                                    <h4 class="box-title">Dealer Customer Properties</h4>
                                </div>


                            </div><hr>
<div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Sr #</th>
                                            <th>Unit #</th>
                                            <th>Customer</th>
                                             <th>Net Amount </th>
                                            <th>Received Amt.</th>
                                            <th>Remaining Amt.</th>
                                            <th>Last Payment Date</th>
                                            <th>Due Amt.</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;$net_amount = 0;$received_amount = 0;$remaining_amount = 0;$due_amount = 0;?>
                                        @foreach($properties as $property)

                                        @if($color[$property->id] == 'red')
                                              <tr style="color:red;">
                                          @elseif($color[$property->id] == 'orange')
                                              <tr style="color:orange;">
                                          @else
                                              <tr style="color:black;">
                                                  @endif
                                            <td>{{$count++}}</td>
                                            <td>{{$property->inventory->unit_number}}</td>
                                            <td>{{$property->customer->name}}</td>
                                            <td>{{number_format($property->net_pay)}}
                                                <?php $net_amount += $property->net_pay;?></td>
                                            <td>{{number_format($receivedAmount[$property->id])}}
                                                <?php $received_amount += $receivedAmount[$property->id];?></td>
                                            <td>{{number_format($remainingAmount[$property->id])}}
                                                <?php $remaining_amount +=$remainingAmount[$property->id];?> </td>
                                             <td> {{$lastDate[$property->id] ? date('d-m-Y', strtotime($lastDate[$property->id]->receipt_date)) : ''}}</td>
                                             <td>{{number_format($dueAmt[$property->id])}} 
                                             <br>@foreach($dueMonth[$property->id] as $s) @if($loop->last){{date('M', strtotime($s->due_date))}} @else{{date('M', strtotime($s->due_date))}} - @endif @endforeach

                                             <?php $due_amount +=$dueAmt[$property->id];?>
                                         </td>

                                             <td>
                                                @permission('sms-dealer')
                                                <a href="#" onclick="openSmsModal({{$property->id}})" ><i class="fa fa-comment"></i></a> &nbsp;&nbsp;
                                                @endpermission

                                                <a href="#" onclick="openDealerTransferModal({{$dealer->id}},{{$property->id}})">Transfer </a>
                                            </td>

                                        </tr>
                                        @endforeach




                                    </tbody>

                                    <tfoot>
                                        <tr>
                                            <th colspan="3" style="text-align: center;">Total</th>
                                            <th>{{number_format($net_amount)}}</th>
                                            <th>{{number_format($received_amount)}}</th>
                                            <th>{{number_format($remaining_amount)}}</th>
                                            <th></th>
                                            <th>{{number_format($due_amount)}}</th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>


                @permission('dealer-payment')
<!-- 
                <div class="row">
                    <div class="col-md-12">
                        <div class="white-box user-table">
                            <div class="row">
                                <div class="col-sm-6">
                                    <h4 class="box-title">Dealer Received Payments (Rs.{{number_format($dealerReceivedAmount->sum('amount'))}}/-)</h4>
                                </div>


                            </div><hr> -->
<!-- <div class="table-responsive">
                                <table id="myTable1" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Sr #</th>
                                            <th>Date</th>
                                            <th>Plot No.</th>
                                            <th>Amount</th>
                                             <th>Payment Mode</th>
                                             <th>note</th>
                                            <th>Action</th>
                                            
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        @foreach($dealerReceivedAmount as $amount)

                                        <tr>
                                            <td>{{$count++}}</td>
                                            <td> {{date('d-m-Y', strtotime($amount->date))}}</td>
                                            <td>{{$amount->property->inventory->plot_number}}</td>
                                            <td>Rs.{{number_format($amount->amount)}}/-</td>
                                            @if($amount->payment_mode == \App\Receipt::cash)
                                            <td><b>Cash</b></td>
                                            @elseif($amount->payment_mode == \App\Receipt::bank)
                                            <td><b>Bank transfer</b><br>
                                                <b>DB:</b>{{$amount->depositorbank ? $amount->depositorbank->name : ''}}<br>
                                                <b>CB:</b>{{$amount->companyAccount ? $amount->companyAccount->bank->name . ' - '.$amount->companyAccount->account_number : '' }}<br>
                                            </td>
                                            @elseif($amount->payment_mode == \App\Receipt::cheque)
                                            <td><b>Cheque</b><br>
                                            <b>DB:</b>{{$amount->depositorbank ? $amount->depositorbank->name : ''}}<br>
                                            <b>CB:</b>{{$amount->companyAccount ? $amount->companyAccount->bank->name . ' - '.$amount->companyAccount->account_number : '' }}<br>
                                            <b>CH:</b>{{$receipt->cheque_number}}
                                        </td>
                                            @elseif($amount->payment_mode == \App\Receipt::adjacement)
                                            <td>Adjustment</td>
                                            @endif
                                            <td>{{$amount->note}}</td>

                                            <td>
                                                <a href="{{route('dealer.payment.delete',['id'=>$amount->id])}}" data-toggle="tooltip" data-original-title="Delete"> <i class="fa fa-close text-danger"></i> </a>
                                            </td>
                                             
                                            
                                        </tr>
                                        @endforeach


                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>-->
                @endpermission

              </div> 
            <!-- /.container-fluid -->

            <div class="modal fade" id="exampleModal1" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  
</div>


<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Send Sms</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body" style="height: 200px;">

        <div class="form-group form-group-sm">
            <div class="col-xs-4">
                <label>Plot Info.</label>
            </div>
            <div class="col-xs-8">
                <input type="number"  name="info" placeholder="Enter Amount" class="form-control" readonly="">
            </div>
        </div>
        <div class="form-group form-group-sm">
            <div class="col-xs-4">
                <label>Phone Number</label>
            </div>
            <div class="col-xs-8">
                <input type="number"  name="number" placeholder="Enter Amount" class="form-control" readonly="">
            </div>
        </div>
        <div class="form-group form-group-sm">
            <div class="col-xs-4">
                <label>Message</label>
            </div>
            <div class="col-xs-8">
                <textarea class="form-control" name="message" ></textarea>
            </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <button type="button" class="btn btn-primary">Send</button>
      </div>
    </div>
  </div>
</div>

@stop

@section('js')
<script>
    $(function() {
        // $('#myTable').DataTable({
        //     "order":false
        // });
         $('#myTable1').DataTable({
            "order":false
        });
        $('.myTable').DataTable({
            "order":false
        });
        });
       
      
    function openSmsModal(property_id) {

        var data={'property_id':property_id};
        $.get('/update_sms_modal', data, function (data) {
            document.getElementById('exampleModal').innerHTML = data;
            $('#exampleModal').modal();
        });
    }

    function openDealerTransferModal(dealer_id,$property_id) {

        var data={'dealer_id':dealer_id,'property_id':$property_id};
        $.get('/update_dealer_transfer_modal', data, function (data) {
            document.getElementById('exampleModal1').innerHTML = data;
            $('#exampleModal1').modal();
            
        });
    }


    </script>
   <script>
    
    </script>
    
        
    @stop