@extends('layouts.app')

@section('title')
Edit Network 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-dealer')
        <li ><a href="{{route('dealer.all')}}">All Sale Networks</a></li>
        @endpermission
        <li class="active">Edit Newtork</li>
      </ol>
@stop

@section('content')

<div class="container-fluid">
                <!--.row-->
                <div class="row">

                    <div class="col-md-12">
                         @if($errors->any())
                        <div class="white-box"><h2>Errors</h2><ul>
    {!! implode('', $errors->all('<li><span class="help-block"><strong>:message</strong></span></li>')) !!}
</ul></div>@endif
                        <div class="white-box">
                            <h3 class="box-title m-b-0"><i class="icon-user fa-fw"></i> Edit Network</h3>
                            <p class="text-muted m-b-30 font-13"> Update the basic information </p>
                            <form class="form-horizontal" action="{{route('dealer.update')}}" method="post" onsubmit="return validate(this)">
                               {{csrf_field()}}
                               <input type="hidden" name="id" value="{{$dealer->id}}">

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">Full Name <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="ti-user"></i></div>
                                            <input  type="text" class="form-control" name="name" value="{{$dealer->name}}" id="exampleInputuname" placeholder="Enter Name">
                                        @if ($errors->has('name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">Code <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="ti-user"></i></div>
                                            <input  type="text" readonly class="form-control" name="code" value="{{$dealer->code}}" id="exampleInputuname" placeholder="Enter Code">
                                        @if ($errors->has('code'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('code') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="address" class="col-sm-2 control-label">Type <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-user"></i></div>
                                            <select class="form-control chosen-select"  name="incentive_type">
                                                <option value="" selected="">None</option>
                                                @foreach($types as $t)
                                                @if($dealer->dealer_type_id == $t->id)
                                                <option selected="" value="{{$t->id}}">{{$t->name}}</option>
                                                @else
                                                <option value="{{$t->id}}">{{$t->name}}</option>
                                                @endif
                                                @endforeach
                                            </select>
                                        @if ($errors->has('incentive_type'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('incentive_type') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="cnic" class="col-sm-2 control-label">CNIC <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="ti-world"></i></div>
                                            <input type="text"  class="form-control" value="{{$dealer->cnic}}" name="cnic" id="cnic" data-inputmask="'mask': '99999-9999999-9'"  placeholder="XXXXX-XXXXXXX-X"  onfocusout="return validateCnic(this)" >

                                            <div style="color: red;display: none;" id="cnic_error1">This Dealer cnic is found in list of DNFBP. You can't add this Dealer record. </div>

                                            
                                        @if ($errors->has('cnic'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('cnic') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputEmail1" class="col-sm-2 control-label">Is Filer </label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-phone"></i></div>
                                            <select class="form-control select2" name="is_filer">
                                                @if($dealer->is_filer)
                                                <option selected="" value="1">YES</option>
                                                <option value="0">NO</option>
                                                @else
                                                 <option value="1">YES</option>
                                                <option selected="" value="0">NO</option>

                                                @endif
                                            </select>
                                            

                                            @if ($errors->has('is_filer'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('is_filer') }}</strong>
                                    </span>
                                @endif</div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">NTN Number</label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="ti-user"></i></div>
                                            <input  type="text" class="form-control" name="ntn_number" value="{{$dealer->ntn_number}}" placeholder="Enter NTN">
                                        @if ($errors->has('ntn_number'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('ntn_number') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                               <div class="form-group">
                                    <label for="address" class="col-sm-2 control-label">Country <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-location-pin"></i></div>
                                            <select class="form-control chosen-select" id="country_id" name="country_id">
                                                <option value="" selected="">None</option>
                                                @foreach($countries as $c)
                                                @if($dealer->city)
                                                @if($dealer->city->country->id == $c->id)
                                                <option selected=""  value="{{$c->id}}">{{$c->name}}</option>
                                                @else
                                                <option  value="{{$c->id}}">{{$c->name}}</option>
                                                @endif

                                                @else
                                                 <option  value="{{$c->id}}">{{$c->name}}</option>
                                                 @endif
                                                @endforeach
                                            </select>
                                        @if ($errors->has('country_id'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('country_id') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                               <div class="form-group">
                                    <label for="address" class="col-sm-2 control-label">City <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-location-pin"></i></div>
                                            <select class="form-control chosen-select" id="city_id" name="city_id">
                                               @foreach($cities as $c)
                                               @if($dealer->city_id == $c->id)
                                               <option selected="" value="{{$c->id}}">{{$c->name}}</option>
                                                @else
                                                <option  value="{{$c->id}}">{{$c->name}}</option>
                                                @endif
                                                @endforeach

                                            </select>
                                        @if ($errors->has('city_id'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('city_id') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="address" class="col-sm-2 control-label">Address</label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="ti-lock"></i></div>
                                            <input type="text" class="form-control" name="address" value="{{$dealer->address}}" id="address1" placeholder="Enter Address">
                                        @if ($errors->has('address'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('address') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                                 <div class="form-group">
                                     <label for="exampleInputEmail1" class="col-sm-2 control-label">Email </label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="ti-email"></i></div>
                                            <input type="email"  class="form-control" name="email" value="{{$dealer->email}}" id="exampleInputEmail1" placeholder="Enter email">
                                        @if ($errors->has('email'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                     <label for="exampleInputEmail1" class="col-sm-2 control-label">Password </label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="ti-email"></i></div>
                                            <input type="text"  class="form-control" name="password" value="{{old('password')}}" id="exampleInputEmail1" placeholder="Enter password">
                                        @if ($errors->has('password'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('password') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="exampleInputEmail1" class="col-sm-2 control-label">Phone Number</label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="ti-email"></i></div>
                                           <input type="text" class="form-control" maxlength="12" data-inputmask="'mask': '0399-99999999'" type='number' name="phone_number" value="{{$dealer->phone_number}}"  placeholder="Enter Phone Number">
                                        @if ($errors->has('phone_number'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('phone_number') }}</strong>
                                    </span>
                                @endif</div>
                                    </div>
                                </div>
                               <div class="form-group">
                                                        <label class="control-label col-md-2">Rebate<br> (use percent
                                                            @if($dealer->rebate_in_percent)
                                                         <input type="checkbox" onclick="percentCheckbox()" name="rebate_in_percent" checked="" id="rebate_in_percent" value="1">
                                                         @else
                                                         <input type="checkbox" onclick="percentCheckbox()" name="rebate_in_percent" id="rebate_in_percent" value="1">

                                                         @endif
                                                     )</label>
                                                        <div class="col-md-10">
                                                             <div class="input-group" >
                                                                @if($dealer->rebate_in_percent)
                                                                <span class="input-group-addon" style="font-size: 12px;" id="rebate_input">%</span>
                                                                @else
                                                                <span class="input-group-addon" style="font-size: 12px;" id="rebate_input">PKR</span>

                                                                @endif
                                                                <input  type="numeric" class="form-control" name="percentage" value="{{$dealer->percentage}}" placeholder="Enter Rebate" >
                                                            </div> 

                                        @if ($errors->has('percentage'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('percentage') }}</strong>
                                    </span>
                                @endif

                                                        </div>
                                                    </div>


                               <div class="form-group">
                                    <label for="inputPassword3" class="col-sm-2 control-label">Status <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="ti-lock"></i></div>
                                            <select class="form-control " name="status">
                                                @if($dealer->status == true)
                                                <option value="1" selected="">Active</option>
                                                <option value="0">InActive</option>
                                                @else
                                                <option value="1" >Active</option>
                                                <option value="0" selected="">InActive</option>
                                                @endif
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group m-b-0">
                                    <div class="col-sm-offset-3 col-sm-9">
                                        <button type="submit" class="btn btn-info waves-effect waves-light m-t-10">Save</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!--./row-->
            </div>
            <!-- /.container-fluid -->

@stop


@section('js')

    <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js"></script>

    <script>
    
    
    
     function validate(self)
    {
        
        
        if($(self).find('input[name="name"]').val() == "")
        {
            $('#required_error').show()
             return false;
        }
        else if($(self).find('input[name="incentive_type"]').val() == "")
        {
            $('#required_error').show()
             return false;
        }
        else if($(self).find('input[name="cnic"]').val() == "")
        {
            $('#required_error').show()
             return false;
        }
        else if($(self).find('input[name="country_id"]').val() == "")
        {
            $('#required_error').show()
             return false;
        }
        else if($(self).find('input[name="city_id"]').val() == "")
        {
            $('#required_error').show()
             return false;
        }
        else
        {
             return true;
        }
        
    }
    
     setTimeout(function() { 
         $('#required_error').hide()
        }, 3000);
        
        

         function validateCnic(self) 
        {
           var cnic = $(self).val().replaceAll('-', '');

        $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
        });

        $.ajax({
        url:"{{ route('validate.dnfbp.cnic') }}",
        method:'POST',
        dataType:'json',
        data: {cnic:cnic},
        success:function(data)
        {
          if (data.response == 'invalid') 
          {
                $(self).closest('.input-group').find('#cnic_error1').show();
          }

        }
        })



        return false;
        }


    $(":input").inputmask();

$('#country_id').change(function() {
    $('.preloader').fadeIn();
        var data = { 'country_id': $(this).val() };

        $.get('/getCitiesByCountry', data, function (data) {
           var model = $('#city_id');
                    model.empty();

                     model.append("<option value='' disabled selected>" + '' + "</option>");


                    $.each(data, function(index, element) {
                        model.append("<option value='"+ element.id +"'>" + element.name + "</option>");
                    });
        });
         $('.preloader').fadeOut();
    });

function percentCheckbox() {

        if($('#rebate_in_percent').prop("checked") == false) {
            document.getElementById('rebate_input').innerHTML = 'PKR';
        }
        else {
            document.getElementById('rebate_input').innerHTML = '%';
        }
    }
   </script>
@stop