@extends('layouts.app')

@section('title')
All Dealers List
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Dealers List</li>
      </ol>
@stop

@section('css')

<link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">

<style>

table.dataTable thead .sorting_asc {
    background-image: none !important;
}

.table.dataTable, table.dataTable {
    width: 99.8%!important;
}
</style>

@stop

@section('content')


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                        	<div class="pull-right">
                                @permission('dealer-payment')
                                <!-- <a href="{{route('dealer.payment.add')}}" class="btn  btn-default">
                                    <i class="fa fa-plus-square"></i>&nbsp; Add Dealer Payment
                                </a> -->
                                @endpermission
                                
							</div>
                            <h3 class="box-title">All Dealers List</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Name</th>
                                            <th>Code</th>
                                            <th>Percentage</th>
                                            

                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        @permission('view-dealer') 
                                            <?php $view_dealer = true;?>
                                        @else
                                            <?php $view_dealer = false;?>
                                        @endpermission

                                        @permission('edit-dealer') 
                                            <?php $edit_dealer = true;?>
                                        @else
                                            <?php $edit_dealer = false;?>
                                        @endpermission

                                        @permission('delete-dealer') 
                                            <?php $delete_dealer = true;?>
                                        @else
                                            <?php $delete_dealer = false;?>
                                        @endpermission


                                        @foreach($allDealers as $dealer)
                                        <tr>
                                            <td>{{$count++}}</td>
                                            <td>
                                            @if($view_dealer) 
                                                <a href="{{route('dealer.detail',['id'=>$dealer->id])}}"><b>{{$dealer->name}}</b> - {{$dealer->dealerType ? $dealer->dealerType->name : ''}}</a>
                                                @else
                                                <b>{{$dealer->name}}</b> - {{$dealer->dealerType ? $dealer->dealerType->name : ''}}
                                                @endif

                                            </td>
                                            <td>{{$dealer->code}}</td>
                                            @if($dealer->rebate_in_percent)
                                            <td>{{$dealer->percentage}} %</td>
                                            @else
                                            <td>{{$dealer->percentage}} PKR</td>
                                            @endif
                                         
                                            <td class="text-nowrap">
                                                @if($view_dealer)
                                                <a href="{{route('dealer.detail',['id'=>$dealer->id])}}" data-toggle="tooltip" data-original-title="View"> <i class="fa fa-eye text-inverse m-r-10"></i> </a>
                                                @endif
                                                &nbsp;&nbsp;&nbsp;

                                                @if($edit_dealer)
                                                <a href="{{route('dealer.editView',['id'=>$dealer->id])}}" data-toggle="tooltip" data-original-title="Edit"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a>
                                                @endif
                                                    &nbsp;&nbsp;&nbsp;

                                                @if($delete_dealer)
                                                <a href="{{route('dealer.delete',['id'=>$dealer->id])}}" data-toggle="confirmation" data-title="Are you sure to delete?" > <i class="fa fa-close text-danger"></i> </a>
                                                @endif
                                            </td>
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')

<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

<script>
    $(function() {
        $('#myTable').DataTable({
            'pageLength':25,
            'dom': 'Bfrtip',
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
        });
    });

        
    </script>
@stop