
@extends('layouts.app')

@section('title')
Add New User 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @role('admin')
        <li ><a href="{{route('account.all')}}">All Users</a></li>
        @endrole
        <li class="active">Add User</li>
      </ol>
@stop
@section('content')

<div class="container-fluid">
                <!--.row-->
                <div class="row">

                    <div class="col-md-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0">Add New User</h3><hr>
                            <form class="form-horizontal" action="{{route('account.insert')}}" method="post" style="margin-top: 40px;">
                               {{csrf_field()}}
                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Name <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="text" class="form-control" name="name" value="{{old('name')}}" id="exampleInputuname" placeholder="Name">
                                        @if ($errors->has('name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Email <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="text" class="form-control" name="email" value="{{old('email')}}" id="exampleInputuname" placeholder="Email">
                                        @if ($errors->has('email'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Phone Number <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="text" class="form-control" name="phone_number" value="{{old('phone_number')}}" placeholder="Phone Number">
                                        @if ($errors->has('phone_number'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('phone_number') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                <label for="password" class="col-sm-2 control-label">Password<span style="color: red">*</span></label>
                                </label>
                                                                    
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">
                                            <span class="btn-show-pass">
                                                <i class="fa fa-eye" id="eye" aria-hidden="true"></i>
                                            </span>
                                            <input type="password" class="form-control" id="password" name="password"
                                                required="" placeholder="Password" value="" autocomplete="new-password">
                                        
                               
                            @if ($errors->has('password'))
                                    <span class="help-block" >
                                        <strong>{{ $errors->first('password') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                            </div>

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Role <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <select class="form-control chosen-select" name="role[]" multiple="">
                                                @foreach($roles as $role)

                                                <option value="{{$role->id}}">
                                                    @foreach($role->projects as $project)
                                                    {{$project->name}}
                                                @endforeach
                                                      --- {{$role->name}}
                                                @endforeach

                                            </select>
                                        @if ($errors->has('role'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('role') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>



                                <div class="form-group m-b-0">
                                    <div class="col-sm-offset-3 col-sm-9">
                                        <button type="submit" class="btn btn-info waves-effect waves-light m-t-10" style="width: 100px;">Save</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!--./row-->
            </div>
            <!-- /.container-fluid -->

@stop
@section('js')
    <script>

        function emptyfield() {
            $('#password').val('');
        }

        $(function () {
            $("#eye").click(function () {
                $(this).toggleClass("fa-eye fa-eye-slash");
                var type = $(this).hasClass("fa-eye-slash") ? "text" : "password";
                $("#password").attr("type", type);
            });
        });
    </script>
@stop