
@extends('layouts.app')


@section('title')
All Accounts 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Account</li>
      </ol>
@stop
@section('content')


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                        	<div class="pull-right">
                                
								<a href="{{route('account.addView')}}" class="btn  btn-primary">
									<i class="fa fa-plus-square"></i>&nbsp; Add new User
								</a>
							</div>
                            <h3 class="box-title">All Accounts</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Name</th>
                                            <th>Email</th>
                                            <th>Phone Number</th>
                                            <th>OTP</th>
                                            <th>Role</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        @foreach($allUsers as $user)
                                        <tr>
                                            <td>{{$count++}}</td>
                                            <td>{{$user->name}}</td>
                                             <td>{{$user->email}}</td>
                                             <td>{{$user->phone_number}}</td>
                                             <td>@if($user->otp){{$user->otp->otp}}@endif</td>
                                             
                                               @if($user->roles)
                                               <td>
                                                @foreach($user->roles as $role)
                                                @foreach($role->projects as $project)
                                                {{$project->name}}
                                            @endforeach
                                                  --- 
                                                <b>{{$role->name}}</b><br>
                                                @endforeach
                                               </td>
                                                   @else
                                                   <td>
                                               </td>
                                               @endif
                                        

                                            <td class="text-nowrap">
                                                @role('admin')
                                                <a href="{{route('account.edit',['id'=>$user->id])}}" data-toggle="tooltip" data-original-title="Edit User"> <i class="fa fa-pencil text-primary"></i> </a>
                                                &nbsp;
                                                &nbsp;
                                                &nbsp;
                                                <a href="{{route('account.delete',['id'=>$user->id])}}" data-toggle="confirmation" data-title="Are you sure to delete?" > <i class="fa fa-close text-danger"></i> </a>
                                                @endrole
                                            </td>
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')
<script>
    $(function() {
        $('#myTable').DataTable();

        });
        </script>
@stop