@extends('layouts.app')

@section('title')
Role Permissions 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Role Access</li>
      </ol>
@stop

@section('css')

<style type="text/css">
    .table>tbody>tr>td {
        font-size: 12px!important;
    }
</style>

@stop

@section('content')
            <div class="container-fluid">

                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title">Role Permission Management</h3>
                            <form method="post"  action="{{route('role.permission')}}">
                                {{csrf_field()}}

                                            <input type="submit" class="btn btn-primary" name="submit" value="Submit" style="float: right;"><br><hr>
                                    <div class="table-responsive">

                                        <table class="table table-bordered" id="myTable">
                                            
                                            <tbody>

                                                <?php $department = 0;?>
                                                
                                                @foreach($permissions as $p)
                                                @if($p->department)

                                                @if($department == $p->department)
                                                <tr>
                                                    <td style="text-align: center;"><b>{{$p->display_name}}</b></td>
                                                    @foreach($roles as $role)
                                                    @if(\App\PermissionRole::where([['role_id',$role->id],['permission_id',$p->id]])->first())
                                                    <th><input style="height: 20px;" type="checkbox" class="form-control dep{{$department}}" checked="" name="permission[{{$role->id}}][{{$p->id}}]"></th>
                                                    @else
                                                    <th><input style="height: 20px;" type="checkbox" class="form-control dep{{$department}}" name="permission[{{$role->id}}][{{$p->id}}]"></th>
                                                    @endif

                                                    @endforeach
                                                    

                                                </tr>

                                                @else
                                                <?php $department = $p->department;?>

                                                <tr></tr>

                                                <tr>
                                                    <td colspan="4"><b style="font-weight: 900;">@if($department == \App\Permission::SALES)
                                                    SALES DEPARTMENT PERMISSIONS
                                                    @elseif($department == \App\Permission::ACCOUNTS)
                                                    ACCOUNTS DEPARTMENT PERMISSIONS
                                                    @elseif($department == \App\Permission::PROCUREMENT)
                                                    PROCUREMENT DEPARTMENT PERMISSIONS
                                                    @endif</b>
                                                </td>
                                                </tr>

                                                <tr></tr>

                                                <tr style="text-align: center;">
                                                    <th width="300px" style="text-align: center;">Access</th>
                                                    @foreach($roles as $role)
                                                    <th style="text-align: center;"> <input type="checkbox" onclick="updateDepartment({{$department}})" class="selectAllDep{{$department}}"> {{$role->name}}</th>
                                                    @endforeach
                                                    
                                                </tr>

                                                <tr>
                                                    <td style="text-align: center;"><b>{{$p->display_name}}</b></td>
                                                    @foreach($roles as $role)
                                                    @if(\App\PermissionRole::where([['role_id',$role->id],['permission_id',$p->id]])->first())
                                                    <th><input style="height: 20px;" type="checkbox" class="form-control dep{{$department}}" checked="" name="permission[{{$role->id}}][{{$p->id}}]"></th>
                                                    @else
                                                    <th><input style="height: 20px;" type="checkbox" class="form-control dep{{$department}}" name="permission[{{$role->id}}][{{$p->id}}]"></th>
                                                    @endif

                                                    @endforeach
                                                    

                                                </tr>




                                                @endif
                                                @endif
                                                @endforeach
                                                


                                            </tbody>
                                        </table>

                                    </form>
                                    </div>

                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')
<script>
    $(function() {
        $('#myTable').DataTable({
            'order':false,
            'paging':false

        });
        });

    function updateDepartment(id) {

        c_id = '.selectAllDepartment'+id;
        check_id = '.dep'+id;

        var checked = $(c_id).is(':checked');
     if(checked){

       $(check_id).each(function(){
         $(this).prop("checked",true);
       });
     }else{
       $(check_id).each(function(){
         $(this).prop("checked",false);
       });
     }
        
    }

    </script>
@stop