@extends('layouts.app')


@section('title')
Email SMS Type
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
       
        <li class="active"> Email Sms Type</li>
        
    </ol>
@stop

@section('content')
    <!-- .container-fluid -->
        <div class="container-fluid">
        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box">
                    <div class="pull-right">
                        <a href="{{ route('smslog.index') }}" class="btn  btn-primary">
                            <i class="fa fa-plus-square"></i>&nbsp; SMS Log
                        </a> 
                        <a href="{{ route('emaillog.index') }}" class="btn  btn-primary">
                            <i class="fa fa-plus-square"></i>&nbsp; Email Log
                        </a>
                    </div>
                    <h3 class="box-title">All Types</h3>

                    <div class="table-responsive">
                        <table id="myTable" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    
                                    <th>Name</th>
                                     
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $count = 1; ?>
                              
                                @foreach ($email_sms_types as $type)
                                    <tr>
                                        <td>{{ $count++ }}</td>
                                        <td>{{ $type->name }}</td>
                                         
                                    

                                        <td class="text-nowrap">
                                            
                                                <a href="{{ route('email-sms.view-type',['id'=>$type->id]) }}"
                                                    data-toggle="tooltip" data-original-title="View"> <i
                                                        class="fa fa-eye text-inverse m-r-10"></i>&nbsp;&nbsp;</a>


                                            
                                                

                                            
                                                
                                            
                                        </td> 
                                    </tr>
                                @endforeach

                             
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- ./container-fluid -->
@stop

@section('js')

    <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js"></script>

    <script></script>
@stop