@extends('layouts.app')


@section('title')
Email And SMS Template
@stop


@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
       
            <li><a href="{{ route('email-sms.index') }}"> Email Sms Type</a></li>
        
        <li class="active">View Type</li>
        
    </ol>
@stop

@section('content')
    <!-- .container-fluid -->
        <div class="container-fluid">
        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box">
                    <div class="pull-right">
                       @php
                      $value= count($email_sms_type->detail); 
                       @endphp
                       @if($value <  2)
                        <a href="{{ route('email-sms.create-detail',$email_sms_type->id) }}" class="btn  btn-primary">
                            <i class="fa fa-plus-square"></i>&nbsp; Add 
                        </a>
                        @endif
                        

                    </div>
                    <h3 class="box-title">Email And Sms Template</h3>

                    <div class="table-responsive">
                        <table id="myTable" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    
                                   
                                    <th>Type</th>
                                    <th>Content</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $count = 1; ?>
                                @foreach ($email_sms_type->detail as $type)
                                <tr>
                                    <td>{{ $count++ }}</td>
                                    <td>
                                   @if($type->content_type == \App\EmailSms::content_type_email)
                                     <strong>   Email </strong>
                                        @elseif($type->content_type == \App\EmailSms::content_type_sms)
                                      <strong>     Sms </strong>
                                        @endif

                                    </td>
                                    <td>
                                        {{$type->content}}
                                    </td>
                                    <td>
                                        @if($type->status == \App\EmailSms::status_on)
                                        On
                                        @elseif($type->status == \App\EmailSms::status_off)
                                        Off
                                        @endif

                                    </td>
                                    <td>
                                        <a href="{{ route('email-sms.edit-detail',['id'=>$type->id]) }}"
                                            data-toggle="tooltip" data-original-title="Edit"> <i
                                                class="fa fa-pencil text-inverse m-r-10"></i>&nbsp;&nbsp;</a>


                                    
                                 

                                    </td>
                                     
                                

                                   
                                </tr>
                            @endforeach
                                
                             
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- ./container-fluid -->
@stop

@section('js')

    <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js"></script>

    <script></script>
@stop